///////////////////////////////////////////////////////////////////////////////
// @ Eduard Heidt                                                            //
///////////////////////////////////////////////////////////////////////////////


#ifndef SHIPH
#define SHIPH

#include "object.h"
#include <stdlib.h>

class Shot: public Object
{
public:
	bool ufo;
	unsigned ts;
	Object* tar;
	Shot(){this->rad = 0; ufo = false; ts = 70;}
};

class Ship: public Object
{
	typedef unsigned char byte;
public:

	Vector vecs[256];
	int display_degs[256][2];
	float shotspeed[256];

   bool present;  // Schiff sichtbar
	byte deg;
   int dx;        // Blickrichtung des Schiffes
   int dy;
	
	void SetDir(int dx, int dy);
	bool IsPresent (void){ return present; }
	void InitWinkelBytes();

	virtual void set(int xx, int yy)
	{
		Object::set(xx, yy);
	}

	int TimeToNavigateTo(byte deg_to)
	{
		int div1 = 0, div2 = 0;
		for(byte n = deg; n != deg_to; n+=3) div1++;
		for(byte n = deg; n != deg_to; n-=3) div2--;
		
		return abs(div1)<abs(div2)?div1:div2;
	}

	Shot GetShot()
	{
		return GetShot(deg);
	}

	Shot GetShot(byte deg )
	{
		Shot ret;
		ret.pos = pos + vecs[deg]*shotspeed[deg]*1.5;
		ret.dir = vecs[deg]*shotspeed[deg] + dir;
		for(int i = 0; i < 8; i++)
			ret.mem[i] = ret.dir;
		return ret;
	}

	Ship():deg(0)
	{
		for(int wb = 0; wb<256; wb++)
		{
			for(int j = 0; j < 255; j++)
				vecs[j] = Vector(cosf(PI/128*j), sinf(PI/128*j)).Normalized();
		}
		InitWinkelBytes();

		rad=18;
	}

	virtual Vector GetDir(int t = 0) const 
	{ 
		if(t>128)
			return Vector(0,0);
		else
			return dir - dir*((float)t/128.f);
	}
	Vector GetRelativePos(int t = 0 ) const;
	Vector GetAbsolutePos(int t = 0 ) const;

};

#endif

