///////////////////////////////////////////////////////////////////////////////
// @ Eduard Heidt                                                            //
///////////////////////////////////////////////////////////////////////////////


#include "object.h"
#include "game.h"

Vector Object::GetShootPos(int t/* = 0*/)
{
	float r = this->GetRelativePos(t).Len();
	float d = this->GetDir().Len();
	float s = 8;

	float ts = sqrt((r*r)/((s*s)+(d*d)));

	return this->GetRelativePos(t+ts);
}

Vector Object::GetRelativePos(int t/* = 0*/) const
{
	Vector dis = dir*(float)t;
	Vector v = (pos+dis)-Game::GetState()->ship.pos;
	return v.GetMod(Vector(-512,-384), Vector(+512, 384));
}

Vector Object::GetAbsolutePos(int t/* = 0*/) const
{
	Vector dis = dir*(float)t;
	Vector v = pos+dis;
	return v.GetMod(Vector(0,MIN_Y), Vector(MAX_X, MAX_Y-MIN_Y));
}

Turn Object::CalculateTurn(byte curr_deg, unsigned t_offset)
{
	Turn ret = Turn::Wait();

	unsigned time_to = INT_MAX;

	for(int w = 0; w < 4; w++)
	for(unsigned do_navigate = 0; do_navigate <= 43; do_navigate++)
	{
		Shot shotA = Game::GetState()->ship.GetShot((curr_deg+do_navigate*3)%256);
		Shot shotB = Game::GetState()->ship.GetShot((curr_deg-do_navigate*3)%256);

		unsigned tsA = shotA.GetCollideTime(*this, do_navigate+t_offset+w);
		unsigned tsB = shotB.GetCollideTime(*this, do_navigate+t_offset+w);

		int dir = tsA < tsB?1:-1;
		unsigned ts = tsA<tsB?tsA:tsB;

		if(ts < 70)
		{
			if(do_navigate+ts < time_to)
			{
				time_to = do_navigate+ts;
				ret = Turn::Fire(do_navigate*dir, w+t_offset, this, do_navigate + ts );
			}
		}
	}

	return ret;
}

void Object::Reset()
{
	static int idx = 1;
	id = idx++;
	old = 0;
	pos = dir = Vector(0,0);
	mc = 0;
	s_start = 0;
	ZeroMemory(mem, sizeof(Vector)*8);
}

bool Object::SameObject(int xx, int yy)
{
	while(xx > MAX_X) xx -= MAX_X;
	while(yy > MAX_Y) yy -= (MAX_Y-MIN_Y);
	while(xx < MIN_X) xx += MAX_X;
	while(yy < MIN_Y) yy += (MAX_Y-MIN_Y);
	
	VDC dx = xx-pos.x;
	VDC dy = yy-pos.y;

	while(dx > MAX_X) dx -= MAX_X;
	while(dy > MAX_Y) dy -= (MAX_Y-MIN_Y);

	if(fabs(dx) <= 16 && fabs(dy) <= 16)
		return true;
	else 
		return false;
}


void Object::set(int xx, int yy)
{
	old++;

	is_ufo = false;
	hit = false;

	xx*=F;
	yy*=F;

	while(xx > MAX_X) xx -= MAX_X;
	while(yy > MAX_Y) yy -= (MAX_Y-MIN_Y);
	while(xx < MIN_X) xx += MAX_X;
	while(yy < MIN_Y) yy += (MAX_Y-MIN_Y);

	VDC dx = xx-pos.x;
	VDC dy = yy-pos.y;
	
	if(fabs(dx) < 16 && fabs(dy) < 16)
	{
		mem[mc%8].x = dx;
		mem[mc%8].y = dy;
		mc++;
	}
	else
	{
		if(Vector(xx,yy).DistanceTo(GetAbsolutePos(2)) > 16)
			Reset();
	}

	dir = Vector(0,0);
	for(unsigned i = 0; i < 8; i++)
			dir = dir + mem[i];
	dir = dir * 0.125f;

	pos.x = (float)xx;
	pos.y = (float)yy;

}
