/*
 * Decompiled with CFR 0.152.
 */
package robot41;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import robot41.Aiming;
import robot41.Asteroid;
import robot41.ControlPacket;
import robot41.Display;
import robot41.FramePacket;
import robot41.LinEqSys22;
import robot41.Screen;
import robot41.Target;

public class Game {
    static final int LOG_T = 1;
    static final int LOG_TARGET = 2;
    static final int LOG_FIRING = 4;
    static final int LOG_FIRING_DBG = 8;
    static final int LOG_MODE = 0;
    Display display;
    DatagramSocket datagramSocket;
    ControlPacket controlPacket;
    FramePacket framePacket;
    int[] vRam;
    Screen screen;
    int t;
    Target target;

    public Game(InetAddress inetAddress, int n, boolean bl) throws IOException {
        try {
            this.datagramSocket = new DatagramSocket();
        }
        catch (SocketException socketException) {
            System.err.println(socketException);
            System.exit(1);
        }
        this.controlPacket = new ControlPacket(this.datagramSocket, inetAddress, n);
        this.framePacket = new FramePacket(this.datagramSocket);
        this.vRam = new int[512];
        this.screen = new Screen();
        if (bl) {
            this.display = new Display(this);
        }
    }

    void findTarget() {
        this.target = null;
        if (this.screen.ship == null) {
            return;
        }
        if (this.screen.saucer != null) {
            this.screen.saucer.priority = 90100;
            this.screen.saucer.calculateFireData(this.t, this.screen.ship);
            this.target = this.screen.saucer;
        }
        for (Asteroid asteroid : this.screen.asteroids) {
            if (this.t > asteroid.tExpectedFireHit) {
                asteroid.nFired = 0;
            }
            if (asteroid.nFire > 0 && asteroid.nFired >= asteroid.nFire && this.screen.asteroids.size() > 1) continue;
            asteroid.calculateFireData(this.t, this.screen.ship);
            double d = Math.sqrt(asteroid.vx * asteroid.vx + asteroid.vy * asteroid.vy);
            int n = this.screen.ship.sx - asteroid.sx;
            int n2 = this.screen.ship.sy - asteroid.sy;
            double d2 = Math.sqrt(n * n + n2 * n2);
            double d3 = (double)asteroid.vy / d;
            double d4 = (double)(-asteroid.vx) / d;
            LinEqSys22.solve(asteroid.vx, asteroid.vy, d3, d4, this.screen.ship.sx - asteroid.sx, this.screen.ship.sy - asteroid.sy);
            double d5 = LinEqSys22.getSolution1();
            double d6 = Math.abs(LinEqSys22.getSolution2()) - (double)(this.screen.ship.getRadius() + asteroid.getRadius());
            asteroid.priority = d6 <= 0.0 && d5 > 1.0 ? 90000 + (int)Math.round(2000.0 / d5) : (asteroid.getSize() == 1 || d2 > 250.0 ? 65000 + Math.round(1000 / (1 + Math.abs(asteroid.tExpectedFireHit - this.t))) : (d2 > 100.0 ? 65010 - asteroid.getSize() : 0));
            asteroid.nFire = asteroid.getSize() == 2 ? 3 : 1;
            if (this.target != null && this.target.priority >= asteroid.priority || asteroid.priority <= 0) continue;
            this.target = asteroid;
        }
    }

    static int deltaAiming(int n, int n2) {
        return (128 + n2 - n & 0xFF) - 128;
    }

    void play() throws IOException {
        int n = 0;
        Target target = new Target();
        while (true) {
            this.controlPacket.send();
            this.t = this.framePacket.receive(this.vRam);
            this.screen.analyze(this.t, this.vRam);
            Aiming.verifyAndUpdateShipsAiming(this.screen.ship, this.controlPacket.getTurningDir());
            if ((this.target == null || this.target.tFire < this.t) && this.screen.ship != null) {
                this.findTarget();
                if (this.target != null) {
                    n = Game.deltaAiming(this.screen.ship.aiming, this.target.aimingFire);
                }
            }
            if (this.screen.ship != null && this.target != null && this.target.tFire >= this.t) {
                if (n != 0) {
                    if (n < 0) {
                        this.controlPacket.setRight(true);
                        ++n;
                    } else if (n > 0) {
                        this.controlPacket.setLeft(true);
                        --n;
                    }
                }
                if (this.t == this.target.tFire) {
                    if (this.screen.ownShots.size() < 4) {
                        ++this.target.nFired;
                    }
                    this.controlPacket.setFire(true);
                }
                if (this.t > this.target.tFire && this.target.nFired >= this.target.nFire) {
                    this.target = null;
                }
            }
            if (this.display == null) continue;
            this.display.repaint();
        }
    }
}

