/*
 * Decompiled with CFR 0.152.
 */
package robot41;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import robot41.Asteroid;
import robot41.Saucer;
import robot41.Ship;
import robot41.Shot;

class Screen {
    static final int LOG_ASTEROID_ANALYSIS = 1;
    static final int LOG_ASTEROID_LOSS = 2;
    static final int LOG_SAUCER_ANALYSIS = 4;
    static final int LOG_SAUCER_LOSS = 8;
    static final int LOG_OWN_SHOT_ANALYSIS = 16;
    static final int LOG_OWN_SHOT_LOSS = 32;
    static final int LOG_FOREIGN_SHOT_ANALYSIS = 64;
    static final int LOG_FOREIGN_SHOT_LOSS = 128;
    static final int LOG_MODE = 0;
    public Saucer saucer;
    public Ship ship;
    public List<Asteroid> asteroids = new LinkedList<Asteroid>();
    public List<Shot> ownShots = new LinkedList<Shot>();
    public List<Shot> foreignShots = new LinkedList<Shot>();
    protected static final int MAX_N_SHOTS = 64;
    protected static final int MAX_N_ASTEROIDS = 64;
    protected static final int DELETED = -1;
    protected boolean shipPresent;
    protected int shipX;
    protected int shipY;
    protected int shipDx;
    protected int shipDy;
    protected boolean saucerPresent;
    protected int saucerX;
    protected int saucerY;
    protected int saucerT;
    protected int nShots;
    protected int[] shotX;
    protected int[] shotY;
    protected int nAsteroids;
    protected int[] asteroidX;
    protected int[] asteroidY;
    protected int[] asteroidT;
    protected Ship shipInstance = new Ship();
    protected Saucer saucerInstance = new Saucer();

    Screen() {
        this.shotX = new int[64];
        this.shotY = new int[64];
        this.asteroidX = new int[64];
        this.asteroidY = new int[64];
        this.asteroidT = new int[64];
    }

    protected void interpreteVRam(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        this.shipPresent = false;
        this.saucerPresent = false;
        this.nShots = 0;
        this.nAsteroids = 0;
        int n8 = 1;
        while (true) {
            int n9 = nArray[n8] >> 12;
            switch (n9) {
                case 10: {
                    n2 = (nArray[n8] & 0x3FF) - 128;
                    n = nArray[n8 + 1] & 0x3FF;
                    n4 = nArray[n8 + 1] >> 12;
                    break;
                }
                case 11: {
                    return;
                }
                case 12: {
                    int n10 = nArray[n8] & 0xFFF;
                    switch (n10) {
                        case 2291: {
                            this.asteroidX[this.nAsteroids] = n;
                            this.asteroidY[this.nAsteroids] = n2;
                            this.asteroidT[this.nAsteroids] = 0x10F & n4 - 13;
                            ++this.nAsteroids;
                            break;
                        }
                        case 2303: {
                            this.asteroidX[this.nAsteroids] = n;
                            this.asteroidY[this.nAsteroids] = n2;
                            this.asteroidT[this.nAsteroids] = 0x20F & n4 - 13;
                            ++this.nAsteroids;
                            break;
                        }
                        case 2317: {
                            this.asteroidX[this.nAsteroids] = n;
                            this.asteroidY[this.nAsteroids] = n2;
                            this.asteroidT[this.nAsteroids] = 0x30F & n4 - 13;
                            ++this.nAsteroids;
                            break;
                        }
                        case 2330: {
                            this.asteroidX[this.nAsteroids] = n;
                            this.asteroidY[this.nAsteroids] = n2;
                            this.asteroidT[this.nAsteroids] = 0x40F & n4 - 13;
                            ++this.nAsteroids;
                            break;
                        }
                        case 2345: {
                            this.saucerX = n;
                            this.saucerY = n2;
                            this.saucerT = n4;
                            this.saucerPresent = true;
                        }
                    }
                    break;
                }
                case 13: {
                    return;
                }
                case 14: {
                    return;
                }
                case 15: {
                    break;
                }
                default: {
                    int n11 = nArray[n8] & 0x3FF;
                    if ((nArray[n8] & 0x400) != 0) {
                        n11 = -n11;
                    }
                    int n12 = nArray[n8 + 1] & 0x3FF;
                    if ((nArray[n8 + 1] & 0x400) != 0) {
                        n12 = -n12;
                    }
                    int n13 = n9;
                    n3 = nArray[n8 + 1] >> 12;
                    if (n12 == 0 && n11 == 0 && n3 == 15) {
                        this.shotX[this.nShots] = n;
                        this.shotY[this.nShots] = n2;
                        ++this.nShots;
                    }
                    if (n9 == 6 && n3 == 12 && n12 != 0 && n11 != 0) {
                        if (n7 == 0) {
                            n5 = n12;
                            n6 = n11;
                        } else {
                            this.shipX = n;
                            this.shipY = n2;
                            this.shipDx = n5 - n12;
                            this.shipDy = n6 - n11;
                            this.shipPresent = true;
                        }
                        ++n7;
                        break;
                    }
                    if (n7 != true) break;
                    n7 = 0;
                }
            }
            if (n9 <= 10) {
                ++n8;
            }
            if (n9 == 14) continue;
            ++n8;
        }
    }

    public void analyze(int n, int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        this.interpreteVRam(nArray);
        if (this.shipPresent) {
            if (this.ship == null) {
                this.ship = this.shipInstance;
            }
            this.ship.sx = this.shipX;
            this.ship.sy = this.shipY;
            this.ship.dx = this.shipDx;
            this.ship.dy = this.shipDy;
        } else {
            this.ship = null;
        }
        if (this.saucerPresent) {
            if (this.saucer == null) {
                this.saucer = this.saucerInstance;
            }
            if (this.saucer.motionAnalyzed) {
                this.saucer.updatePredictedPosition(n);
                this.saucer.verifyPredictedPosition(this.saucerX, this.saucerY);
                if (!this.saucer.predictedPositionVerified) {
                    this.saucer.analyzeMotion(n, this.saucerX, this.saucerY);
                }
            } else {
                this.saucer.sx = this.saucerX;
                this.saucer.sy = this.saucerY;
                this.saucer.type = this.saucerT;
                this.saucer.vx = 0;
                this.saucer.vy = 0;
                this.saucer.analyzeMotion(n, this.saucerX, this.saucerY);
            }
        } else {
            this.saucer = null;
        }
        for (Shot body2 : this.ownShots) {
            body2.updatePredictedPosition(n);
        }
        Iterator<Shot> iterator = this.ownShots.listIterator();
        while (iterator.hasNext()) {
            Shot shot = (Shot)iterator.next();
            if (!shot.motionAnalyzed) continue;
            for (n7 = 0; n7 < this.nShots; ++n7) {
                if (this.shotX[n7] == -1 || !shot.verifyPredictedPosition(this.shotX[n7], this.shotY[n7])) continue;
                this.shotX[n7] = -1;
                break;
            }
            if (shot.predictedPositionVerified) continue;
            iterator.remove();
        }
        iterator = this.ownShots.listIterator();
        while (iterator.hasNext()) {
            Shot shot = (Shot)iterator.next();
            if (shot.motionAnalyzed) continue;
            n7 = 0;
            n6 = Integer.MAX_VALUE;
            for (n5 = 0; n5 < this.nShots; ++n5) {
                if (this.shotX[n5] == -1 || (n4 = (n3 = shot.sx - this.shotX[n5]) * n3 + (n2 = shot.sy - this.shotY[n5]) * n2) >= n6) continue;
                n6 = n4;
                n7 = n5;
            }
            if (n6 < 256) {
                shot.analyzeMotion(n, this.shotX[n7], this.shotY[n7]);
                this.shotX[n7] = -1;
                continue;
            }
            iterator.remove();
        }
        for (Shot shot : this.foreignShots) {
            shot.updatePredictedPosition(n);
        }
        iterator = this.foreignShots.listIterator();
        while (iterator.hasNext()) {
            Shot shot = (Shot)iterator.next();
            if (!shot.motionAnalyzed) continue;
            for (n7 = 0; n7 < this.nShots; ++n7) {
                if (this.shotX[n7] == -1 || !shot.verifyPredictedPosition(this.shotX[n7], this.shotY[n7])) continue;
                this.shotX[n7] = -1;
                break;
            }
            if (shot.predictedPositionVerified) continue;
            iterator.remove();
        }
        iterator = this.foreignShots.listIterator();
        while (iterator.hasNext()) {
            Shot shot = (Shot)iterator.next();
            if (shot.motionAnalyzed) continue;
            n7 = 0;
            n6 = Integer.MAX_VALUE;
            for (n5 = 0; n5 < this.nShots; ++n5) {
                if (this.shotX[n5] == -1 || (n4 = (n3 = shot.sx - this.shotX[n5]) * n3 + (n2 = shot.sy - this.shotY[n5]) * n2) >= n6) continue;
                n6 = n4;
                n7 = n5;
            }
            if (n6 < 256) {
                n5 = 0;
                n3 = 0;
                n2 = 0;
                if (this.ship != null) {
                    n5 = shot.sx - this.ship.sx;
                    n3 = shot.sy - this.ship.sy;
                    n2 = (int)Math.round(Math.sqrt(n5 * n5 + n3 * n3));
                }
                shot.analyzeMotion(n, this.shotX[n7], this.shotY[n7]);
                if (shot.iStep == 2 && (n5 = n5 * 50 / 16 - shot.vx) * n5 + (n3 = n3 * 50 / 16 - shot.vy) * n3 < 144) {
                    this.ownShots.add(shot);
                    iterator.remove();
                }
                this.shotX[n7] = -1;
                continue;
            }
            iterator.remove();
        }
        for (int i = 0; i < this.nShots; ++i) {
            if (this.shotX[i] == -1) continue;
            Shot shot = new Shot(this.shotX[i], this.shotY[i]);
            shot.analyzeMotion(n, this.shotX[i], this.shotY[i]);
            this.foreignShots.add(shot);
        }
        for (Asteroid asteroid : this.asteroids) {
            asteroid.updatePredictedPosition(n);
        }
        Iterator<Asteroid> iterator2 = this.asteroids.listIterator();
        while (iterator2.hasNext()) {
            Asteroid asteroid = (Asteroid)iterator2.next();
            if (!asteroid.motionAnalyzed) continue;
            for (n7 = 0; n7 < this.nAsteroids; ++n7) {
                if (this.asteroidX[n7] == -1 || this.asteroidT[n7] != asteroid.type || !asteroid.verifyPredictedPosition(this.asteroidX[n7], this.asteroidY[n7])) continue;
                this.asteroidX[n7] = -1;
                break;
            }
            if (asteroid.predictedPositionVerified) continue;
            iterator2.remove();
        }
        iterator2 = this.asteroids.listIterator();
        while (iterator2.hasNext()) {
            Asteroid asteroid = (Asteroid)iterator2.next();
            if (asteroid.motionAnalyzed) continue;
            n7 = 0;
            n6 = Integer.MAX_VALUE;
            for (n5 = 0; n5 < this.nAsteroids; ++n5) {
                if (this.asteroidX[n5] == -1 || this.asteroidT[n5] != asteroid.type || (n4 = (n3 = asteroid.psx - this.asteroidX[n5]) * n3 + (n2 = asteroid.psy - this.asteroidY[n5]) * n2) >= n6) continue;
                n6 = n4;
                n7 = n5;
            }
            if (n6 < 100) {
                asteroid.analyzeMotion(n, this.asteroidX[n7], this.asteroidY[n7]);
                this.asteroidX[n7] = -1;
                continue;
            }
            iterator2.remove();
        }
        for (int i = 0; i < this.nAsteroids; ++i) {
            if (this.asteroidX[i] == -1) continue;
            Asteroid asteroid = new Asteroid(this.asteroidX[i], this.asteroidY[i], this.asteroidT[i]);
            asteroid.analyzeMotion(n, this.asteroidX[i], this.asteroidY[i]);
            this.asteroids.add(asteroid);
        }
    }
}

