// creativ'08-Wettbewerb zum 25. c't-Geburtstag
// Beitrag von Curd Wallhaeusser

package robot41;

import java.awt.*;
import java.awt.event.*;
import java.util.List;

public class Display extends Frame implements WindowListener
{

  TextField commentLine =new TextField("...");
  Game game;
  Screen screen;

  public Display(Game game)
  {
    this.game=game;
    screen=game.screen;
    addWindowListener(this);
    add(commentLine ,"South");
    setSize(1024,768+80);
    setResizable(false);
    show();
  } // constructor

  public void paint(Graphics g)
  {
    int x,y,r;

    Ship   ship=screen.ship;
    Saucer saucer=screen.saucer;
    Target target=game.target;
    List<Asteroid> asteroids=screen.asteroids;
    List<Shot> ownShots=screen.ownShots;
    List<Shot> foreignShots=screen.foreignShots;
        
    for(Asteroid a: asteroids)
    {
      x=    a.sx;
      y=768-a.sy;
      r=a.getRadius();
      if(a==target)
      {
        g.setColor(Color.RED);
        if(a.motionAnalyzed)
        g.drawOval(x-r,y-r,2*r,2*r);
      }
      else
      {
        if(a.motionAnalyzed)
          g.setColor(Color.BLACK);
        else
          g.setColor(Color.DARK_GRAY);
        g.drawOval(x-r,y-r,2*r,2*r);
        g.setColor(Color.LIGHT_GRAY);
      }
      g.drawLine(x,y,x+100*a.vx,y-100*a.vy);
    }

    for(Shot s: ownShots)
    {
      x=    s.sx;
      y=768-s.sy;
      r=2;
      g.setColor(Color.YELLOW);
      g.drawOval(x-r,y-r,2*r,2*r);
      g.setColor(Color.YELLOW);
      g.drawLine(x,y,x+100*s.vx,y-100*s.vy);
    }
    for(Shot s: foreignShots)
    {
      x=    s.sx;
      y=768-s.sy;
      r=2;
      g.setColor(Color.DARK_GRAY);
      g.drawOval(x-r,y-r,2*r,2*r);
      g.setColor(Color.LIGHT_GRAY);
      g.drawLine(x,y,x+100*s.vx,y-100*s.vy);
    }

    if(ship!=null)
    {
      g.setColor(Color.GREEN);
      double a=6*Math.PI/256*ship.aiming;
      double ca=Math.cos(a);
      double sa=Math.sin(a);
      x=    ship.sx;
      y=768-ship.sy;
      r=ship.getRadius();
      g.drawOval(x-r,y-r,2*r,2*r);
      g.drawLine(x,y,x+(int)Math.round(25*ca),y-(int)Math.round(25*sa));
    }

    if(saucer!=null)
    {
      x=    saucer.sx;
      y=768-saucer.sy;
      r=saucer.getRadius();
      g.setColor(Color.MAGENTA);
      g.fillOval(x-r,y-r,2*r,2*r);
      g.drawLine(x,y,x+100*saucer.vx,y-100*saucer.vy);
    }

    int n=asteroids.size();
    commentLine.setText("#asteroids="+n+((saucer==null)?"":("saucer.type="+saucer.type)));
  } // paint
  
  void shutDown()
  {
    System.exit(0);
  } // shutDown

// WindowListener interface:
  
  public void windowActivated(WindowEvent e)
  {
  } // windowActivated
  
  public void windowClosed(WindowEvent e) 
  {
  } // windowClosed
  
  public void windowClosing(WindowEvent e) 
  {
    shutDown();
  } // windowClosing
  
  public void windowDeactivated(WindowEvent e) 
  {
  } // windowDeactivated
  
  public void windowDeiconified(WindowEvent e) 
  {
  } // windowDeiconified
  
  public void windowIconified(WindowEvent e) 
  {
  } // windowIconified
  
  public void windowOpened(WindowEvent e) 
  {
  } // windowOpened

} // class

