// creativ'08-Wettbewerb zum 25. c't-Geburtstag
// Beitrag von Curd Wallhaeusser

package robot41;

public class Target extends Body
{
  
  public int type;

  public int priority;

  public int tFire,aimingFire;
  public int nFire,nFired;
  public int tExpectedFireHit;
  
  public Target()
  {
  } //constructor

  static int deltaAiming(int a0, int a1){ return ((128+a1-a0)&0xff)-128; }
  static int dxdy2BestAiming(int actualAiming, double dx, double dy)
  {
    double aIdeal=Math.atan2(dy,dx);           // ideal aiming (rad)
    double aActual=actualAiming*3*Math.PI/128; // actual aiming (rad)
    double delta=aIdeal-aActual;
    while(delta>Math.PI)delta-=2*Math.PI; 
    while(delta<-Math.PI)delta+=2*Math.PI;
    return 0xff&(actualAiming+(int)Math.round(delta/(3*Math.PI/128)));
  } // dxdy2BestAiming

  void calculateFireData(int t, Ship ship)
  {
    int tW=0;
    double speedOfBullet=7.875;
    double dx,dy,dt=0;
    dx=sx-ship.sx; dy=sy-ship.sy;
    aimingFire=(ship.aiming+43)&0xff; // assume worst case
    for(int j=0; j<3; j++)
    {
      tW=Math.abs(deltaAiming(ship.aiming,aimingFire))+1; //+4; // estimated delay until it is possible to fire 
      for(int i=0; i<3; i++)
      {
        double d=Math.sqrt(dx*dx+dy*dy)-20; //-19;
        dt=tW+d/speedOfBullet;
        dx=sx + dt*vx/8 - ship.sx; 
        dy=sy + dt*vy/8 - ship.sy;
      }
      aimingFire=dxdy2BestAiming(ship.aiming,dx,dy);
    }
    tFire=t+tW;
    
    tExpectedFireHit=t+(int)Math.round(dt)+1;
  } // calculateFireData


  static String fi(int l, int i)
  {
    int j=i;
    if(j<0){ l--; j=-j; }
    if(j>=1000)l--;
    if(j>= 100)l--;
    if(j>=  10)l--;
    switch(l)
    {
      case 4: return "    "+i;
      case 3: return "   "+i;
      case 2: return "  "+i;
      case 1: return " "+i;
      case 0: return ""+i;
    }
    return "???";
  } // fi

  public String toString()
  {
    String ts=Integer.toHexString(type);
    ts="0000".substring(ts.length())+ts;
    return "type="+ts+" sx="+fi(4,sx)+" sy="+fi(4,sy);
  } // toString

} // class
