/*
 *
 * Asteroids Player
 *
 * for the c't Competition 2008 (Creativ '08) 
 *
 * Copyright 2008, Volker Raum, Erlangen, Germany
 *
 */
package de.volkerraum.asteroids;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;

import de.volkerraum.asteroids.connection.MameConnection;
import de.volkerraum.asteroids.model.AsteroidsModel;
import de.volkerraum.asteroids.model.ConfigHandler;
import de.volkerraum.asteroids.model.ResultWrapper;
import de.volkerraum.asteroids.player.Player;

/**
 * @author Volker Raum (C) 2007
 */
public class MameRunner extends Thread implements Observer
{
   String server = null;
   AsteroidsModel model;
   Process mameProc = null;

   String sync = "SYNC";

   List<ResultWrapper> results = new ArrayList<ResultWrapper>();
   Player player = null;
   Random rand = new Random();
   MameConnection conn = null;

   // ConfigHandler handler = new TargetRating1();

   ConfigHandler handler = null;

   FileOutputStream fos = null;

   public MameRunner(String server)
   {
      super();
      this.server = server;
      try
      {
         fos = new FileOutputStream("Result.txt", true);
         fos.write((new Date() + "\n").getBytes());
      }
      catch (Exception e)
      {
         // TODO Auto-generated catch block
         e.printStackTrace();
      }

   }

   public void run()
   {
      while (true)
      {
         // START MAME
         try
         {
            mameProc = Runtime.getRuntime().exec(server);
            Thread.sleep(3000 + (rand.nextInt(7) * 100));

            if (handler != null)
               handler.setConfig();

            model = new AsteroidsModel();
            model.addObserver(this);
            conn = new MameConnection("localhost", 1979, model, false);

            model.setConnection(conn);
            player = new Player(model);

            mameProc.waitFor();
            Thread.sleep(1000);

            System.err.println("Next Loop");
            player.kill();
            conn.stop();

         }
         catch (Exception e)
         {
            // TODO Auto-generated catch block
            e.printStackTrace();
         }
      }
   }

   @Override
   public void update(Observable o, Object arg)
   {
      Integer msg = (Integer) arg;

      if (msg == AsteroidsModel.MSG_GAME_FINISHED)
      {
         ResultWrapper newResult = new ResultWrapper();
         newResult.score = model.getScore();
         if (handler != null)
            newResult.parameters = handler.getConfig();

         results.add(newResult);

         try
         {
            System.err.println("----");
            for (ResultWrapper currResult : results)
            {
               System.err.println("SCORE " + currResult.score + " PARAM " + currResult.parameters);

            }
            fos.write(("SCORE " + newResult.score + " PARAM " + newResult.parameters + "\n").getBytes());

            System.err.println("----");
            fos.flush();
         }
         catch (IOException e)
         {
            // TODO Auto-generated catch block
            e.printStackTrace();
         }

         mameProc.destroy();

         try
         {
            Thread.sleep(2000);
         }
         catch (Exception e)
         {
         }
         deleteOrSaveRecordFiles(newResult.score);

      }

   }

   private void deleteOrSaveRecordFiles(int score)
   {
      File[] files = new File(".").listFiles();
      for (File currFile : files)
      {
         if (currFile.getName().endsWith(".gz"))
         {
            if (score > 95000)
            {
               File newFile = new File(currFile.getAbsolutePath() + "-" + score);
               currFile.renameTo(newFile);
            }
            else
            {
               currFile.delete();
            }
         }
      }

   }

}
