/*
 *
 * Asteroids Player
 *
 * for the c't Competition 2008 (Creativ '08) 
 *
 * Copyright 2008, Volker Raum, Erlangen, Germany
 *
 */
package de.volkerraum.asteroids.connection;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

import de.volkerraum.asteroids.model.AsteroidsModel;

/**
 * @author Volker Raum (C) 2007
 */
public class MameConnection implements Connection
{
   public static final byte COMMAND_HYPERSPACE = 0x1;
   public static final byte COMMAND_FIRE = 0x2;
   public static final byte COMMAND_THROTTLE = 0x4;
   public static final byte COMMAND_RIGHT = 0x8;
   public static final byte COMMAND_LEFT = 0x10;

   public static final int SEND_LENGTH = 8;
   public static final int RECEIVE_LENGTH = 1026;
   DatagramSocket sock = null;
   byte[] sendBytes = "ctmame__".getBytes(); // 8
   // Bytes
   byte[] receiveBuffer = new byte[RECEIVE_LENGTH];

   private SocketAddress socketAddress = null;
   AsteroidsModel theModel = null;

   byte sendCount = 0x00;
   byte lastCommand = -1;

   boolean recordingWanted = false;
   boolean recordingActivated = true;
   FileOutputStream fos = null;

   boolean process = true;

   public MameConnection(String hostname, int port, AsteroidsModel model, boolean recordingWanted)
   {
      theModel = model;
      this.recordingWanted = recordingWanted;

      theModel.setConnection(this);
      if (port < 0)
         port = 1979;

      InetAddress server = null;
      try
      {
         server = InetAddress.getByName(hostname);
      }
      catch (UnknownHostException e)
      {
         // TODO Auto-generated catch block
         e.printStackTrace();
      }

      try
      {
         sock = new DatagramSocket();
      }
      catch (SocketException e1)
      {
         // TODO Auto-generated catch block
         e1.printStackTrace();
      }

      socketAddress = new InetSocketAddress(server, port);

      if (recordingWanted)
      {
         try
         {
            fos = new FileOutputStream("frames.aff");
         }
         catch (FileNotFoundException e)
         {
            System.err.println("Unable to open Framesfile");
            e.printStackTrace();
            System.exit(1);
         }
      }

      Receiver receiver = new Receiver();
      receiver.start();

   }

   public void activateRecording(boolean activate)
   {
      recordingActivated = activate;
   }

   public void stopRecording()
   {
      try
      {
         fos.close();
         fos = null;
      }
      catch (IOException e)
      {
         // TODO Auto-generated catch block
         e.printStackTrace();
      }
   }

   /*
    * (non-Javadoc)
    * 
    * @see de.volkerraum.asteroids.connection.Connection#sendCommand(byte)
    */
   public void sendCommand(byte command)
   {

      if (!process)
         return;

      lastCommand = command;

      sendBytes[6] = command;
      sendBytes[7] = command;
      try
      {
         sock.send(new DatagramPacket(sendBytes, SEND_LENGTH, socketAddress));
      }
      catch (IOException e)
      {
         // TODO Auto-generated catch block
         e.printStackTrace();
      }
      sendCount++;
   }

   class Receiver extends Thread
   {
      public void run()
      {
         while (process)
         {

            DatagramPacket a = new DatagramPacket(receiveBuffer, RECEIVE_LENGTH);
            try
            {
               sock.receive(a);

               if (fos != null && recordingActivated)
                  fos.write(a.getData());

               theModel.analyseIncomingBytes(a.getData());
            }
            catch (IOException e)
            {
               if (process)
                  e.printStackTrace();
            }

         }
         System.err.println("End Receiver");
      }

   }

   public void stop()
   {
      process = false;
      sock.close();
   }
}
