/*
 *
 * Asteroids Player
 *
 * for the c't Competition 2008 (Creativ '08) 
 *
 * Copyright 2008, Volker Raum, Erlangen, Germany
 *
 */
package de.volkerraum.asteroids.model;

/**
 * @author   Volker Raum  (C) 2007
 */
public class Asteroid extends BaseObject
{
   public static final int MEAN_VALUE_COUNT = 9; // Subspace Pixel (8 necessary)

   int                     type;

   /**
    * @author   Volker Raum  (C) 2007
    */
   public enum SIZES
   {
      SMALL, MEDIUM, BIG, ALL
   };

   SIZES    sizeType;

   double[] rawXHist        = new double[MEAN_VALUE_COUNT];
   double[] rawYHist        = new double[MEAN_VALUE_COUNT];
   int      histCounter   = -1;
   int      historyFilled = 0;

   public void setAll(int x, int y, int type, int size, SIZES sizetype)
   {
      this.sizeType = sizetype;
      this.x = x;
      this.y = y;
      this.rawX = x;
      this.rawY = y;
      this.type = type;
      this.size = size;
   }

   public void copyData(Asteroid other)
   {
      super.copyData(other);
      this.type = other.type;
      this.sizeType = other.sizeType;
      
      for ( int i = 0 ; i < MEAN_VALUE_COUNT  ; ++i )
      {
         this.rawXHist[i] = other.rawXHist[i] ;
         this.rawYHist[i] = other.rawYHist[i] ;
      }

   }

   public void clearValue()
   {
      super.clearValue();
   }

   public void addHistory()
   {
      histCounter++;
      if (histCounter == MEAN_VALUE_COUNT)
         histCounter = 0;
      
      rawXHist[histCounter] = rawX;
      rawYHist[histCounter] = rawY;

      if (historyFilled != MEAN_VALUE_COUNT)
         historyFilled++;

   }

   public double getMeanDX()
   {
      
     double lastValue = rawXHist[0] ;
     
     if ( historyFilled == MEAN_VALUE_COUNT) // Array is filled
     {
        int mostRecentValueIndex = histCounter+1 ; // RING BUFFER
        if ( mostRecentValueIndex == MEAN_VALUE_COUNT)
           mostRecentValueIndex = 0 ;
        lastValue = rawXHist[mostRecentValueIndex] ;
     }
     return Helper.calcDiffWithTorus(rawXHist[histCounter], lastValue, 1024, 800)/ (historyFilled-1) ;
     
   }

   public double getMeanDY()
   {
      double lastValue = rawYHist[0] ;
      
      if ( historyFilled == MEAN_VALUE_COUNT) // Array is filled
      {
         int mostRecentValueIndex = histCounter+1 ; // RING BUFFER
         if ( mostRecentValueIndex == MEAN_VALUE_COUNT)
            mostRecentValueIndex = 0 ;
         lastValue = rawYHist[mostRecentValueIndex] ;
      }
      return Helper.calcDiffWithTorus(rawYHist[histCounter], lastValue, 768, 600) / (historyFilled-1);
      
   }

   public void printDEBUG()
   {
      System.err.println("A " + x + "/" + y + " D " + dx + "/" + dy);
   }

}
