/*
 *
 * Asteroids Player
 *
 * for the c't Competition 2008 (Creativ '08) 
 *
 * Copyright 2008, Volker Raum, Erlangen, Germany
 *
 */
package de.volkerraum.asteroids.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

import de.volkerraum.asteroids.connection.MameConnection;

public class RecordingControlFrame extends JFrame
{
   JToggleButton activateButton = new JToggleButton("RECORD");
   JButton       stopButton     = new JButton("STOP");

   JPanel        mainPanel      = new JPanel();

   public RecordingControlFrame(final MameConnection connection)
   {
      mainPanel.add(activateButton);
      mainPanel.add(stopButton);
      activateButton.setSelected(true) ;

      this.setContentPane(mainPanel);

      activateButton.addActionListener(new ActionListener()
      {

         public void actionPerformed(ActionEvent e)
         {
            connection.activateRecording(activateButton.isSelected());
         }
      });
      stopButton.addActionListener(new ActionListener()
      {

         public void actionPerformed(ActionEvent e)
         {
            connection.stopRecording();
            System.exit(0);
         }
      });

   }
}
