/*
 *
 * Asteroids Player
 *
 * for the c't Competition 2008 (Creativ '08) 
 *
 * Copyright 2008, Volker Raum, Erlangen, Germany
 *
 */
package de.volkerraum.asteroids.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import de.volkerraum.asteroids.connection.MameConnection;
import de.volkerraum.asteroids.model.AsteroidsModel;

/**
 * @author   Volker Raum  (C) 2007
 */
public class ReplayControlFrame extends JFrame
{
   JButton             jButtonNextFrame      = new JButton("NEXT");
   JButton             jButtonNext5Frames    = new JButton("NEXT 5");
   JButton             jButtonNext20Frames   = new JButton("NEXT 20");
   JButton             jButtonSameFrame      = new JButton("SAME");
   JButton             jButtonPreviousFrame  = new JButton("PREVIOUS");

   JTextField          jTextFieldWantedFrame = new JTextField(4);
   JButton             jButtonGoToFrame      = new JButton("GoTo");

   JPanel              jPanelFrameCommand    = new JPanel();

   JButton             jButtonStop           = new JButton("STOP");
   JLabel              jLabelFramecount      = new JLabel("FRAME");

   JSlider             jSliderFrames         = new JSlider();

   JPanel              mainPanel             = new JPanel();
   FileInputStream     fis                   = null;
   byte[]              frameData             = new byte[MameConnection.RECEIVE_LENGTH];
   int                 framecount            = 0;

   List<byte[]>        frameList             = new ArrayList<byte[]>();

   AsteroidsModel      theModel              = null;
   FrameSliderListener sliderListener        = new FrameSliderListener();

   public ReplayControlFrame(final AsteroidsModel model)
   {
      super("REPLAY CONTROL");
      theModel = model;
      try
      {
         fis = new FileInputStream("frames.aff");
         int readBytes = 0;
         do
         {
            byte[] newFrame = new byte[MameConnection.RECEIVE_LENGTH];
            readBytes = fis.read(newFrame);
            frameList.add(newFrame);
         }
         while (readBytes == MameConnection.RECEIVE_LENGTH);

         fis.close();
      }
      catch (Exception e1)
      {
         System.err.println("Could not open frames.aff and read it");
         e1.printStackTrace();
         System.exit(1);
      }

      jSliderFrames.setMaximum(frameList.size() - 1);
      jSliderFrames.setValue(0);

      jSliderFrames.setMajorTickSpacing(frameList.size() / 20);
      jSliderFrames.setPaintTicks(true);
      jSliderFrames.setPaintTicks(true);
      jSliderFrames.setPaintLabels(true);

      mainPanel.setLayout(new GridBagLayout());

      jPanelFrameCommand.add(jButtonPreviousFrame);
      jPanelFrameCommand.add(jButtonSameFrame);
      jPanelFrameCommand.add(jButtonNextFrame);
      jPanelFrameCommand.add(jButtonNext5Frames);
      jPanelFrameCommand.add(jButtonNext20Frames);

      jPanelFrameCommand.add(jTextFieldWantedFrame);
      jPanelFrameCommand.add(jButtonGoToFrame);

      mainPanel.add(jLabelFramecount, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
      mainPanel.add(jSliderFrames, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(3, 3, 3, 3), 0, 0));
      mainPanel.add(jPanelFrameCommand, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
      mainPanel.add(jButtonStop, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));

      this.setContentPane(mainPanel);

      jButtonNextFrame.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent e)
         {
            framecount++;
            if (framecount == frameList.size())
               framecount--;
            jLabelFramecount.setText("FRAME # " + framecount);

            jSliderFrames.removeChangeListener(sliderListener);
            jSliderFrames.setValue(framecount);
            jSliderFrames.addChangeListener(sliderListener);
            model.analyseIncomingBytes(frameList.get(framecount));
         }
      });
      jButtonNext5Frames.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent e)
         {
            for (int i = 0; i < 5; ++i)
            {
               framecount++;
               if (framecount == frameList.size())
                  framecount--;
               jLabelFramecount.setText("FRAME # " + framecount);

               jSliderFrames.removeChangeListener(sliderListener);
               jSliderFrames.setValue(framecount);
               jSliderFrames.addChangeListener(sliderListener);
               model.analyseIncomingBytes(frameList.get(framecount));
            }

         }
      });
      jButtonGoToFrame.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent e)
         {
            int wantedFrame = Integer.parseInt(jTextFieldWantedFrame.getText());
            for (int i = 0; i < wantedFrame + 1; ++i)
            {
               model.analyseIncomingBytes(frameList.get(i));
            }
            framecount = wantedFrame;
            jLabelFramecount.setText("FRAME # " + framecount);

            jSliderFrames.removeChangeListener(sliderListener);
            jSliderFrames.setValue(framecount);
            jSliderFrames.addChangeListener(sliderListener);

         }
      });

      jButtonNext20Frames.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent e)
         {
            for (int i = 0; i < 20; ++i)
            {
               framecount++;
               if (framecount == frameList.size())
                  framecount--;
               jLabelFramecount.setText("FRAME # " + framecount);

               jSliderFrames.removeChangeListener(sliderListener);
               jSliderFrames.setValue(framecount);
               jSliderFrames.addChangeListener(sliderListener);
               model.analyseIncomingBytes(frameList.get(framecount));
            }

         }
      });

      jButtonPreviousFrame.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent e)
         {

            framecount--;
            if (framecount == -1)
               framecount = 0;
            jLabelFramecount.setText("FRAME # " + framecount);

            jSliderFrames.removeChangeListener(sliderListener);
            jSliderFrames.setValue(framecount);
            jSliderFrames.addChangeListener(sliderListener);
            model.analyseIncomingBytes(frameList.get(framecount));
         }
      });
      jButtonSameFrame.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent e)
         {
            model.analyseIncomingBytes(frameList.get(framecount));
         }
      });

      jSliderFrames.addChangeListener(sliderListener);

      jButtonStop.addActionListener(new ActionListener()
      {

         public void actionPerformed(ActionEvent e)
         {
            System.exit(0);
         }
      });

   }

   class FrameSliderListener implements ChangeListener
   {

      public void stateChanged(ChangeEvent e)
      {
         framecount = jSliderFrames.getValue();
         jLabelFramecount.setText("FRAME # " + framecount);
         theModel.analyseIncomingBytes(frameList.get(framecount));
      }

   }

}
