/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.analysis.AnimationListener;
import de.caff.asteroid.analysis.DumpFile;
import de.caff.asteroid.analysis.DumpFileLoadedListener;
import de.caff.asteroid.analysis.EnhancedFrameDisplay;
import de.caff.asteroid.analysis.TimeLine;
import de.caff.gimmicks.swing.ResourcedAction;
import de.caff.i18n.I18n;
import de.caff.i18n.swing.RJCheckBox;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ButtonBar
extends JToolBar
implements DumpFileLoadedListener {
    private static final int DEFAULT_ANIMATION_DELAY = 16;
    private static final String MEDIA_BUTTON_ICON_LOCATION = "/toolbarButtonGraphics/media/";
    private static final String MEDIA_BUTTON_ICON_EXTENSION = "16.gif";
    private AbstractAction playAction;
    private ResourcedAction skipBackAction;
    private ResourcedAction frameBackAction;
    private ResourcedAction frameForwardAction;
    private ResourcedAction skipForwardAction;
    private JCheckBox velocityCheckbox;
    private JCheckBox timeCheckBox;
    private JCheckBox antialiasCheckbox;
    private boolean running;
    private TimeLine timeLine;
    private Collection<AnimationListener> animationListeners = new LinkedList<AnimationListener>();
    private int animationDelay = 16;
    private FramePreparer velocityPreparer;

    static {
        I18n.addAppResourceBase("de.caff.asteroid.analysis.resources.ButtonBar");
    }

    private static Icon getIcon(String iconName) {
        return new ImageIcon(ButtonBar.class.getResource(MEDIA_BUTTON_ICON_LOCATION + iconName + MEDIA_BUTTON_ICON_EXTENSION));
    }

    public ButtonBar(final TimeLine timeLine, final EnhancedFrameDisplay frameDisplay, FramePreparer velocityPreparer) {
        this.timeLine = timeLine;
        this.velocityPreparer = velocityPreparer;
        this.skipBackAction = new ResourcedAction("actSkipBack"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DumpFile.Mark marker = timeLine.getPreviousMarker(timeLine.getCurrentIndex());
                if (marker != null) {
                    timeLine.setCurrentIndex(marker.getFrameIndex());
                }
            }

            @Override
            protected Object clone() throws CloneNotSupportedException {
                return super.clone();
            }
        };
        this.add(this.skipBackAction);
        this.frameBackAction = new ResourcedAction("actFrameBack"){

            @Override
            public void actionPerformed(ActionEvent e) {
                timeLine.setCurrentIndex(timeLine.getCurrentIndex() - 1);
            }

            @Override
            protected Object clone() throws CloneNotSupportedException {
                return super.clone();
            }
        };
        this.add(this.frameBackAction);
        this.addSeparator();
        this.playAction = new ResourcedAction("actPlay"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonBar.this.toggleRunning();
            }

            @Override
            protected Object clone() throws CloneNotSupportedException {
                return super.clone();
            }
        };
        this.playAction.putValue("SmallIcon", ButtonBar.getIcon("Play"));
        this.add(this.playAction);
        this.addSeparator();
        this.frameForwardAction = new ResourcedAction("actFrameForward"){

            @Override
            public void actionPerformed(ActionEvent e) {
                timeLine.setCurrentIndex(timeLine.getCurrentIndex() + 1);
            }

            @Override
            protected Object clone() throws CloneNotSupportedException {
                return super.clone();
            }
        };
        this.add(this.frameForwardAction);
        this.skipForwardAction = new ResourcedAction("actSkipForward"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DumpFile.Mark marker = timeLine.getNextMarker(timeLine.getCurrentIndex());
                if (marker != null) {
                    timeLine.setCurrentIndex(marker.getFrameIndex());
                }
            }

            @Override
            protected Object clone() throws CloneNotSupportedException {
                return super.clone();
            }
        };
        this.add(this.skipForwardAction);
        this.addSeparator(new Dimension(16, 16));
        this.velocityCheckbox = new RJCheckBox("cbVelocities", false);
        this.add(this.velocityCheckbox);
        this.velocityCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ButtonBar.this.runVelocityPreparer(timeLine.getDumpFile());
            }
        });
        this.timeCheckBox = new RJCheckBox("cbTime", true);
        this.add(this.timeCheckBox);
        this.timeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                frameDisplay.setShowingSessionTime(ButtonBar.this.timeCheckBox.isSelected());
            }
        });
        this.antialiasCheckbox = new RJCheckBox("cbAntialias", false);
        this.add(this.antialiasCheckbox);
        this.antialiasCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                frameDisplay.setUsingAntialising(ButtonBar.this.antialiasCheckbox.isSelected());
            }
        });
        this.addSeparator(new Dimension(16, 16));
        final JComboBox<AnimationSpeed> speeds = new JComboBox<AnimationSpeed>(AnimationSpeed.values());
        speeds.setSelectedItem((Object)AnimationSpeed.FULL_SPEED);
        speeds.setToolTipText(I18n.getString("tttSpeeds"));
        speeds.setMaximumSize(new Dimension(100, speeds.getPreferredSize().height));
        this.add(speeds);
        speeds.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ButtonBar.this.animationDelay = ((AnimationSpeed)((Object)speeds.getSelectedItem())).getDelay();
            }
        });
        timeLine.addDumpFileLoadedListener(this);
        this.loadedDumpfile(timeLine.getDumpFile());
    }

    private void runVelocityPreparer(DumpFile dumpFile) {
        if (dumpFile != null) {
            if (this.velocityCheckbox.isSelected()) {
                dumpFile.runPreparer(this.velocityPreparer);
            } else {
                dumpFile.runPreparer(new FramePreparer(){

                    @Override
                    public void prepareFrames(LinkedList<FrameInfo> frameInfos) {
                        FrameInfo last = frameInfos.getLast();
                        for (MovingGameObject mgo : last.getMovingGameObjects()) {
                            mgo.setVelocity(0.0, 0.0);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toggleRunning() {
        AbstractAction abstractAction = this.playAction;
        synchronized (abstractAction) {
            if (this.running) {
                this.stopRunning();
            } else {
                this.startRunning();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation() {
        AbstractAction abstractAction = this.playAction;
        synchronized (abstractAction) {
            this.stopRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAnimation() {
        AbstractAction abstractAction = this.playAction;
        synchronized (abstractAction) {
            this.startRunning();
        }
    }

    private void startRunning() {
        if (!this.running && this.timeLine.getDumpFile() != null) {
            this.running = true;
            this.playAction.putValue("SmallIcon", ButtonBar.getIcon("Stop"));
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        AbstractAction abstractAction = ButtonBar.this.playAction;
                        synchronized (abstractAction) {
                            if (!ButtonBar.this.running) {
                                return;
                            }
                        }
                        final int current = ButtonBar.this.timeLine.getCurrentIndex();
                        if (current + 1 == ButtonBar.this.timeLine.getFrameCount()) {
                            ButtonBar.this.toggleRunning();
                        }
                        if (current >= 0) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ButtonBar.this.timeLine.setCurrentIndex(current + 1);
                                }
                            });
                        } else {
                            ButtonBar.this.toggleRunning();
                        }
                        try {
                            Thread.sleep(ButtonBar.this.animationDelay);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            this.informAnimationListeners(true);
            thread.start();
        }
    }

    private void stopRunning() {
        if (this.running) {
            this.running = false;
            this.informAnimationListeners(false);
            this.playAction.putValue("SmallIcon", ButtonBar.getIcon("Play"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnimationRunning() {
        AbstractAction abstractAction = this.playAction;
        synchronized (abstractAction) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnimationListener(AnimationListener listener) {
        Collection<AnimationListener> collection = this.animationListeners;
        synchronized (collection) {
            this.animationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAnimationListener(AnimationListener listener) {
        Collection<AnimationListener> collection = this.animationListeners;
        synchronized (collection) {
            return this.animationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informAnimationListeners(boolean starting) {
        ArrayList<AnimationListener> listeners;
        Collection<AnimationListener> collection = this.animationListeners;
        synchronized (collection) {
            listeners = new ArrayList<AnimationListener>(this.animationListeners);
        }
        for (AnimationListener listener : listeners) {
            if (starting) {
                listener.animationStarting();
                continue;
            }
            listener.animationEnded();
        }
    }

    @Override
    public void loadedDumpfile(DumpFile dumpFile) {
        boolean active = dumpFile != null;
        Action[] actionArray = new Action[]{this.skipBackAction, this.frameBackAction, this.playAction, this.frameForwardAction, this.skipForwardAction};
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            action.setEnabled(active);
            ++n2;
        }
        this.runVelocityPreparer(dumpFile);
    }

    private static enum AnimationSpeed {
        SIXTEENTH_SPEED("1/16x", 16.0),
        EIGTH_SPEED("1/8x", 8.0),
        QUARTER_SPEED("1/4x", 4.0),
        HALF_SPEED("1/2x", 2.0),
        FULL_SPEED("1x", 1.0),
        DOUBLE_SPEED("2x", 0.5),
        FOUR_TIMES_SPEED("4x", 0.25);

        private String displayString;
        private double factor;

        private AnimationSpeed(String display, double factor) {
            this.displayString = display;
            this.factor = factor;
        }

        int getDelay() {
            return (int)Math.floor(16.0 * this.factor + 0.5);
        }

        public String toString() {
            return this.displayString;
        }
    }
}

