/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.settings.UrlListPreferenceProperty;
import de.caff.util.settings.swing.AbstractBasicSimpleEditablePreferenceProperty;
import de.caff.util.settings.swing.EditorProvider;
import de.caff.util.settings.swing.UrlListEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.prefs.Preferences;

public class SwingUrlListPreferenceProperty
extends AbstractBasicSimpleEditablePreferenceProperty
implements UrlListPreferenceProperty {
    private static final String PREF_KEY_SUFFIX_NR = "NR";
    private List urlList;

    public SwingUrlListPreferenceProperty(String basicName, String baseTag, Collection defaultList) {
        super(basicName, baseTag);
        this.urlList = defaultList != null ? new ArrayList(defaultList) : new ArrayList();
    }

    @Override
    public EditorProvider getEditorProvider(Locale l) {
        return new UrlListEditor(this, l);
    }

    @Override
    public void readFrom(Preferences preferences) {
        String tagPrefix = this.getBasicName();
        int size = preferences.getInt(String.valueOf(tagPrefix) + PREF_KEY_SUFFIX_NR, -1);
        if (size != -1) {
            boolean changed;
            ArrayList oldList = new ArrayList(this.urlList);
            this.urlList = new ArrayList(size);
            int index = 0;
            while (index < size) {
                String url = preferences.get(String.valueOf(tagPrefix) + index, null);
                if (url != null) {
                    this.urlList.add(url);
                }
                ++index;
            }
            if (oldList.size() != this.urlList.size()) {
                changed = true;
            } else {
                Iterator itOld = oldList.iterator();
                Iterator itNew = this.urlList.iterator();
                changed = false;
                while (itOld.hasNext() && itNew.hasNext()) {
                    if (itOld.next().equals(itNew.next())) continue;
                    changed = true;
                    break;
                }
                boolean bl = changed = changed || itOld.hasNext() ^ itNew.hasNext();
            }
            if (changed) {
                this.fireValueChange(this.getBasicName(), oldList, this.urlList);
            }
        }
    }

    @Override
    public void storeTo(Preferences preferences) {
        String tagPrefix = this.getBasicName();
        if (this.urlList == null) {
            preferences.putInt(String.valueOf(tagPrefix) + PREF_KEY_SUFFIX_NR, 0);
        } else {
            preferences.putInt(String.valueOf(tagPrefix) + PREF_KEY_SUFFIX_NR, this.urlList.size());
            int index = 0;
            for (String url : this.urlList) {
                preferences.put(String.valueOf(tagPrefix) + index, url);
                ++index;
            }
        }
    }

    public void addUrl(String url) {
        this.addUrl(url, -1);
    }

    public void addUrl(String url, int pos) {
        ArrayList oldList = new ArrayList(this.urlList);
        if (pos < 0 && pos >= this.urlList.size()) {
            this.urlList.add(url);
        } else {
            this.urlList.add(pos, url);
        }
        this.fireValueChange(this.getBasicName(), oldList, this.urlList);
    }

    public void remove(int pos) {
        if (pos >= 0 && pos < this.urlList.size()) {
            ArrayList oldList = new ArrayList(this.urlList);
            this.urlList.remove(pos);
            this.fireValueChange(this.getBasicName(), oldList, this.urlList);
        }
    }

    public void swap(int pos1, int pos2) {
        if (pos1 >= 0 && pos1 < this.urlList.size() && pos2 >= 0 && pos2 < this.urlList.size() && pos1 != pos2) {
            ArrayList oldList = new ArrayList(this.urlList);
            Collections.swap(this.urlList, pos1, pos2);
            this.fireValueChange(this.getBasicName(), oldList, this.urlList);
        }
    }

    @Override
    public Collection getUrlList() {
        return Collections.unmodifiableCollection(this.urlList);
    }

    void setUrlList(Collection newList) {
        boolean changed;
        if (newList.size() != this.urlList.size()) {
            changed = true;
        } else {
            Iterator itOld = this.urlList.iterator();
            Iterator itNew = newList.iterator();
            changed = false;
            while (itOld.hasNext() && itNew.hasNext()) {
                if (itOld.next().equals(itNew.next())) continue;
                changed = true;
                break;
            }
            changed = changed || itOld.hasNext() ^ itNew.hasNext();
        }
        List oldList = this.urlList;
        this.urlList = new ArrayList(newList);
        if (changed) {
            this.fireValueChange(this.getBasicName(), oldList, this.urlList);
        }
    }
}

