/*
 * Decompiled with CFR 0.152.
 */
package de.dkn.asteroids;

import de.caff.asteroid.Bullet;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import de.dkn.asteroids.DknDecisionData;
import de.dkn.asteroids.DknShootingDirPreparer;
import de.dkn.asteroids.DknStatistics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class DknDecisionPreparer
implements FramePreparer {
    private static final int MIN_BULLET_LIFETIME = 65;
    private static final int FRAMES_AHEAD_OBJECT_HYPERSPACE = 4;
    private static final int FRAMES_AHEAD_TOO_DANGEROUS_TOO_FIRE = 12;
    private static final int DEATH_TOLERANCE_FRAMES = 1;
    private static final int MAX_FRAMES_AHEAD_DANGEROUS_TARGET = 132;
    private static final int MAX_FIRST_SHOOTING_DIRECTION_DELTA = 130;
    private static final int MAX_FASTEST_SHOOTING_DIRECTION_DELTA = 44;
    private static final int MIN_SHIP_BULLET_SQUARED_SHIP_DISTANCE = 300;
    private static final int MAX_SHIP_BULLET_SQUARED_SHIP_DISTANCE = 500;
    private final TargetHitResult THR_NO_HIT = new TargetHitResult(0, null, null);
    private boolean firedLastTime = false;
    private DknDecisionData decision;
    private Bullet possibleBullet = new Bullet(0, 0, 0);
    private int nextId = 0;
    private static final int MAX_CONCURRENT_SHIP_BULLETS = 4;

    @Override
    public void prepareFrames(LinkedList<FrameInfo> frameInfos) {
        if (frameInfos.size() >= 1) {
            FrameInfo frame = frameInfos.getLast();
            DknDecisionData prevDecision = frameInfos.size() < 2 ? null : frameInfos.get(frameInfos.size() - 2).getDecisionData();
            this.decision = frame.getDecisionData();
            if (prevDecision != null) {
                this.decision.inherit(prevDecision);
            }
            DknStatistics.getInstance().setScore(frame.getScore());
            SpaceShip ship = frame.getSpaceShip();
            if (ship == null) {
                this.decision.hyperInProgress = false;
            } else {
                this.correctFailedShotIfNeededAndIdentifyShipBullets(frameInfos, frame, ship);
                this.setShipRelatedValuesInPotentiallyDangerousObjects(frame, ship);
                this.cleanupShotTargets(frame);
                this.splitPotentialTargetsIntoGroups(frame, prevDecision);
                if (this.escapeIfNecessary(frame, prevDecision)) {
                    return;
                }
                if (prevDecision != null && prevDecision.isHitExpectedInNextFrame()) {
                    this.fireIfAnyTargetWillBeHit(frame, ship, this.decision.allNotShotTargets, 0);
                }
                boolean turned = false;
                if (!this.decision.dangerousTargets.isEmpty()) {
                    turned = this.turnToHitAndFireLimited(frame, ship, this.decision.dangerousTargets, true);
                }
                if (!turned && !this.decision.highPrioTargets.isEmpty()) {
                    turned = this.turnToHitAndFireLimited(frame, ship, this.decision.highPrioTargets, true);
                }
                if (!turned) {
                    if (this.fireIfAnyTargetWillBeHit(frame, ship, this.decision.allNotShotTargets, 0)) {
                        MovingGameObject shotTarget = this.decision.fireThr.getShotTargetInfo().getShotTarget();
                        this.decision.lowPrioTargets.remove(shotTarget);
                    }
                    this.turnToHit(frame, ship, this.decision.lowPrioTargets, true);
                }
            }
        }
    }

    private void correctFailedShotIfNeededAndIdentifyShipBullets(LinkedList<FrameInfo> frameInfos, FrameInfo frame, SpaceShip ship) {
        ExpectedBulletInfo ebi = null;
        int i = frameInfos.size() - 2;
        while (i >= 0 && i >= frameInfos.size() - 3 && ebi == null) {
            FrameInfo fi = frameInfos.get(i);
            if (fi.getIndex() == frame.getIndex() - 2) {
                ebi = fi.getDecisionData().expectedBulletInfo;
            }
            --i;
        }
        if (ebi != null) {
            boolean expectedBulletOccuredExactly = false;
            boolean expectedBulletOccuredDeviant = false;
            for (Bullet bullet : frame.getBullets()) {
                if (bullet.getVelocityX() != 0.0 || bullet.getVelocityY() != 0.0) continue;
                int distanceSq = (int)bullet.getLocation().distanceSq(ship.getLocation());
                if (300 <= distanceSq && distanceSq <= 500) {
                    expectedBulletOccuredDeviant = true;
                    bullet.setIdentity(this.nextId++);
                }
                if (!bullet.getLocation().equals(ebi.getExpectedLocation())) continue;
                expectedBulletOccuredExactly = true;
                expectedBulletOccuredDeviant = false;
                break;
            }
            if (!expectedBulletOccuredExactly) {
                this.decision.shotTargets.remove(ebi.getTargetIdentity());
            }
            DknStatistics.getInstance().incrementBulletStatistics(expectedBulletOccuredExactly, expectedBulletOccuredDeviant);
        }
    }

    private void setShipRelatedValuesInPotentiallyDangerousObjects(FrameInfo frame, SpaceShip ship) {
        for (MovingGameObject o : frame.getPotentiallyDangerousObjects()) {
            o.setShipRelatedValues(ship, 132);
        }
    }

    private void cleanupShotTargets(FrameInfo frame) {
        HashMap<Integer, ShotTargetInfo> newShotTargets = new HashMap<Integer, ShotTargetInfo>();
        for (MovingGameObject target : frame.getPotentialTargets()) {
            Integer id = target.getIdentity();
            ShotTargetInfo sti = this.decision.shotTargets.get(id);
            if (sti == null || sti.targetShouldHaveBeenDeath(frame) || sti.targetIsUfoAndHasChangedDirection(target)) continue;
            newShotTargets.put(id, sti);
        }
        this.decision.shotTargets = newShotTargets;
    }

    private void splitPotentialTargetsIntoGroups(FrameInfo frame, DknDecisionData prevDecision) {
        this.decision.dangerousTargets = new ArrayList<MovingGameObject>();
        this.decision.highPrioTargets = new ArrayList<MovingGameObject>();
        this.decision.lowPrioTargets = new ArrayList<MovingGameObject>();
        this.decision.allNotShotTargets = new ArrayList<MovingGameObject>();
        for (MovingGameObject target : frame.getPotentialTargets()) {
            if (target.getIdentity() == null || this.decision.shotTargets.get(target.getIdentity()) != null) continue;
            if (target.isDangerous()) {
                this.decision.dangerousTargets.add(target);
            } else if (target instanceof Ufo) {
                this.decision.highPrioTargets.add(target);
            } else {
                this.decision.lowPrioTargets.add(target);
            }
            this.decision.allNotShotTargets.add(target);
        }
        Collections.sort(this.decision.dangerousTargets, new BySquaredShipDistance());
        Collections.sort(this.decision.highPrioTargets, new BySquaredShipDistance());
        Collections.sort(this.decision.lowPrioTargets, new BySquaredShipDistance());
        Collections.sort(this.decision.allNotShotTargets, new BySquaredShipDistance());
    }

    private boolean escapeIfNecessary(FrameInfo frame, DknDecisionData prevDecision) {
        for (MovingGameObject o : frame.getPotentiallyDangerousObjects()) {
            if (o.getHitShipInFrames() <= 0 || o.getHitShipInFrames() > 4) continue;
            for (MovingGameObject target : frame.getPotentialTargets()) {
                target.setDangerous(false);
            }
            if (prevDecision != null && prevDecision.hyperInProgress) break;
            this.decision.hyper = true;
            this.decision.hyperInProgress = true;
            break;
        }
        return this.decision.isHyper();
    }

    private boolean turnToHitAndFireLimited(FrameInfo frame, SpaceShip ship, List<MovingGameObject> turnToTargets, boolean findFirst) {
        boolean turned;
        TargetHitResult thr = this.turnToHit(frame, ship, turnToTargets, findFirst);
        int turns = thr.getTurns();
        boolean bl = turned = turns > 0;
        if (turns == 1) {
            this.decision.hitExpectedInNextFrame = true;
        } else if (turned) {
            if (frame.getShipBulletCount() < 3) {
                this.fireIfAnyTargetWillBeHit(frame, ship, this.decision.allNotShotTargets, 0);
            } else {
                this.fireIfAnyTargetWillBeHit(frame, ship, this.decision.allNotShotTargets, turns);
            }
        }
        return turned;
    }

    private boolean fireIfAnyTargetWillBeHit(FrameInfo frame, SpaceShip ship, List<MovingGameObject> targets, int maxHitInFrames) {
        TargetHitResult thr;
        boolean firedThisTime = false;
        if (!(this.firedLastTime || (thr = this.findFirstTargetHit(frame, ship, 0, 0, targets)).getHitInFrames() <= 0 || maxHitInFrames != 0 && thr.getHitInFrames() >= maxHitInFrames)) {
            this.decision.fireThr = thr;
            this.decision.expectedBulletInfo = thr.getExpectedBulletInfo();
            this.decision.shotTargets.put(thr.getShotTargetInfo().getTargetIdentity(), thr.getShotTargetInfo());
            this.decision.fire = true;
            firedThisTime = true;
        }
        this.firedLastTime = firedThisTime;
        return this.firedLastTime;
    }

    private TargetHitResult turnToHit(FrameInfo frame, SpaceShip ship, List<MovingGameObject> targets, boolean findFirst) {
        TargetHitResult thr = findFirst ? this.findFirstTargetHit(frame, ship, 1, 130, targets) : this.findFastestTargetHit(frame, ship, 1, 44, targets);
        if (thr.getHitInFrames() > 0 && thr.getVectoredTurns() > 0) {
            this.decision.turnThr = thr;
            this.decision.left = true;
            frame.turnNextShootingDirectionLeft();
            return thr;
        }
        if (thr.getHitInFrames() > 0 && thr.getVectoredTurns() < 0) {
            this.decision.turnThr = thr;
            this.decision.right = true;
            frame.turnNextShootingDirectionRight();
            return thr;
        }
        return this.THR_NO_HIT;
    }

    private TargetHitResult findFastestTargetHit(FrameInfo frame, SpaceShip ship, int fromShootDirDelta, int toShootDirDelta, List<MovingGameObject> targets) {
        TargetHitResult fastestThr = null;
        for (MovingGameObject target : targets) {
            int i = -toShootDirDelta;
            while (i <= toShootDirDelta) {
                int bulletOccurDelay;
                FrameInfo.Direction shootDirLeft;
                TargetHitResult thr;
                if ((i <= -fromShootDirDelta || i >= fromShootDirDelta) && (thr = this.evaluateTargetHitWithoutDirection(frame, ship, shootDirLeft = FrameInfo.SHOOTING_DIRECTIONS[DknShootingDirPreparer.normalize(frame.getProbableShootingDir() + i)], bulletOccurDelay = Math.abs(i) + 2, target)).getHitInFrames() > bulletOccurDelay) {
                    thr.setVectoredTurns(i);
                    if (fastestThr == null || thr.getHitInFrames() < fastestThr.getHitInFrames()) {
                        fastestThr = thr;
                    }
                }
                ++i;
            }
        }
        if (fastestThr == null) {
            return this.THR_NO_HIT;
        }
        return fastestThr;
    }

    private TargetHitResult findFirstTargetHit(FrameInfo frame, SpaceShip ship, int fromShootDirDelta, int toShootDirDelta, List<MovingGameObject> targets) {
        int i = fromShootDirDelta;
        while (i <= toShootDirDelta) {
            for (MovingGameObject target : targets) {
                TargetHitResult thr = this.evaluateTargetHitWithDirection(frame, ship, i, target);
                if (thr.getHitInFrames() <= 0 || this.tooDangerousToFire(target, thr.getHitInFrames())) continue;
                return thr;
            }
            ++i;
        }
        return this.THR_NO_HIT;
    }

    private boolean tooDangerousToFire(MovingGameObject target, int hitInFrames) {
        return !target.isDangerous() && !(target instanceof Ufo) && (target.getSize() == 32 || target.getSize() == 16) && hitInFrames > 0 && hitInFrames < 12;
    }

    private TargetHitResult evaluateTargetHitWithDirection(FrameInfo frame, SpaceShip ship, int i, MovingGameObject target) {
        int bulletOccurDelay;
        FrameInfo.Direction shootDirLeft = FrameInfo.SHOOTING_DIRECTIONS[DknShootingDirPreparer.normalize(frame.getProbableShootingDir() + i)];
        TargetHitResult thrLeft = this.evaluateTargetHitWithoutDirection(frame, ship, shootDirLeft, bulletOccurDelay = i + 2, target);
        if (thrLeft.getHitInFrames() > bulletOccurDelay) {
            thrLeft.setVectoredTurns(i);
            return thrLeft;
        }
        FrameInfo.Direction shootDirRight = FrameInfo.SHOOTING_DIRECTIONS[DknShootingDirPreparer.normalize(frame.getProbableShootingDir() - i)];
        TargetHitResult thrRight = this.evaluateTargetHitWithoutDirection(frame, ship, shootDirRight, bulletOccurDelay, target);
        if (thrRight.getHitInFrames() > bulletOccurDelay) {
            thrRight.setVectoredTurns(-i);
            return thrRight;
        }
        return this.THR_NO_HIT;
    }

    private TargetHitResult evaluateTargetHitWithoutDirection(FrameInfo frame, SpaceShip ship, FrameInfo.Direction shootDir, int bulletOccurDelay, MovingGameObject target) {
        double bvx = shootDir.getBulletVelocity().getX();
        double bvy = shootDir.getBulletVelocity().getY();
        int bx = ship.getX() + (int)shootDir.getDisplacement().getX();
        int by = ship.getY() + (int)shootDir.getDisplacement().getY();
        if (target.getVelocityX() != 0.0 || target.getVelocityY() != 0.0) {
            this.possibleBullet.setX((int)Math.round((double)bx - (double)bulletOccurDelay * bvx));
            this.possibleBullet.setY((int)Math.round((double)by - (double)bulletOccurDelay * bvy));
            this.possibleBullet.setVelocity(bvx, bvy);
            int hitInFrames = target.hitInFrames(this.possibleBullet, 65 + bulletOccurDelay);
            if (hitInFrames > 0) {
                return new TargetHitResult(hitInFrames, new ExpectedBulletInfo(frame, bx, by, target), new ShotTargetInfo(target, frame.getReceiveTime() + (long)((hitInFrames + 1) * 1000 / 60)));
            }
        }
        return this.THR_NO_HIT;
    }

    public class BySquaredShipDistance
    implements Comparator<MovingGameObject> {
        @Override
        public int compare(MovingGameObject o1, MovingGameObject o2) {
            int sd2;
            int sd1 = o1.getSquaredDistanceToShip();
            return sd1 < (sd2 = o2.getSquaredDistanceToShip()) ? -1 : (sd1 == sd2 ? 0 : 1);
        }
    }

    public class ExpectedBulletInfo {
        private int frameIndex;
        private int expectedX;
        private int expectedY;
        private Integer targetIdentity;

        public ExpectedBulletInfo(FrameInfo frame, int x, int y, MovingGameObject target) {
            this.frameIndex = frame.getIndex();
            this.expectedX = x;
            this.expectedY = y;
            this.targetIdentity = target.getIdentity();
        }

        public Point getExpectedLocation() {
            return new Point(this.expectedX, this.expectedY);
        }

        public Integer getTargetIdentity() {
            return this.targetIdentity;
        }

        public String toString() {
            return String.format("EBI[frameIndex=%d,expectedX=%d,expectedY=%d,targetIdentity=%s]", this.frameIndex, this.expectedX, this.expectedY, this.targetIdentity);
        }

        public int getFrameIndex() {
            return this.frameIndex;
        }
    }

    public class ShotTargetInfo {
        private Integer targetIdentity;
        private Point origin;
        private long expectedDeathTime;
        private MovingGameObject shotTarget;

        public ShotTargetInfo(MovingGameObject givenTarget, long givenExpectedDeathTime) {
            this.targetIdentity = givenTarget.getIdentity();
            this.origin = givenTarget.getOrigin();
            this.expectedDeathTime = givenExpectedDeathTime;
            this.shotTarget = givenTarget;
        }

        public boolean targetShouldHaveBeenDeath(FrameInfo frame) {
            return frame.getReceiveTime() > this.expectedDeathTime;
        }

        public boolean targetIsUfoAndHasChangedDirection(MovingGameObject target) {
            return target instanceof Ufo && !this.origin.equals(target.getOrigin());
        }

        public Integer getTargetIdentity() {
            return this.targetIdentity;
        }

        public long getExpectedDeathTime() {
            return this.expectedDeathTime;
        }

        public String toString() {
            return String.format("STI[id=%d,expectedDeathTime=%d]", this.targetIdentity, this.expectedDeathTime);
        }

        public Point getOrigin() {
            return this.origin;
        }

        public MovingGameObject getShotTarget() {
            return this.shotTarget;
        }
    }

    public class TargetHitResult {
        private int hitInFrames;
        private ExpectedBulletInfo expectedBulletInfo;
        private ShotTargetInfo shotTargetInfo;
        private int vectoredTurns;

        public TargetHitResult(int hitInFrames, ExpectedBulletInfo expectedBulletInfo, ShotTargetInfo shotTargetInfo) {
            this.hitInFrames = hitInFrames;
            this.expectedBulletInfo = expectedBulletInfo;
            this.shotTargetInfo = shotTargetInfo;
        }

        public int getHitInFrames() {
            return this.hitInFrames;
        }

        public ExpectedBulletInfo getExpectedBulletInfo() {
            return this.expectedBulletInfo;
        }

        public ShotTargetInfo getShotTargetInfo() {
            return this.shotTargetInfo;
        }

        public String toString() {
            if (this.expectedBulletInfo == null || this.shotTargetInfo == null) {
                return String.format("THR[hitInFrames=%d]", this.hitInFrames);
            }
            return String.format("THR[hitInFrames=%d,%s,%s]", this.hitInFrames, this.shotTargetInfo.toString(), this.expectedBulletInfo.toString());
        }

        public int getTurns() {
            return Math.abs(this.vectoredTurns);
        }

        public int getVectoredTurns() {
            return this.vectoredTurns;
        }

        public void setVectoredTurns(int vectoredTurns) {
            this.vectoredTurns = vectoredTurns;
        }
    }
}

