/*
 * Decompiled with CFR 0.152.
 */
package de.dkn.asteroids;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import de.caff.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;

public class DknVelocityPreparer
implements FramePreparer {
    private static final int ORIGIN_RESET_MAX_XY_CHANGE = 80;
    private static final double ORIGIN_RESET_UFO_ANGLE_CHANGE = 0.17453292519943295;
    private static final double NO_PAIR_BULLET_ANGLE_CHANGE = 2.9670597283903604;
    private static final int MAX_SQUARED_ASTEROID_VELOCITY = 36;
    protected static final int MAX_SQUARED_BULLET_VELOCITY = 256;
    private int nextId = 0;

    protected void prepareUfo(LinkedList<FrameInfo> frameInfos, FrameInfo prevFrame, FrameInfo currFrame) {
        Ufo prev;
        Ufo curr = currFrame.getUfo();
        if (curr != null && (prev = prevFrame.getUfo()) != null) {
            curr.inheret(prev);
            curr.setLifetime(prev.getLifetime() + currFrame.getLifetimeIncrement());
            curr.setVelocityFromDelta(prev);
            if (curr.getIdentity() == null) {
                curr.setIdentity(this.nextId++);
                curr.setOriginX(prev.getX());
                curr.setOriginY(prev.getY());
            } else {
                double ovx = (double)(curr.getX() - curr.getOriginX()) / (double)curr.getLifetime();
                double ovy = (double)(curr.getY() - curr.getOriginY()) / (double)curr.getLifetime();
                double vacc = Math.abs(curr.getVelocityAngle() - Math.PI);
                double vacp = Math.abs(prev.getVelocityAngle() - Math.PI);
                if (Math.abs(curr.getX() - prev.getX()) > 80 || Math.abs(curr.getY() - prev.getY()) > 80 || Math.abs(vacc - vacp) > 0.17453292519943295) {
                    curr.setOriginX(curr.getX());
                    curr.setOriginY(curr.getY());
                    curr.setLifetime(0);
                } else {
                    curr.setVelocity(ovx, ovy);
                }
            }
        }
    }

    protected void prepareSpaceShip(LinkedList<FrameInfo> frameInfos, FrameInfo prevFrame, FrameInfo currFrame) {
        SpaceShip ship = currFrame.getSpaceShip();
        if (ship != null) {
            ship.setVelocityFromDelta(prevFrame.getSpaceShip());
        }
    }

    protected void prepareAsteroids(LinkedList<FrameInfo> frameInfos, FrameInfo prevFrame, FrameInfo currFrame) {
        ArrayList<Integer> usedIds = new ArrayList<Integer>();
        AsteroidSelector selector = new AsteroidSelector(prevFrame.getAsteroids());
        for (Asteroid curr : currFrame.getAsteroids()) {
            Asteroid prev = selector.getBestMatch(curr, usedIds);
            if (prev == null) continue;
            curr.inheret(prev);
            curr.setLifetime(prev.getLifetime() + currFrame.getLifetimeIncrement());
            curr.setVelocityFromDelta(prev);
            if (curr.getIdentity() == null) {
                curr.setIdentity(this.nextId++);
                if (Math.abs(curr.getX() - prev.getX()) > 80 || Math.abs(curr.getY() - prev.getY()) > 80) {
                    curr.setOriginX(curr.getX());
                    curr.setOriginY(curr.getY());
                    curr.setLifetime(0);
                } else {
                    curr.setOriginX(prev.getX());
                    curr.setOriginY(prev.getY());
                }
            } else {
                double ovx = (double)(curr.getX() - curr.getOriginX()) / (double)curr.getLifetime();
                double ovy = (double)(curr.getY() - curr.getOriginY()) / (double)curr.getLifetime();
                curr.setVelocity(ovx, ovy);
                if (Math.abs(curr.getX() - prev.getX()) > 80 || Math.abs(curr.getY() - prev.getY()) > 80) {
                    curr.setOriginX(curr.getX());
                    curr.setOriginY(curr.getY());
                    curr.setLifetime(0);
                    curr.setVelocityFromDelta(prev);
                }
            }
            usedIds.add(curr.getIdentity());
        }
    }

    protected void prepareBullets(LinkedList<FrameInfo> frameInfos, FrameInfo prevFrame, FrameInfo currFrame) {
        for (Bullet oldBullet : prevFrame.getBullets()) {
            double futureX = (double)oldBullet.getX() + oldBullet.getVelocityX();
            double futureY = (double)oldBullet.getY() + oldBullet.getVelocityY();
            TreeMap<Double, Pair<Bullet>> result = new TreeMap<Double, Pair<Bullet>>();
            for (Bullet bullet : currFrame.getBullets()) {
                double dist2 = bullet.getSquaredDistance(futureX, futureY);
                if (!(dist2 < 256.0)) continue;
                bullet.setVelocityFromDelta(oldBullet);
                boolean oppositeVelocityX = Math.signum(Math.round(bullet.getVelocityX())) == -Math.signum(Math.round(oldBullet.getVelocityX()));
                boolean oppositeVelocityY = Math.signum(Math.round(bullet.getVelocityY())) == -Math.signum(Math.round(oldBullet.getVelocityY()));
                bullet.setVelocity(0.0, 0.0);
                if (oppositeVelocityX && oppositeVelocityY) continue;
                result.put(dist2, new Pair<Bullet>(oldBullet, bullet));
            }
            LinkedList pairs = new LinkedList(result.values());
            while (!pairs.isEmpty()) {
                Pair pair = (Pair)pairs.remove(0);
                ((Bullet)pair.second).setVelocityFromDelta((MovingGameObject)pair.first);
                ((Bullet)pair.second).setLifetime(((Bullet)pair.first).getLifetime() + currFrame.getLifetimeIncrement());
                ((Bullet)pair.second).setIdentity(((Bullet)pair.first).getIdentity());
                ListIterator it = pairs.listIterator();
                while (it.hasNext()) {
                    Pair p = (Pair)it.next();
                    if (!((Bullet)p.first).equals(pair.first) && !((Bullet)p.second).equals(pair.second)) continue;
                    it.remove();
                }
            }
        }
    }

    protected void prepareSingleFrame(FrameInfo frame) {
        for (Bullet bullet : frame.getBullets()) {
            bullet.setLifetime(1);
        }
    }

    @Override
    public void prepareFrames(LinkedList<FrameInfo> frameInfos) {
        if (frameInfos.size() >= 2) {
            FrameInfo currFrame = frameInfos.getLast();
            FrameInfo prevFrame = frameInfos.get(frameInfos.size() - 2);
            int idMinusLastId = currFrame.getId() - prevFrame.getId();
            if (idMinusLastId == 0) {
                currFrame.setLifetimeIncrement(1);
            } else if (idMinusLastId < 0) {
                currFrame.setLifetimeIncrement(idMinusLastId + 256);
            } else {
                currFrame.setLifetimeIncrement(idMinusLastId);
            }
            this.prepareUfo(frameInfos, prevFrame, currFrame);
            this.prepareSpaceShip(frameInfos, prevFrame, currFrame);
            this.prepareAsteroids(frameInfos, prevFrame, currFrame);
            this.prepareBullets(frameInfos, prevFrame, currFrame);
        } else if (!frameInfos.isEmpty()) {
            this.prepareSingleFrame(frameInfos.getLast());
        }
    }

    protected static class AsteroidSelector {
        private Map<Key, Collection<Asteroid>> sorted = new HashMap<Key, Collection<Asteroid>>();

        public AsteroidSelector(Collection<Asteroid> asteroids) {
            for (Asteroid ast : asteroids) {
                Key key = new Key(ast);
                Collection<Asteroid> list = this.sorted.get(key);
                if (list == null) {
                    list = new LinkedList<Asteroid>();
                    this.sorted.put(key, list);
                }
                list.add(ast);
            }
        }

        public Asteroid getBestMatch(Asteroid asteroid, List<Integer> usedIds) {
            Key key = new Key(asteroid);
            Collection<Asteroid> list = this.sorted.get(key);
            TreeMap<Double, Asteroid> result = new TreeMap<Double, Asteroid>();
            if (list != null) {
                double futureX = (double)asteroid.getX() + asteroid.getVelocityX();
                double futureY = (double)asteroid.getY() + asteroid.getVelocityY();
                for (Asteroid a : list) {
                    double dist2;
                    if (a.getIdentity() != null && usedIds.contains(a.getIdentity()) || !((dist2 = a.getSquaredDistance(futureX, futureY)) < 36.0)) continue;
                    result.put(dist2, a);
                }
            }
            int oldAsteroids = 0;
            for (Asteroid a : result.values()) {
                if (a.getIdentity() == null) continue;
                ++oldAsteroids;
            }
            return result.isEmpty() || oldAsteroids > 1 ? null : (Asteroid)result.values().iterator().next();
        }

        private static class Key {
            private final int type;
            private final int size;

            private Key(Asteroid ast) {
                this.type = ast.getType();
                this.size = ast.getSize();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key key = (Key)o;
                if (this.size != key.size) {
                    return false;
                }
                return this.type == key.type;
            }

            public int hashCode() {
                int result = this.type;
                result = 31 * result + this.size;
                return result;
            }
        }
    }
}

