// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings;

import java.util.Locale;
import java.util.prefs.Preferences;

/**
 *  Description of an enum value.
 *
 *  A enum value is described by a distinguished 
 *  human-readable name, maybe further description,
 *  a possibility to read it from and write it to
 *  a Preferences object and the real value which
 *  it represents.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public interface EnumValue
{
  /**
   *  Get a human readable name for this enum value.
   *  @param l locale to use
   *  @return  human readable short name
   */
  public String getShortName(Locale l);

  /**
   *  Get a longer description which describes this value.
   *  @param l locale to use
   *  @return human readable description or <code>null</code> if no description is available
   */
  public String getLongName(Locale l);

  /**
   *  Store this value to the preferences under the given key.
   *  @param preferences preferences to store to
   *  @param key key under which to store
   */
  public void storeTo(Preferences preferences, String key);

  /**
   *  Is this value equal to the value which is stored in the preferences under the given key?
   *  @param preferences preferences where a enum value is stored
   *  @param key key under which the enum value is stored
   *  @return <code>true</code> if the enum value is equal to the one stored in the preferences,
   *          <code>false</code> otherwise
   */
  public boolean isEqualTo(Preferences preferences, String key);

  /**
   *  Get the real value which is used in this enum.
   *  @return the real value
   */
  public Object getRealValue();
}
