package de.dkn.asteroids;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * <p>
 * Fhrt eine kleine Statistik darber, wie lange die Bearbeitung eines Frames braucht. Laut
 * Eintrgen im Forum muss ein Durchlauf in max. 16 ms erledigt sein, wovon ca. 8 ms auf den Netzweg
 * hin+zurck entfallen, der Berechnung bleiben damit 8 ms.
 * </p>
 * <p>
 * Die Klasse kann fr Singleton- und "normale" Instanzen verwendet werden.
 * </p>
 * <p>
 * HINWEIS: Die Domain de.dkn gehrt nicht mir, aber ich benutze das Krzel dkn schon sehr lange und
 * meine, bzw. unsere Domain de.familie-damken ist nicht Java-fhig und damit ist de.dkn aus meiner
 * Sicht genauso geeignet wie jede abweichende Schreibweise von de.familie-damken.
 * </p>
 * <p>
 * (c) 2008, by Uwe Damken
 * </p>
 */
public class DknStatistics {

	private static DknStatistics instance = new DknStatistics();

	private long sum = 0;

	private int score = 0;

	private int firePushed = 0;

	private int bulletFits = 0;

	private int bulletAlmostFits = 0;

	private int bulletMissfits = 0;

	private List<Integer> values = new ArrayList<Integer>(18500);

	public DknStatistics() {
	}

	public static DknStatistics getInstance() {
		return instance;
	}

	public void addValue(int value) {
		values.add(value);
		sum += value;
	}

	public void incrementFirePushed() {
		firePushed++;
	}

	public void incrementBulletStatistics(boolean fits, boolean almostFits) {
		if (fits) {
			bulletFits++;
		} else if (almostFits) {
			bulletAlmostFits++;
		} else {
			bulletMissfits++;
		}
	}

	public String toString() {
		Collections.sort(values);
		int n = values.size();
		int bulletsOccured = bulletFits + bulletAlmostFits + bulletMissfits;
		return String
				.format(
						"Statistics: (n/min/avg/max/10/50/90)=(%d/%d/%d/%d/%d/%d/%d), (pushed/fits/almost/miss/fits ratio/almost ratio)=(%d/%d/%d/%d/%d/%d), score=%d",
						n, values.get(0), sum / n, values.get(n - 1), values.get(n / 10), values
								.get(n / 2), values.get(n * 9 / 10), firePushed, bulletFits,
						bulletAlmostFits, bulletMissfits, (bulletsOccured == 0) ? 0 : bulletFits
								* 100 / bulletsOccured, (bulletsOccured == 0) ? 0
								: (bulletFits + bulletAlmostFits) * 100 / bulletsOccured, score);
	}

	public void setScore(int score) {
		this.score = score;
	}

	public int getN() {
		return values.size();
	}

}
