/*
 * Copyright (C) 2008 Henning Faber
 * 
 * This file is part of Sitting Duck Asteroids Bot project.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. 
 */
package de.hfaber.asteroids.client;


/**
 * Listener interface for receiving game status events.
 * 
 * @author Henning Faber
 */
public interface IGameStatusListener {

    /**
     * Invoked when a new game status has been received from the
     * mame server.
     * 
     * @param e the game status event that carries information about the
     *  updated game status
     */
    public void gameStatusUpdated(GameStatusEvent e);
    
}
