﻿/*
 * Asteroids Player Client 
 * 2008 ct-Wettbewerb
 * 
 * by Stefc (stefan.boether@gmail.com) */

using System;

namespace stefc.asteroids
{
    /// <summary>
    /// Represents one asteroid
    /// </summary>
    public class Asteroid : SpaceObject, IComparable<Asteroid>
    {
        
        public Asteroid(int x, int y, int size, int type):base(x,y,size)
        {
            Type = type;
        }
    
        public int Type { get; set; }

        
        public override int GetRadius()
        {
            switch (Size)
            {	
                case 0:  // großer Asteroid
                    return 32;
                    
                case 15: // mittlerer Asteroid
                    return 16;
                    
                case 14: // kleiner Asteroid
                    return  8;
                    
                default:
                    throw new NotImplementedException();
            }
        }
        #region IComparable<Asteroid> Members
        /// <summary>
        /// Asteroiden sind nach Größe und Typ sortiert
        /// </summary>
        /// <param name="other"></param>
        /// <returns></returns>
        public int CompareTo(Asteroid other)
        {
            if (other == null)
                return +1;
            int result = base.CompareTo(other);
            if (result != 0)
                return result;

            return Type.CompareTo(other.Type);
        }

        #endregion


     
     }
}
