#pragma once
#include <winsock2.h>
#include <stdio.h>

static const char KEY_HYPERSPACE = 1;
static const char KEY_FIRE = 2;
static const char KEY_THRUST = 4;
static const char KEY_RIGHT = 8;
static const char KEY_LEFT = 0x10;
static const char KEY_START = 0x20;

#pragma pack(1)
struct SKeyPack {
	char signature[6];

	unsigned char keys;
	unsigned char ping;

	SKeyPack() {
		signature[0] = 'c';
		signature[1] = 't';
		signature[2] = 'm';
		signature[3] = 'a';
		signature[4] = 'm';
		signature[5] = 'e';
		keys = '@';//64=01000000=A0
		ping = '@';
	}
};

struct SFramePack {
	char vectorram[1024];
	unsigned char cFrameNo;  // wird bei jedem Frame inkrementiert
	unsigned char cPing;     // Der Server schickt das letzte empfangene ping-Byte zurck
};
#pragma pack()

class CCommunicator
{
private:
	SOCKET	sd;
	DWORD	server_ip;
public:
	void Connect(const char* server_ip_str);

	void SendPacket(SKeyPack &packet);
	void ReceivePacket(SFramePack &packet);

	CCommunicator(void);
	~CCommunicator(void);
};
