#pragma once
#include "vector.h"
#include <math.h>

inline double Sigmoid(double x, double a)
{
	return 1/(1+exp(-x/a));
}
inline int	  RandInt(int x,int y) {return rand()%(y-x+1)+x;}
inline double RandFloat()		   {return (rand())/(RAND_MAX+1.0);}
inline bool   RandBool()
{
	if (RandInt(0,1)) return true;

	else return false;
}
inline double RandomClamped()	   {return RandFloat() - RandFloat();}
inline double ArcTan(double GegenKath, double AnKath)
{
	if ((AnKath>0)&&(GegenKath==0)) return 0;
	if ((AnKath==0)&&(GegenKath>0)) return PI/2;
	if ((AnKath<0)&&(GegenKath==0)) return PI;
	if ((AnKath==0)&&(GegenKath<0)) return 3*PI/2;
	if ((AnKath>0)&&(GegenKath>0)) return 0+atan(GegenKath/AnKath);
	if ((AnKath<0)&&(GegenKath>0)) return PI/2+(PI/2-atan(-GegenKath/AnKath));
	if ((AnKath<0)&&(GegenKath<0)) return PI+atan(GegenKath/AnKath);
	if ((AnKath>0)&&(GegenKath<0)) return 3*PI/2+(PI/2-atan(-GegenKath/AnKath));
	return 0;
}

//Berechnet. wohin man schieen muss um "object" zu treffen (mit Schussgeschwindigkeit 8 (die 64))
inline Vector WhereToShoot(Vector vShipPos, Vector vObjectPos, Vector vObjectDir)
{
	double dx=vObjectDir.x;
	double dy=vObjectDir.y;
	double x=vObjectPos.x-vShipPos.x;
	double y=vObjectPos.y-vShipPos.y;

	double radix=pow(((dx*x+dy*y)/(dx*dx+dy*dy-64)),2)-(x*x+y*y)/(dx*dx+dy*dy-64);
	
	double _t=0;
	if (radix>0) _t=-(dx*x+dy*y)/(dx*dx+dy*dy-64)+sqrt(radix);

	return (vObjectPos+vObjectDir*_t);
}

inline bool IntersectsCircle(Vector vPos, Vector vDir, Vector vCirclePos, double dCircleRadius)
{
	return (vCirclePos.DistanceToRay(vPos,vDir)<dCircleRadius);
}