#include "Communicator.h"

CCommunicator::CCommunicator(void)
{

}

CCommunicator::~CCommunicator(void)
{
}

void CCommunicator::Connect(const char* server_ip_str)
{
	printf("Initialisiere Verbindung zu %s\n", server_ip_str);
	server_ip = inet_addr(server_ip_str);
   if (server_ip == INADDR_NONE)
   {
      fprintf(stderr, "Ungueltige IP-Adresse: '%s'\n", server_ip_str);
      exit(1);
   }

   WSADATA wsadata;
   if (WSAStartup(MAKEWORD(2,2), &wsadata))
   {
      fprintf(stderr, "Fehler beim Initialisieren von Winsock.\n");
      exit(2);
   }

   sd = socket(AF_INET, SOCK_DGRAM, 0);
   if (sd == INVALID_SOCKET)
   {
      fprintf(stderr, "Fehler %d bei socket().\n", WSAGetLastError());
      exit(2);
   }

   unsigned long enable_nonblocking = 1;
   if (ioctlsocket(sd, FIONBIO, &enable_nonblocking))
   {
      fprintf(stderr, "Kann Socket nicht auf nonblocking setzen (%d)", WSAGetLastError());
      exit(1);
   }

   sockaddr_in sa;
   memset(&sa, 0, sizeof sa);
   sa.sin_family = AF_INET;
   sa.sin_addr.s_addr = 0;
   sa.sin_port = 0;


   if (bind(sd, (struct sockaddr*) &sa, sizeof sa))
   {
      fprintf(stderr, "Fehler %d bei bind().\n", WSAGetLastError());
      exit(2);
   }

	//Ein Paket schicken, sodass MAME wei, dass sich jemand verbindet
    //Tasten initialisieren
	SKeyPack FirstKeys;
	SendPacket(FirstKeys);
}

void CCommunicator::SendPacket(SKeyPack &packet)
{
   sockaddr_in server;
   memset(&server, 0, sizeof server);
   server.sin_family = AF_INET;
   server.sin_port = htons(1979);
   server.sin_addr.s_addr = server_ip;
   if ((int)sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
   {
      int err = WSAGetLastError();
      if (err != WSAEWOULDBLOCK)
      {
         fprintf(stderr, "Fehler %d bei sendto().\n", err);
         exit(1);
      }

   }
}

void CCommunicator::ReceivePacket(SFramePack &packet)
{
   // sockaddr_in sender;
   // int sender_size = sizeof sender;
   fd_set readfds, writefds, exceptfds;

   do
   {
      FD_ZERO(&readfds);
      FD_ZERO(&writefds);
      FD_ZERO(&exceptfds);
      FD_SET(sd, &readfds);
      FD_SET(sd, &exceptfds);
      select(sd+1, &readfds, &writefds, &exceptfds, NULL);
      int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
      if (bytes_received != (int)sizeof packet)
      {
         int err = WSAGetLastError();
         fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
         exit(1);
      }
      FD_ZERO(&readfds);
      FD_ZERO(&writefds);
      FD_ZERO(&exceptfds);
      FD_SET(sd, &readfds);
      timeval zero;
      zero.tv_sec = zero.tv_usec = 0;
      select(sd+1, &readfds, &writefds, &exceptfds, &zero);
   } while(FD_ISSET(sd, &readfds));
}
