﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ct.Asteroid
{
    class motion
    {
        //GameStatus asteroids_basegame = new GameStatus();
        coordinate[] asteroids = new coordinate[100];
        coordinate[] shots = new coordinate[10];
        coordinate saucer;
        int nasteroids = 0;
        int nshots = 0;
        int temp_dx;
        int temp_dy;
        bool saucer_was_present = false;
        collision MyCollision = new collision();


        public bool calculate_shots(GameStatus game)
        {
            //collision MyCollision = new collision();
            //Console.Clear();


            //Bewegungsvektor berechnen
            if (game.nshots == nshots)
            {
                for (int i = 0; i < nshots; ++i)
                {
                    temp_dx = game.shots[i].x - shots[i].x;
                    if (temp_dx > 512)
                        temp_dx -= 1023;
                    if (temp_dx < -512)
                        temp_dx += 1023;
                    game.shots[i].dx += temp_dx;

                    temp_dy = game.shots[i].y - shots[i].y;
                    if (temp_dy > 384)
                        temp_dy -= 767;
                    if (temp_dy < -384)
                        temp_dy += 767;
                    game.shots[i].dy += temp_dy;

                    //Im Schuß seinen Abstand zum Schiff eintragen
                    game.shots[i].DistanceToShip = game.ship.DistanceTo(game.shots[i].x, game.shots[i].y)
                                                     - game.shots[i].radius;

                    //Plausibilität der Zuordnung der Asteroiden überprüfen
                    //TODO: Besser in den Ablauf integrieren!!!
                    if (Math.Sqrt(temp_dx * temp_dx + temp_dy * temp_dy) > 20)
                    {
                        //hier passen die Werte nicht mehr zu einem Asteroiden
                        game.shots[i].dx = 0;
                        game.shots[i].dy = 0;
                        game.shots[i].motion_start = DateTime.Now;
                        game.shots[i].collision_time = 4000;
                        //die alten Positionen merken
                        shots[i].x = game.shots[i].x;
                        shots[i].y = game.shots[i].y;
                        continue;
                    }
                    //Kollision mit Schiff berechnen
                    MyCollision.Clear();
                    MyCollision.SetShot1(i, game);
                    MyCollision.SetShip2(game);
                    bool temp = MyCollision.DetectCollision(21, 5);
                    if ( MyCollision.collision_time > 10)           //Hiermit versuche ich eigene Schüsse auszublenden
                        game.shots[i].collision_time = MyCollision.collision_time;
                    //Console.WriteLine("DX:" + game.shots[i].dx.ToString() + " DY: " + game.shots[i].dy.ToString() + " Collision: " + game.shots[i].collision_time.ToString() + " Coll: " + temp.ToString());
                }
            }
            else
            {
                //alle Berechneten Vektoren löschen und die Zeit vermerken
                for (int i = 0; i < game.nshots; ++i)
                {
                    game.shots[i].dx = 0;
                    game.shots[i].dy = 0;
                    game.shots[i].motion_start = DateTime.Now;
                    //Im Shot seinen Abstand zum Schiff eintragen
                    game.shots[i].DistanceToShip = game.ship.DistanceTo(game.shots[i].x, game.shots[i].y)
                                                     - game.shots[i].radius;
                    game.shots[i].collision_time = 4000;

                }

            }

            //die alten Positionen merken
            for (int i = 0; i < game.nshots; ++i)
            {
                shots[i].x = game.shots[i].x;
                shots[i].y = game.shots[i].y;
            }

            nshots = game.nshots;
            return false;
        }


        public bool calculate_asteroids(GameStatus game)
        {
            //collision MyCollision = new collision();
            //Console.Clear();


            //Bewegungsvektor berechnen
            if (game.nasteroids == nasteroids)
            {
                for (int i = 0; i < nasteroids; ++i)
                {
                    temp_dx = game.asteroids[i].x - asteroids[i].x;
                    if (temp_dx > 50)
                        temp_dx -= 1023;
                    if (temp_dx < -50)
                        temp_dx += 1023;
                    game.asteroids[i].dx += temp_dx;

                    temp_dy = game.asteroids[i].y - asteroids[i].y;
                    if (temp_dy > 50)
                        temp_dy -= 767;
                    if (temp_dy < -50)
                        temp_dy += 767;
                    game.asteroids[i].dy += temp_dy;
                    //Im Asteroiden seinen Abstand zum Schiff eintragen
                    game.asteroids[i].DistanceToShip = game.ship.DistanceTo(game.asteroids[i].x, game.asteroids[i].y)
                                                     - game.asteroids[i].radius; 
                    //Im Asteroiden seinen Winkel vom Schiff aus eintragen
                    game.asteroids[i].AngleFromShip = Math.Atan2(game.ship.NormalizeToY(game.asteroids[i].y), game.ship.NormalizeToX(game.asteroids[i].x));
                    //Kollision mit Schiff berechnen
                    MyCollision.Clear();
                    MyCollision.SetAsteroid1(i, game);
                    MyCollision.SetShip2(game);
                    bool temp =  MyCollision.DetectCollision(101, 20);
                    game.asteroids[i].collision_time = MyCollision.collision_time;
                    //Console.WriteLine("DX:" + game.asteroids[i].dx.ToString() + " DY: " + game.asteroids[i].dy.ToString() + " Collision: " + game.asteroids[i].collision_time.ToString() + " Coll: " + temp.ToString() + " AngleRelShip: " + (game.asteroids[i].AngleFromShip - game.ship.Angle).ToString());
                    
                    //Wir wollen erkennen, ob das aktuelle Target schon getroffen wird.
                    //TODO: Großer Test
                    //if (i == game.CurrentTarget)
                    //{
                        for (int j = 0; j < game.nshots; j++)
                        {
                            MyCollision.Clear();
                            MyCollision.SetShot1(j, game);
                            MyCollision.SetAsteroid2(i, game);
                            if (MyCollision.DetectCollision(200, 5))
                            {
                                game.asteroids[i].dont_shoot_me = true;
                                statistics.NrOfDontShoots++;
                                break;

                            }

                        //}
                    }

                }
            }
            else
            {
                //alle Berechneten Vektoren löschen und die Zeit vermerken
                for (int i = 0; i < game.nasteroids; ++i)
                {
                    game.asteroids[i].dx = 0;
                    game.asteroids[i].dy = 0;
                    game.asteroids[i].motion_start = DateTime.Now;
                    game.asteroids[i].dont_shoot_me = false;
                    //Im Asteroiden seinen Abstand zum Schiff eintragen
                    game.asteroids[i].DistanceToShip = game.ship.DistanceTo(game.asteroids[i].x, game.asteroids[i].y) 
                                                     - game.asteroids[i].radius;
                    //if (game.nasteroids > 25)
                    //    Console.WriteLine("More than 25 asteroids");
                    
                }

            }

            //die alten Positionen merken
            for (int i = 0; i < game.nasteroids; ++i)
            {
                asteroids[i].x = game.asteroids[i].x;
                asteroids[i].y = game.asteroids[i].y;
            }

            nasteroids = game.nasteroids;
            return false;
        }

        public bool calculate_saucer(GameStatus game)
        {
            //Erster Fall: Das Ufo taucht gerade auf - Initialisierung
            if ((!saucer_was_present) && game.saucer.present)
            {
                saucer.x = game.saucer.x;
                saucer.y = game.saucer.y;
                game.saucer.dx = 0;
                game.saucer.dy = 0;
                game.saucer.motion_start = DateTime.Now;
                saucer_was_present = true;
                //Die Entfernung zum Schiff in das Ufo speichern
                game.saucer.DistanceToShip = game.ship.DistanceTo(game.saucer.x, game.saucer.y) - game.saucer.radius;
            }

            //Zweiter Fall: Das Ufo ist schon länger da - laufende Berechnung
            else if (saucer_was_present && game.saucer.present)
            {
                temp_dx = game.saucer.x - saucer.x;
                if (temp_dx > 50)
                    temp_dx -= 1023;
                if (temp_dx < -50)
                    temp_dx += 1023;

                temp_dy = game.saucer.y - saucer.y;
                if (temp_dy > 50)
                    temp_dy -= 767;
                if (temp_dy < -50)
                    temp_dy += 767;

                if (Math.Atan2(temp_dy, temp_dx) - Math.Atan2(game.saucer.dy, game.saucer.dx) < 0.2)
                {
                    game.saucer.dx += temp_dx;
                    game.saucer.dy += temp_dy;
                }
                else //das Schiff hat wohl seine Richtung geändert - Neustart!
                {
                    game.saucer.dx = temp_dx;
                    game.saucer.dy = temp_dy;
                    game.saucer.motion_start = DateTime.Now;
                    Console.WriteLine("Richtungsänderung UFO UFO UFO");
                }
                //die alten Positionen merken
                saucer.x = game.saucer.x;
                saucer.y = game.saucer.y;
                //Die Entfernung zum Schiff in das Ufo speichern
                game.saucer.DistanceToShip = game.ship.DistanceTo(game.saucer.x, game.saucer.y) - game.saucer.radius;
                //gucken ob es vom Schuss getroffen wird
                game.saucer.dont_shoot_me = false;
                for (int j = 0; j < game.nshots; j++)
                {
                    MyCollision.Clear();
                    MyCollision.SetShot1(j, game);
                    MyCollision.SetSaucer2(game);

                    if (MyCollision.DetectCollision(200, 5))
                    {
                        game.saucer.dont_shoot_me = true;
                    }
                }
            }
            //Dritter Fall - das Ufo ist nicht da - Automaten zurück setzen
            else
            {
                //alle Berechneten Vektoren löschen und die Zeit vermerken
                saucer_was_present = false;
                game.saucer.dont_shoot_me = false;
            }
            return false;
        }
    }
}
