﻿//#define DEBUG
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Net;
using System.Net.Sockets;


namespace ct.Asteroid
{

   public class Player
   {
       public const int NO_TARGET = 9999;
       public const int UFO_TARGET = 9998;
	    Socket mySocket;
	    IPAddress server_ip;
        DateTime TimeOut10Min = DateTime.Now;
        DateTime TimePerFrame = DateTime.Now;
        KeysPacket keys = new KeysPacket();
        GameStatus game = new GameStatus();
        int fps_counter = 0;
        int fps = 60;
        DateTime StartOfFpsMeasure = DateTime.Now;
        
        public Player(Socket sock, IPAddress server)
        {
            mySocket = sock;
            server_ip = server;
        }

        int SelectTargetAsteroid()
        {
            int first_collision_time = 9999;        //hier steht die nächste Aufprallzeit drin
            int first_collision_number = 9999;      //und hier, welcher Ast. trifft
            int fastest_hit_number = 9999;          //welcher Ast. ist am schnellsten zu treffen?
            int fastest_hit_score = 9999;           //Punkterating aus Winkel und Entfernung
            //Erstmal den aussuchen, der als erstes Kollidiert----------------------------
            for (int i = 0; i < game.nasteroids; ++i)
            {
                //if (game.asteroids[i].dont_shoot_me)
                //    continue;
                if ((game.asteroids[i].collision_time < first_collision_time)
                 && (game.asteroids[i].collision_time > 0))
                {
                    first_collision_time = game.asteroids[i].collision_time;
                    first_collision_number = i;
                }
            }
            //Kollisionserkennung Ende-----------------------------------------------------

            //Jetzt den aussuchen, den wir schnell abschießen können, erstmal einfach-----
            for (int i = 0; i < game.nasteroids; ++i)
            {
                int temp_score = (int) game.asteroids[i].DistanceToShip;
                //=======================wir probieren was anderes==================
                double winkel = game.ship.Angle - game.asteroids[i].AngleFromShip;
                if (winkel < -Math.PI)
                    winkel += 2 * Math.PI;
                if (winkel > Math.PI)
                    winkel -= 2 * Math.PI;
                //Jetzt geht der benötigte Drehwinkel mit ein
                temp_score = (int)(temp_score + Math.Abs(winkel * 100));
                //=======================wir probieren was anderes==================

                //temp_score = (int) TotalShotTime(i);
               

                //Und jetzt die Größe des Asteroiden. Kleiner = Besser.
                temp_score = temp_score + (game.asteroids[i].radius);
                //falls der asteroid wahrscheinlich schon getroffen wird, bekommt er einen miesen score
                if (game.asteroids[i].dont_shoot_me && (game.asteroids[i].radius < 40))
                    temp_score = temp_score * 4;

                if (temp_score < fastest_hit_score)
                {
                    fastest_hit_score = temp_score;
                    fastest_hit_number = i;
                }
            }
            //Reihenfolgeerkennung Ende-----------------------------------------------------

            if (first_collision_time < 1000)
            {
                return first_collision_number;
            }
            else
                return fastest_hit_number;


        }


        double AimToTarget(int target, double offset_time, ref double flight_time)
        {
            int dx = 0;
            int dy = 100;
            int dist = 0;
            double shot_time = 0;
            if (target == UFO_TARGET)
            {
                coordinate temp = new coordinate();
                temp = game.saucer.GetFuturePosition(offset_time);
                temp.x = game.ship.NormalizeToX(temp.x);
                temp.y = game.ship.NormalizeToY(temp.y);

                for (int i = 0; i < 20; i++)
                {
                    //Die Entfernung Schiff / projezierter Zielpunkt
                    dist = (int)(Math.Sqrt(temp.x * temp.x + temp.y * temp.y));
                    //Wie lange braucht ein Schuss dahin?
                    shot_time = (dist * 1000 / (fps * 8)) +(1 * 1000 / fps); //1 Framezeiten dranhängen
                    //Wo ist nach dieser Zeit der Asteroid, also unser neuer Zielpunkt?
                    temp = game.saucer.GetFuturePosition(offset_time + shot_time);
                    //temp ist jetzt absolut, machen wir es doch wieder relativ zum Schiff
                    temp.x = game.ship.NormalizeToX(temp.x);
                    temp.y = game.ship.NormalizeToY(temp.y);
                }

                flight_time = shot_time;
                return Math.Atan2(temp.y, temp.x);
            }
            else if (target == NO_TARGET)
            {
                flight_time = 0;
                return Math.Atan2(dy, dx);
                //TODO: Was, wenn wir kein Ziel haben?
            }
            else
            {
                coordinate temp = new coordinate();
                temp = game.asteroids[target].GetFuturePosition(offset_time);
                temp.x = game.ship.NormalizeToX(temp.x);
                temp.y = game.ship.NormalizeToY(temp.y);

                for (int i = 0; i < 20; i++)
                {
                    //Die Entfernung Schiff / projezierter Zielpunkt
                    dist = (int)(Math.Sqrt(temp.x * temp.x + temp.y * temp.y));
                    //Wie lange braucht ein Schuss dahin?
                    shot_time = (dist * 1000 / (fps * 8)) +(1 * 1000 / fps); //1 Framezeiten dranhängen
                    //Wo ist nach dieser Zeit der Asteroid, also unser neuer Zielpunkt?
                    temp = game.asteroids[target].GetFuturePosition(offset_time + shot_time);
                    //temp ist jetzt absolut, machen wir es doch wieder relativ zum Schiff
                    temp.x = game.ship.NormalizeToX(temp.x);
                    temp.y = game.ship.NormalizeToY(temp.y);
                }
                flight_time = shot_time;
                return Math.Atan2(temp.y, temp.x);
            }
            
        }

        double TotalShotTime(int target)
        {
            double flight_time = 0;
            double turn_time = 0;
            double AngleToShoot = 0;
            for (int i = 0; i < 20; i++)
            {
                AngleToShoot = AimToTarget(target, turn_time, ref flight_time);
                double turn_angle = game.ship.Angle - AngleToShoot;
                if (turn_angle < -Math.PI)
                    turn_angle += 2 * Math.PI;
                if (turn_angle > Math.PI)
                    turn_angle -= 2 * Math.PI;
                //Jetzt wirds dreckig, der Wettbewerb ist fast vorbei: Wir merken uns den Winkel, 
                //den wir uns verdrehen müßten um in diesem Zug zu schießen
                if (turn_time == 0)
                {
                    game.asteroids[target].NeededShotAngleNow = turn_angle;
                }

                //Zeit für die gewünschte Drehung in ms
                turn_time = ((Math.Abs(turn_angle) * 85.33) / (2 * Math.PI) ) * 1000 / fps;
            }

            return (turn_time + flight_time);
        }

        public void Run()
        {
	        FramePacket frame = new FramePacket();

	        
            motion my_motion = new motion();
	        //char prevframe = (char)0;
	        int t = 0;

            game.clear(true);
            keys.start(true);
            SendPacket(keys);
	        for (;;)
	        {
                Thread.Sleep(1);
		        //++t;         // Zeit
		        //SendPacket(keys);
                frame = ReceivePacket();
                if (frame == null) continue;
                TimePerFrame = DateTime.Now;
                ++keys.ping; // jedes gesendete Päckchen erhält eine individuelle Nummer zur Latenzmessung
                //if (keys.ping > 255) keys.ping = (char)0;

                MeasureFps();

		        InterpretScreen(frame, game);
                game.ship.HandleWinkelByte((byte)frame.ping);
                my_motion.calculate_asteroids(game);
                my_motion.calculate_shots(game);
                my_motion.calculate_saucer(game);
		        keys.clear();   // alle Tasten loslassen
                //10 Minuten überwachen.
                TimeOutOneGame();

                int target = NO_TARGET;
                double AngleToShoot = 1;

                if (game.ship.present)
                {
                    if ((game.saucer.present) && (!game.saucer.dont_shoot_me))
                    {
                        target = UFO_TARGET;
                    }

                    int target_asteroid = SelectTargetAsteroid();

                    if (target_asteroid != NO_TARGET)
                    {
                        //Wenn wir noch kein Target (Ufo) haben, oder der Asteroid gefährlicher ist als das Ufo
                        if ((target == NO_TARGET) || (game.asteroids[target_asteroid].collision_time < 300))
                        {
                            target = target_asteroid;
                        }
                    }
                    game.CurrentTarget = target;
                    double dummy = 0;
                    AngleToShoot = AimToTarget(target,0, ref dummy);

                    double genauigkeit = game.ship.Angle - AngleToShoot;
                    if (genauigkeit < -Math.PI)
                        genauigkeit += 2 * Math.PI;
                    if (genauigkeit > Math.PI)
                        genauigkeit -= 2 * Math.PI;

                    // Schiff in Richtung auf das nächstgelegene Objekt drehen
                    // mathematisch wird hier das Kreuzprodukt aus den Vektoren 
                    // ship_dx/y/0 und min_dx/y/0 berechnet
                    if (genauigkeit < -0.04)
                        keys.left(true);
                    if (genauigkeit > 0.04)
                        keys.right(true);

                    if (HitByAsteroid())  // Flucht, wenn Kollision unausweichlich
                        keys.hyperspace(true);
                    if (HitByEnemyShot())//Flucht, wenn wir gleich abgeschossen werden.
                    {
                        keys.hyperspace(true);
                    }

                    //if (min_dist > 400 * 400) // beschleunigen, wenn nichts in der Nähe
                    //    keys.thrust(true);
                    //int anzahl_schuesse_temp = 4;
                    //if (game.saucer.present)
                    //    anzahl_schuesse_temp = 6;

                    if ((Math.Abs(genauigkeit) < 0.1) && (game.CurrentTarget != NO_TARGET) /*&& (game.nshots < anzahl_schuesse_temp)*/) //0.05
                    {
                        if (t++ % 2 == 0)  // Feuerknopf drücken, so schnell es geht
                        {
                            keys.fire(true);
                            keys.left(false);
                            keys.right(false);

                            ////TODO Großer Versuch!
                            if ((game.CurrentTarget != UFO_TARGET))
                                game.asteroids[target].dont_shoot_me = true;
                        }
                    }
                    else
                    {
                        t = 0;
                    }
                    ////Die zwischendurch-Asteroiden erledigen
                    //for (int i = 0; i < game.nasteroids; i++)
                    //{
                    //    genauigkeit = game.asteroids[i].NeededShotAngleNow;

                    //    if ((Math.Abs(genauigkeit) < 0.1) && (!game.asteroids[i].dont_shoot_me))
                    //    {

                    //        keys.fire(true);
                    //        keys.left(false);
                    //        keys.right(false);
                    //        game.asteroids[i].dont_shoot_me = true;
                    //        break;
                    //    }

                    //}
#if DEBUG
                    if (game.CurrentTarget == NO_TARGET)
                    {
                        Console.WriteLine("NO TARGET");
                    }
         
#endif
                    game.ship.HandlePostWinkelByte(keys);
                }
                else
                {
                    //if (t % 2 == 0)  //Startknopf
                    //    keys.start(true);
                }
                
                SendPacket(keys);
                TimeSpan temptime = DateTime.Now - TimePerFrame;
                //Console.WriteLine(" TimePerFrame: " + temptime.TotalMilliseconds.ToString());
	        }
        }

        public bool HitByEnemyShot()
        {
            for (int i = 0; i < game.nshots; i++)
            {
                if (game.shots[i].collision_time < 50)
                {
                    return true;
                }
            }
            return false;
        }

        public bool HitByAsteroid()
        {
            for (int i = 0; i < game.nasteroids; i++)
            {
                if ((game.asteroids[i].collision_time < 50) &&
                    (game.asteroids[i].collision_time > 0))
                {
                    return true;
                }
            }
            return false;
        }

        private void MeasureFps()
        {
            //Schauen, wie viele frames wir in einer Sekunde haben
            fps_counter++;
            if (DateTime.Now.Ticks > (StartOfFpsMeasure.Ticks + 10000000))
            {
                fps = fps_counter;
                fps_counter = 0;
                StartOfFpsMeasure = DateTime.Now;
            }
        }

        unsafe void InterpretScreen(FramePacket packet, GameStatus game)
        {
	        ushort[] vector_ram = packet.vectorram2;
	        int dx;
            int dy;
            int sf;
            int vx = 0;
            int vy = 0, vz = 0, vs = 0;
	        int v1x = 0;
	        int v1y = 0;
	        int shipdetect = 0;

	        game.clear(false);
	        if (packet.vectorram[1] != 0xe0 && packet.vectorram[1] != 0xe2)
		        return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	        int pc = 1;
	        for (;pc < 513;)
	        {
                int op = vector_ram[pc] >> 12; ;
		        switch (op)
		        {
		        case 0xa: // LABS
			        vy = vector_ram[pc] & 0x3ff;
			        vx = vector_ram[pc+1] & 0x3ff;
			        vs = vector_ram[pc+1] >> 12;
			        break;
		        case 0xb: // HALT
			        return;
		        case 0xc: // JSRL
			        switch (vector_ram[pc] & 0xfff)
			        {
			        case 0x8f3:
				        game.asteroids[game.nasteroids++].set(vx, vy, 1, vs);
				        break;
			        case 0x8ff:
				        game.asteroids[game.nasteroids++].set(vx, vy, 2, vs);
				        break;
			        case 0x90d:
				        game.asteroids[game.nasteroids++].set(vx, vy, 3, vs);
				        break;
			        case 0x91a:
				        game.asteroids[game.nasteroids++].set(vx, vy, 4, vs);
				        break;
			        case 0x929:
				        game.saucer.present = true;
				        game.saucer.x = vx;
				        game.saucer.y = vy;
				        game.saucer.size = vs;
                        switch (game.saucer.size)
                        {	// den ungefähren Radius des UFOs eintragen
                            case 15: // großes UFO
                                game.saucer.radius = 20;
                                break;
                            case 14: // kleines UFO
                                game.saucer.radius = 10;
                                break;
                        }
				        break;
			        }  
			        break;
		        case 0xd: // RTSL
			        return;
		        case 0xe: // JMPL
			        /*
			        pc = vector_ram[pc] & 0xfff;
			        break;
			        */
			        return;
		        case 0xf: // SVEC
			        /*
			        dy = vector_ram[pc] & 0x300;
			        if ((vector_ram[pc] & 0x400) != 0)
				        dy = -dy;
			        dx = (vector_ram[pc] & 3) << 8;
			        if ((vector_ram[pc] & 4) != 0)
				        dx = -dx;
			        sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			        vz = (vector_ram[pc] & 0xf0) >> 4;
			        */
			        break;
		        default:
			        dy = vector_ram[pc] & 0x3ff;
			        if ((vector_ram[pc] & 0x400) != 0)
				        dy = -dy;
			        dx = vector_ram[pc+1] & 0x3ff;
			        if ((vector_ram[pc+1] & 0x400) != 0)
				        dx = -dx;
			        sf = op;
			        vz = vector_ram[pc+1] >> 12;
			        if (dx == 0 && dy == 0 && vz == 15)
				        game.shots[game.nshots++].set(vx, vy);
			        if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			        {
				        switch (shipdetect)
				        {
				        case 0:
					        v1x = dx;
					        v1y = dy;
					        ++shipdetect;
					        break;
				        case 1:
					        game.ship.present = true;
					        game.ship.x = vx;
					        game.ship.y = vy;
					        game.ship.dx = v1x - dx;
					        game.ship.dy = v1y - dy;
                            //game.ship.Angle = Math.Atan2(game.ship.dy, game.ship.dx);
					        ++shipdetect;
					        break;
				        }
			        }
			        else if (shipdetect == 1)
				        shipdetect = 0;

			        break;
		        }
		        if (op <= 0xa)
			        ++pc;
		        if (op != 0xe) // JMPL
			        ++pc;
	        }   

        }

        void TimeOutOneGame()
        {
#if DEBUG

            TimeSpan temp;
            temp = DateTime.Now - TimeOut10Min;
            Console.Clear();
            Console.WriteLine("FPS: " + fps.ToString());
            Console.WriteLine(" Zeit: " + (300-temp.TotalSeconds));
            if (game.ship.present)
                    game.stats.print();
            if (temp.TotalMinutes >= 5) 
            {
                TimeOut10Min = DateTime.Now;
                do
                {
                    temp = DateTime.Now - TimeOut10Min;
                    keys.hyperspace(true);
                    SendPacket(keys);
                    Thread.Sleep(200);
                    keys.hyperspace(false);
                    SendPacket(keys);
                    Thread.Sleep(200);
                    Console.Clear();
                    Console.WriteLine("FPS: " + fps.ToString());
                    Console.WriteLine(" Zeit: " + (180 - temp.TotalSeconds));
                    game.stats.print();

                } while (temp.TotalMinutes < 3);
                TimeOut10Min = DateTime.Now;
                keys.start(true);
                SendPacket(keys);
                Thread.Sleep(20);
                keys.start(false);
                SendPacket(keys);
                Thread.Sleep(20);
                keys.start(true);
                SendPacket(keys);
                Thread.Sleep(20);
                keys.start(false);
                SendPacket(keys);
                Thread.Sleep(20);
                keys.start(true);
                SendPacket(keys);
                Thread.Sleep(20);
                keys.start(false);
                SendPacket(keys);
                Thread.Sleep(20);
                keys.start(true);
                SendPacket(keys);
                game.stats.clear();

            }
#endif
        }


        public FramePacket ReceivePacket()
        {

            if (mySocket.Available == 0) return null;

            int received = 0;

            EndPoint myRemoteEndpoint = new IPEndPoint(server_ip, 1979);
            
            byte[] receiveBytes = new byte[mySocket.Available];

            try
            {
                received = mySocket.ReceiveFrom(receiveBytes, ref myRemoteEndpoint);
            }
            catch (Exception e)
            {
                Console.WriteLine("Exception in ReceivePacket():" + e.Message);
                
            }
            if (received == 5)
            {
                Console.WriteLine("Busy");
            }
            return FramePacket.FromByteArray(receiveBytes);
        }

      
        void SendPacket(KeysPacket packet)
        {

            byte[] bytCommand = packet.ToByteArray();

            int pret = mySocket.SendTo(bytCommand, bytCommand.Length, SocketFlags.None, new IPEndPoint(server_ip, 1979));
            
        }
    }
}
