
//Hier speichern wir, welche mglichen Positionen die Asteroiden im ersten Level haben knnen.
//Da Asteroids leider das untere Byte von einer Positionskomponente nicht setzt (also der alte
//Inhalt aus dem letzten Spiel bernommen wird), ist die Sache leider nicht so einfach, wie
//man zuerst annehmen knnte.
//Die erste Dimension in der Tabelle gibt den Index vom Seed an, der im ersten Frame des Spiels gilt.
//Die zweite gibt den entsprechenden Asteroiden an.

const
struct
{
	byte Status;
	bool XComponentExact;//Asteroids setzt nur eine Komponente auf einen festen Wert.
	word MinComponent, MaxComponent;//Der Bereich, in dem eine der Komponenten liegt. Durch 8 geteilt.
	word ExactComponent;//Die jeweils andere Komponente
	char VelocityX, VelocityY;
}
AsteroidStartPositions[NumSeedCombinations][4] = 
{
	{ { 0x0c, true , 0x023e, 0x025e, 0x000b, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x009e, 0x00be, 0x1ff8, (char)0xf8, (char)0xf5}, },
	{ { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x0c, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, },
	{ { 0x14, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x037e, 0x039e, 0x000c, (char)0xf5, (char)0x0c}, { 0x14, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x02de, 0x02fe, 0x1ff9, (char)0xf9, (char)0xf7}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, { 0x04, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x01fe, 0x021e, 0x0006, (char)0xf7, (char)0x06}, { 0x04, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, },
	{ { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, },
	{ { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x0c, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x000b, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, },
	{ { 0x14, true , 0x029f, 0x02bf, 0x000f, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x037e, 0x039e, 0x000c, (char)0xf5, (char)0x0c}, },
	{ { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02de, 0x02fe, 0x1ff9, (char)0xf9, (char)0xf7}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, },
	{ { 0x1c, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x01fe, 0x021e, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, },
	{ { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x000b, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, },
	{ { 0x14, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x000f, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, },
	{ { 0x1c, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02de, 0x02fe, 0x1ff9, (char)0xf9, (char)0xf7}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, },
	{ { 0x14, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x0d, (char)0xf9}, },
	{ { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x000b, (char)0x0b, (char)0xf2}, },
	{ { 0x14, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x000f, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x0c, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02de, 0x02fe, 0x1ff9, (char)0xf9, (char)0xf7}, },
	{ { 0x14, true , 0x007e, 0x009e, 0x000a, (char)0x0a, (char)0xf4}, { 0x14, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, },
	{ { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, },
	{ { 0x14, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x04, false, 0x02e1, 0x0301, 0x17f7, (char)0x09, (char)0xf7}, { 0x04, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, false, 0x01be, 0x01de, 0x000e, (char)0xf2, (char)0x0e}, { 0x0c, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x14, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x007e, 0x009e, 0x000a, (char)0x0a, (char)0xf4}, { 0x14, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, },
	{ { 0x04, true , 0x021f, 0x023f, 0x000b, (char)0x0b, (char)0xf9}, { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0e, (char)0xf6}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf6, (char)0x0e}, },
	{ { 0x0c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, { 0x04, false, 0x02e1, 0x0301, 0x17f7, (char)0x09, (char)0xf7}, { 0x04, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x01be, 0x01de, 0x000e, (char)0xf2, (char)0x0e}, { 0x0c, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x14, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x007e, 0x009e, 0x000a, (char)0x0a, (char)0xf4}, { 0x14, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, },
	{ { 0x04, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x021f, 0x023f, 0x000b, (char)0x0b, (char)0xf9}, { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xf9, (char)0xf5}, },
	{ { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0e, (char)0xf6}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x04, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, { 0x04, false, 0x02e1, 0x0301, 0x17f7, (char)0x09, (char)0xf7}, { 0x04, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x04, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x01be, 0x01de, 0x000e, (char)0xf2, (char)0x0e}, { 0x0c, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x0c, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x007e, 0x009e, 0x000a, (char)0x0a, (char)0xf4}, },
	{ { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x09, (char)0xf7}, { 0x04, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x021f, 0x023f, 0x000b, (char)0x0b, (char)0xf9}, { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, },
	{ { 0x14, true , 0x02a1, 0x02c1, 0x1ff5, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0e, (char)0xf6}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, },
	{ { 0x0c, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, { 0x04, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, { 0x04, false, 0x02e1, 0x0301, 0x17f7, (char)0x09, (char)0xf7}, },
	{ { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x01be, 0x01de, 0x000e, (char)0xf2, (char)0x0e}, },
	{ { 0x0c, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x09, (char)0xf7}, { 0x04, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x021f, 0x023f, 0x000b, (char)0x0b, (char)0xf9}, },
	{ { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff5, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0e, (char)0xf6}, },
	{ { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x1c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, { 0x04, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, },
	{ { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0a, (char)0xf3}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x00c0, 0x00e0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x14, false, 0x019f, 0x01be, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x09, (char)0xf7}, { 0x04, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x14, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff5, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x04, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, { 0x04, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x0c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0a, (char)0xf3}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x14, true , 0x027e, 0x029e, 0x0009, (char)0x09, (char)0xf4}, { 0x14, false, 0x019f, 0x01be, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x09, (char)0xf7}, },
	{ { 0x0c, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x14, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff5, (char)0xf5, (char)0x0d}, },
	{ { 0x04, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x01de, 0x01fe, 0x000f, (char)0xf4, (char)0x0f}, { 0x04, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, },
	{ { 0x14, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0a, (char)0xf3}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x0c, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, { 0x14, true , 0x027e, 0x029e, 0x0009, (char)0x09, (char)0xf4}, { 0x14, false, 0x019f, 0x01be, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, },
	{ { 0x0c, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, true , 0x01ff, 0x021e, 0x000d, (char)0x0d, (char)0xf8}, { 0x04, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x01de, 0x01fe, 0x000f, (char)0xf4, (char)0x0f}, { 0x04, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0a, (char)0xf3}, },
	{ { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x0c, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, { 0x14, true , 0x027e, 0x029e, 0x0009, (char)0x09, (char)0xf4}, { 0x14, false, 0x019f, 0x01be, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x1c, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, },
	{ { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x1ff6, (char)0xf6, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x000d, (char)0x0d, (char)0xf8}, { 0x04, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x04, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x01de, 0x01fe, 0x000f, (char)0xf4, (char)0x0f}, { 0x04, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0a, (char)0xf5}, },
	{ { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, { 0x14, true , 0x027e, 0x029e, 0x0009, (char)0x09, (char)0xf4}, },
	{ { 0x04, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, },
	{ { 0x04, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x0c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0040, 0x0060, 0x1ff6, (char)0xf6, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x000d, (char)0x0d, (char)0xf8}, { 0x04, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, },
	{ { 0x14, true , 0x01fe, 0x021d, 0x0009, (char)0x09, (char)0xf0}, { 0x04, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x01de, 0x01fe, 0x000f, (char)0xf4, (char)0x0f}, },
	{ { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x04, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, },
	{ { 0x0c, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0f, (char)0xf6}, },
	{ { 0x14, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0040, 0x0060, 0x1ff6, (char)0xf6, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x000d, (char)0x0d, (char)0xf8}, },
	{ { 0x04, false, 0x005e, 0x007e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x01fe, 0x021d, 0x0009, (char)0x09, (char)0xf0}, { 0x04, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, },
	{ { 0x04, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x14, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x04, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, },
	{ { 0x04, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x00de, 0x00fe, 0x000c, (char)0x0c, (char)0xf7}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0040, 0x0060, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x0c, true , 0x01df, 0x01ff, 0x0008, (char)0x08, (char)0xfa}, { 0x04, false, 0x005e, 0x007e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x01fe, 0x021d, 0x0009, (char)0x09, (char)0xf0}, { 0x04, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf7, (char)0x0c}, { 0x14, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x04, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x0c, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, { 0x04, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x000c, (char)0x0c, (char)0xf7}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x01df, 0x01ff, 0x0008, (char)0x08, (char)0xfa}, { 0x04, false, 0x005e, 0x007e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x01fe, 0x021d, 0x0009, (char)0x09, (char)0xf0}, },
	{ { 0x1c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x14, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf7, (char)0x0c}, { 0x14, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, },
	{ { 0x04, true , 0x0200, 0x0220, 0x1ff1, (char)0xf1, (char)0x06}, { 0x04, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, },
	{ { 0x04, false, 0x001e, 0x003e, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, { 0x04, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x000c, (char)0x0c, (char)0xf7}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x00a1, 0x00c0, 0x17f5, (char)0x08, (char)0xf5}, { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x01df, 0x01ff, 0x0008, (char)0x08, (char)0xfa}, { 0x04, false, 0x005e, 0x007e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x0c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, },
	{ { 0x14, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf7, (char)0x0c}, { 0x14, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x04, true , 0x02e0, 0x0000, 0x1ff5, (char)0xf5, (char)0x07}, { 0x04, true , 0x0200, 0x0220, 0x1ff1, (char)0xf1, (char)0x06}, { 0x04, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x01df, 0x01ff, 0x000a, (char)0x0a, (char)0xfa}, { 0x04, false, 0x001e, 0x003e, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, { 0x04, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x0c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x000c, (char)0x0c, (char)0xf7}, },
	{ { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x00a1, 0x00c0, 0x17f5, (char)0x08, (char)0xf5}, { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x01df, 0x01ff, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf7, (char)0x0c}, },
	{ { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e0, 0x0000, 0x1ff5, (char)0xf5, (char)0x07}, { 0x04, true , 0x0200, 0x0220, 0x1ff1, (char)0xf1, (char)0x06}, { 0x04, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01df, 0x01ff, 0x000a, (char)0x0a, (char)0xfa}, { 0x04, false, 0x001e, 0x003e, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, },
	{ { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, },
	{ { 0x1c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x00a1, 0x00c0, 0x17f5, (char)0x08, (char)0xf5}, { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, },
	{ { 0x1c, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, },
	{ { 0x14, true , 0x0181, 0x01a1, 0x1ff0, (char)0xf0, (char)0x0c}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x031e, 0x033e, 0x0009, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, },
	{ { 0x04, true , 0x0240, 0x0260, 0x1ff3, (char)0xf3, (char)0x06}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e0, 0x0000, 0x1ff5, (char)0xf5, (char)0x07}, { 0x04, true , 0x0200, 0x0220, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01df, 0x01ff, 0x000a, (char)0x0a, (char)0xfa}, { 0x04, false, 0x001e, 0x003e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x04, true , 0x013f, 0x015f, 0x000c, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x09, (char)0xf5}, { 0x1c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x00a1, 0x00c0, 0x17f5, (char)0x08, (char)0xf5}, },
	{ { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x14, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x1ff0, (char)0xf0, (char)0x0c}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x031e, 0x033e, 0x0009, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, { 0x04, true , 0x0240, 0x0260, 0x1ff3, (char)0xf3, (char)0x06}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e0, 0x0000, 0x1ff5, (char)0xf5, (char)0x07}, },
	{ { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01df, 0x01ff, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x013f, 0x015f, 0x000c, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x001f, 0x003e, 0x17f1, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x09, (char)0xf5}, { 0x1c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x0c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, },
	{ { 0x14, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x1ff0, (char)0xf0, (char)0x0c}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x031e, 0x033e, 0x0009, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, },
	{ { 0x04, true , 0x0220, 0x0240, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, { 0x04, true , 0x0240, 0x0260, 0x1ff3, (char)0xf3, (char)0x06}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, },
	{ { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x013f, 0x015f, 0x000c, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x04, true , 0x017f, 0x019f, 0x0008, (char)0x08, (char)0xfa}, { 0x14, false, 0x001f, 0x003e, 0x17f1, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x09, (char)0xf5}, { 0x1c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, },
	{ { 0x0c, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x14, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x1ff0, (char)0xf0, (char)0x0c}, },
	{ { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x031e, 0x033e, 0x0009, (char)0xf1, (char)0x09}, },
	{ { 0x04, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0220, 0x0240, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, { 0x04, true , 0x0240, 0x0260, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x0c, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x013f, 0x015f, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x14, false, 0x03e0, 0x0000, 0x000f, (char)0x07, (char)0x0f}, { 0x04, true , 0x017f, 0x019f, 0x0008, (char)0x08, (char)0xfa}, { 0x14, false, 0x001f, 0x003e, 0x17f1, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x09, (char)0xf5}, },
	{ { 0x04, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0220, 0x0240, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x1c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, },
	{ { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x007f, 0x009e, 0x17f4, (char)0xf8, (char)0xf4}, { 0x14, false, 0x03e0, 0x0000, 0x000f, (char)0x07, (char)0x0f}, { 0x04, true , 0x017f, 0x019f, 0x0008, (char)0x08, (char)0xfa}, { 0x14, false, 0x001f, 0x003e, 0x17f1, (char)0xf8, (char)0xf1}, },
	{ { 0x1c, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x04, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0220, 0x0240, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x04, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x007f, 0x009e, 0x17f4, (char)0xf8, (char)0xf4}, { 0x14, false, 0x03e0, 0x0000, 0x000f, (char)0x07, (char)0x0f}, { 0x04, true , 0x017f, 0x019f, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x04, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x04, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x01df, 0x01ff, 0x000a, (char)0x0a, (char)0xfa}, { 0x04, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x14, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0380, 0x03a0, 0x000c, (char)0x07, (char)0x0c}, { 0x14, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x007f, 0x009e, 0x17f4, (char)0xf8, (char)0xf4}, { 0x14, false, 0x03e0, 0x0000, 0x000f, (char)0x07, (char)0x0f}, },
	{ { 0x14, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, },
	{ { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, { 0x14, true , 0x01df, 0x01ff, 0x000a, (char)0x0a, (char)0xfa}, { 0x04, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, },
	{ { 0x1c, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, true , 0x0181, 0x01a1, 0x1ff0, (char)0xf0, (char)0x0c}, { 0x14, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x14, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0380, 0x03a0, 0x000c, (char)0x07, (char)0x0c}, { 0x14, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x007f, 0x009e, 0x17f4, (char)0xf8, (char)0xf4}, },
	{ { 0x04, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, },
	{ { 0x04, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x0c, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, { 0x14, true , 0x01df, 0x01ff, 0x000a, (char)0x0a, (char)0xfa}, { 0x04, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x1c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0181, 0x01a1, 0x1ff0, (char)0xf0, (char)0x0c}, { 0x14, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0380, 0x03a0, 0x000c, (char)0x07, (char)0x0c}, { 0x14, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, { 0x14, true , 0x01df, 0x01ff, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x14, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0181, 0x01a1, 0x1ff0, (char)0xf0, (char)0x0c}, { 0x14, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0380, 0x03a0, 0x000c, (char)0x07, (char)0x0c}, },
	{ { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, },
	{ { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x04, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, },
	{ { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, },
	{ { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0181, 0x01a1, 0x1ff0, (char)0xf0, (char)0x0c}, },
	{ { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, },
	{ { 0x04, false, 0x02ff, 0x031f, 0x17f8, (char)0xf9, (char)0xf8}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x04, true , 0x02fe, 0x001d, 0x000c, (char)0x0c, (char)0xf0}, { 0x04, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x0c, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x04, false, 0x01de, 0x01fd, 0x000f, (char)0xf0, (char)0x0f}, { 0x04, false, 0x02ff, 0x031f, 0x17f8, (char)0xf9, (char)0xf8}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, },
	{ { 0x04, true , 0x0201, 0x0220, 0x0007, (char)0x07, (char)0x08}, { 0x04, true , 0x02fe, 0x001d, 0x000c, (char)0x0c, (char)0xf0}, { 0x04, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, },
	{ { 0x0c, false, 0x0041, 0x0061, 0x17f2, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0c, (char)0xf4}, { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, },
	{ { 0x1c, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, { 0x04, false, 0x01de, 0x01fd, 0x000f, (char)0xf0, (char)0x0f}, { 0x04, false, 0x02ff, 0x031f, 0x17f8, (char)0xf9, (char)0xf8}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x0201, 0x0220, 0x0007, (char)0x07, (char)0x08}, { 0x04, true , 0x02fe, 0x001d, 0x000c, (char)0x0c, (char)0xf0}, { 0x04, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, },
	{ { 0x04, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0041, 0x0061, 0x17f2, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0c, (char)0xf4}, { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, { 0x04, false, 0x01de, 0x01fd, 0x000f, (char)0xf0, (char)0x0f}, { 0x04, false, 0x02ff, 0x031f, 0x17f8, (char)0xf9, (char)0xf8}, },
	{ { 0x04, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x0201, 0x0220, 0x0007, (char)0x07, (char)0x08}, { 0x04, true , 0x02fe, 0x001d, 0x000c, (char)0x0c, (char)0xf0}, },
	{ { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, },
	{ { 0x04, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0041, 0x0061, 0x17f2, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0c, (char)0xf4}, { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, { 0x04, false, 0x01de, 0x01fd, 0x000f, (char)0xf0, (char)0x0f}, },
	{ { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, },
	{ { 0x14, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x0201, 0x0220, 0x0007, (char)0x07, (char)0x08}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0f, (char)0xf1}, },
	{ { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, { 0x04, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0041, 0x0061, 0x17f2, (char)0x0e, (char)0xf2}, },
	{ { 0x0c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0c, (char)0xf4}, },
	{ { 0x1c, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, },
	{ { 0x1c, true , 0x021f, 0x023f, 0x000f, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, },
	{ { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, { 0x04, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021f, 0x023f, 0x000f, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, },
	{ { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x013f, 0x015f, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, { 0x04, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, },
	{ { 0x1c, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, },
	{ { 0x0c, false, 0x02de, 0x02fe, 0x0007, (char)0xf5, (char)0x07}, { 0x04, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021f, 0x023f, 0x000f, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, },
	{ { 0x0c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x013f, 0x015f, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, },
	{ { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x07, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, true , 0x027e, 0x029e, 0x000d, (char)0x0d, (char)0xf4}, { 0x14, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x1c, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x02de, 0x02fe, 0x0007, (char)0xf5, (char)0x07}, { 0x04, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021f, 0x023f, 0x000f, (char)0x0f, (char)0xf9}, },
	{ { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x013f, 0x015f, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0181, 0x01a1, 0x1ff4, (char)0xf4, (char)0x0c}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x07, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, },
	{ { 0x14, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x027e, 0x029e, 0x000d, (char)0x0d, (char)0xf4}, { 0x14, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, },
	{ { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x02de, 0x02fe, 0x0007, (char)0xf5, (char)0x07}, { 0x04, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x013f, 0x015f, 0x000e, (char)0x0e, (char)0xfa}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0181, 0x01a1, 0x1ff4, (char)0xf4, (char)0x0c}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0d, (char)0xf5}, },
	{ { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x07, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x1c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x027e, 0x029e, 0x000d, (char)0x0d, (char)0xf4}, { 0x14, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x01ff, 0x021e, 0x0009, (char)0x09, (char)0xf8}, { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x02de, 0x02fe, 0x0007, (char)0xf5, (char)0x07}, },
	{ { 0x0c, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf6, (char)0x06}, { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x04, false, 0x0081, 0x00a1, 0x17f4, (char)0x0c, (char)0xf4}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0181, 0x01a1, 0x1ff4, (char)0xf4, (char)0x0c}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x1c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x027e, 0x029e, 0x000d, (char)0x0d, (char)0xf4}, },
	{ { 0x04, true , 0x0080, 0x00a0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x14, true , 0x01ff, 0x021e, 0x0009, (char)0x09, (char)0xf8}, { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x04, true , 0x011f, 0x013f, 0x1ff8, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf6, (char)0x06}, { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0081, 0x00a1, 0x17f4, (char)0x0c, (char)0xf4}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0181, 0x01a1, 0x1ff4, (char)0xf4, (char)0x0c}, },
	{ { 0x04, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, },
	{ { 0x04, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x14, true , 0x02e0, 0x0000, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x0080, 0x00a0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x14, true , 0x01ff, 0x021e, 0x0009, (char)0x09, (char)0xf8}, { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x011f, 0x013f, 0x1ff8, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x0c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf6, (char)0x06}, { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0081, 0x00a1, 0x17f4, (char)0x0c, (char)0xf4}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x1c, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e0, 0x0000, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x0080, 0x00a0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x14, true , 0x01ff, 0x021e, 0x0009, (char)0x09, (char)0xf8}, },
	{ { 0x1c, false, 0x00e1, 0x0100, 0x17f7, (char)0x08, (char)0xf7}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x011f, 0x013f, 0x1ff8, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x1c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0081, 0x00a1, 0x17f4, (char)0x0c, (char)0xf4}, },
	{ { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, },
	{ { 0x04, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e0, 0x0000, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x0080, 0x00a0, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x00e1, 0x0100, 0x17f7, (char)0x08, (char)0xf7}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x011f, 0x013f, 0x1ff8, (char)0xf8, (char)0xf9}, },
	{ { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, { 0x04, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x04, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e0, 0x0000, 0x0007, (char)0x07, (char)0x07}, },
	{ { 0x14, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x00e1, 0x0100, 0x17f7, (char)0x08, (char)0xf7}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, },
	{ { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, { 0x04, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x04, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x00e1, 0x0100, 0x17f7, (char)0x08, (char)0xf7}, },
	{ { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, },
	{ { 0x0c, false, 0x0181, 0x01a0, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf1, (char)0x0d}, },
	{ { 0x1c, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, },
	{ { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, { 0x04, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, },
	{ { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, },
	{ { 0x0c, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0a, (char)0xf5}, },
	{ { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0181, 0x01a0, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, },
	{ { 0x04, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, },
	{ { 0x04, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, },
	{ { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x04, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, },
	{ { 0x0c, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0181, 0x01a0, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, },
	{ { 0x14, true , 0x02de, 0x02fe, 0x000f, (char)0x0f, (char)0xf7}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, },
	{ { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf7, (char)0x0f}, { 0x04, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, },
	{ { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0181, 0x01a0, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02de, 0x02fe, 0x000f, (char)0x0f, (char)0xf7}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, },
	{ { 0x1c, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf7, (char)0x0f}, { 0x04, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, },
	{ { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02de, 0x02fe, 0x000f, (char)0x0f, (char)0xf7}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, },
	{ { 0x1c, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, },
	{ { 0x14, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x0c, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf7, (char)0x0f}, { 0x04, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, false, 0x0141, 0x0161, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x1c, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, },
	{ { 0x14, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02de, 0x02fe, 0x000f, (char)0x0f, (char)0xf7}, },
	{ { 0x0c, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x14, false, 0x025f, 0x027f, 0x17f3, (char)0xf9, (char)0xf3}, { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf7, (char)0x0f}, },
	{ { 0x0c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0141, 0x0161, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x01a1, 0x01c1, 0x1ff4, (char)0xf4, (char)0x0d}, { 0x1c, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, },
	{ { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x025f, 0x027f, 0x17f3, (char)0xf9, (char)0xf3}, { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0141, 0x0161, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, },
	{ { 0x14, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff4, (char)0xf4, (char)0x0d}, { 0x1c, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, },
	{ { 0x14, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0b, (char)0xf5}, },
	{ { 0x04, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, },
	{ { 0x0c, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x025f, 0x027f, 0x17f3, (char)0xf9, (char)0xf3}, { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0141, 0x0161, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x14, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff4, (char)0xf4, (char)0x0d}, { 0x1c, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, },
	{ { 0x04, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x0c, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0b, (char)0xf7}, { 0x04, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x025f, 0x027f, 0x17f3, (char)0xf9, (char)0xf3}, },
	{ { 0x14, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff4, (char)0xf4, (char)0x0d}, },
	{ { 0x1c, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x0c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0b, (char)0xf7}, { 0x04, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, },
	{ { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, },
	{ { 0x1c, true , 0x007e, 0x009e, 0x000a, (char)0x0a, (char)0xf4}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, { 0x0c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0b, (char)0xf7}, { 0x04, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x00a0, 0x00c0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x14, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, { 0x14, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x04, true , 0x02be, 0x02de, 0x0009, (char)0x09, (char)0xf6}, { 0x0c, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x14, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x007e, 0x009e, 0x000a, (char)0x0a, (char)0xf4}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, { 0x0c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0b, (char)0xf7}, },
	{ { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x00a0, 0x00c0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x0c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, { 0x14, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, { 0x04, true , 0x02be, 0x02de, 0x0009, (char)0x09, (char)0xf6}, { 0x0c, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, },
	{ { 0x0c, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x007e, 0x009e, 0x000a, (char)0x0a, (char)0xf4}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x14, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, { 0x0c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x0281, 0x02a1, 0x1ff1, (char)0xf1, (char)0x0c}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x00a0, 0x00c0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, },
	{ { 0x14, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, { 0x14, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x04, false, 0x023e, 0x025e, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, { 0x04, true , 0x02be, 0x02de, 0x0009, (char)0x09, (char)0xf6}, { 0x0c, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x04, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, true , 0x011f, 0x013f, 0x000c, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x007e, 0x009e, 0x000a, (char)0x0a, (char)0xf4}, },
	{ { 0x1c, false, 0x0261, 0x0281, 0x17f3, (char)0x09, (char)0xf3}, { 0x14, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, },
	{ { 0x1c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, },
	{ { 0x14, true , 0x01a1, 0x01c1, 0x1ff4, (char)0xf4, (char)0x0d}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff1, (char)0xf1, (char)0x0c}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x00a0, 0x00c0, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x04, true , 0x025f, 0x027f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, },
	{ { 0x0c, true , 0x02e0, 0x0000, 0x1ff3, (char)0xf3, (char)0x07}, { 0x04, false, 0x023e, 0x025e, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, { 0x04, true , 0x02be, 0x02de, 0x0009, (char)0x09, (char)0xf6}, },
	{ { 0x14, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, },
	{ { 0x04, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x011f, 0x013f, 0x000c, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0261, 0x0281, 0x17f3, (char)0x09, (char)0xf3}, { 0x14, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, },
	{ { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, },
	{ { 0x14, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff4, (char)0xf4, (char)0x0d}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff1, (char)0xf1, (char)0x0c}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0d, (char)0xf6}, },
	{ { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025f, 0x027f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x1c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x1ff3, (char)0xf3, (char)0x07}, { 0x04, false, 0x023e, 0x025e, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, },
	{ { 0x1c, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, { 0x14, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, },
	{ { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, { 0x04, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x011f, 0x013f, 0x000c, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x14, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0261, 0x0281, 0x17f3, (char)0x09, (char)0xf3}, { 0x14, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff4, (char)0xf4, (char)0x0d}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff1, (char)0xf1, (char)0x0c}, },
	{ { 0x04, true , 0x02c0, 0x02e0, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025f, 0x027f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x04, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x1ff3, (char)0xf3, (char)0x07}, { 0x04, false, 0x023e, 0x025e, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x0c, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, { 0x14, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, { 0x04, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x011f, 0x013f, 0x000c, (char)0x0c, (char)0xf9}, },
	{ { 0x1c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0261, 0x0281, 0x17f3, (char)0x09, (char)0xf3}, },
	{ { 0x14, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff4, (char)0xf4, (char)0x0d}, },
	{ { 0x1c, false, 0x02fe, 0x031e, 0x0008, (char)0xf5, (char)0x08}, { 0x04, true , 0x02c0, 0x02e0, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025f, 0x027f, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x14, true , 0x01fe, 0x021d, 0x000b, (char)0x0b, (char)0xf0}, { 0x04, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x1ff3, (char)0xf3, (char)0x07}, },
	{ { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, { 0x14, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x14, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, { 0x04, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, true , 0x009e, 0x00be, 0x0008, (char)0x08, (char)0xf5}, { 0x1c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, },
	{ { 0x14, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, },
	{ { 0x04, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x02fe, 0x031e, 0x0008, (char)0xf5, (char)0x08}, { 0x04, true , 0x02c0, 0x02e0, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x01fe, 0x021d, 0x000b, (char)0x0b, (char)0xf0}, { 0x04, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, },
	{ { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, },
	{ { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x009e, 0x00be, 0x0008, (char)0x08, (char)0xf5}, { 0x1c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, },
	{ { 0x1c, false, 0x007e, 0x009e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, },
	{ { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x02fe, 0x031e, 0x0008, (char)0xf5, (char)0x08}, { 0x04, true , 0x02c0, 0x02e0, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x01fe, 0x021d, 0x000b, (char)0x0b, (char)0xf0}, { 0x04, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x0000, 0x0020, 0x1ff2, (char)0xf2, (char)0x06}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, },
	{ { 0x04, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x009e, 0x00be, 0x0008, (char)0x08, (char)0xf5}, { 0x1c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x0c, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x007e, 0x009e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x02fe, 0x031e, 0x0008, (char)0xf5, (char)0x08}, },
	{ { 0x04, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x01fe, 0x021d, 0x000b, (char)0x0b, (char)0xf0}, },
	{ { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0000, 0x0020, 0x1ff2, (char)0xf2, (char)0x06}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x04, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0b, (char)0xf7}, { 0x04, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x009e, 0x00be, 0x0008, (char)0x08, (char)0xf5}, },
	{ { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, },
	{ { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x007e, 0x009e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, },
	{ { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf7, (char)0x06}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, },
	{ { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0000, 0x0020, 0x1ff2, (char)0xf2, (char)0x06}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, },
	{ { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, false, 0x001f, 0x003e, 0x17f1, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0b, (char)0xf7}, { 0x04, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x0d, (char)0xf9}, },
	{ { 0x1c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, },
	{ { 0x14, true , 0x0080, 0x00a0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x007e, 0x009e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x04, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, },
	{ { 0x04, false, 0x023e, 0x025e, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf7, (char)0x06}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, },
	{ { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0000, 0x0020, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x04, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x023e, 0x025e, 0x0009, (char)0x09, (char)0xf2}, { 0x1c, false, 0x001f, 0x003e, 0x17f1, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0b, (char)0xf7}, { 0x04, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, },
	{ { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x14, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0080, 0x00a0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x04, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, { 0x04, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x0c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x023e, 0x025e, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf7, (char)0x06}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x04, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, false, 0x03de, 0x03fe, 0x000f, (char)0xf7, (char)0x0f}, { 0x04, true , 0x023e, 0x025e, 0x0009, (char)0x09, (char)0xf2}, { 0x1c, false, 0x001f, 0x003e, 0x17f1, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0b, (char)0xf7}, },
	{ { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0080, 0x00a0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, { 0x04, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x023e, 0x025e, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x1c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, },
	{ { 0x1c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x03de, 0x03fe, 0x000f, (char)0xf7, (char)0x0f}, { 0x04, true , 0x023e, 0x025e, 0x0009, (char)0x09, (char)0xf2}, { 0x1c, false, 0x001f, 0x003e, 0x17f1, (char)0xf8, (char)0xf1}, },
	{ { 0x1c, true , 0x0281, 0x02a1, 0x1ff1, (char)0xf1, (char)0x0c}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0080, 0x00a0, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, { 0x04, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, },
	{ { 0x04, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x023e, 0x025e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x0c, true , 0x013f, 0x015f, 0x000c, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x09, (char)0xf5}, { 0x1c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x1c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x03de, 0x03fe, 0x000f, (char)0xf7, (char)0x0f}, { 0x04, true , 0x023e, 0x025e, 0x0009, (char)0x09, (char)0xf2}, },
	{ { 0x14, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff1, (char)0xf1, (char)0x0c}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x0c, true , 0x02e0, 0x0000, 0x1ff5, (char)0xf5, (char)0x07}, { 0x04, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, },
	{ { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0a, (char)0xfa}, { 0x04, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, },
	{ { 0x0c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x013f, 0x015f, 0x000c, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x09, (char)0xf5}, { 0x1c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x03de, 0x03fe, 0x000f, (char)0xf7, (char)0x0f}, },
	{ { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff1, (char)0xf1, (char)0x0c}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, true , 0x00ff, 0x011e, 0x000e, (char)0x0e, (char)0xf8}, { 0x04, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x1c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x1ff5, (char)0xf5, (char)0x07}, { 0x04, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0a, (char)0xf3}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0a, (char)0xfa}, { 0x04, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, },
	{ { 0x1c, false, 0x00be, 0x00de, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x013f, 0x015f, 0x000c, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x017f, 0x019f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x09, (char)0xf5}, { 0x1c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x14, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff1, (char)0xf1, (char)0x0c}, },
	{ { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x000e, (char)0x0e, (char)0xf8}, { 0x04, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, },
	{ { 0x04, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x1ff5, (char)0xf5, (char)0x07}, { 0x04, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x0c, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0a, (char)0xf3}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0a, (char)0xfa}, { 0x04, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00be, 0x00de, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x013f, 0x015f, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x017f, 0x019f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x09, (char)0xf5}, },
	{ { 0x04, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x0c, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x1c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x000e, (char)0x0e, (char)0xf8}, { 0x04, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x01fe, 0x021d, 0x000b, (char)0x0b, (char)0xf0}, { 0x04, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x1ff5, (char)0xf5, (char)0x07}, },
	{ { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0a, (char)0xf3}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x14, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00be, 0x00de, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x0c, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x017f, 0x019f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, },
	{ { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x000e, (char)0x0e, (char)0xf8}, },
	{ { 0x04, true , 0x0080, 0x00a0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x14, true , 0x01fe, 0x021d, 0x000b, (char)0x0b, (char)0xf0}, { 0x04, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x04, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0a, (char)0xf3}, },
	{ { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00be, 0x00de, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x017f, 0x019f, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, },
	{ { 0x04, true , 0x025f, 0x027f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0080, 0x00a0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x14, true , 0x01fe, 0x021d, 0x000b, (char)0x0b, (char)0xf0}, { 0x04, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0d, (char)0xfa}, { 0x04, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x0c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x07, (char)0x0c}, { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025f, 0x027f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0080, 0x00a0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x14, true , 0x01fe, 0x021d, 0x000b, (char)0x0b, (char)0xf0}, },
	{ { 0x1c, false, 0x00df, 0x00fe, 0x17f7, (char)0xf8, (char)0xf7}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0d, (char)0xfa}, { 0x04, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x1c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x14, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x07, (char)0x0c}, { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, },
	{ { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, },
	{ { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025f, 0x027f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x0c, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0080, 0x00a0, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x00df, 0x00fe, 0x17f7, (char)0xf8, (char)0xf7}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0d, (char)0xfa}, { 0x04, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, },
	{ { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x07, (char)0x0c}, { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025f, 0x027f, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x14, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, true , 0x003e, 0x005e, 0x1ff8, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x00df, 0x00fe, 0x17f7, (char)0xf8, (char)0xf7}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x07, (char)0x0c}, },
	{ { 0x04, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, },
	{ { 0x04, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, },
	{ { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x003e, 0x005e, 0x1ff8, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x00df, 0x00fe, 0x17f7, (char)0xf8, (char)0xf7}, },
	{ { 0x14, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, },
	{ { 0x0c, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, { 0x14, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, },
	{ { 0x1c, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, },
	{ { 0x14, true , 0x01df, 0x01ff, 0x000c, (char)0x0c, (char)0xfa}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x0c, true , 0x02df, 0x02ff, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf3, (char)0x0f}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x003e, 0x005e, 0x1ff8, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0b, (char)0xf5}, },
	{ { 0x04, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, { 0x14, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x0f, (char)0xf2}, { 0x1c, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x007e, 0x009e, 0x000e, (char)0x0e, (char)0xf4}, { 0x14, true , 0x01df, 0x01ff, 0x000c, (char)0x0c, (char)0xfa}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x1c, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02df, 0x02ff, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, },
	{ { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf3, (char)0x0f}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x1c, false, 0x007e, 0x009e, 0x0006, (char)0xf2, (char)0x06}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x003e, 0x005e, 0x1ff8, (char)0xf8, (char)0xf2}, },
	{ { 0x14, true , 0x0101, 0x0120, 0x1ff4, (char)0xf4, (char)0x08}, { 0x04, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xf9, (char)0xf1}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, { 0x14, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, },
	{ { 0x0c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x0f, (char)0xf2}, { 0x1c, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x000e, (char)0x0e, (char)0xf4}, { 0x14, true , 0x01df, 0x01ff, 0x000c, (char)0x0c, (char)0xfa}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, },
	{ { 0x04, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02df, 0x02ff, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf3, (char)0x0f}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, },
	{ { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x007e, 0x009e, 0x0006, (char)0xf2, (char)0x06}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff4, (char)0xf4, (char)0x08}, { 0x04, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, },
	{ { 0x04, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xf9, (char)0xf1}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, },
	{ { 0x0c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x0f, (char)0xf2}, { 0x1c, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, },
	{ { 0x14, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x000e, (char)0x0e, (char)0xf4}, { 0x14, true , 0x01df, 0x01ff, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02df, 0x02ff, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x14, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf3, (char)0x0f}, },
	{ { 0x0c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x007e, 0x009e, 0x0006, (char)0xf2, (char)0x06}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, },
	{ { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff4, (char)0xf4, (char)0x08}, { 0x04, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x0200, 0x0220, 0x0007, (char)0x07, (char)0x06}, { 0x04, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xf9, (char)0xf1}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x04, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x0f, (char)0xf2}, },
	{ { 0x0c, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, { 0x14, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x000e, (char)0x0e, (char)0xf4}, },
	{ { 0x1c, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, },
	{ { 0x14, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x007e, 0x009e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x04, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff4, (char)0xf4, (char)0x08}, },
	{ { 0x04, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x0200, 0x0220, 0x0007, (char)0x07, (char)0x06}, { 0x04, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xf9, (char)0xf1}, },
	{ { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x0c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, { 0x14, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, { 0x04, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x0200, 0x0220, 0x0007, (char)0x07, (char)0x06}, { 0x04, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, { 0x14, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, },
	{ { 0x14, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x14, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, { 0x04, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x0200, 0x0220, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x04, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, },
	{ { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, },
	{ { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, { 0x04, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, },
	{ { 0x14, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x0c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x14, false, 0x03be, 0x03de, 0x000e, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x04, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, },
	{ { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x001e, 0x003e, 0x000e, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, },
	{ { 0x1c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, },
	{ { 0x1c, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x1c, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x03be, 0x03de, 0x000e, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, },
	{ { 0x14, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x1ff6, (char)0xf6, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x001e, 0x003e, 0x000e, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x0c, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x03be, 0x03de, 0x000e, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf5, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x1ff6, (char)0xf6, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x14, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x001e, 0x003e, 0x000e, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x14, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x03be, 0x03de, 0x000e, (char)0xf7, (char)0x0e}, },
	{ { 0x14, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf5, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x04, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x1ff6, (char)0xf6, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, },
	{ { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x001e, 0x003e, 0x000e, (char)0x0e, (char)0xf1}, },
	{ { 0x04, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, },
	{ { 0x14, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, },
	{ { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf5, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, },
	{ { 0x04, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x04, true , 0x01df, 0x01ff, 0x000c, (char)0x0c, (char)0xfa}, { 0x04, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x0c, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, },
	{ { 0x1c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, { 0x04, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01df, 0x01ff, 0x000c, (char)0x0c, (char)0xfa}, { 0x04, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, },
	{ { 0x1c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, },
	{ { 0x14, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, { 0x04, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01df, 0x01ff, 0x000c, (char)0x0c, (char)0xfa}, { 0x04, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x04, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, },
	{ { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, { 0x04, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, },
	{ { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01df, 0x01ff, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x14, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, },
	{ { 0x14, true , 0x00e0, 0x0100, 0x1ff0, (char)0xf0, (char)0x07}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, { 0x04, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, },
	{ { 0x04, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, },
	{ { 0x04, true , 0x0221, 0x0241, 0x0007, (char)0x07, (char)0x09}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0f, (char)0xf3}, { 0x14, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, },
	{ { 0x0c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0e, (char)0xf6}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x00e0, 0x0100, 0x1ff0, (char)0xf0, (char)0x07}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff0, (char)0xf0, (char)0x08}, },
	{ { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf3, (char)0x06}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0221, 0x0241, 0x0007, (char)0x07, (char)0x09}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x0c, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0f, (char)0xf3}, { 0x14, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0e, (char)0xf6}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x00e0, 0x0100, 0x1ff0, (char)0xf0, (char)0x07}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x009e, 0x00bd, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x04, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf3, (char)0x06}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, },
	{ { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0221, 0x0241, 0x0007, (char)0x07, (char)0x09}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0f, (char)0xf3}, { 0x14, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, },
	{ { 0x04, false, 0x0041, 0x0061, 0x17f2, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0e, (char)0xf6}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x00e0, 0x0100, 0x1ff0, (char)0xf0, (char)0x07}, },
	{ { 0x14, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, { 0x04, false, 0x009e, 0x00bd, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf3, (char)0x06}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, },
	{ { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0221, 0x0241, 0x0007, (char)0x07, (char)0x09}, },
	{ { 0x04, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0f, (char)0xf3}, },
	{ { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0041, 0x0061, 0x17f2, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0e, (char)0xf6}, },
	{ { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, { 0x04, false, 0x009e, 0x00bd, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, },
	{ { 0x04, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, },
	{ { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0041, 0x0061, 0x17f2, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, { 0x04, false, 0x009e, 0x00bd, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x1c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, },
	{ { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x1ff3, (char)0xf3, (char)0x0f}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0041, 0x0061, 0x17f2, (char)0x0a, (char)0xf2}, },
	{ { 0x0c, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, { 0x04, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, },
	{ { 0x1c, true , 0x029f, 0x02bf, 0x000f, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e1, 0x0001, 0x1ff3, (char)0xf3, (char)0x0f}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, },
	{ { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, { 0x04, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029f, 0x02bf, 0x000f, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e1, 0x0001, 0x1ff3, (char)0xf3, (char)0x0f}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, { 0x04, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, },
	{ { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, },
	{ { 0x0c, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029f, 0x02bf, 0x000f, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e1, 0x0001, 0x1ff3, (char)0xf3, (char)0x0f}, },
	{ { 0x14, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, },
	{ { 0x0c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x14, true , 0x029e, 0x02be, 0x1ff9, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029f, 0x02bf, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x04, true , 0x017f, 0x019f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x0261, 0x0281, 0x17f3, (char)0x0b, (char)0xf3}, { 0x14, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029e, 0x02be, 0x1ff9, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x021f, 0x023f, 0x0009, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, },
	{ { 0x1c, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x04, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0261, 0x0281, 0x17f3, (char)0x0b, (char)0xf3}, { 0x14, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0d, (char)0xf5}, },
	{ { 0x1c, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x0260, 0x0280, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029e, 0x02be, 0x1ff9, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x021f, 0x023f, 0x0009, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x1c, true , 0x025f, 0x027f, 0x0009, (char)0x09, (char)0xfa}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0261, 0x0281, 0x17f3, (char)0x0b, (char)0xf3}, { 0x14, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x04, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0260, 0x0280, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029e, 0x02be, 0x1ff9, (char)0xf9, (char)0xf5}, },
	{ { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x021f, 0x023f, 0x0009, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x14, true , 0x01bf, 0x01df, 0x000e, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x0009, (char)0x09, (char)0xfa}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, },
	{ { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0261, 0x0281, 0x17f3, (char)0x0b, (char)0xf3}, },
	{ { 0x14, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0260, 0x0280, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x021f, 0x023f, 0x0009, (char)0x09, (char)0xf9}, },
	{ { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x000e, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x14, false, 0x011f, 0x013e, 0x17f9, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x0009, (char)0x09, (char)0xfa}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, true , 0x0240, 0x0260, 0x1ff1, (char)0xf1, (char)0x06}, { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x00a0, 0x00c0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x04, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0260, 0x0280, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x000e, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x011f, 0x013e, 0x17f9, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x0c, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0240, 0x0260, 0x1ff1, (char)0xf1, (char)0x06}, { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x00a0, 0x00c0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, },
	{ { 0x0c, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf4, (char)0x0f}, { 0x04, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, },
	{ { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x000e, (char)0x0e, (char)0xfa}, },
	{ { 0x14, true , 0x0201, 0x0220, 0x1ff7, (char)0xf7, (char)0x08}, { 0x04, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x011f, 0x013e, 0x17f9, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0240, 0x0260, 0x1ff1, (char)0xf1, (char)0x06}, { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x00a0, 0x00c0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x1c, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x019f, 0x01bf, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf4, (char)0x0f}, { 0x04, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0201, 0x0220, 0x1ff7, (char)0xf7, (char)0x08}, { 0x04, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x011f, 0x013e, 0x17f9, (char)0xf8, (char)0xf9}, },
	{ { 0x04, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0240, 0x0260, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x00a0, 0x00c0, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x14, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x019f, 0x01bf, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf4, (char)0x0f}, { 0x04, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, },
	{ { 0x0c, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0201, 0x0220, 0x1ff7, (char)0xf7, (char)0x08}, { 0x04, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, },
	{ { 0x04, true , 0x0200, 0x0220, 0x1ff5, (char)0xf5, (char)0x06}, { 0x04, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, },
	{ { 0x04, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, },
	{ { 0x0c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, },
	{ { 0x14, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, { 0x14, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x019f, 0x01bf, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf4, (char)0x0f}, },
	{ { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x14, false, 0x023e, 0x025e, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, },
	{ { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0201, 0x0220, 0x1ff7, (char)0xf7, (char)0x08}, },
	{ { 0x04, false, 0x00fe, 0x011e, 0x0008, (char)0xf4, (char)0x08}, { 0x04, true , 0x0200, 0x0220, 0x1ff5, (char)0xf5, (char)0x06}, { 0x04, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, },
	{ { 0x04, true , 0x01fe, 0x021d, 0x0009, (char)0x09, (char)0xf0}, { 0x04, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, },
	{ { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, { 0x14, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x019f, 0x01bf, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x04, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, },
	{ { 0x0c, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x023e, 0x025e, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, },
	{ { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00fe, 0x011e, 0x0008, (char)0xf4, (char)0x08}, { 0x04, true , 0x0200, 0x0220, 0x1ff5, (char)0xf5, (char)0x06}, { 0x04, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x1ff6, (char)0xf6, (char)0x06}, { 0x04, true , 0x01fe, 0x021d, 0x0009, (char)0x09, (char)0xf0}, { 0x04, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, },
	{ { 0x04, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, { 0x14, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, },
	{ { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x14, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x023e, 0x025e, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00fe, 0x011e, 0x0008, (char)0xf4, (char)0x08}, { 0x04, true , 0x0200, 0x0220, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x1ff6, (char)0xf6, (char)0x06}, { 0x04, true , 0x01fe, 0x021d, 0x0009, (char)0x09, (char)0xf0}, { 0x04, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x04, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, },
	{ { 0x1c, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x023e, 0x025e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x14, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00fe, 0x011e, 0x0008, (char)0xf4, (char)0x08}, },
	{ { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x1ff6, (char)0xf6, (char)0x06}, { 0x04, true , 0x01fe, 0x021d, 0x0009, (char)0x09, (char)0xf0}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, },
	{ { 0x14, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, },
	{ { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, },
	{ { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, },
	{ { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, },
	{ { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, },
	{ { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, },
	{ { 0x1c, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, },
	{ { 0x1c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, },
	{ { 0x14, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, },
	{ { 0x04, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x04, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, },
	{ { 0x04, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x14, true , 0x01df, 0x01ff, 0x000a, (char)0x0a, (char)0xfa}, { 0x04, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, },
	{ { 0x0c, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, { 0x04, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x14, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, },
	{ { 0x0c, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x1c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, },
	{ { 0x1c, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x01df, 0x01ff, 0x000a, (char)0x0a, (char)0xfa}, { 0x04, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, { 0x04, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, },
	{ { 0x1c, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, },
	{ { 0x1c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x1c, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x14, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x0c, true , 0x023f, 0x025f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x01df, 0x01ff, 0x000a, (char)0x0a, (char)0xfa}, { 0x04, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, },
	{ { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, { 0x04, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x14, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, },
	{ { 0x1c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x14, false, 0x0161, 0x0181, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x0c, true , 0x02c0, 0x02e0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x01df, 0x01ff, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x14, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, },
	{ { 0x0c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, },
	{ { 0x0c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0161, 0x0181, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x02c0, 0x02e0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x14, true , 0x017f, 0x019f, 0x000e, (char)0x0e, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0161, 0x0181, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x02c0, 0x02e0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x14, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x017f, 0x019f, 0x000e, (char)0x0e, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x04, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0161, 0x0181, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x0c, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x02c0, 0x02e0, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x017f, 0x019f, 0x000e, (char)0x0e, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x02e1, 0x0301, 0x17f7, (char)0x0b, (char)0xf7}, { 0x04, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x0c, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x14, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x0c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x02de, 0x02fe, 0x0007, (char)0xf7, (char)0x07}, { 0x04, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x017f, 0x019f, 0x000e, (char)0x0e, (char)0xfa}, },
	{ { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, false, 0x02e1, 0x0301, 0x17f7, (char)0x0b, (char)0xf7}, { 0x04, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x02de, 0x02fe, 0x0007, (char)0xf7, (char)0x07}, { 0x04, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xf9, (char)0xf9}, },
	{ { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x14, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, false, 0x02e1, 0x0301, 0x17f7, (char)0x0b, (char)0xf7}, { 0x04, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x04, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, },
	{ { 0x0c, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x14, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x02de, 0x02fe, 0x0007, (char)0xf7, (char)0x07}, { 0x04, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, },
	{ { 0x0c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, },
	{ { 0x1c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x14, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, { 0x04, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, false, 0x02e1, 0x0301, 0x17f7, (char)0x0b, (char)0xf7}, },
	{ { 0x0c, false, 0x01de, 0x01fe, 0x000f, (char)0xf2, (char)0x0f}, { 0x04, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, },
	{ { 0x14, true , 0x02c1, 0x02e1, 0x1ff5, (char)0xf5, (char)0x0e}, { 0x0c, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x04, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, { 0x14, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x02de, 0x02fe, 0x0007, (char)0xf7, (char)0x07}, },
	{ { 0x14, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x0c, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, { 0x04, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x01de, 0x01fe, 0x000f, (char)0xf2, (char)0x0f}, { 0x04, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x02c1, 0x02e1, 0x1ff5, (char)0xf5, (char)0x0e}, { 0x0c, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, { 0x14, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x0c, false, 0x019f, 0x01be, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, { 0x04, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, },
	{ { 0x1c, true , 0x0241, 0x0261, 0x1ff1, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x01de, 0x01fe, 0x000f, (char)0xf2, (char)0x0f}, { 0x04, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x02c1, 0x02e1, 0x1ff5, (char)0xf5, (char)0x0e}, { 0x0c, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, },
	{ { 0x04, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x04, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, { 0x14, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, },
	{ { 0x0c, true , 0x019f, 0x01bf, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, },
	{ { 0x14, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x019f, 0x01be, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, },
	{ { 0x0c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x0241, 0x0261, 0x1ff1, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x01de, 0x01fe, 0x000f, (char)0xf2, (char)0x0f}, },
	{ { 0x14, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x02c1, 0x02e1, 0x1ff5, (char)0xf5, (char)0x0e}, },
	{ { 0x0c, true , 0x02de, 0x02fe, 0x000b, (char)0x0b, (char)0xf7}, { 0x04, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, },
	{ { 0x14, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x019f, 0x01bf, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, },
	{ { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, },
	{ { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x019f, 0x01be, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x0241, 0x0261, 0x1ff1, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, },
	{ { 0x0c, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, },
	{ { 0x1c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02de, 0x02fe, 0x000b, (char)0x0b, (char)0xf7}, { 0x04, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, true , 0x0080, 0x00a0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x019f, 0x01bf, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, },
	{ { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x019f, 0x01be, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x1c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x0241, 0x0261, 0x1ff1, (char)0xf1, (char)0x0a}, },
	{ { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02de, 0x02fe, 0x000b, (char)0x0b, (char)0xf7}, { 0x04, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, },
	{ { 0x0c, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0080, 0x00a0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x019f, 0x01bf, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x04, true , 0x027e, 0x029e, 0x0009, (char)0x09, (char)0xf4}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x011e, 0x013e, 0x0009, (char)0xf2, (char)0x09}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, },
	{ { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, },
	{ { 0x04, false, 0x0081, 0x00a1, 0x17f4, (char)0x0a, (char)0xf4}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0101, 0x0120, 0x1ff4, (char)0xf4, (char)0x08}, { 0x04, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02de, 0x02fe, 0x000b, (char)0x0b, (char)0xf7}, },
	{ { 0x14, true , 0x021e, 0x023e, 0x0009, (char)0x09, (char)0xf1}, { 0x0c, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, },
	{ { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0080, 0x00a0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x14, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, { 0x04, true , 0x027e, 0x029e, 0x0009, (char)0x09, (char)0xf4}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x011e, 0x013e, 0x0009, (char)0xf2, (char)0x09}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, },
	{ { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0f, (char)0xf6}, },
	{ { 0x14, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x0081, 0x00a1, 0x17f4, (char)0x0a, (char)0xf4}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x0101, 0x0120, 0x1ff4, (char)0xf4, (char)0x08}, { 0x04, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x04, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x021e, 0x023e, 0x0009, (char)0x09, (char)0xf1}, { 0x0c, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, },
	{ { 0x0c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0080, 0x00a0, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x1c, false, 0x0181, 0x01a0, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, { 0x04, true , 0x027e, 0x029e, 0x0009, (char)0x09, (char)0xf4}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x011e, 0x013e, 0x0009, (char)0xf2, (char)0x09}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, },
	{ { 0x14, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x04, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x0081, 0x00a1, 0x17f4, (char)0x0a, (char)0xf4}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x0101, 0x0120, 0x1ff4, (char)0xf4, (char)0x08}, { 0x04, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, },
	{ { 0x0c, false, 0x01e1, 0x0200, 0x17fa, (char)0x08, (char)0xfa}, { 0x04, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x021e, 0x023e, 0x0009, (char)0x09, (char)0xf1}, { 0x0c, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x1c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0181, 0x01a0, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, { 0x04, true , 0x027e, 0x029e, 0x0009, (char)0x09, (char)0xf4}, },
	{ { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x011e, 0x013e, 0x0009, (char)0xf2, (char)0x09}, },
	{ { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x0081, 0x00a1, 0x17f4, (char)0x0a, (char)0xf4}, },
	{ { 0x1c, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x0101, 0x0120, 0x1ff4, (char)0xf4, (char)0x08}, },
	{ { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x01e1, 0x0200, 0x17fa, (char)0x08, (char)0xfa}, { 0x04, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x021e, 0x023e, 0x0009, (char)0x09, (char)0xf1}, },
	{ { 0x1c, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x007f, 0x009e, 0x17f4, (char)0xf8, (char)0xf4}, { 0x14, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0181, 0x01a0, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, },
	{ { 0x0c, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x14, true , 0x0200, 0x0220, 0x1ff1, (char)0xf1, (char)0x06}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, },
	{ { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x04, false, 0x00a1, 0x00c0, 0x17f5, (char)0x08, (char)0xf5}, { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x01e1, 0x0200, 0x17fa, (char)0x08, (char)0xfa}, { 0x04, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, },
	{ { 0x14, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x007f, 0x009e, 0x17f4, (char)0xf8, (char)0xf4}, { 0x14, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0181, 0x01a0, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x04, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x04, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0200, 0x0220, 0x1ff1, (char)0xf1, (char)0x06}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x04, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x09, (char)0xfa}, { 0x04, false, 0x00a1, 0x00c0, 0x17f5, (char)0x08, (char)0xf5}, { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x01e1, 0x0200, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x037e, 0x039e, 0x000c, (char)0xf7, (char)0x0c}, { 0x14, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x007f, 0x009e, 0x17f4, (char)0xf8, (char)0xf4}, { 0x14, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf7, (char)0x0a}, },
	{ { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0200, 0x0220, 0x1ff1, (char)0xf1, (char)0x06}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, },
	{ { 0x1c, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, },
	{ { 0x1c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x09, (char)0xfa}, { 0x04, false, 0x00a1, 0x00c0, 0x17f5, (char)0x08, (char)0xf5}, { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0a, (char)0xf1}, },
	{ { 0x1c, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x14, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x037e, 0x039e, 0x000c, (char)0xf7, (char)0x0c}, { 0x14, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x007f, 0x009e, 0x17f4, (char)0xf8, (char)0xf4}, },
	{ { 0x04, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, },
	{ { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0200, 0x0220, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x0c, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x09, (char)0xfa}, { 0x04, false, 0x00a1, 0x00c0, 0x17f5, (char)0x08, (char)0xf5}, },
	{ { 0x1c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x037e, 0x039e, 0x000c, (char)0xf7, (char)0x0c}, { 0x14, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02e0, 0x0000, 0x1ff5, (char)0xf5, (char)0x07}, { 0x04, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x04, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x0c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, },
	{ { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, true , 0x02c1, 0x02e1, 0x0007, (char)0x07, (char)0x0e}, { 0x0c, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x14, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x0c, true , 0x025f, 0x027f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x037e, 0x039e, 0x000c, (char)0xf7, (char)0x0c}, },
	{ { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e0, 0x0000, 0x1ff5, (char)0xf5, (char)0x07}, { 0x04, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, },
	{ { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, },
	{ { 0x1c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, },
	{ { 0x1c, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02c1, 0x02e1, 0x0007, (char)0x07, (char)0x0e}, { 0x0c, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, },
	{ { 0x14, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x0c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x025f, 0x027f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, },
	{ { 0x1c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e0, 0x0000, 0x1ff5, (char)0xf5, (char)0x07}, { 0x04, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, },
	{ { 0x1c, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, },
	{ { 0x04, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02c1, 0x02e1, 0x0007, (char)0x07, (char)0x0e}, { 0x0c, true , 0x013f, 0x015f, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x0c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x025f, 0x027f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x14, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e0, 0x0000, 0x1ff5, (char)0xf5, (char)0x07}, },
	{ { 0x0c, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x14, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02c1, 0x02e1, 0x0007, (char)0x07, (char)0x0e}, },
	{ { 0x0c, true , 0x01bf, 0x01df, 0x000a, (char)0x0a, (char)0xfa}, { 0x0c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x02a1, 0x02c1, 0x1ff5, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x025f, 0x027f, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, },
	{ { 0x1c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01bf, 0x01df, 0x000a, (char)0x0a, (char)0xfa}, { 0x0c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a1, 0x02c1, 0x1ff5, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x04, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, },
	{ { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01bf, 0x01df, 0x000a, (char)0x0a, (char)0xfa}, { 0x0c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x0161, 0x0181, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a1, 0x02c1, 0x1ff5, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x1c, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, },
	{ { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x04, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x0c, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x14, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01bf, 0x01df, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0161, 0x0181, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a1, 0x02c1, 0x1ff5, (char)0xf5, (char)0x0d}, },
	{ { 0x1c, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x14, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x0c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, },
	{ { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0161, 0x0181, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x14, true , 0x007e, 0x009e, 0x000e, (char)0x0e, (char)0xf4}, { 0x14, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x0c, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x14, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, { 0x14, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0161, 0x0181, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x0c, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, },
	{ { 0x14, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x007e, 0x009e, 0x000e, (char)0x0e, (char)0xf4}, { 0x14, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, },
	{ { 0x04, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, },
	{ { 0x0c, false, 0x0281, 0x02a1, 0x17f4, (char)0x0b, (char)0xf4}, { 0x14, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, { 0x14, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x1c, true , 0x0101, 0x0120, 0x1ff6, (char)0xf6, (char)0x08}, { 0x04, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x14, true , 0x021e, 0x023e, 0x000d, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x0c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x007e, 0x009e, 0x000e, (char)0x0e, (char)0xf4}, { 0x14, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, },
	{ { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, { 0x04, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0281, 0x02a1, 0x1ff1, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0281, 0x02a1, 0x17f4, (char)0x0b, (char)0xf4}, { 0x14, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, { 0x14, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x0240, 0x0260, 0x0006, (char)0x07, (char)0x06}, { 0x1c, true , 0x0101, 0x0120, 0x1ff6, (char)0xf6, (char)0x08}, { 0x04, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x04, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x021e, 0x023e, 0x000d, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x0c, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x007e, 0x009e, 0x000e, (char)0x0e, (char)0xf4}, },
	{ { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, { 0x04, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x023e, 0x025e, 0x1ff9, (char)0xf9, (char)0xf2}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, { 0x0c, true , 0x0281, 0x02a1, 0x1ff1, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0281, 0x02a1, 0x17f4, (char)0x0b, (char)0xf4}, { 0x14, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, },
	{ { 0x0c, true , 0x00e0, 0x0100, 0x1ff2, (char)0xf2, (char)0x07}, { 0x04, false, 0x0240, 0x0260, 0x0006, (char)0x07, (char)0x06}, { 0x1c, true , 0x0101, 0x0120, 0x1ff6, (char)0xf6, (char)0x08}, { 0x04, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, },
	{ { 0x14, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x021e, 0x023e, 0x000d, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, },
	{ { 0x04, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x039e, 0x03be, 0x000d, (char)0xf3, (char)0x0d}, { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, { 0x04, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, },
	{ { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, },
	{ { 0x04, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, { 0x14, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, { 0x0c, true , 0x0281, 0x02a1, 0x1ff1, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0281, 0x02a1, 0x17f4, (char)0x0b, (char)0xf4}, },
	{ { 0x1c, true , 0x021e, 0x023e, 0x000d, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x00e0, 0x0100, 0x1ff2, (char)0xf2, (char)0x07}, { 0x04, false, 0x0240, 0x0260, 0x0006, (char)0x07, (char)0x06}, { 0x1c, true , 0x0101, 0x0120, 0x1ff6, (char)0xf6, (char)0x08}, },
	{ { 0x1c, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, { 0x14, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x021e, 0x023e, 0x000d, (char)0x0d, (char)0xf1}, },
	{ { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, { 0x04, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x039e, 0x03be, 0x000d, (char)0xf3, (char)0x0d}, { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, },
	{ { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x14, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, { 0x14, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, { 0x0c, true , 0x0281, 0x02a1, 0x1ff1, (char)0xf1, (char)0x0c}, },
	{ { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, },
	{ { 0x04, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x021e, 0x023e, 0x000d, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x00e0, 0x0100, 0x1ff2, (char)0xf2, (char)0x07}, { 0x04, false, 0x0240, 0x0260, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x0c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, { 0x14, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, { 0x04, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, },
	{ { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x039e, 0x03be, 0x000d, (char)0xf3, (char)0x0d}, { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, { 0x14, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, },
	{ { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, },
	{ { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x021e, 0x023e, 0x000d, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x00e0, 0x0100, 0x1ff2, (char)0xf2, (char)0x07}, },
	{ { 0x14, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, { 0x14, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, { 0x04, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x039e, 0x03be, 0x000d, (char)0xf3, (char)0x0d}, },
	{ { 0x04, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, { 0x14, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, },
	{ { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, },
	{ { 0x1c, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x021e, 0x023e, 0x000d, (char)0x0d, (char)0xf1}, },
	{ { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, },
	{ { 0x14, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf4, (char)0x07}, },
	{ { 0x0c, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01bf, 0x01de, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x14, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, { 0x14, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, },
	{ { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x1ff6, (char)0xf6, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, },
	{ { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, { 0x14, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, },
	{ { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x1ff6, (char)0xf6, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x09, (char)0xfa}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x14, true , 0x02a1, 0x02c1, 0x1ff7, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x04, true , 0x025f, 0x027f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf7, (char)0x0a}, },
	{ { 0x0c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, },
	{ { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x1ff6, (char)0xf6, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, },
	{ { 0x1c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x09, (char)0xfa}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, },
	{ { 0x1c, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff7, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, },
	{ { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025f, 0x027f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, },
	{ { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, },
	{ { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x09, (char)0xfa}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, },
	{ { 0x04, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff7, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025f, 0x027f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x1c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x14, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, false, 0x013e, 0x015e, 0x000a, (char)0xf4, (char)0x0a}, { 0x1c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x0c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff7, (char)0xf7, (char)0x0d}, },
	{ { 0x04, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025f, 0x027f, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, true , 0x00a0, 0x00c0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x0c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x013e, 0x015e, 0x000a, (char)0xf4, (char)0x0a}, { 0x1c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x14, true , 0x0181, 0x01a1, 0x1ff2, (char)0xf2, (char)0x0c}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00a0, 0x00c0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x027f, 0x029f, 0x0009, (char)0x09, (char)0xfa}, { 0x14, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x1c, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, { 0x0c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x013e, 0x015e, 0x000a, (char)0xf4, (char)0x0a}, { 0x1c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, },
	{ { 0x14, true , 0x0260, 0x0280, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x1ff2, (char)0xf2, (char)0x0c}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, },
	{ { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00a0, 0x00c0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, { 0x0c, true , 0x027f, 0x029f, 0x0009, (char)0x09, (char)0xfa}, { 0x14, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x04, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, { 0x0c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x013e, 0x015e, 0x000a, (char)0xf4, (char)0x0a}, },
	{ { 0x0c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0260, 0x0280, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x1ff2, (char)0xf2, (char)0x0c}, { 0x14, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, },
	{ { 0x1c, true , 0x00ff, 0x011e, 0x000c, (char)0x0c, (char)0xf8}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x09, (char)0xf1}, { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x1c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, },
	{ { 0x14, true , 0x00a0, 0x00c0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00a0, 0x00c0, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x04, true , 0x015f, 0x017f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, { 0x0c, true , 0x027f, 0x029f, 0x0009, (char)0x09, (char)0xfa}, { 0x14, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x0c, false, 0x02de, 0x02fe, 0x0007, (char)0xf1, (char)0x07}, { 0x04, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, { 0x0c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0260, 0x0280, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x1ff2, (char)0xf2, (char)0x0c}, },
	{ { 0x04, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00ff, 0x011e, 0x000c, (char)0x0c, (char)0xf8}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x04, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x09, (char)0xf1}, { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, true , 0x02a0, 0x02c0, 0x0007, (char)0x07, (char)0x06}, { 0x1c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x015f, 0x017f, 0x000e, (char)0x0e, (char)0xfa}, { 0x14, true , 0x00a0, 0x00c0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x0c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x015f, 0x017f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, { 0x0c, true , 0x027f, 0x029f, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x1c, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x02de, 0x02fe, 0x0007, (char)0xf1, (char)0x07}, { 0x04, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, },
	{ { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0260, 0x0280, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x14, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00ff, 0x011e, 0x000c, (char)0x0c, (char)0xf8}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0200, 0x0220, 0x1ff7, (char)0xf7, (char)0x06}, { 0x04, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x09, (char)0xf1}, { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02a0, 0x02c0, 0x0007, (char)0x07, (char)0x06}, { 0x1c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x0c, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, { 0x14, true , 0x015f, 0x017f, 0x000e, (char)0x0e, (char)0xfa}, { 0x14, true , 0x00a0, 0x00c0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x00be, 0x00de, 0x1ff8, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x015f, 0x017f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, },
	{ { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x02de, 0x02fe, 0x0007, (char)0xf1, (char)0x07}, { 0x04, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x04, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00ff, 0x011e, 0x000c, (char)0x0c, (char)0xf8}, },
	{ { 0x04, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0200, 0x0220, 0x1ff7, (char)0xf7, (char)0x06}, { 0x04, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x09, (char)0xf1}, },
	{ { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0d, (char)0xf3}, { 0x14, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02a0, 0x02c0, 0x0007, (char)0x07, (char)0x06}, { 0x1c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x0c, true , 0x00be, 0x00de, 0x000a, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, { 0x14, true , 0x015f, 0x017f, 0x000e, (char)0x0e, (char)0xfa}, { 0x14, true , 0x00a0, 0x00c0, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00be, 0x00de, 0x1ff8, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x015f, 0x017f, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x02de, 0x02fe, 0x0007, (char)0xf1, (char)0x07}, },
	{ { 0x0c, false, 0x027e, 0x029e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf6, (char)0x08}, { 0x04, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, { 0x04, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0200, 0x0220, 0x1ff7, (char)0xf7, (char)0x06}, { 0x04, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0d, (char)0xf3}, { 0x14, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02a0, 0x02c0, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00be, 0x00de, 0x000a, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, { 0x14, true , 0x015f, 0x017f, 0x000e, (char)0x0e, (char)0xfa}, },
	{ { 0x14, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00be, 0x00de, 0x1ff8, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, },
	{ { 0x0c, true , 0x0080, 0x00a0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x027e, 0x029e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf6, (char)0x08}, { 0x04, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x04, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, { 0x04, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0200, 0x0220, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x04, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0d, (char)0xf3}, { 0x14, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x04, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00be, 0x00de, 0x000a, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, },
	{ { 0x0c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00be, 0x00de, 0x1ff8, (char)0xf8, (char)0xf6}, },
	{ { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x0080, 0x00a0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x04, false, 0x0181, 0x01a1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x027e, 0x029e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, },
	{ { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf6, (char)0x08}, { 0x04, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, { 0x04, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, { 0x04, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, },
	{ { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0d, (char)0xf3}, },
	{ { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00be, 0x00de, 0x000a, (char)0x0a, (char)0xf6}, },
	{ { 0x0c, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x0060, 0x0080, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x0080, 0x00a0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0181, 0x01a1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x027e, 0x029e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x04, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf6, (char)0x08}, },
	{ { 0x04, false, 0x039e, 0x03be, 0x000d, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, { 0x04, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, },
	{ { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, },
	{ { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x0060, 0x0080, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x0080, 0x00a0, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0a, (char)0xf4}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0181, 0x01a1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, },
	{ { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, { 0x04, false, 0x039e, 0x03be, 0x000d, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, { 0x04, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, },
	{ { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x04, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x0060, 0x0080, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0a, (char)0xf4}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0181, 0x01a1, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x04, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, { 0x04, false, 0x039e, 0x03be, 0x000d, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, },
	{ { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, },
	{ { 0x04, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x0060, 0x0080, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0a, (char)0xf4}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x00de, 0x00fe, 0x000c, (char)0x0c, (char)0xf7}, { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, },
	{ { 0x0c, true , 0x01df, 0x01ff, 0x0008, (char)0x08, (char)0xfa}, { 0x04, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, { 0x04, false, 0x039e, 0x03be, 0x000d, (char)0xf1, (char)0x0d}, },
	{ { 0x1c, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, },
	{ { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0d, (char)0xf2}, },
	{ { 0x0c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0a, (char)0xf4}, },
	{ { 0x1c, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00de, 0x00fe, 0x000c, (char)0x0c, (char)0xf7}, { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x01df, 0x01ff, 0x0008, (char)0x08, (char)0xfa}, { 0x04, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, },
	{ { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x1c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x1c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, },
	{ { 0x1c, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x001e, 0x003e, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x0040, 0x0060, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00de, 0x00fe, 0x000c, (char)0x0c, (char)0xf7}, { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x009f, 0x00be, 0x17f5, (char)0xf8, (char)0xf5}, { 0x1c, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x01df, 0x01ff, 0x0008, (char)0x08, (char)0xfa}, { 0x04, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, },
	{ { 0x0c, true , 0x0141, 0x0161, 0x1ff0, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, },
	{ { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x001e, 0x003e, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00de, 0x00fe, 0x000c, (char)0x0c, (char)0xf7}, },
	{ { 0x14, true , 0x00ff, 0x011e, 0x000a, (char)0x0a, (char)0xf8}, { 0x04, false, 0x009f, 0x00be, 0x17f5, (char)0xf8, (char)0xf5}, { 0x1c, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x01df, 0x01ff, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x0c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0141, 0x0161, 0x1ff0, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, },
	{ { 0x14, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, },
	{ { 0x14, true , 0x01df, 0x01ff, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x001e, 0x003e, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x14, false, 0x03be, 0x03de, 0x000e, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x04, true , 0x0281, 0x02a1, 0x0007, (char)0x07, (char)0x0c}, { 0x14, true , 0x00ff, 0x011e, 0x000a, (char)0x0a, (char)0xf8}, { 0x04, false, 0x009f, 0x00be, 0x17f5, (char)0xf8, (char)0xf5}, { 0x1c, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, },
	{ { 0x04, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0141, 0x0161, 0x1ff0, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, false, 0x0261, 0x0281, 0x17f3, (char)0x0f, (char)0xf3}, { 0x14, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0e, (char)0xf6}, { 0x0c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x01df, 0x01ff, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, },
	{ { 0x1c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x001e, 0x003e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x1c, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x03be, 0x03de, 0x000e, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x14, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x0281, 0x02a1, 0x0007, (char)0x07, (char)0x0c}, { 0x14, true , 0x00ff, 0x011e, 0x000a, (char)0x0a, (char)0xf8}, { 0x04, false, 0x009f, 0x00be, 0x17f5, (char)0xf8, (char)0xf5}, },
	{ { 0x04, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0141, 0x0161, 0x1ff0, (char)0xf0, (char)0x0a}, },
	{ { 0x0c, true , 0x02bf, 0x02df, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x0c, false, 0x0261, 0x0281, 0x17f3, (char)0x0f, (char)0xf3}, { 0x14, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0e, (char)0xf6}, { 0x0c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x14, true , 0x0241, 0x0261, 0x0007, (char)0x07, (char)0x0a}, { 0x1c, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x01df, 0x01ff, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x04, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x0c, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x03be, 0x03de, 0x000e, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0281, 0x02a1, 0x17f4, (char)0x0d, (char)0xf4}, { 0x14, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x0281, 0x02a1, 0x0007, (char)0x07, (char)0x0c}, { 0x14, true , 0x00ff, 0x011e, 0x000a, (char)0x0a, (char)0xf8}, },
	{ { 0x1c, true , 0x00ff, 0x011e, 0x000a, (char)0x0a, (char)0xf8}, { 0x04, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x02bf, 0x02df, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x0c, false, 0x0261, 0x0281, 0x17f3, (char)0x0f, (char)0xf3}, { 0x14, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0e, (char)0xf6}, { 0x0c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x007e, 0x009e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x0241, 0x0261, 0x0007, (char)0x07, (char)0x0a}, { 0x1c, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x01df, 0x01ff, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x14, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x03be, 0x03de, 0x000e, (char)0xf3, (char)0x0e}, },
	{ { 0x14, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0281, 0x02a1, 0x17f4, (char)0x0d, (char)0xf4}, { 0x14, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x0281, 0x02a1, 0x0007, (char)0x07, (char)0x0c}, },
	{ { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00ff, 0x011e, 0x000a, (char)0x0a, (char)0xf8}, { 0x04, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x04, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x02bf, 0x02df, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x0c, false, 0x0261, 0x0281, 0x17f3, (char)0x0f, (char)0xf3}, },
	{ { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0e, (char)0xf6}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x007e, 0x009e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x0241, 0x0261, 0x0007, (char)0x07, (char)0x0a}, { 0x1c, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, },
	{ { 0x04, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0281, 0x02a1, 0x17f4, (char)0x0d, (char)0xf4}, { 0x14, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, },
	{ { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00ff, 0x011e, 0x000a, (char)0x0a, (char)0xf8}, { 0x04, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x02bf, 0x02df, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x14, true , 0x0020, 0x0040, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x04, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x007e, 0x009e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x0241, 0x0261, 0x0007, (char)0x07, (char)0x0a}, },
	{ { 0x0c, true , 0x00de, 0x00fe, 0x1ff8, (char)0xf8, (char)0xf7}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0281, 0x02a1, 0x17f4, (char)0x0d, (char)0xf4}, },
	{ { 0x04, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00ff, 0x011e, 0x000a, (char)0x0a, (char)0xf8}, },
	{ { 0x04, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x0020, 0x0040, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0e, (char)0xf7}, { 0x04, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x007e, 0x009e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x1c, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00de, 0x00fe, 0x1ff8, (char)0xf8, (char)0xf7}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, },
	{ { 0x1c, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x14, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, { 0x04, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x0c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x0020, 0x0040, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02bf, 0x02df, 0x000b, (char)0x0b, (char)0xfa}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0e, (char)0xf7}, { 0x04, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x07, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00de, 0x00fe, 0x1ff8, (char)0xf8, (char)0xf7}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, { 0x04, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, },
	{ { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x0020, 0x0040, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x02bf, 0x02df, 0x000b, (char)0x0b, (char)0xfa}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0e, (char)0xf7}, { 0x04, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, },
	{ { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x07, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00de, 0x00fe, 0x1ff8, (char)0xf8, (char)0xf7}, },
	{ { 0x0c, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x0c, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, { 0x04, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, },
	{ { 0x1c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, },
	{ { 0x1c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, },
	{ { 0x14, true , 0x029e, 0x02be, 0x1ff9, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x02bf, 0x02df, 0x000b, (char)0x0b, (char)0xfa}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0e, (char)0xf7}, },
	{ { 0x0c, false, 0x015e, 0x017e, 0x000b, (char)0xf2, (char)0x0b}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x07, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x04, true , 0x017f, 0x019f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, },
	{ { 0x0c, false, 0x031e, 0x033e, 0x0009, (char)0xf5, (char)0x09}, { 0x0c, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, },
	{ { 0x14, true , 0x023e, 0x025e, 0x000b, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029e, 0x02be, 0x1ff9, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x02bf, 0x02df, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x0c, false, 0x02c1, 0x02e1, 0x17f6, (char)0x09, (char)0xf6}, { 0x0c, false, 0x015e, 0x017e, 0x000b, (char)0xf2, (char)0x0b}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x07, (char)0x0d}, },
	{ { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x017f, 0x019f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x04, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x031e, 0x033e, 0x0009, (char)0xf5, (char)0x09}, { 0x0c, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x023e, 0x025e, 0x000b, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, },
	{ { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x017f, 0x019f, 0x0008, (char)0x08, (char)0xfa}, { 0x14, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029e, 0x02be, 0x1ff9, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf5, (char)0x0d}, },
	{ { 0x1c, false, 0x031e, 0x033e, 0x0009, (char)0xf1, (char)0x09}, { 0x0c, false, 0x02c1, 0x02e1, 0x17f6, (char)0x09, (char)0xf6}, { 0x0c, false, 0x015e, 0x017e, 0x000b, (char)0xf2, (char)0x0b}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x04, false, 0x007e, 0x009e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x017f, 0x019f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x04, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x031e, 0x033e, 0x0009, (char)0xf5, (char)0x09}, { 0x0c, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, },
	{ { 0x0c, true , 0x021e, 0x023e, 0x0009, (char)0x09, (char)0xf1}, { 0x0c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x023e, 0x025e, 0x000b, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x017f, 0x019f, 0x0008, (char)0x08, (char)0xfa}, { 0x14, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029e, 0x02be, 0x1ff9, (char)0xf9, (char)0xf5}, },
	{ { 0x04, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x031e, 0x033e, 0x0009, (char)0xf1, (char)0x09}, { 0x0c, false, 0x02c1, 0x02e1, 0x17f6, (char)0x09, (char)0xf6}, { 0x0c, false, 0x015e, 0x017e, 0x000b, (char)0xf2, (char)0x0b}, },
	{ { 0x0c, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x14, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x007e, 0x009e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x017f, 0x019f, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x031e, 0x033e, 0x0009, (char)0xf5, (char)0x09}, },
	{ { 0x04, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021e, 0x023e, 0x0009, (char)0x09, (char)0xf1}, { 0x0c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x023e, 0x025e, 0x000b, (char)0x0b, (char)0xf2}, },
	{ { 0x0c, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x017f, 0x019f, 0x0008, (char)0x08, (char)0xfa}, { 0x14, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x02e1, 0x0301, 0x17f7, (char)0x0f, (char)0xf7}, { 0x04, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x031e, 0x033e, 0x0009, (char)0xf1, (char)0x09}, { 0x0c, false, 0x02c1, 0x02e1, 0x17f6, (char)0x09, (char)0xf6}, },
	{ { 0x0c, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, },
	{ { 0x1c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x007e, 0x009e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, true , 0x0200, 0x0220, 0x1ff7, (char)0xf7, (char)0x06}, { 0x04, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021e, 0x023e, 0x0009, (char)0x09, (char)0xf1}, { 0x0c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x14, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, },
	{ { 0x0c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x017f, 0x019f, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x1c, true , 0x007e, 0x009e, 0x1ff8, (char)0xf8, (char)0xf4}, { 0x14, false, 0x02e1, 0x0301, 0x17f7, (char)0x0f, (char)0xf7}, { 0x04, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x031e, 0x033e, 0x0009, (char)0xf1, (char)0x09}, },
	{ { 0x1c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x0240, 0x0260, 0x1ff1, (char)0xf1, (char)0x06}, { 0x1c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x007e, 0x009e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x04, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x04, false, 0x013e, 0x015e, 0x000a, (char)0xf4, (char)0x0a}, { 0x1c, true , 0x0200, 0x0220, 0x1ff7, (char)0xf7, (char)0x06}, { 0x04, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021e, 0x023e, 0x0009, (char)0x09, (char)0xf1}, },
	{ { 0x04, true , 0x027e, 0x029e, 0x0009, (char)0x09, (char)0xf4}, { 0x14, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x1ff8, (char)0xf8, (char)0xf4}, { 0x14, false, 0x02e1, 0x0301, 0x17f7, (char)0x0f, (char)0xf7}, { 0x04, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x04, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, },
	{ { 0x0c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x0240, 0x0260, 0x1ff1, (char)0xf1, (char)0x06}, { 0x1c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, { 0x04, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x013e, 0x015e, 0x000a, (char)0xf4, (char)0x0a}, { 0x1c, true , 0x0200, 0x0220, 0x1ff7, (char)0xf7, (char)0x06}, { 0x04, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, { 0x04, true , 0x027e, 0x029e, 0x0009, (char)0x09, (char)0xf4}, { 0x14, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, },
	{ { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf7, (char)0x0c}, { 0x14, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x1ff8, (char)0xf8, (char)0xf4}, { 0x14, false, 0x02e1, 0x0301, 0x17f7, (char)0x0f, (char)0xf7}, },
	{ { 0x14, true , 0x01ff, 0x021e, 0x000f, (char)0x0f, (char)0xf8}, { 0x04, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x0240, 0x0260, 0x1ff1, (char)0xf1, (char)0x06}, { 0x1c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, { 0x04, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, },
	{ { 0x1c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x013e, 0x015e, 0x000a, (char)0xf4, (char)0x0a}, { 0x1c, true , 0x0200, 0x0220, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x1c, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, { 0x04, true , 0x027e, 0x029e, 0x0009, (char)0x09, (char)0xf4}, { 0x14, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x14, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf7, (char)0x0c}, { 0x14, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x1ff8, (char)0xf8, (char)0xf4}, },
	{ { 0x04, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x01ff, 0x021e, 0x000f, (char)0x0f, (char)0xf8}, { 0x04, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x0240, 0x0260, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x0c, false, 0x01a1, 0x01c0, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, { 0x04, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x1c, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x013e, 0x015e, 0x000a, (char)0xf4, (char)0x0a}, },
	{ { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, { 0x04, true , 0x027e, 0x029e, 0x0009, (char)0x09, (char)0xf4}, },
	{ { 0x04, false, 0x013e, 0x015e, 0x000a, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf7, (char)0x0c}, { 0x14, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0a, (char)0xf8}, { 0x04, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x01ff, 0x021e, 0x000f, (char)0x0f, (char)0xf8}, { 0x04, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, },
	{ { 0x1c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, },
	{ { 0x14, false, 0x0021, 0x0041, 0x17f1, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x01a1, 0x01c0, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, },
	{ { 0x0c, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x007f, 0x009e, 0x17f4, (char)0xf8, (char)0xf4}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, },
	{ { 0x0c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x013e, 0x015e, 0x000a, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x14, true , 0x0200, 0x0220, 0x1ff1, (char)0xf1, (char)0x06}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf7, (char)0x0c}, },
	{ { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0a, (char)0xf8}, { 0x04, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x01ff, 0x021e, 0x000f, (char)0x0f, (char)0xf8}, },
	{ { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, },
	{ { 0x04, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, { 0x14, false, 0x0021, 0x0041, 0x17f1, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x01a1, 0x01c0, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0c, (char)0xf6}, },
	{ { 0x14, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x007f, 0x009e, 0x17f4, (char)0xf8, (char)0xf4}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x013e, 0x015e, 0x000a, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x0201, 0x0220, 0x1ff1, (char)0xf1, (char)0x08}, },
	{ { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf4, (char)0x0c}, { 0x14, true , 0x0200, 0x0220, 0x1ff1, (char)0xf1, (char)0x06}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0a, (char)0xf8}, { 0x04, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, { 0x14, false, 0x0021, 0x0041, 0x17f1, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x01a1, 0x01c0, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x04, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x005e, 0x007e, 0x1ff8, (char)0xf8, (char)0xf3}, { 0x14, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x007f, 0x009e, 0x17f4, (char)0xf8, (char)0xf4}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x013e, 0x015e, 0x000a, (char)0xf6, (char)0x0a}, },
	{ { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf4, (char)0x0c}, { 0x14, true , 0x0200, 0x0220, 0x1ff1, (char)0xf1, (char)0x06}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x04, false, 0x03de, 0x03fe, 0x000f, (char)0xf1, (char)0x0f}, { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0a, (char)0xf8}, },
	{ { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x07, (char)0x0c}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, { 0x14, false, 0x0021, 0x0041, 0x17f1, (char)0x0a, (char)0xf1}, },
	{ { 0x04, true , 0x01ff, 0x021e, 0x000f, (char)0x0f, (char)0xf8}, { 0x04, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x005e, 0x007e, 0x1ff8, (char)0xf8, (char)0xf3}, { 0x14, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x007f, 0x009e, 0x17f4, (char)0xf8, (char)0xf4}, },
	{ { 0x1c, false, 0x0041, 0x0061, 0x17f2, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0c, (char)0xf4}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf4, (char)0x0c}, { 0x14, true , 0x0200, 0x0220, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x1c, false, 0x00ff, 0x011e, 0x17f8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x03de, 0x03fe, 0x000f, (char)0xf1, (char)0x0f}, { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x07, (char)0x0c}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x1ff4, (char)0xf4, (char)0x06}, { 0x04, true , 0x01ff, 0x021e, 0x000f, (char)0x0f, (char)0xf8}, { 0x04, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x04, false, 0x001f, 0x003e, 0x17f1, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x005e, 0x007e, 0x1ff8, (char)0xf8, (char)0xf3}, { 0x14, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0041, 0x0061, 0x17f2, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0c, (char)0xf4}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf4, (char)0x0c}, },
	{ { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00ff, 0x011e, 0x17f8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x03de, 0x03fe, 0x000f, (char)0xf1, (char)0x0f}, { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, },
	{ { 0x04, true , 0x02a0, 0x02c0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x07, (char)0x0c}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0000, 0x0020, 0x1ff4, (char)0xf4, (char)0x06}, { 0x04, true , 0x01ff, 0x021e, 0x000f, (char)0x0f, (char)0xf8}, { 0x04, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, },
	{ { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0a, (char)0xfa}, { 0x04, false, 0x001f, 0x003e, 0x17f1, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x005e, 0x007e, 0x1ff8, (char)0xf8, (char)0xf3}, },
	{ { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0041, 0x0061, 0x17f2, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0c, (char)0xf4}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00ff, 0x011e, 0x17f8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x03de, 0x03fe, 0x000f, (char)0xf1, (char)0x0f}, },
	{ { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02a0, 0x02c0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf3, (char)0x0e}, },
	{ { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x07, (char)0x0c}, },
	{ { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0000, 0x0020, 0x1ff4, (char)0xf4, (char)0x06}, { 0x04, true , 0x01ff, 0x021e, 0x000f, (char)0x0f, (char)0xf8}, },
	{ { 0x1c, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0a, (char)0xfa}, { 0x04, false, 0x001f, 0x003e, 0x17f1, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0f, (char)0xf1}, },
	{ { 0x1c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0041, 0x0061, 0x17f2, (char)0x0e, (char)0xf2}, },
	{ { 0x14, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0c, (char)0xf4}, },
	{ { 0x04, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00ff, 0x011e, 0x17f8, (char)0xf8, (char)0xf8}, },
	{ { 0x04, true , 0x0181, 0x01a1, 0x1ff0, (char)0xf0, (char)0x0c}, { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02a0, 0x02c0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x1c, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x04, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x04, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0000, 0x0020, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0a, (char)0xfa}, { 0x04, false, 0x001f, 0x003e, 0x17f1, (char)0xf8, (char)0xf1}, },
	{ { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0281, 0x02a1, 0x17f4, (char)0x09, (char)0xf4}, { 0x14, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x1ff0, (char)0xf0, (char)0x0c}, { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02a0, 0x02c0, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0281, 0x02a1, 0x17f4, (char)0x09, (char)0xf4}, { 0x14, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, },
	{ { 0x04, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x1ff0, (char)0xf0, (char)0x0c}, { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, },
	{ { 0x04, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, },
	{ { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0181, 0x01a0, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0281, 0x02a1, 0x17f4, (char)0x09, (char)0xf4}, { 0x14, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x1ff0, (char)0xf0, (char)0x0c}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0181, 0x01a0, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0281, 0x02a1, 0x17f4, (char)0x09, (char)0xf4}, },
	{ { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, true , 0x0060, 0x0080, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x04, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, },
	{ { 0x04, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0181, 0x01a0, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x02de, 0x02fe, 0x000f, (char)0x0f, (char)0xf7}, { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x01df, 0x01ff, 0x000e, (char)0x0e, (char)0xfa}, { 0x04, true , 0x0060, 0x0080, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x000d, (char)0x0d, (char)0xfa}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, { 0x04, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0181, 0x01a0, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02de, 0x02fe, 0x000f, (char)0x0f, (char)0xf7}, { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x01df, 0x01ff, 0x000e, (char)0x0e, (char)0xfa}, { 0x04, true , 0x0060, 0x0080, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000d, (char)0x0d, (char)0xfa}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, { 0x04, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, },
	{ { 0x1c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02de, 0x02fe, 0x000f, (char)0x0f, (char)0xf7}, { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x1c, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x01df, 0x01ff, 0x000e, (char)0x0e, (char)0xfa}, { 0x04, true , 0x0060, 0x0080, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000d, (char)0x0d, (char)0xfa}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x0c, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, { 0x04, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x0c, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, },
	{ { 0x14, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02de, 0x02fe, 0x000f, (char)0x0f, (char)0xf7}, },
	{ { 0x0c, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x01df, 0x01ff, 0x000e, (char)0x0e, (char)0xfa}, },
	{ { 0x14, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02e1, 0x0001, 0x1ff7, (char)0xf7, (char)0x0f}, },
	{ { 0x0c, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, false, 0x0261, 0x0281, 0x17f3, (char)0x09, (char)0xf3}, { 0x14, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x00be, 0x00de, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x04, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, },
	{ { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0261, 0x0281, 0x17f3, (char)0x09, (char)0xf3}, { 0x14, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00be, 0x00de, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, },
	{ { 0x14, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x04, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x0c, true , 0x021e, 0x023e, 0x1ff9, (char)0xf9, (char)0xf1}, { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x1c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x04, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0261, 0x0281, 0x17f3, (char)0x09, (char)0xf3}, { 0x14, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00be, 0x00de, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021e, 0x023e, 0x1ff9, (char)0xf9, (char)0xf1}, { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0261, 0x0281, 0x17f3, (char)0x09, (char)0xf3}, },
	{ { 0x14, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00be, 0x00de, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, },
	{ { 0x1c, true , 0x0200, 0x0220, 0x0007, (char)0x07, (char)0x06}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021e, 0x023e, 0x1ff9, (char)0xf9, (char)0xf1}, { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x14, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x1c, true , 0x009e, 0x00be, 0x1ff8, (char)0xf8, (char)0xf5}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xf9, (char)0xf9}, },
	{ { 0x1c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02c0, 0x02e0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x0200, 0x0220, 0x0007, (char)0x07, (char)0x06}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021e, 0x023e, 0x1ff9, (char)0xf9, (char)0xf1}, },
	{ { 0x04, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x009e, 0x00be, 0x1ff8, (char)0xf8, (char)0xf5}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x0c, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, },
	{ { 0x1c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x14, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, { 0x04, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, },
	{ { 0x0c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x0200, 0x0220, 0x0007, (char)0x07, (char)0x06}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, { 0x04, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x0c, true , 0x0281, 0x02a1, 0x1ff7, (char)0xf7, (char)0x0c}, { 0x14, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x009e, 0x00be, 0x1ff8, (char)0xf8, (char)0xf5}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, },
	{ { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0f, (char)0xf2}, { 0x1c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, { 0x04, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x011f, 0x013f, 0x000c, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x0200, 0x0220, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x1c, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, { 0x14, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, { 0x04, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x14, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x0281, 0x02a1, 0x1ff7, (char)0xf7, (char)0x0c}, { 0x14, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x009e, 0x00be, 0x1ff8, (char)0xf8, (char)0xf5}, },
	{ { 0x04, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0f, (char)0xf2}, { 0x1c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x14, true , 0x0240, 0x0260, 0x0007, (char)0x07, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, { 0x04, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, },
	{ { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x011f, 0x013f, 0x000c, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf5, (char)0x0a}, },
	{ { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, { 0x14, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, { 0x04, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, },
	{ { 0x1c, true , 0x029e, 0x02be, 0x0009, (char)0x09, (char)0xf5}, { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x0c, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x1c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x0281, 0x02a1, 0x1ff7, (char)0xf7, (char)0x0c}, { 0x14, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, },
	{ { 0x14, false, 0x02de, 0x02fe, 0x0007, (char)0xf5, (char)0x07}, { 0x04, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, },
	{ { 0x04, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0f, (char)0xf2}, { 0x1c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, },
	{ { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf5, (char)0x0c}, { 0x14, true , 0x0240, 0x0260, 0x0007, (char)0x07, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02de, 0x02fe, 0x0009, (char)0x09, (char)0xf7}, },
	{ { 0x14, true , 0x01ff, 0x021e, 0x000b, (char)0x0b, (char)0xf8}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x011f, 0x013f, 0x000c, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, },
	{ { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, { 0x14, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, },
	{ { 0x14, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x029e, 0x02be, 0x0009, (char)0x09, (char)0xf5}, { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x0c, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x0281, 0x02a1, 0x1ff7, (char)0xf7, (char)0x0c}, },
	{ { 0x1c, true , 0x015f, 0x017f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x02de, 0x02fe, 0x0007, (char)0xf5, (char)0x07}, { 0x04, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, },
	{ { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0f, (char)0xf2}, },
	{ { 0x14, false, 0x01be, 0x01de, 0x000e, (char)0xf2, (char)0x0e}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf5, (char)0x0c}, { 0x14, true , 0x0240, 0x0260, 0x0007, (char)0x07, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x04, true , 0x0281, 0x02a1, 0x1ff5, (char)0xf5, (char)0x0c}, { 0x14, true , 0x01ff, 0x021e, 0x000b, (char)0x0b, (char)0xf8}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x011f, 0x013f, 0x000c, (char)0x0c, (char)0xf9}, },
	{ { 0x04, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, },
	{ { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x029e, 0x02be, 0x0009, (char)0x09, (char)0xf5}, { 0x1c, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, },
	{ { 0x14, true , 0x00be, 0x00de, 0x000e, (char)0x0e, (char)0xf6}, { 0x0c, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, },
	{ { 0x0c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x015f, 0x017f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x02de, 0x02fe, 0x0007, (char)0xf5, (char)0x07}, { 0x04, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, },
	{ { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01be, 0x01de, 0x000e, (char)0xf2, (char)0x0e}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf5, (char)0x0c}, { 0x14, true , 0x0240, 0x0260, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf6, (char)0x08}, { 0x04, true , 0x0281, 0x02a1, 0x1ff5, (char)0xf5, (char)0x0c}, { 0x14, true , 0x01ff, 0x021e, 0x000b, (char)0x0b, (char)0xf8}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, },
	{ { 0x04, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x029e, 0x02be, 0x0009, (char)0x09, (char)0xf5}, },
	{ { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x000e, (char)0x0e, (char)0xf6}, { 0x0c, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x14, true , 0x00be, 0x00de, 0x0008, (char)0x08, (char)0xf6}, { 0x0c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x015f, 0x017f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x02de, 0x02fe, 0x0007, (char)0xf5, (char)0x07}, },
	{ { 0x0c, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01be, 0x01de, 0x000e, (char)0xf2, (char)0x0e}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf5, (char)0x0c}, },
	{ { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf6, (char)0x08}, { 0x04, true , 0x0281, 0x02a1, 0x1ff5, (char)0xf5, (char)0x0c}, { 0x14, true , 0x01ff, 0x021e, 0x000b, (char)0x0b, (char)0xf8}, },
	{ { 0x04, true , 0x0101, 0x0120, 0x1ff6, (char)0xf6, (char)0x08}, { 0x04, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, false, 0x0041, 0x0061, 0x17f2, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x000e, (char)0x0e, (char)0xf6}, { 0x0c, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, },
	{ { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x0008, (char)0x08, (char)0xf6}, { 0x0c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x015f, 0x017f, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x14, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, { 0x0c, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, true , 0x0260, 0x0280, 0x1ff1, (char)0xf1, (char)0x06}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01be, 0x01de, 0x000e, (char)0xf2, (char)0x0e}, },
	{ { 0x14, true , 0x00e0, 0x0100, 0x1ff2, (char)0xf2, (char)0x07}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf6, (char)0x08}, { 0x04, true , 0x0281, 0x02a1, 0x1ff5, (char)0xf5, (char)0x0c}, },
	{ { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0101, 0x0120, 0x1ff6, (char)0xf6, (char)0x08}, { 0x04, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x0c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0041, 0x0061, 0x17f2, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x000e, (char)0x0e, (char)0xf6}, },
	{ { 0x14, true , 0x02a1, 0x02c1, 0x0007, (char)0x07, (char)0x0d}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x0008, (char)0x08, (char)0xf6}, { 0x0c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, { 0x0c, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x0260, 0x0280, 0x1ff1, (char)0xf1, (char)0x06}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x14, true , 0x00e0, 0x0100, 0x1ff2, (char)0xf2, (char)0x07}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf6, (char)0x08}, },
	{ { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0101, 0x0120, 0x1ff6, (char)0xf6, (char)0x08}, { 0x04, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, true , 0x0020, 0x0040, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0041, 0x0061, 0x17f2, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a1, 0x02c1, 0x0007, (char)0x07, (char)0x0d}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x0008, (char)0x08, (char)0xf6}, },
	{ { 0x0c, false, 0x00df, 0x00fe, 0x17f7, (char)0xf8, (char)0xf7}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, { 0x0c, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, },
	{ { 0x1c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x0260, 0x0280, 0x1ff1, (char)0xf1, (char)0x06}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, },
	{ { 0x14, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x14, true , 0x00e0, 0x0100, 0x1ff2, (char)0xf2, (char)0x07}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0101, 0x0120, 0x1ff6, (char)0xf6, (char)0x08}, },
	{ { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0d, (char)0xf1}, },
	{ { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0020, 0x0040, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0041, 0x0061, 0x17f2, (char)0x0a, (char)0xf2}, },
	{ { 0x0c, true , 0x027e, 0x029e, 0x000d, (char)0x0d, (char)0xf4}, { 0x14, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a1, 0x02c1, 0x0007, (char)0x07, (char)0x0d}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x00df, 0x00fe, 0x17f7, (char)0xf8, (char)0xf7}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, },
	{ { 0x1c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x0260, 0x0280, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x14, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x14, true , 0x00e0, 0x0100, 0x1ff2, (char)0xf2, (char)0x07}, },
	{ { 0x0c, false, 0x00fe, 0x011e, 0x0008, (char)0xf4, (char)0x08}, { 0x04, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0020, 0x0040, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x027e, 0x029e, 0x000d, (char)0x0d, (char)0xf4}, { 0x14, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a1, 0x02c1, 0x0007, (char)0x07, (char)0x0d}, },
	{ { 0x04, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x00df, 0x00fe, 0x17f7, (char)0xf8, (char)0xf7}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, true , 0x00a0, 0x00c0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00fe, 0x011e, 0x0008, (char)0xf4, (char)0x08}, { 0x04, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, },
	{ { 0x04, true , 0x0181, 0x01a1, 0x1ff2, (char)0xf2, (char)0x0c}, { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0020, 0x0040, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, { 0x14, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x027e, 0x029e, 0x000d, (char)0x0d, (char)0xf4}, { 0x14, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x00df, 0x00fe, 0x17f7, (char)0xf8, (char)0xf7}, },
	{ { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00a0, 0x00c0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, },
	{ { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00fe, 0x011e, 0x0008, (char)0xf4, (char)0x08}, { 0x04, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, },
	{ { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x1ff2, (char)0xf2, (char)0x0c}, { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, { 0x14, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x027e, 0x029e, 0x000d, (char)0x0d, (char)0xf4}, },
	{ { 0x1c, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, },
	{ { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00a0, 0x00c0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x04, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00fe, 0x011e, 0x0008, (char)0xf4, (char)0x08}, },
	{ { 0x04, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x1ff2, (char)0xf2, (char)0x0c}, { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, },
	{ { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, { 0x14, false, 0x001e, 0x003e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, },
	{ { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00a0, 0x00c0, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x1ff2, (char)0xf2, (char)0x0c}, },
	{ { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, },
	{ { 0x14, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x14, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, },
	{ { 0x04, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x04, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, },
	{ { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x09, (char)0xf6}, { 0x0c, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, },
	{ { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, { 0x04, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, },
	{ { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x1c, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x09, (char)0xf6}, { 0x0c, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x04, true , 0x0060, 0x0080, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, },
	{ { 0x04, false, 0x00de, 0x00fd, 0x0007, (char)0xf0, (char)0x07}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, { 0x04, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, },
	{ { 0x04, false, 0x0240, 0x0260, 0x0006, (char)0x07, (char)0x06}, { 0x1c, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x09, (char)0xf6}, { 0x0c, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0081, 0x00a1, 0x17f4, (char)0x0e, (char)0xf4}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, { 0x04, true , 0x0060, 0x0080, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x09, (char)0xf0}, { 0x04, false, 0x00de, 0x00fd, 0x0007, (char)0xf0, (char)0x07}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, { 0x04, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, },
	{ { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0240, 0x0260, 0x0006, (char)0x07, (char)0x06}, { 0x1c, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x09, (char)0xf6}, },
	{ { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0081, 0x00a1, 0x17f4, (char)0x0e, (char)0xf4}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, { 0x04, true , 0x0060, 0x0080, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x09, (char)0xf0}, { 0x04, false, 0x00de, 0x00fd, 0x0007, (char)0xf0, (char)0x07}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, },
	{ { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, },
	{ { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, },
	{ { 0x04, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0240, 0x0260, 0x0006, (char)0x07, (char)0x06}, { 0x1c, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0081, 0x00a1, 0x17f4, (char)0x0e, (char)0xf4}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, { 0x04, true , 0x0060, 0x0080, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x09, (char)0xf0}, { 0x04, false, 0x00de, 0x00fd, 0x0007, (char)0xf0, (char)0x07}, },
	{ { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0320, 0x0340, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0240, 0x0260, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0081, 0x00a1, 0x17f4, (char)0x0e, (char)0xf4}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, },
	{ { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x09, (char)0xf0}, },
	{ { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x04, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, },
	{ { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, },
	{ { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, },
	{ { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, },
	{ { 0x04, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x04, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, },
	{ { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, },
	{ { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, },
	{ { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x1c, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x1c, true , 0x013f, 0x015f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x0141, 0x0161, 0x1ff2, (char)0xf2, (char)0x0a}, { 0x1c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x04, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0141, 0x0161, 0x1ff2, (char)0xf2, (char)0x0a}, { 0x1c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, },
	{ { 0x14, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x14, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0141, 0x0161, 0x1ff2, (char)0xf2, (char)0x0a}, { 0x1c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x04, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, true , 0x021f, 0x023f, 0x0009, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x04, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0141, 0x0161, 0x1ff2, (char)0xf2, (char)0x0a}, },
	{ { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xf9, (char)0xf8}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x021f, 0x023f, 0x0009, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x0c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xf9, (char)0xf8}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x04, true , 0x00ff, 0x011e, 0x0008, (char)0x08, (char)0xf8}, { 0x04, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x021f, 0x023f, 0x0009, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00de, 0x17f6, (char)0xf8, (char)0xf6}, },
	{ { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, },
	{ { 0x04, false, 0x00ff, 0x011e, 0x17f8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xf9, (char)0xf8}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00ff, 0x011e, 0x0008, (char)0x08, (char)0xf8}, { 0x04, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x021f, 0x023f, 0x0009, (char)0x09, (char)0xf9}, },
	{ { 0x04, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00ff, 0x011e, 0x17f8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x02ff, 0x031f, 0x17f8, (char)0xf9, (char)0xf8}, },
	{ { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00ff, 0x011e, 0x0008, (char)0x08, (char)0xf8}, { 0x04, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x04, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, },
	{ { 0x0c, true , 0x001e, 0x003e, 0x000e, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x1c, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00ff, 0x011e, 0x17f8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x1c, true , 0x01e1, 0x0201, 0x1ff0, (char)0xf0, (char)0x0f}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x14, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x1ff3, (char)0xf3, (char)0x0f}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00ff, 0x011e, 0x0008, (char)0x08, (char)0xf8}, },
	{ { 0x04, false, 0x03de, 0x03fe, 0x000f, (char)0xf7, (char)0x0f}, { 0x04, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x001e, 0x003e, 0x000e, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x023f, 0x025f, 0x000f, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00ff, 0x011e, 0x17f8, (char)0xf8, (char)0xf8}, },
	{ { 0x1c, true , 0x029e, 0x02be, 0x000f, (char)0x0f, (char)0xf5}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff0, (char)0xf0, (char)0x0f}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e1, 0x0001, 0x1ff3, (char)0xf3, (char)0x0f}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x03de, 0x03fe, 0x000f, (char)0xf7, (char)0x0f}, { 0x04, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x001e, 0x003e, 0x1ff8, (char)0xf8, (char)0xf1}, },
	{ { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, { 0x04, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x001e, 0x003e, 0x000e, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x023f, 0x025f, 0x000f, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029e, 0x02be, 0x000f, (char)0x0f, (char)0xf5}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff0, (char)0xf0, (char)0x0f}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, },
	{ { 0x0c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0f, (char)0xf5}, { 0x1c, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e1, 0x0001, 0x1ff3, (char)0xf3, (char)0x0f}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, },
	{ { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x03de, 0x03fe, 0x000f, (char)0xf7, (char)0x0f}, { 0x04, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, },
	{ { 0x1c, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, { 0x04, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x001e, 0x003e, 0x000e, (char)0x0e, (char)0xf1}, },
	{ { 0x1c, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, },
	{ { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x023f, 0x025f, 0x000f, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, },
	{ { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf5, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029e, 0x02be, 0x000f, (char)0x0f, (char)0xf5}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff0, (char)0xf0, (char)0x0f}, },
	{ { 0x14, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0f, (char)0xf5}, { 0x1c, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, },
	{ { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e1, 0x0001, 0x1ff3, (char)0xf3, (char)0x0f}, },
	{ { 0x14, true , 0x023f, 0x025f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x03de, 0x03fe, 0x000f, (char)0xf7, (char)0x0f}, },
	{ { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, { 0x04, true , 0x02bf, 0x02df, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x14, false, 0x013e, 0x015e, 0x000a, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x04, true , 0x027e, 0x029e, 0x000d, (char)0x0d, (char)0xf4}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x023f, 0x025f, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf5, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029e, 0x02be, 0x000f, (char)0x0f, (char)0xf5}, },
	{ { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0f, (char)0xf5}, { 0x1c, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0181, 0x01a1, 0x1ff4, (char)0xf4, (char)0x0c}, { 0x14, true , 0x023f, 0x025f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, },
	{ { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013e, 0x015e, 0x000a, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x00de, 0x00fe, 0x0007, (char)0xf6, (char)0x07}, { 0x04, true , 0x027e, 0x029e, 0x000d, (char)0x0d, (char)0xf4}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, },
	{ { 0x04, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf5, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0f, (char)0xf5}, },
	{ { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x1ff4, (char)0xf4, (char)0x0c}, { 0x14, true , 0x023f, 0x025f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0d, (char)0xf5}, },
	{ { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013e, 0x015e, 0x000a, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x1c, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, { 0x14, false, 0x00de, 0x00fe, 0x0007, (char)0xf6, (char)0x07}, { 0x04, true , 0x027e, 0x029e, 0x000d, (char)0x0d, (char)0xf4}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x1ff4, (char)0xf4, (char)0x0c}, { 0x14, true , 0x023f, 0x025f, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013e, 0x015e, 0x000a, (char)0xf6, (char)0x0a}, },
	{ { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, { 0x14, false, 0x00de, 0x00fe, 0x0007, (char)0xf6, (char)0x07}, { 0x04, true , 0x027e, 0x029e, 0x000d, (char)0x0d, (char)0xf4}, },
	{ { 0x1c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, },
	{ { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x1ff4, (char)0xf4, (char)0x0c}, },
	{ { 0x1c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, },
	{ { 0x1c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x021f, 0x023f, 0x17f1, (char)0xf9, (char)0xf1}, { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, { 0x14, false, 0x00de, 0x00fe, 0x0007, (char)0xf6, (char)0x07}, },
	{ { 0x0c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x14, true , 0x00a0, 0x00c0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x04, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x0c, true , 0x02c0, 0x02e0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x14, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x04, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x021f, 0x023f, 0x17f1, (char)0xf9, (char)0xf1}, { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, },
	{ { 0x0c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x00a0, 0x00c0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02c0, 0x02e0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, },
	{ { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, },
	{ { 0x0c, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0200, 0x0220, 0x1ff7, (char)0xf7, (char)0x06}, { 0x04, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x021f, 0x023f, 0x17f1, (char)0xf9, (char)0xf1}, { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x001e, 0x003e, 0x000e, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x0c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x00a0, 0x00c0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x1c, true , 0x00be, 0x00de, 0x0008, (char)0x08, (char)0xf6}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02c0, 0x02e0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x04, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0200, 0x0220, 0x1ff7, (char)0xf7, (char)0x06}, { 0x04, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x021f, 0x023f, 0x17f1, (char)0xf9, (char)0xf1}, },
	{ { 0x04, true , 0x01ff, 0x021e, 0x000d, (char)0x0d, (char)0xf8}, { 0x04, true , 0x001e, 0x003e, 0x000e, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x00a0, 0x00c0, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00be, 0x00de, 0x0008, (char)0x08, (char)0xf6}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02c0, 0x02e0, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x0c, true , 0x015f, 0x017f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0200, 0x0220, 0x1ff7, (char)0xf7, (char)0x06}, { 0x04, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x04, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, { 0x04, true , 0x01ff, 0x021e, 0x000d, (char)0x0d, (char)0xf8}, { 0x04, true , 0x001e, 0x003e, 0x000e, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x04, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, },
	{ { 0x0c, true , 0x02a1, 0x02c1, 0x0007, (char)0x07, (char)0x0d}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00be, 0x00de, 0x0008, (char)0x08, (char)0xf6}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, },
	{ { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, },
	{ { 0x0c, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x015f, 0x017f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x1c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, },
	{ { 0x1c, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0200, 0x0220, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, { 0x04, true , 0x01ff, 0x021e, 0x000d, (char)0x0d, (char)0xf8}, { 0x04, true , 0x001e, 0x003e, 0x000e, (char)0x0e, (char)0xf1}, },
	{ { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02a1, 0x02c1, 0x0007, (char)0x07, (char)0x0d}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00be, 0x00de, 0x0008, (char)0x08, (char)0xf6}, },
	{ { 0x0c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x015f, 0x017f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, },
	{ { 0x14, true , 0x023e, 0x025e, 0x000f, (char)0x0f, (char)0xf2}, { 0x1c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x0c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, },
	{ { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, { 0x04, true , 0x01ff, 0x021e, 0x000d, (char)0x0d, (char)0xf8}, },
	{ { 0x1c, true , 0x029e, 0x02be, 0x0009, (char)0x09, (char)0xf5}, { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, },
	{ { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf2, (char)0x0b}, { 0x14, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02a1, 0x02c1, 0x0007, (char)0x07, (char)0x0d}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02c0, 0x02e0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x0c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, },
	{ { 0x04, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x015f, 0x017f, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x023e, 0x025e, 0x000f, (char)0x0f, (char)0xf2}, { 0x1c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, },
	{ { 0x14, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x03de, 0x03fe, 0x000f, (char)0xf5, (char)0x0f}, },
	{ { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029e, 0x02be, 0x0009, (char)0x09, (char)0xf5}, { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf2, (char)0x0b}, { 0x14, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02a1, 0x02c1, 0x0007, (char)0x07, (char)0x0d}, },
	{ { 0x1c, true , 0x0161, 0x0181, 0x1ff6, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x0c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x14, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, },
	{ { 0x0c, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x023e, 0x025e, 0x000f, (char)0x0f, (char)0xf2}, { 0x1c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x0281, 0x02a1, 0x1ff5, (char)0xf5, (char)0x0c}, { 0x14, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x14, true , 0x021f, 0x023f, 0x000b, (char)0x0b, (char)0xf9}, { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029e, 0x02be, 0x0009, (char)0x09, (char)0xf5}, { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, },
	{ { 0x14, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf2, (char)0x0b}, { 0x14, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x019f, 0x01bf, 0x000c, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x1ff6, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x0c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, },
	{ { 0x1c, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x023e, 0x025e, 0x000f, (char)0x0f, (char)0xf2}, },
	{ { 0x14, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff5, (char)0xf5, (char)0x0c}, { 0x14, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x000b, (char)0x0b, (char)0xf9}, { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029e, 0x02be, 0x0009, (char)0x09, (char)0xf5}, },
	{ { 0x1c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf2, (char)0x0b}, },
	{ { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x019f, 0x01bf, 0x000c, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x1ff6, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x00a0, 0x00c0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x1c, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, },
	{ { 0x14, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff5, (char)0xf5, (char)0x0c}, { 0x14, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, },
	{ { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xf9, (char)0xf7}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x000b, (char)0x0b, (char)0xf9}, { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x01c1, 0x01e1, 0x1ff2, (char)0xf2, (char)0x0e}, { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, },
	{ { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x019f, 0x01bf, 0x000c, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x1ff6, (char)0xf6, (char)0x0b}, },
	{ { 0x0c, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, },
	{ { 0x14, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x1c, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff5, (char)0xf5, (char)0x0c}, },
	{ { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xf9, (char)0xf7}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x000b, (char)0x0b, (char)0xf9}, },
	{ { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff2, (char)0xf2, (char)0x0e}, { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x025e, 0x027e, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x14, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x019f, 0x01bf, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x14, true , 0x027f, 0x029f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x1c, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, },
	{ { 0x1c, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xf9, (char)0xf7}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x009e, 0x00be, 0x000e, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff2, (char)0xf2, (char)0x0e}, { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x0d, (char)0xf9}, },
	{ { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x027f, 0x029f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x00a0, 0x00c0, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x04, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x0c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xf9, (char)0xf7}, },
	{ { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x000e, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff2, (char)0xf2, (char)0x0e}, },
	{ { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x027f, 0x029f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, },
	{ { 0x1c, true , 0x0101, 0x0120, 0x1ff6, (char)0xf6, (char)0x08}, { 0x04, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x14, true , 0x021e, 0x023e, 0x000d, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x000e, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x00c0, 0x00e0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x019f, 0x01bf, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf6, (char)0x0e}, },
	{ { 0x14, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x027f, 0x029f, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0101, 0x0120, 0x1ff6, (char)0xf6, (char)0x08}, { 0x04, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021e, 0x023e, 0x000d, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x000e, (char)0x0e, (char)0xf5}, },
	{ { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, },
	{ { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, },
	{ { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0101, 0x0120, 0x1ff6, (char)0xf6, (char)0x08}, { 0x04, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021e, 0x023e, 0x000d, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, },
	{ { 0x1c, false, 0x001e, 0x003e, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x14, false, 0x0041, 0x0061, 0x17f2, (char)0x0c, (char)0xf2}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, },
	{ { 0x0c, true , 0x007e, 0x009e, 0x1ff8, (char)0xf8, (char)0xf4}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, },
	{ { 0x1c, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x04, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0101, 0x0120, 0x1ff6, (char)0xf6, (char)0x08}, },
	{ { 0x04, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021e, 0x023e, 0x000d, (char)0x0d, (char)0xf1}, },
	{ { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x001e, 0x003e, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0041, 0x0061, 0x17f2, (char)0x0c, (char)0xf2}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x007e, 0x009e, 0x1ff8, (char)0xf8, (char)0xf4}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, },
	{ { 0x0c, false, 0x007e, 0x009e, 0x0006, (char)0xf2, (char)0x06}, { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x09, (char)0xf0}, { 0x04, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0000, 0x0020, 0x1ff2, (char)0xf2, (char)0x06}, { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x001e, 0x003e, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, },
	{ { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0041, 0x0061, 0x17f2, (char)0x0c, (char)0xf2}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x04, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x007e, 0x009e, 0x1ff8, (char)0xf8, (char)0xf4}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, false, 0x00de, 0x00fd, 0x0007, (char)0xf0, (char)0x07}, { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x14, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x007e, 0x009e, 0x0006, (char)0xf2, (char)0x06}, { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, },
	{ { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, },
	{ { 0x04, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x09, (char)0xf0}, { 0x04, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x1ff2, (char)0xf2, (char)0x06}, { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x001e, 0x003e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x04, true , 0x005e, 0x007e, 0x000e, (char)0x0e, (char)0xf3}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0041, 0x0061, 0x17f2, (char)0x0c, (char)0xf2}, },
	{ { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0c, (char)0xf7}, { 0x04, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x007e, 0x009e, 0x1ff8, (char)0xf8, (char)0xf4}, },
	{ { 0x1c, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x00de, 0x00fd, 0x0007, (char)0xf0, (char)0x07}, { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, },
	{ { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x007e, 0x009e, 0x0006, (char)0xf2, (char)0x06}, { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf7, (char)0x06}, { 0x04, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x09, (char)0xf0}, { 0x04, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, },
	{ { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x1ff2, (char)0xf2, (char)0x06}, { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, },
	{ { 0x0c, true , 0x02fe, 0x001d, 0x000c, (char)0x0c, (char)0xf0}, { 0x04, true , 0x005e, 0x007e, 0x000e, (char)0x0e, (char)0xf3}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0c, (char)0xf7}, { 0x04, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x00de, 0x00fd, 0x0007, (char)0xf0, (char)0x07}, { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, },
	{ { 0x14, true , 0x00a0, 0x00c0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x007e, 0x009e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x04, true , 0x0161, 0x0181, 0x1ff0, (char)0xf0, (char)0x0b}, { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf7, (char)0x06}, { 0x04, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x09, (char)0xf0}, },
	{ { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x04, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x02fe, 0x001d, 0x000c, (char)0x0c, (char)0xf0}, { 0x04, true , 0x005e, 0x007e, 0x000e, (char)0x0e, (char)0xf3}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0c, (char)0xf7}, { 0x04, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, },
	{ { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x00de, 0x00fd, 0x0007, (char)0xf0, (char)0x07}, },
	{ { 0x14, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, { 0x14, true , 0x00a0, 0x00c0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x0161, 0x0181, 0x1ff0, (char)0xf0, (char)0x0b}, { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf7, (char)0x06}, { 0x04, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, },
	{ { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x1c, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x02fe, 0x001d, 0x000c, (char)0x0c, (char)0xf0}, { 0x04, true , 0x005e, 0x007e, 0x000e, (char)0x0e, (char)0xf3}, },
	{ { 0x14, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0c, (char)0xf7}, },
	{ { 0x0c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x14, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, { 0x14, true , 0x00a0, 0x00c0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x0161, 0x0181, 0x1ff0, (char)0xf0, (char)0x0b}, { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, },
	{ { 0x04, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x04, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x02fe, 0x001d, 0x000c, (char)0x0c, (char)0xf0}, },
	{ { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, },
	{ { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, { 0x14, true , 0x00a0, 0x00c0, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x0161, 0x0181, 0x1ff0, (char)0xf0, (char)0x0b}, },
	{ { 0x14, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, { 0x04, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, },
	{ { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x02c1, 0x02e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x1c, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, },
	{ { 0x14, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0281, 0x02a1, 0x17f4, (char)0x0f, (char)0xf4}, },
	{ { 0x04, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, },
	{ { 0x04, true , 0x0080, 0x00a0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, { 0x04, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, },
	{ { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, },
	{ { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x025f, 0x027f, 0x0009, (char)0x09, (char)0xfa}, { 0x14, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0080, 0x00a0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, { 0x04, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, },
	{ { 0x04, true , 0x02df, 0x02ff, 0x000d, (char)0x0d, (char)0xfa}, { 0x04, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x14, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0d, (char)0xf6}, },
	{ { 0x0c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025f, 0x027f, 0x0009, (char)0x09, (char)0xfa}, { 0x14, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0080, 0x00a0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x14, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, },
	{ { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02df, 0x02ff, 0x000d, (char)0x0d, (char)0xfa}, { 0x04, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x1c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, },
	{ { 0x1c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x011f, 0x013e, 0x17f9, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025f, 0x027f, 0x0009, (char)0x09, (char)0xfa}, { 0x14, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x0240, 0x0260, 0x1ff1, (char)0xf1, (char)0x06}, { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x14, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0080, 0x00a0, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x0141, 0x0161, 0x1ff4, (char)0xf4, (char)0x0a}, { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02df, 0x02ff, 0x000d, (char)0x0d, (char)0xfa}, { 0x04, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x04, false, 0x029f, 0x02bf, 0x17f5, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x04, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x011f, 0x013e, 0x17f9, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025f, 0x027f, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x0c, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0240, 0x0260, 0x1ff1, (char)0xf1, (char)0x06}, { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0141, 0x0161, 0x1ff4, (char)0xf4, (char)0x0a}, { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02df, 0x02ff, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x14, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x029f, 0x02bf, 0x17f5, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, },
	{ { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, true , 0x0201, 0x0220, 0x0007, (char)0x07, (char)0x08}, { 0x04, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x011f, 0x013e, 0x17f9, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0240, 0x0260, 0x1ff1, (char)0xf1, (char)0x06}, { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x0061, 0x0081, 0x17f3, (char)0x0e, (char)0xf3}, { 0x14, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x1c, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0141, 0x0161, 0x1ff4, (char)0xf4, (char)0x0a}, { 0x1c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x017f, 0x019f, 0x0008, (char)0x08, (char)0xfa}, { 0x14, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x029f, 0x02bf, 0x17f5, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x14, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0201, 0x0220, 0x0007, (char)0x07, (char)0x08}, { 0x04, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x011f, 0x013e, 0x17f9, (char)0xf8, (char)0xf9}, },
	{ { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x1c, true , 0x0240, 0x0260, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x0c, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0061, 0x0081, 0x17f3, (char)0x0e, (char)0xf3}, { 0x14, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x1c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0141, 0x0161, 0x1ff4, (char)0xf4, (char)0x0a}, },
	{ { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x017f, 0x019f, 0x0008, (char)0x08, (char)0xfa}, { 0x14, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x029f, 0x02bf, 0x17f5, (char)0xf9, (char)0xf5}, },
	{ { 0x04, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0201, 0x0220, 0x0007, (char)0x07, (char)0x08}, { 0x04, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x14, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02a0, 0x02c0, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x04, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0061, 0x0081, 0x17f3, (char)0x0e, (char)0xf3}, { 0x14, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x0c, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x017f, 0x019f, 0x0008, (char)0x08, (char)0xfa}, { 0x14, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0201, 0x0220, 0x0007, (char)0x07, (char)0x08}, },
	{ { 0x04, false, 0x007e, 0x009e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x04, true , 0x00ff, 0x011e, 0x0008, (char)0x08, (char)0xf8}, { 0x04, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0061, 0x0081, 0x17f3, (char)0x0e, (char)0xf3}, },
	{ { 0x0c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x017f, 0x019f, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, },
	{ { 0x04, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x007e, 0x009e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00ff, 0x011e, 0x0008, (char)0x08, (char)0xf8}, { 0x04, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, },
	{ { 0x04, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, },
	{ { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x007e, 0x009e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00ff, 0x011e, 0x0008, (char)0x08, (char)0xf8}, { 0x04, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x04, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x003e, 0x005e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, },
	{ { 0x1c, false, 0x0041, 0x0061, 0x17f2, (char)0x0c, (char)0xf2}, { 0x1c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x1c, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, { 0x14, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x1c, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x007e, 0x009e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00ff, 0x011e, 0x0008, (char)0x08, (char)0xf8}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x1ff4, (char)0xf4, (char)0x06}, { 0x04, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0041, 0x0061, 0x17f2, (char)0x0c, (char)0xf2}, { 0x1c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, { 0x14, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x04, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x1ff4, (char)0xf4, (char)0x06}, { 0x04, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x04, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, },
	{ { 0x0c, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0041, 0x0061, 0x17f2, (char)0x0c, (char)0xf2}, { 0x1c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, { 0x14, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, },
	{ { 0x14, true , 0x01e1, 0x0201, 0x1ff0, (char)0xf0, (char)0x0f}, { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x1ff3, (char)0xf3, (char)0x0f}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x1ff4, (char)0xf4, (char)0x06}, { 0x04, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, },
	{ { 0x04, false, 0x03e0, 0x0000, 0x000f, (char)0x07, (char)0x0f}, { 0x04, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0e, (char)0xf1}, },
	{ { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0041, 0x0061, 0x17f2, (char)0x0c, (char)0xf2}, },
	{ { 0x0c, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0081, 0x00a0, 0x17f4, (char)0x08, (char)0xf4}, },
	{ { 0x1c, true , 0x021f, 0x023f, 0x000f, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, },
	{ { 0x1c, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x01e1, 0x0201, 0x1ff0, (char)0xf0, (char)0x0f}, { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x1ff3, (char)0xf3, (char)0x0f}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x04, false, 0x03e0, 0x0000, 0x000f, (char)0x07, (char)0x0f}, { 0x04, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, },
	{ { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf3, (char)0x0f}, { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021f, 0x023f, 0x000f, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x01e1, 0x0201, 0x1ff0, (char)0xf0, (char)0x0f}, { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0f, (char)0xf5}, { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, true , 0x013f, 0x015f, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x1ff3, (char)0xf3, (char)0x0f}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x04, false, 0x03e0, 0x0000, 0x000f, (char)0x07, (char)0x0f}, { 0x04, true , 0x02fe, 0x001d, 0x000a, (char)0x0a, (char)0xf0}, },
	{ { 0x1c, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf3, (char)0x0f}, { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf5, (char)0x06}, { 0x14, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, },
	{ { 0x14, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021f, 0x023f, 0x000f, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x01e1, 0x0201, 0x1ff0, (char)0xf0, (char)0x0f}, },
	{ { 0x14, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0f, (char)0xf5}, { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x1ff3, (char)0xf3, (char)0x0f}, },
	{ { 0x14, true , 0x013f, 0x015f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x04, false, 0x03e0, 0x0000, 0x000f, (char)0x07, (char)0x0f}, },
	{ { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf3, (char)0x0f}, { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x14, false, 0x013e, 0x015e, 0x000a, (char)0xf2, (char)0x0a}, { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf5, (char)0x06}, { 0x14, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x04, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021f, 0x023f, 0x000f, (char)0x0f, (char)0xf9}, },
	{ { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, },
	{ { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0f, (char)0xf5}, { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x013f, 0x015f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf3, (char)0x0f}, },
	{ { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013e, 0x015e, 0x000a, (char)0xf2, (char)0x0a}, { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf5, (char)0x06}, { 0x14, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, },
	{ { 0x14, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x03bf, 0x03df, 0x17fa, (char)0xf9, (char)0xfa}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x0f, (char)0xf5}, },
	{ { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x000e, (char)0x0e, (char)0xfa}, },
	{ { 0x14, true , 0x0221, 0x0241, 0x0007, (char)0x07, (char)0x09}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x013f, 0x015f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013e, 0x015e, 0x000a, (char)0xf2, (char)0x0a}, { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x1c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x01ff, 0x021e, 0x0009, (char)0x09, (char)0xf8}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x1c, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x03bf, 0x03df, 0x17fa, (char)0xf9, (char)0xfa}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf6, (char)0x06}, { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0221, 0x0241, 0x0007, (char)0x07, (char)0x09}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x013f, 0x015f, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x0c, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013e, 0x015e, 0x000a, (char)0xf2, (char)0x0a}, },
	{ { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, { 0x04, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x0009, (char)0x09, (char)0xf8}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x04, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x03bf, 0x03df, 0x17fa, (char)0xf9, (char)0xfa}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf6, (char)0x06}, { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, },
	{ { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0221, 0x0241, 0x0007, (char)0x07, (char)0x09}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, },
	{ { 0x04, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x00e0, 0x0100, 0x1ff6, (char)0xf6, (char)0x07}, },
	{ { 0x14, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, { 0x04, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x0009, (char)0x09, (char)0xf8}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x0c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x03bf, 0x03df, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x14, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf6, (char)0x06}, { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0221, 0x0241, 0x0007, (char)0x07, (char)0x09}, },
	{ { 0x04, true , 0x00de, 0x00fe, 0x1ff8, (char)0xf8, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x04, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, { 0x04, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x01ff, 0x021e, 0x0009, (char)0x09, (char)0xf8}, },
	{ { 0x04, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x0c, true , 0x00de, 0x00fe, 0x000e, (char)0x0e, (char)0xf7}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x00de, 0x00fe, 0x1ff8, (char)0xf8, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, },
	{ { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf7, (char)0x08}, { 0x04, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, { 0x04, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x04, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x00de, 0x00fe, 0x000e, (char)0x0e, (char)0xf7}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x1c, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x00de, 0x00fe, 0x1ff8, (char)0xf8, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x009e, 0x00bd, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x14, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf7, (char)0x08}, { 0x04, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, },
	{ { 0x04, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, { 0x04, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x04, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x00de, 0x00fe, 0x000e, (char)0x0e, (char)0xf7}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x00de, 0x00fe, 0x1ff8, (char)0xf8, (char)0xf7}, },
	{ { 0x14, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x009e, 0x00bd, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, { 0x14, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf7, (char)0x08}, { 0x04, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, { 0x04, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, },
	{ { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, },
	{ { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x00de, 0x00fe, 0x000e, (char)0x0e, (char)0xf7}, },
	{ { 0x14, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x009e, 0x00bd, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x14, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, },
	{ { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf7, (char)0x08}, },
	{ { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, { 0x04, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, },
	{ { 0x04, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, { 0x14, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, },
	{ { 0x0c, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x009e, 0x00bd, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, },
	{ { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf3, (char)0x06}, { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, },
	{ { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, },
	{ { 0x0c, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, { 0x04, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, { 0x14, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, },
	{ { 0x04, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf3, (char)0x06}, { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, { 0x04, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, { 0x14, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, },
	{ { 0x04, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf3, (char)0x06}, { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, },
	{ { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, { 0x04, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, },
	{ { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, },
	{ { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, true , 0x00e0, 0x0100, 0x1ff0, (char)0xf0, (char)0x07}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, },
	{ { 0x04, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, },
	{ { 0x04, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x007e, 0x009d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, { 0x04, true , 0x00e0, 0x0100, 0x1ff0, (char)0xf0, (char)0x07}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, },
	{ { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, },
	{ { 0x14, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, { 0x04, true , 0x00e0, 0x0100, 0x1ff0, (char)0xf0, (char)0x07}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, },
	{ { 0x04, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0101, 0x0121, 0x17f8, (char)0x0a, (char)0xf8}, { 0x04, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, { 0x04, true , 0x00e0, 0x0100, 0x1ff0, (char)0xf0, (char)0x07}, },
	{ { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, },
	{ { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0101, 0x0121, 0x17f8, (char)0x0a, (char)0xf8}, { 0x04, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, },
	{ { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, },
	{ { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, },
	{ { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, },
	{ { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0101, 0x0121, 0x17f8, (char)0x0a, (char)0xf8}, { 0x04, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x01df, 0x01ff, 0x000c, (char)0x0c, (char)0xfa}, { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x0c, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x14, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0101, 0x0121, 0x17f8, (char)0x0a, (char)0xf8}, },
	{ { 0x1c, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01df, 0x01ff, 0x000c, (char)0x0c, (char)0xfa}, { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, },
	{ { 0x1c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, },
	{ { 0x1c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01df, 0x01ff, 0x000c, (char)0x0c, (char)0xfa}, { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x1c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01df, 0x01ff, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02df, 0x02ff, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, },
	{ { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x14, false, 0x02bf, 0x02df, 0x17f6, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0b, (char)0xf3}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x14, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x021f, 0x023f, 0x0009, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x02bf, 0x02df, 0x17f6, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x04, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0b, (char)0xf3}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x021f, 0x023f, 0x0009, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x02bf, 0x02df, 0x17f6, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x1c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0b, (char)0xf3}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x04, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x021f, 0x023f, 0x0009, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x14, true , 0x01bf, 0x01df, 0x000e, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, { 0x14, false, 0x02bf, 0x02df, 0x17f6, (char)0xf9, (char)0xf6}, },
	{ { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, },
	{ { 0x1c, true , 0x02e0, 0x0000, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0b, (char)0xf3}, },
	{ { 0x14, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x0c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x1c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x021f, 0x023f, 0x0009, (char)0x09, (char)0xf9}, },
	{ { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x07, (char)0x0b}, { 0x14, true , 0x01bf, 0x01df, 0x000e, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x025e, 0x027e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02e0, 0x0000, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, },
	{ { 0x1c, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf6, (char)0x09}, { 0x0c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x07, (char)0x0b}, { 0x14, true , 0x01bf, 0x01df, 0x000e, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x14, true , 0x02be, 0x02de, 0x0009, (char)0x09, (char)0xf6}, { 0x0c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02e0, 0x0000, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, },
	{ { 0x14, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf6, (char)0x09}, { 0x0c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x0c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, },
	{ { 0x14, true , 0x02be, 0x02de, 0x000d, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x07, (char)0x0b}, { 0x14, true , 0x01bf, 0x01df, 0x000e, (char)0x0e, (char)0xfa}, },
	{ { 0x0c, true , 0x019f, 0x01bf, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x0009, (char)0x09, (char)0xf6}, { 0x0c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02e0, 0x0000, 0x0007, (char)0x07, (char)0x07}, },
	{ { 0x0c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf6, (char)0x09}, { 0x0c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x02be, 0x02de, 0x000d, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x07, (char)0x0b}, },
	{ { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x0009, (char)0x09, (char)0xf6}, { 0x0c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, },
	{ { 0x04, true , 0x0181, 0x01a1, 0x1ff6, (char)0xf6, (char)0x0c}, { 0x14, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf6, (char)0x09}, },
	{ { 0x04, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x02be, 0x02de, 0x000d, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, },
	{ { 0x14, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x0009, (char)0x09, (char)0xf6}, },
	{ { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, },
	{ { 0x1c, false, 0x007e, 0x009e, 0x0006, (char)0xf2, (char)0x06}, { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0241, 0x0261, 0x1ff5, (char)0xf5, (char)0x0a}, },
	{ { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0181, 0x01a1, 0x1ff6, (char)0xf6, (char)0x0c}, { 0x14, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, },
	{ { 0x04, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, },
	{ { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x02be, 0x02de, 0x000d, (char)0x0d, (char)0xf6}, },
	{ { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x04, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, { 0x14, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, },
	{ { 0x0c, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, },
	{ { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x007e, 0x009e, 0x0006, (char)0xf2, (char)0x06}, { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, },
	{ { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0181, 0x01a1, 0x1ff6, (char)0xf6, (char)0x0c}, { 0x14, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x04, true , 0x0101, 0x0120, 0x1ff4, (char)0xf4, (char)0x08}, { 0x04, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, },
	{ { 0x04, true , 0x021e, 0x023e, 0x0009, (char)0x09, (char)0xf1}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, },
	{ { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, { 0x14, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x04, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, },
	{ { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x007e, 0x009e, 0x0006, (char)0xf2, (char)0x06}, { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0181, 0x01a1, 0x1ff6, (char)0xf6, (char)0x0c}, },
	{ { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x1ff4, (char)0xf4, (char)0x08}, { 0x04, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x021e, 0x023e, 0x0009, (char)0x09, (char)0xf1}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, },
	{ { 0x0c, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, { 0x14, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, },
	{ { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, },
	{ { 0x14, false, 0x01be, 0x01dd, 0x000e, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x007e, 0x009e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x1ff4, (char)0xf4, (char)0x08}, { 0x04, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, },
	{ { 0x04, true , 0x0200, 0x0220, 0x0007, (char)0x07, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x021e, 0x023e, 0x0009, (char)0x09, (char)0xf1}, { 0x0c, false, 0x001e, 0x003e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x04, false, 0x0021, 0x0041, 0x17f1, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x003e, 0x005e, 0x000c, (char)0x0c, (char)0xf2}, { 0x1c, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, },
	{ { 0x1c, true , 0x009e, 0x00be, 0x0008, (char)0x08, (char)0xf5}, { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x011e, 0x013d, 0x0009, (char)0xf0, (char)0x09}, },
	{ { 0x1c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x01be, 0x01dd, 0x000e, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x1ff4, (char)0xf4, (char)0x08}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, { 0x04, true , 0x0200, 0x0220, 0x0007, (char)0x07, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x021e, 0x023e, 0x0009, (char)0x09, (char)0xf1}, },
	{ { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0021, 0x0041, 0x17f1, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x02c1, 0x02e1, 0x0007, (char)0x07, (char)0x0e}, { 0x0c, true , 0x003e, 0x005e, 0x000c, (char)0x0c, (char)0xf2}, { 0x1c, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x009e, 0x00be, 0x0008, (char)0x08, (char)0xf5}, { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x01be, 0x01dd, 0x000e, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, },
	{ { 0x1c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, { 0x04, true , 0x0200, 0x0220, 0x0007, (char)0x07, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0021, 0x0041, 0x17f1, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, },
	{ { 0x1c, true , 0x0020, 0x0040, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02c1, 0x02e1, 0x0007, (char)0x07, (char)0x0e}, { 0x0c, true , 0x003e, 0x005e, 0x000c, (char)0x0c, (char)0xf2}, { 0x1c, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, },
	{ { 0x14, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x009e, 0x00be, 0x0008, (char)0x08, (char)0xf5}, { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x01be, 0x01dd, 0x000e, (char)0xf0, (char)0x0e}, },
	{ { 0x14, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf1, (char)0x0c}, },
	{ { 0x04, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, },
	{ { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, { 0x04, true , 0x0200, 0x0220, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0021, 0x0041, 0x17f1, (char)0x0e, (char)0xf1}, },
	{ { 0x04, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x0020, 0x0040, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02c1, 0x02e1, 0x0007, (char)0x07, (char)0x0e}, { 0x0c, true , 0x003e, 0x005e, 0x000c, (char)0x0c, (char)0xf2}, },
	{ { 0x0c, false, 0x0161, 0x0181, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x009e, 0x00be, 0x0008, (char)0x08, (char)0xf5}, },
	{ { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x14, false, 0x0181, 0x01a1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, },
	{ { 0x0c, false, 0x02fe, 0x031e, 0x0008, (char)0xf5, (char)0x08}, { 0x04, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, },
	{ { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, },
	{ { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x0020, 0x0040, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x02c1, 0x02e1, 0x0007, (char)0x07, (char)0x0e}, },
	{ { 0x0c, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0161, 0x0181, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x1c, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x14, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0181, 0x01a1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x04, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x02fe, 0x031e, 0x0008, (char)0xf5, (char)0x08}, { 0x04, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, },
	{ { 0x04, false, 0x025e, 0x027e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x0020, 0x0040, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0161, 0x0181, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, },
	{ { 0x0c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x14, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0181, 0x01a1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x14, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, },
	{ { 0x04, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, { 0x04, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x02fe, 0x031e, 0x0008, (char)0xf5, (char)0x08}, { 0x04, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, { 0x04, false, 0x025e, 0x027e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x029e, 0x02be, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, },
	{ { 0x04, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0161, 0x0181, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x0c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0181, 0x01a1, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, { 0x04, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x02fe, 0x031e, 0x0008, (char)0xf5, (char)0x08}, },
	{ { 0x04, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, { 0x04, false, 0x025e, 0x027e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0021, 0x0040, 0x17f1, (char)0x08, (char)0xf1}, },
	{ { 0x04, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, { 0x04, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, },
	{ { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, { 0x04, false, 0x025e, 0x027e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x14, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, },
	{ { 0x1c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, },
	{ { 0x04, true , 0x00a0, 0x00c0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xf9, (char)0xf0}, },
	{ { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, },
	{ { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0281, 0x02a1, 0x17f4, (char)0x0b, (char)0xf4}, { 0x14, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x14, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, { 0x04, true , 0x00a0, 0x00c0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, },
	{ { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, },
	{ { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x14, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0281, 0x02a1, 0x17f4, (char)0x0b, (char)0xf4}, { 0x14, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, },
	{ { 0x04, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, { 0x04, true , 0x00a0, 0x00c0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, },
	{ { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0281, 0x02a1, 0x17f4, (char)0x0b, (char)0xf4}, { 0x14, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x0c, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, { 0x04, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, { 0x04, true , 0x00a0, 0x00c0, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, { 0x04, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0281, 0x02a1, 0x17f4, (char)0x0b, (char)0xf4}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, { 0x04, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, { 0x14, false, 0x0201, 0x0221, 0x17f0, (char)0x0d, (char)0xf0}, },
	{ { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, },
	{ { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x03fe, 0x001e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x04, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, },
	{ { 0x04, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x09, (char)0xf0}, { 0x04, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, { 0x04, false, 0x005e, 0x007d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x04, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x09, (char)0xf0}, { 0x04, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0201, 0x0221, 0x17f0, (char)0x0b, (char)0xf0}, },
	{ { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, },
	{ { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, },
	{ { 0x04, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x09, (char)0xf0}, { 0x04, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x09, (char)0xf0}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, },
	{ { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x0c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, },
	{ { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, },
	{ { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, },
	{ { 0x1c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x1c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x0141, 0x0161, 0x1ff2, (char)0xf2, (char)0x0a}, { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02df, 0x02ff, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x0c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0141, 0x0161, 0x1ff2, (char)0xf2, (char)0x0a}, { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, },
	{ { 0x14, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x14, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x14, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xf9, (char)0xf5}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0141, 0x0161, 0x1ff2, (char)0xf2, (char)0x0a}, { 0x1c, false, 0x03bf, 0x03df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x027f, 0x029f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x14, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xf9, (char)0xf5}, },
	{ { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0141, 0x0161, 0x1ff2, (char)0xf2, (char)0x0a}, },
	{ { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x04, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x013f, 0x015f, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x00ff, 0x011e, 0x0008, (char)0x08, (char)0xf8}, { 0x04, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x04, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00ff, 0x011e, 0x0008, (char)0x08, (char)0xf8}, { 0x04, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, },
	{ { 0x04, true , 0x011f, 0x013f, 0x1ff8, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, },
	{ { 0x04, false, 0x03bf, 0x03df, 0x17fa, (char)0xf9, (char)0xfa}, { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00ff, 0x011e, 0x0008, (char)0x08, (char)0xf8}, { 0x04, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x011f, 0x013f, 0x1ff8, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x1c, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, false, 0x01de, 0x01fd, 0x000f, (char)0xf0, (char)0x0f}, { 0x04, false, 0x03bf, 0x03df, 0x17fa, (char)0xf9, (char)0xfa}, { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x14, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00ff, 0x011e, 0x0008, (char)0x08, (char)0xf8}, },
	{ { 0x04, true , 0x0201, 0x0220, 0x1ff7, (char)0xf7, (char)0x08}, { 0x04, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x011f, 0x013f, 0x1ff8, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x021e, 0x023e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x003e, 0x005e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x0c, true , 0x003e, 0x005e, 0x000e, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, },
	{ { 0x1c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x01de, 0x01fd, 0x000f, (char)0xf0, (char)0x0f}, { 0x04, false, 0x03bf, 0x03df, 0x17fa, (char)0xf9, (char)0xfa}, { 0x0c, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, { 0x04, true , 0x0201, 0x0220, 0x1ff7, (char)0xf7, (char)0x08}, { 0x04, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, { 0x04, true , 0x011f, 0x013f, 0x1ff8, (char)0xf8, (char)0xf9}, },
	{ { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x003e, 0x005e, 0x000e, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x01de, 0x01fd, 0x000f, (char)0xf0, (char)0x0f}, { 0x04, false, 0x03bf, 0x03df, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x14, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, { 0x0c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, },
	{ { 0x04, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, { 0x04, true , 0x0201, 0x0220, 0x1ff7, (char)0xf7, (char)0x08}, { 0x04, true , 0x01fe, 0x021d, 0x000f, (char)0x0f, (char)0xf0}, },
	{ { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x04, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x003e, 0x005e, 0x000e, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x005e, 0x007e, 0x000c, (char)0x0c, (char)0xf3}, },
	{ { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x00de, 0x00fe, 0x0008, (char)0x08, (char)0xf7}, },
	{ { 0x14, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x01de, 0x01fd, 0x000f, (char)0xf0, (char)0x0f}, },
	{ { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x03be, 0x03de, 0x000e, (char)0xf1, (char)0x0e}, },
	{ { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, { 0x04, false, 0x037e, 0x039e, 0x000c, (char)0xf3, (char)0x0c}, },
	{ { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, { 0x04, true , 0x0201, 0x0220, 0x1ff7, (char)0xf7, (char)0x08}, },
	{ { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0f, (char)0xf1}, },
	{ { 0x04, true , 0x02fe, 0x001d, 0x000c, (char)0x0c, (char)0xf0}, { 0x04, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x003e, 0x005e, 0x000e, (char)0x0e, (char)0xf2}, },
	{ { 0x0c, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0c, (char)0xf5}, },
	{ { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x04, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, },
	{ { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x000c, (char)0x0c, (char)0xf0}, { 0x04, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, },
	{ { 0x0c, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x013e, 0x015d, 0x000a, (char)0xf0, (char)0x0a}, },
	{ { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00fe, 0x011e, 0x0008, (char)0xf2, (char)0x08}, },
	{ { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, { 0x04, true , 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x000c, (char)0x0c, (char)0xf0}, { 0x04, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, },
	{ { 0x04, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, { 0x04, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c1, 0x00e0, 0x17f6, (char)0x08, (char)0xf6}, },
	{ { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, { 0x14, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, },
	{ { 0x04, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x000c, (char)0x0c, (char)0xf0}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, { 0x04, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, },
	{ { 0x04, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x017e, 0x019d, 0x000c, (char)0xf0, (char)0x0c}, },
	{ { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf1, (char)0x08}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, { 0x04, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, },
	{ { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, { 0x04, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0041, 0x0060, 0x17f2, (char)0x08, (char)0xf2}, },
	{ { 0x0c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, { 0x04, false, 0x01fe, 0x021e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x02fe, 0x001d, 0x0008, (char)0x08, (char)0xf0}, },
	{ { 0x1c, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, { 0x04, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, { 0x0c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x009e, 0x00bd, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00fe, 0x011d, 0x0008, (char)0xf0, (char)0x08}, },
	{ { 0x04, true , 0x0141, 0x0161, 0x1ff0, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, { 0x04, true , 0x001e, 0x003e, 0x0008, (char)0x08, (char)0xf1}, },
	{ { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x0c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0a, (char)0xf8}, { 0x04, false, 0x009e, 0x00bd, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x1ff0, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x1ff1, (char)0xf1, (char)0x0f}, },
	{ { 0x14, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, },
	{ { 0x14, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x14, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0a, (char)0xf8}, { 0x04, false, 0x009e, 0x00bd, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0f, (char)0xf8}, },
	{ { 0x04, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x1ff0, (char)0xf0, (char)0x0a}, { 0x1c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x02fe, 0x001d, 0x1ff8, (char)0xf8, (char)0xf0}, },
	{ { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0040, 0x0060, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0a, (char)0xf8}, { 0x04, false, 0x009e, 0x00bd, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x1ff0, (char)0xf0, (char)0x0a}, },
	{ { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x0c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0a, (char)0xf8}, },
	{ { 0x04, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, },
	{ { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x14, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, { 0x04, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00be, 0x00dd, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x04, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0181, 0x01a1, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, { 0x04, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0301, 0x0321, 0x17f8, (char)0x09, (char)0xf8}, },
	{ { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x03ff, 0x001f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, },
	{ { 0x04, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, { 0x04, false, 0x001e, 0x003d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x003e, 0x005d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x1c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0101, 0x0120, 0x17f8, (char)0x08, (char)0xf8}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x03ff, 0x001e, 0x17f0, (char)0xf8, (char)0xf0}, },
	{ { 0x04, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, },
	{ { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, { 0x04, false, 0x0201, 0x0221, 0x17f0, (char)0x0f, (char)0xf0}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0021, 0x17f0, (char)0x0e, (char)0xf0}, },
	{ { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, },
	{ { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, },
	{ { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0a, (char)0xf0}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, },
	{ { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0300, 0x0320, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0021, 0x17f0, (char)0x0c, (char)0xf0}, },
	{ { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, },
	{ { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, { 0x04, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, { 0x04, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, { 0x04, false, 0x0001, 0x0020, 0x17f0, (char)0x08, (char)0xf0}, },
	{ { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x03fe, 0x001d, 0x0006, (char)0xf0, (char)0x06}, },
	{ { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, { 0x04, true , 0x0000, 0x0020, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, { 0x04, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02e1, 0x0001, 0x0007, (char)0x07, (char)0x0f}, },
	{ { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x02df, 0x02ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x1c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013f, 0x015f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00bf, 0x00df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, },
	{ { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, { 0x0c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x00be, 0x00de, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, },
	{ { 0x1c, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021f, 0x023f, 0x1ff9, (char)0xf9, (char)0xf9}, },
	{ { 0x1c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x04, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x011e, 0x013e, 0x0009, (char)0xf6, (char)0x09}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, },
	{ { 0x14, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x09, (char)0xf6}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, },
	{ { 0x0c, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, { 0x04, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x011e, 0x013e, 0x0009, (char)0xf6, (char)0x09}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, },
	{ { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x019f, 0x01bf, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, { 0x0c, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x09, (char)0xf6}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf5, (char)0x0a}, { 0x1c, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, { 0x04, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x011f, 0x013f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x04, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x011e, 0x013e, 0x0009, (char)0xf6, (char)0x09}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x1ff9, (char)0xf9, (char)0xf6}, },
	{ { 0x0c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x09, (char)0xf6}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf2, (char)0x0d}, },
	{ { 0x1c, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf5, (char)0x0a}, },
	{ { 0x14, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, { 0x04, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, },
	{ { 0x04, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x011e, 0x013e, 0x0009, (char)0xf6, (char)0x09}, },
	{ { 0x04, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, },
	{ { 0x0c, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, },
	{ { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x07, (char)0x0b}, { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x0008, (char)0x08, (char)0xfa}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf4, (char)0x0b}, },
	{ { 0x14, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x09, (char)0xf6}, },
	{ { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, },
	{ { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, },
	{ { 0x1c, true , 0x02de, 0x02fe, 0x000b, (char)0x0b, (char)0xf7}, { 0x04, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, },
	{ { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x005e, 0x007e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x14, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, },
	{ { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x07, (char)0x0b}, { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, },
	{ { 0x14, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, },
	{ { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x000b, (char)0x0b, (char)0xf7}, { 0x04, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021e, 0x023e, 0x000b, (char)0x0b, (char)0xf1}, },
	{ { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x07, (char)0x0b}, { 0x14, true , 0x00be, 0x00de, 0x000c, (char)0x0c, (char)0xf6}, },
	{ { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, },
	{ { 0x14, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x000b, (char)0x0b, (char)0xf7}, { 0x04, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, },
	{ { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x029f, 0x02bf, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0360, 0x0380, 0x000b, (char)0x07, (char)0x0b}, },
	{ { 0x14, true , 0x02be, 0x02de, 0x000d, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, },
	{ { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025f, 0x027f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02de, 0x02fe, 0x000b, (char)0x0b, (char)0xf7}, },
	{ { 0x0c, true , 0x0181, 0x01a1, 0x1ff6, (char)0xf6, (char)0x0c}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, },
	{ { 0x14, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029f, 0x02bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x0080, 0x00a0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x02be, 0x02de, 0x000d, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf7, (char)0x0b}, },
	{ { 0x14, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, },
	{ { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x019f, 0x01bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0181, 0x01a1, 0x1ff6, (char)0xf6, (char)0x0c}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, },
	{ { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xf9, (char)0xf3}, { 0x14, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, },
	{ { 0x0c, true , 0x00c0, 0x00e0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0080, 0x00a0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x02be, 0x02de, 0x000d, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, },
	{ { 0x0c, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, },
	{ { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, },
	{ { 0x04, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0181, 0x01a1, 0x1ff6, (char)0xf6, (char)0x0c}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xf9, (char)0xf3}, { 0x14, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x029e, 0x02be, 0x000b, (char)0x0b, (char)0xf5}, },
	{ { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x00c0, 0x00e0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, { 0x1c, false, 0x015e, 0x017e, 0x000b, (char)0xf6, (char)0x0b}, },
	{ { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0080, 0x00a0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x02be, 0x02de, 0x000d, (char)0x0d, (char)0xf6}, },
	{ { 0x0c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x0220, 0x0240, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, },
	{ { 0x14, true , 0x005e, 0x007e, 0x000e, (char)0x0e, (char)0xf3}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, },
	{ { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0181, 0x01a1, 0x1ff6, (char)0xf6, (char)0x0c}, },
	{ { 0x1c, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xf9, (char)0xf3}, { 0x14, false, 0x031f, 0x033f, 0x17f9, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x00c0, 0x00e0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0241, 0x0261, 0x17f2, (char)0x0b, (char)0xf2}, },
	{ { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0080, 0x00a0, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, },
	{ { 0x04, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0220, 0x0240, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xf9, (char)0xf2}, },
	{ { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x005e, 0x007e, 0x000e, (char)0x0e, (char)0xf3}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x1c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xf9, (char)0xf3}, },
	{ { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x00c0, 0x00e0, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x00fe, 0x011e, 0x0008, (char)0xf6, (char)0x08}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x14, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, { 0x04, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0220, 0x0240, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x0c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x005e, 0x007e, 0x000e, (char)0x0e, (char)0xf3}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x0040, 0x0060, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x14, true , 0x009e, 0x00be, 0x0008, (char)0x08, (char)0xf5}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x14, true , 0x02c0, 0x02e0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00fe, 0x011e, 0x0008, (char)0xf6, (char)0x08}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, { 0x04, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0220, 0x0240, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x04, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x005e, 0x007e, 0x000e, (char)0x0e, (char)0xf3}, },
	{ { 0x0c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0040, 0x0060, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x0008, (char)0x08, (char)0xf5}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x0c, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, },
	{ { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00fe, 0x011e, 0x0008, (char)0xf6, (char)0x08}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, { 0x04, true , 0x019f, 0x01bf, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x0000, 0x0020, 0x1ff6, (char)0xf6, (char)0x06}, { 0x04, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x14, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0040, 0x0060, 0x1ff4, (char)0xf4, (char)0x06}, { 0x1c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, },
	{ { 0x0c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x0008, (char)0x08, (char)0xf5}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00fe, 0x011e, 0x0008, (char)0xf6, (char)0x08}, },
	{ { 0x04, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, },
	{ { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0000, 0x0020, 0x1ff6, (char)0xf6, (char)0x06}, { 0x04, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0040, 0x0060, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x0008, (char)0x08, (char)0xf5}, },
	{ { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, },
	{ { 0x14, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x02c0, 0x02e0, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x0c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x01e1, 0x0201, 0x1ff6, (char)0xf6, (char)0x0f}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, },
	{ { 0x14, true , 0x02df, 0x02ff, 0x000d, (char)0x0d, (char)0xfa}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0000, 0x0020, 0x1ff6, (char)0xf6, (char)0x06}, { 0x04, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, },
	{ { 0x0c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x14, true , 0x029f, 0x02bf, 0x000f, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, { 0x0c, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0b, (char)0xf6}, },
	{ { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, },
	{ { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0301, 0x0321, 0x17f8, (char)0x0d, (char)0xf8}, },
	{ { 0x1c, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff6, (char)0xf6, (char)0x0f}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x01ff, 0x021f, 0x17f0, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02df, 0x02ff, 0x000d, (char)0x0d, (char)0xfa}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0000, 0x0020, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x001e, 0x003e, 0x000c, (char)0x0c, (char)0xf1}, },
	{ { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x005f, 0x007e, 0x17f3, (char)0xf8, (char)0xf3}, },
	{ { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x000f, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff0, (char)0xf0, (char)0x06}, },
	{ { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x035e, 0x037e, 0x000b, (char)0xf1, (char)0x0b}, },
	{ { 0x14, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff6, (char)0xf6, (char)0x0f}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02df, 0x02ff, 0x000d, (char)0x0d, (char)0xfa}, { 0x04, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x14, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, },
	{ { 0x0c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x000f, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x02c0, 0x02e0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x14, true , 0x019f, 0x01bf, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff6, (char)0xf6, (char)0x0f}, },
	{ { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02df, 0x02ff, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, },
	{ { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02c0, 0x02e0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, },
	{ { 0x1c, true , 0x0181, 0x01a1, 0x1ff6, (char)0xf6, (char)0x0c}, { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, },
	{ { 0x1c, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x019f, 0x01bf, 0x000c, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02c0, 0x02e0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x000a, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, },
	{ { 0x1c, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, { 0x14, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0181, 0x01a1, 0x1ff6, (char)0xf6, (char)0x0c}, { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, },
	{ { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, },
	{ { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, { 0x0c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x000c, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02c0, 0x02e0, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf5, (char)0x0b}, },
	{ { 0x14, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0181, 0x01a1, 0x1ff6, (char)0xf6, (char)0x0c}, { 0x14, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, { 0x0c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x000b, (char)0x0b, (char)0xf6}, },
	{ { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x000c, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, },
	{ { 0x1c, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x14, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x02bf, 0x02df, 0x17f6, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x0181, 0x01a1, 0x1ff6, (char)0xf6, (char)0x0c}, },
	{ { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021f, 0x023f, 0x000d, (char)0x0d, (char)0xf9}, },
	{ { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00c0, 0x00e0, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02c0, 0x02e0, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf6, (char)0x09}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x14, false, 0x0241, 0x0261, 0x17f2, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, },
	{ { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x025f, 0x027f, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x14, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, },
	{ { 0x14, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x029f, 0x02bf, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf6, (char)0x09}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x0241, 0x0261, 0x17f2, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, { 0x14, true , 0x019f, 0x01bf, 0x000e, (char)0x0e, (char)0xfa}, },
	{ { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, { 0x1c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x0009, (char)0x09, (char)0xf3}, { 0x14, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf6, (char)0x09}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x14, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x0241, 0x0261, 0x17f2, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x01a1, 0x01c1, 0x1ff6, (char)0xf6, (char)0x0d}, },
	{ { 0x04, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x0361, 0x0381, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x14, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x019e, 0x01be, 0x000d, (char)0xf6, (char)0x0d}, },
	{ { 0x04, true , 0x005e, 0x007e, 0x000e, (char)0x0e, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025e, 0x027e, 0x0009, (char)0x09, (char)0xf3}, { 0x14, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf6, (char)0x09}, },
	{ { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x0241, 0x0261, 0x17f2, (char)0x0d, (char)0xf2}, },
	{ { 0x14, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x04, true , 0x0220, 0x0240, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, { 0x1c, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, },
	{ { 0x04, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x14, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, },
	{ { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0c, (char)0xf7}, { 0x04, true , 0x005e, 0x007e, 0x000e, (char)0x0e, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x1c, true , 0x01bf, 0x01df, 0x0008, (char)0x08, (char)0xfa}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025e, 0x027e, 0x0009, (char)0x09, (char)0xf3}, { 0x14, false, 0x011e, 0x013e, 0x0009, (char)0xf4, (char)0x09}, },
	{ { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, },
	{ { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0220, 0x0240, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x0241, 0x0261, 0x17f2, (char)0x09, (char)0xf2}, },
	{ { 0x0c, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, { 0x04, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, { 0x0c, true , 0x0080, 0x00a0, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0c, (char)0xf7}, { 0x04, true , 0x005e, 0x007e, 0x000e, (char)0x0e, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x0008, (char)0x08, (char)0xfa}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025e, 0x027e, 0x0009, (char)0x09, (char)0xf3}, },
	{ { 0x14, true , 0x009e, 0x00be, 0x1ff8, (char)0xf8, (char)0xf5}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, },
	{ { 0x0c, true , 0x0161, 0x0181, 0x1ff0, (char)0xf0, (char)0x0b}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x14, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0220, 0x0240, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, },
	{ { 0x04, true , 0x02c1, 0x02e1, 0x1ff5, (char)0xf5, (char)0x0e}, { 0x0c, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, { 0x04, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0220, 0x0240, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0c, (char)0xf7}, { 0x04, true , 0x005e, 0x007e, 0x000e, (char)0x0e, (char)0xf3}, },
	{ { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x0008, (char)0x08, (char)0xfa}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x14, true , 0x027e, 0x029e, 0x000f, (char)0x0f, (char)0xf4}, { 0x14, true , 0x009e, 0x00be, 0x1ff8, (char)0xf8, (char)0xf5}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x0c, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0161, 0x0181, 0x1ff0, (char)0xf0, (char)0x0b}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0380, 0x03a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, },
	{ { 0x1c, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0220, 0x0240, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x1c, true , 0x01e1, 0x0201, 0x1ff4, (char)0xf4, (char)0x0f}, { 0x04, true , 0x02c1, 0x02e1, 0x1ff5, (char)0xf5, (char)0x0e}, { 0x0c, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, { 0x04, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0c, (char)0xf7}, },
	{ { 0x0c, false, 0x03be, 0x03de, 0x000e, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x14, true , 0x0281, 0x02a1, 0x1ff7, (char)0xf7, (char)0x0c}, { 0x14, true , 0x027e, 0x029e, 0x000f, (char)0x0f, (char)0xf4}, { 0x14, true , 0x009e, 0x00be, 0x1ff8, (char)0xf8, (char)0xf5}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0161, 0x0181, 0x1ff0, (char)0xf0, (char)0x0b}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, },
	{ { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, false, 0x0141, 0x0161, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff4, (char)0xf4, (char)0x0f}, { 0x04, true , 0x02c1, 0x02e1, 0x1ff5, (char)0xf5, (char)0x0e}, { 0x0c, true , 0x01fe, 0x021d, 0x000d, (char)0x0d, (char)0xf0}, },
	{ { 0x1c, true , 0x027e, 0x029e, 0x1ff9, (char)0xf9, (char)0xf4}, { 0x14, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0021, 0x0041, 0x17f1, (char)0x0a, (char)0xf1}, },
	{ { 0x1c, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x03be, 0x03de, 0x000e, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0281, 0x02a1, 0x1ff7, (char)0xf7, (char)0x0c}, { 0x14, true , 0x027e, 0x029e, 0x000f, (char)0x0f, (char)0xf4}, { 0x14, true , 0x009e, 0x00be, 0x1ff8, (char)0xf8, (char)0xf5}, },
	{ { 0x04, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0161, 0x0181, 0x1ff0, (char)0xf0, (char)0x0b}, },
	{ { 0x0c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, },
	{ { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0141, 0x0161, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff4, (char)0xf4, (char)0x0f}, { 0x04, true , 0x02c1, 0x02e1, 0x1ff5, (char)0xf5, (char)0x0e}, },
	{ { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x027e, 0x029e, 0x1ff9, (char)0xf9, (char)0xf4}, { 0x14, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x03be, 0x03de, 0x000e, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, },
	{ { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0281, 0x02a1, 0x1ff7, (char)0xf7, (char)0x0c}, { 0x14, true , 0x027e, 0x029e, 0x000f, (char)0x0f, (char)0xf4}, },
	{ { 0x1c, true , 0x00ff, 0x011e, 0x000a, (char)0x0a, (char)0xf8}, { 0x04, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, },
	{ { 0x1c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, },
	{ { 0x0c, false, 0x00be, 0x00de, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0141, 0x0161, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff4, (char)0xf4, (char)0x0f}, },
	{ { 0x14, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x027e, 0x029e, 0x1ff9, (char)0xf9, (char)0xf4}, { 0x14, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x0c, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x03be, 0x03de, 0x000e, (char)0xf3, (char)0x0e}, },
	{ { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0281, 0x02a1, 0x1ff7, (char)0xf7, (char)0x0c}, },
	{ { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00ff, 0x011e, 0x000a, (char)0x0a, (char)0xf8}, { 0x04, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, },
	{ { 0x04, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, },
	{ { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00be, 0x00de, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0141, 0x0161, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x027e, 0x029e, 0x1ff9, (char)0xf9, (char)0xf4}, },
	{ { 0x04, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, { 0x0c, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x0c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00ff, 0x011e, 0x000a, (char)0x0a, (char)0xf8}, { 0x04, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, },
	{ { 0x0c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x1c, true , 0x02a1, 0x02c1, 0x1ff3, (char)0xf3, (char)0x0d}, { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00be, 0x00de, 0x0006, (char)0xf4, (char)0x06}, { 0x0c, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x14, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x04, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, { 0x0c, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00ff, 0x011e, 0x000a, (char)0x0a, (char)0xf8}, },
	{ { 0x1c, true , 0x027f, 0x029f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x005f, 0x007f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02a1, 0x02c1, 0x1ff3, (char)0xf3, (char)0x0d}, { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00be, 0x00de, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x0c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x017f, 0x019e, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x1c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, { 0x0c, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x09, (char)0xf1}, { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x1c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x027f, 0x029f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x04, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x0c, true , 0x0280, 0x02a0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x14, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02a1, 0x02c1, 0x1ff3, (char)0xf3, (char)0x0d}, { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, { 0x14, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, },
	{ { 0x04, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x09, (char)0xf1}, { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x00e0, 0x0100, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, false, 0x0281, 0x02a1, 0x17f4, (char)0x09, (char)0xf4}, { 0x14, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x027f, 0x029f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x0c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x14, true , 0x0220, 0x0240, 0x1ff5, (char)0xf5, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x14, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02a1, 0x02c1, 0x1ff3, (char)0xf3, (char)0x0d}, },
	{ { 0x04, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0261, 0x0281, 0x0007, (char)0x07, (char)0x0b}, },
	{ { 0x0c, true , 0x00e0, 0x0100, 0x1ff4, (char)0xf4, (char)0x07}, { 0x04, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x01e1, 0x0200, 0x17fa, (char)0x08, (char)0xfa}, { 0x04, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x09, (char)0xf1}, { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x14, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0281, 0x02a1, 0x17f4, (char)0x09, (char)0xf4}, { 0x14, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x027f, 0x029f, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x04, true , 0x0221, 0x0241, 0x0007, (char)0x07, (char)0x09}, { 0x0c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0220, 0x0240, 0x1ff5, (char)0xf5, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x14, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0e, (char)0xf7}, { 0x04, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, { 0x0c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00e0, 0x0100, 0x1ff4, (char)0xf4, (char)0x07}, { 0x04, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x027f, 0x029f, 0x0009, (char)0x09, (char)0xfa}, { 0x14, false, 0x01e1, 0x0200, 0x17fa, (char)0x08, (char)0xfa}, { 0x04, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x09, (char)0xf1}, },
	{ { 0x1c, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x0040, 0x0060, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x14, true , 0x0260, 0x0280, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0281, 0x02a1, 0x17f4, (char)0x09, (char)0xf4}, { 0x14, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0221, 0x0241, 0x0007, (char)0x07, (char)0x09}, { 0x0c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0220, 0x0240, 0x1ff5, (char)0xf5, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x1c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0e, (char)0xf7}, { 0x04, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, { 0x14, false, 0x0120, 0x0140, 0x0009, (char)0x06, (char)0x09}, },
	{ { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00e0, 0x0100, 0x1ff4, (char)0xf4, (char)0x07}, { 0x04, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x0241, 0x0261, 0x1ff7, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x027f, 0x029f, 0x0009, (char)0x09, (char)0xfa}, { 0x14, false, 0x01e1, 0x0200, 0x17fa, (char)0x08, (char)0xfa}, { 0x04, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x04, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0260, 0x0280, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0281, 0x02a1, 0x17f4, (char)0x09, (char)0xf4}, },
	{ { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0221, 0x0241, 0x0007, (char)0x07, (char)0x09}, { 0x0c, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x1c, true , 0x01bf, 0x01df, 0x000a, (char)0x0a, (char)0xfa}, { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0220, 0x0240, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0e, (char)0xf7}, { 0x04, true , 0x005e, 0x007e, 0x000a, (char)0x0a, (char)0xf3}, },
	{ { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00e0, 0x0100, 0x1ff4, (char)0xf4, (char)0x07}, },
	{ { 0x0c, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x0241, 0x0261, 0x1ff7, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x027f, 0x029f, 0x0009, (char)0x09, (char)0xfa}, { 0x14, false, 0x01e1, 0x0200, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x14, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0260, 0x0280, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, },
	{ { 0x1c, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0221, 0x0241, 0x0007, (char)0x07, (char)0x09}, },
	{ { 0x1c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x000a, (char)0x0a, (char)0xfa}, { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0e, (char)0xf7}, },
	{ { 0x0c, true , 0x0280, 0x02a0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x0241, 0x0261, 0x1ff7, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x027f, 0x029f, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, },
	{ { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0260, 0x0280, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x000a, (char)0x0a, (char)0xfa}, { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x0241, 0x0261, 0x1ff7, (char)0xf7, (char)0x0a}, },
	{ { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, },
	{ { 0x0c, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf5, (char)0x0d}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff1, (char)0xf1, (char)0x06}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x1c, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x0221, 0x0241, 0x17f1, (char)0x0d, (char)0xf1}, },
	{ { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x0c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, },
	{ { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, },
	{ { 0x04, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, },
	{ { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x14, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, },
	{ { 0x04, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, },
	{ { 0x04, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, },
	{ { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x0c, true , 0x027f, 0x029f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x1c, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, },
	{ { 0x14, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, { 0x0c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, },
	{ { 0x1c, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, { 0x0c, true , 0x027f, 0x029f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x009f, 0x00bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x04, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x0c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, { 0x1c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x0101, 0x0120, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x1c, true , 0x023e, 0x025e, 0x0009, (char)0x09, (char)0xf2}, { 0x1c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x021e, 0x023e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x1c, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x14, false, 0x013e, 0x015e, 0x000a, (char)0xf4, (char)0x0a}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, { 0x0c, true , 0x027f, 0x029f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x0c, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, { 0x04, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x01a1, 0x01c1, 0x1ff2, (char)0xf2, (char)0x0d}, },
	{ { 0x04, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x0c, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x023e, 0x025e, 0x0009, (char)0x09, (char)0xf2}, { 0x1c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013e, 0x015e, 0x000a, (char)0xf4, (char)0x0a}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x14, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, { 0x0c, true , 0x027f, 0x029f, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x04, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, { 0x04, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, },
	{ { 0x04, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, },
	{ { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x023e, 0x025e, 0x0009, (char)0x09, (char)0xf2}, { 0x1c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x14, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013e, 0x015e, 0x000a, (char)0xf4, (char)0x0a}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, },
	{ { 0x04, true , 0x0260, 0x0280, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x031e, 0x033e, 0x0009, (char)0xf7, (char)0x09}, },
	{ { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, { 0x04, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0c, (char)0xf9}, },
	{ { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x023e, 0x025e, 0x0009, (char)0x09, (char)0xf2}, },
	{ { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x009e, 0x00be, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013e, 0x015e, 0x000a, (char)0xf4, (char)0x0a}, },
	{ { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0260, 0x0280, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, },
	{ { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, },
	{ { 0x1c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf3, (char)0x0d}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, },
	{ { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, { 0x0c, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0260, 0x0280, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, },
	{ { 0x1c, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf3, (char)0x0d}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x01c1, 0x01e0, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x14, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, },
	{ { 0x04, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0260, 0x0280, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf3, (char)0x0d}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, },
	{ { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x0d, (char)0xf1}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x0c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, { 0x1c, true , 0x02bf, 0x02df, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x039e, 0x03be, 0x000d, (char)0xf3, (char)0x0d}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x033e, 0x035e, 0x000a, (char)0xf7, (char)0x0a}, },
	{ { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, { 0x04, false, 0x027f, 0x029f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x00ff, 0x011e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x0d, (char)0xf1}, },
	{ { 0x1c, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, },
	{ { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x009e, 0x00be, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x013f, 0x015e, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x027e, 0x029e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x1c, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x0101, 0x0120, 0x1ff2, (char)0xf2, (char)0x08}, },
	{ { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0220, 0x0240, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x003e, 0x005e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x14, true , 0x02a0, 0x02c0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, false, 0x0141, 0x0160, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x01bf, 0x01df, 0x000a, (char)0x0a, (char)0xfa}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, },
	{ { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, { 0x04, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x02a0, 0x02c0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, { 0x0c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x14, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02a0, 0x02c0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, { 0x14, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x0c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, { 0x0c, true , 0x0281, 0x02a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, },
	{ { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x000a, (char)0x0a, (char)0xfa}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025e, 0x027e, 0x000f, (char)0x0f, (char)0xf3}, },
	{ { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01e1, 0x0201, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02a0, 0x02c0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x03c1, 0x03e1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x0c, false, 0x0261, 0x0281, 0x17f3, (char)0x0d, (char)0xf3}, { 0x14, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02a0, 0x02c0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x0281, 0x02a1, 0x1ff3, (char)0xf3, (char)0x0c}, },
	{ { 0x1c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0221, 0x0241, 0x1ff7, (char)0xf7, (char)0x09}, },
	{ { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x000a, (char)0x0a, (char)0xfa}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0d, (char)0xf3}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02a0, 0x02c0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, },
	{ { 0x0c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x0261, 0x0281, 0x17f3, (char)0x0d, (char)0xf3}, { 0x14, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x02a0, 0x02c0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, { 0x04, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, false, 0x02df, 0x02ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x023f, 0x025f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0d, (char)0xf3}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02a0, 0x02c0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x0261, 0x0281, 0x17f3, (char)0x0d, (char)0xf3}, { 0x14, true , 0x015f, 0x017f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x02e1, 0x0301, 0x17f7, (char)0x0d, (char)0xf7}, },
	{ { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x04, false, 0x0181, 0x01a1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0d, (char)0xf3}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, false, 0x0261, 0x0281, 0x17f3, (char)0x0d, (char)0xf3}, },
	{ { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, true , 0x011f, 0x013f, 0x1ff8, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x0260, 0x0280, 0x1ff1, (char)0xf1, (char)0x06}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x033f, 0x035f, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0181, 0x01a1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x04, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, },
	{ { 0x04, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0261, 0x0281, 0x17f3, (char)0x0d, (char)0xf3}, },
	{ { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x14, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a0, 0x01c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x011f, 0x013f, 0x1ff8, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0341, 0x0361, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0260, 0x0280, 0x1ff1, (char)0xf1, (char)0x06}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x0280, 0x02a0, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0a, (char)0xf4}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0181, 0x01a1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, },
	{ { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, { 0x04, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, },
	{ { 0x14, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x14, true , 0x0060, 0x0080, 0x1ff4, (char)0xf4, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x04, false, 0x00e1, 0x0100, 0x17f7, (char)0x08, (char)0xf7}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x011f, 0x013f, 0x1ff8, (char)0xf8, (char)0xf9}, { 0x0c, false, 0x035e, 0x037e, 0x000b, (char)0xf3, (char)0x0b}, },
	{ { 0x0c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0260, 0x0280, 0x1ff1, (char)0xf1, (char)0x06}, { 0x14, false, 0x02be, 0x02de, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x14, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0a, (char)0xf4}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0181, 0x01a1, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x01ff, 0x021e, 0x1ffa, (char)0xfa, (char)0xf8}, },
	{ { 0x04, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, },
	{ { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x0060, 0x0080, 0x1ff4, (char)0xf4, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e1, 0x0100, 0x17f7, (char)0x08, (char)0xf7}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x011f, 0x013f, 0x1ff8, (char)0xf8, (char)0xf9}, },
	{ { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0260, 0x0280, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0a, (char)0xf4}, { 0x14, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, },
	{ { 0x14, false, 0x01fe, 0x021e, 0x0006, (char)0xf7, (char)0x06}, { 0x04, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x04, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x0060, 0x0080, 0x1ff4, (char)0xf4, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x1c, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e1, 0x0100, 0x17f7, (char)0x08, (char)0xf7}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, },
	{ { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x14, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0a, (char)0xf4}, },
	{ { 0x04, false, 0x02be, 0x02de, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x01fe, 0x021e, 0x0006, (char)0xf7, (char)0x06}, { 0x04, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, },
	{ { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x0060, 0x0080, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e1, 0x0100, 0x17f7, (char)0x08, (char)0xf7}, },
	{ { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, },
	{ { 0x0c, true , 0x015f, 0x017f, 0x0008, (char)0x08, (char)0xfa}, { 0x14, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x1c, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x02be, 0x02de, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, { 0x04, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x01fe, 0x021e, 0x0006, (char)0xf7, (char)0x06}, { 0x04, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x04, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, },
	{ { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, },
	{ { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, },
	{ { 0x14, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x0c, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x015f, 0x017f, 0x0008, (char)0x08, (char)0xfa}, { 0x14, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x02be, 0x02de, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x02fe, 0x031e, 0x0008, (char)0xf3, (char)0x08}, },
	{ { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0e, (char)0xf4}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x01fe, 0x021e, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x1c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x02fe, 0x001d, 0x000e, (char)0x0e, (char)0xf0}, },
	{ { 0x1c, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, { 0x0c, false, 0x001f, 0x003f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x0008, (char)0x08, (char)0xf2}, },
	{ { 0x14, false, 0x005e, 0x007e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x00be, 0x00de, 0x1ff8, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x015f, 0x017f, 0x0008, (char)0x08, (char)0xfa}, { 0x14, false, 0x015e, 0x017d, 0x000b, (char)0xf0, (char)0x0b}, },
	{ { 0x0c, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, { 0x04, false, 0x02be, 0x02de, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x14, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0e, (char)0xf4}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, },
	{ { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x04, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0221, 0x0241, 0x17f1, (char)0x0b, (char)0xf1}, },
	{ { 0x04, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005e, 0x007e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, },
	{ { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x00be, 0x00de, 0x1ff8, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, { 0x0c, true , 0x015f, 0x017f, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x0c, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e0, 0x0000, 0x1ff1, (char)0xf1, (char)0x07}, },
	{ { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf5, (char)0x0c}, { 0x14, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0e, (char)0xf4}, { 0x14, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, },
	{ { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x03c0, 0x03e0, 0x000e, (char)0x07, (char)0x0e}, },
	{ { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005e, 0x007e, 0x0006, (char)0xf4, (char)0x06}, { 0x14, true , 0x027f, 0x029f, 0x000f, (char)0x0f, (char)0xfa}, },
	{ { 0x1c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x00be, 0x00de, 0x1ff8, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x0321, 0x0341, 0x17f9, (char)0x0f, (char)0xf9}, },
	{ { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x0c, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x023f, 0x025f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x14, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf5, (char)0x0c}, { 0x14, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0081, 0x00a1, 0x17f4, (char)0x0e, (char)0xf4}, },
	{ { 0x04, false, 0x025e, 0x027e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, { 0x1c, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, },
	{ { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x0020, 0x0040, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005e, 0x007e, 0x0006, (char)0xf4, (char)0x06}, },
	{ { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x00be, 0x00de, 0x1ff8, (char)0xf8, (char)0xf6}, },
	{ { 0x14, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x0c, false, 0x019e, 0x01bd, 0x000d, (char)0xf0, (char)0x0d}, },
	{ { 0x04, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf5, (char)0x0c}, { 0x14, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x02de, 0x02fe, 0x1ff9, (char)0xf9, (char)0xf7}, { 0x04, false, 0x025e, 0x027e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x0141, 0x0161, 0x1ff6, (char)0xf6, (char)0x0a}, },
	{ { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, },
	{ { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, { 0x0c, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x0c, false, 0x03be, 0x03de, 0x000e, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, { 0x1c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x0c, true , 0x01ff, 0x021e, 0x000f, (char)0x0f, (char)0xf8}, { 0x04, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x037e, 0x039e, 0x000c, (char)0xf5, (char)0x0c}, },
	{ { 0x1c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02de, 0x02fe, 0x1ff9, (char)0xf9, (char)0xf7}, { 0x04, false, 0x025e, 0x027e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x02ff, 0x031f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, false, 0x0041, 0x0061, 0x17f2, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x1c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0c, (char)0xf1}, },
	{ { 0x1c, true , 0x0220, 0x0240, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x03be, 0x03de, 0x000e, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003f, 0x005e, 0x17f2, (char)0xf8, (char)0xf2}, },
	{ { 0x14, false, 0x005e, 0x007e, 0x0006, (char)0xf2, (char)0x06}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, true , 0x00c0, 0x00e0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x01ff, 0x021e, 0x000f, (char)0x0f, (char)0xf8}, { 0x04, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, { 0x14, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, },
	{ { 0x04, false, 0x019f, 0x01be, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02de, 0x02fe, 0x1ff9, (char)0xf9, (char)0xf7}, { 0x04, false, 0x025e, 0x027e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x0c, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0041, 0x0061, 0x17f2, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, },
	{ { 0x04, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0220, 0x0240, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x03be, 0x03de, 0x000e, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005e, 0x007e, 0x0006, (char)0xf2, (char)0x06}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x00c0, 0x00e0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x01ff, 0x021e, 0x000f, (char)0x0f, (char)0xf8}, { 0x04, true , 0x015f, 0x017f, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0a, (char)0xfa}, { 0x04, false, 0x019f, 0x01be, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x02de, 0x02fe, 0x1ff9, (char)0xf9, (char)0xf7}, },
	{ { 0x0c, false, 0x03be, 0x03de, 0x000e, (char)0xf5, (char)0x0e}, { 0x0c, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0041, 0x0061, 0x17f2, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02e1, 0x0001, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, { 0x04, false, 0x03df, 0x03ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0220, 0x0240, 0x1ff1, (char)0xf1, (char)0x06}, { 0x0c, false, 0x03be, 0x03de, 0x000e, (char)0xf7, (char)0x0e}, },
	{ { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005e, 0x007e, 0x0006, (char)0xf2, (char)0x06}, { 0x14, false, 0x0381, 0x03a1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x00c0, 0x00e0, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x01ff, 0x021e, 0x000f, (char)0x0f, (char)0xf8}, },
	{ { 0x1c, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0a, (char)0xfa}, { 0x04, false, 0x019f, 0x01be, 0x17fa, (char)0xf8, (char)0xfa}, { 0x1c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x03be, 0x03de, 0x000e, (char)0xf5, (char)0x0e}, { 0x0c, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0041, 0x0061, 0x17f2, (char)0x0e, (char)0xf2}, },
	{ { 0x14, false, 0x025e, 0x027e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x007f, 0x009f, 0x17f4, (char)0xfa, (char)0xf4}, },
	{ { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, { 0x1c, true , 0x00ff, 0x011e, 0x1ff8, (char)0xf8, (char)0xf8}, },
	{ { 0x04, true , 0x0181, 0x01a1, 0x1ff4, (char)0xf4, (char)0x0c}, { 0x14, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0220, 0x0240, 0x1ff1, (char)0xf1, (char)0x06}, },
	{ { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, { 0x14, false, 0x005e, 0x007e, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, true , 0x00c0, 0x00e0, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0a, (char)0xfa}, { 0x04, false, 0x019f, 0x01be, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x03be, 0x03de, 0x000e, (char)0xf5, (char)0x0e}, { 0x0c, true , 0x0241, 0x0261, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x025e, 0x027e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, { 0x04, true , 0x0141, 0x0161, 0x0006, (char)0x06, (char)0x0a}, },
	{ { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x1ff4, (char)0xf4, (char)0x0c}, { 0x14, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0e, (char)0xf1}, { 0x0c, true , 0x015f, 0x017f, 0x000a, (char)0x0a, (char)0xfa}, },
	{ { 0x0c, true , 0x0020, 0x0040, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x14, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, { 0x14, false, 0x01e1, 0x0201, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x03be, 0x03de, 0x000e, (char)0xf5, (char)0x0e}, },
	{ { 0x14, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x025e, 0x027e, 0x0006, (char)0xf1, (char)0x06}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0300, 0x0320, 0x0008, (char)0x07, (char)0x08}, },
	{ { 0x04, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x1ff4, (char)0xf4, (char)0x0c}, { 0x14, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x0021, 0x0041, 0x17f1, (char)0x0e, (char)0xf1}, },
	{ { 0x04, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x0020, 0x0040, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, true , 0x027f, 0x029f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x0008, (char)0x08, (char)0xf4}, },
	{ { 0x1c, true , 0x021f, 0x023f, 0x000b, (char)0x0b, (char)0xf9}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0c, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, },
	{ { 0x1c, true , 0x0260, 0x0280, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, { 0x14, false, 0x025e, 0x027e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x14, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, { 0x04, false, 0x00be, 0x00de, 0x0006, (char)0xf2, (char)0x06}, },
	{ { 0x0c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, { 0x04, true , 0x0181, 0x01a1, 0x1ff4, (char)0xf4, (char)0x0c}, },
	{ { 0x1c, true , 0x02df, 0x02ff, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, },
	{ { 0x1c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x0020, 0x0040, 0x1ff4, (char)0xf4, (char)0x06}, { 0x0c, true , 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x027f, 0x029f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, { 0x14, false, 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021f, 0x023f, 0x000b, (char)0x0b, (char)0xf9}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0c, (char)0xfa}, },
	{ { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0260, 0x0280, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x027f, 0x029f, 0x17f4, (char)0xf9, (char)0xf4}, },
	{ { 0x1c, true , 0x027e, 0x029e, 0x000f, (char)0x0f, (char)0xf4}, { 0x14, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, false, 0x0100, 0x0120, 0x0008, (char)0x06, (char)0x08}, },
	{ { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0200, 0x0220, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02df, 0x02ff, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x0020, 0x0040, 0x1ff4, (char)0xf4, (char)0x06}, },
	{ { 0x1c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x027f, 0x029f, 0x000d, (char)0x0d, (char)0xfa}, { 0x14, true , 0x005e, 0x007e, 0x0008, (char)0x08, (char)0xf3}, },
	{ { 0x14, false, 0x02df, 0x02ff, 0x17f7, (char)0xf9, (char)0xf7}, { 0x04, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021f, 0x023f, 0x000b, (char)0x0b, (char)0xf9}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, true , 0x01c1, 0x01e1, 0x1ff2, (char)0xf2, (char)0x0e}, { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0260, 0x0280, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, },
	{ { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x027e, 0x029e, 0x000f, (char)0x0f, (char)0xf4}, { 0x14, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02a1, 0x02c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x04, true , 0x023f, 0x025f, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x04, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, },
	{ { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02df, 0x02ff, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, },
	{ { 0x14, true , 0x013f, 0x015f, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, { 0x04, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x0c, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x027f, 0x029f, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x1c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02df, 0x02ff, 0x17f7, (char)0xf9, (char)0xf7}, { 0x04, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x021f, 0x023f, 0x000b, (char)0x0b, (char)0xf9}, },
	{ { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff2, (char)0xf2, (char)0x0e}, { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x0260, 0x0280, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x14, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x027e, 0x029e, 0x000f, (char)0x0f, (char)0xf4}, { 0x14, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, { 0x04, true , 0x023f, 0x025f, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x01df, 0x01ff, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x02df, 0x02ff, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x03e0, 0x0000, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x14, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, { 0x14, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, },
	{ { 0x0c, false, 0x01a1, 0x01c0, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02df, 0x02ff, 0x17f7, (char)0xf9, (char)0xf7}, { 0x04, false, 0x039f, 0x03bf, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff2, (char)0xf2, (char)0x0e}, { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf5, (char)0x0d}, { 0x1c, true , 0x027e, 0x029e, 0x000f, (char)0x0f, (char)0xf4}, },
	{ { 0x04, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, { 0x04, true , 0x023f, 0x025f, 0x000b, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, },
	{ { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x000e, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, { 0x1c, true , 0x0161, 0x0181, 0x1ff4, (char)0xf4, (char)0x0b}, },
	{ { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x01a1, 0x01c0, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x02df, 0x02ff, 0x17f7, (char)0xf9, (char)0xf7}, },
	{ { 0x0c, false, 0x023e, 0x025e, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff2, (char)0xf2, (char)0x0e}, },
	{ { 0x14, false, 0x007e, 0x009e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf5, (char)0x0d}, },
	{ { 0x04, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, { 0x04, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, { 0x04, true , 0x023f, 0x025f, 0x000b, (char)0x0b, (char)0xfa}, },
	{ { 0x0c, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x013f, 0x015f, 0x000e, (char)0x0e, (char)0xfa}, },
	{ { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x029e, 0x02be, 0x000d, (char)0x0d, (char)0xf5}, },
	{ { 0x04, true , 0x007e, 0x009e, 0x1ff8, (char)0xf8, (char)0xf4}, { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x01a1, 0x01c0, 0x17fa, (char)0x08, (char)0xfa}, { 0x1c, false, 0x015f, 0x017f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x023e, 0x025e, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x007e, 0x009e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x017f, 0x019f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, { 0x04, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, },
	{ { 0x04, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x04, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, { 0x14, true , 0x00be, 0x00de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x007e, 0x009e, 0x1ff8, (char)0xf8, (char)0xf4}, { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, { 0x0c, false, 0x01a1, 0x01c0, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x04, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x023e, 0x025e, 0x0006, (char)0xf3, (char)0x06}, { 0x1c, false, 0x033e, 0x035e, 0x000a, (char)0xf1, (char)0x0a}, },
	{ { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x007e, 0x009e, 0x0006, (char)0xf6, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, { 0x04, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, },
	{ { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, },
	{ { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0181, 0x01a1, 0x0006, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x005e, 0x007e, 0x1ff8, (char)0xf8, (char)0xf3}, { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x007e, 0x009e, 0x1ff8, (char)0xf8, (char)0xf4}, { 0x14, false, 0x0321, 0x0341, 0x17f9, (char)0x09, (char)0xf9}, },
	{ { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, { 0x0c, false, 0x023e, 0x025e, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x14, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x007e, 0x009e, 0x0006, (char)0xf6, (char)0x06}, },
	{ { 0x04, false, 0x039e, 0x03be, 0x000d, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0101, 0x0121, 0x17f8, (char)0x0c, (char)0xf8}, },
	{ { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, },
	{ { 0x04, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x005e, 0x007e, 0x1ff8, (char)0xf8, (char)0xf3}, { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, { 0x04, true , 0x007e, 0x009e, 0x1ff8, (char)0xf8, (char)0xf4}, },
	{ { 0x1c, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x0c, true , 0x0121, 0x0141, 0x1ff0, (char)0xf0, (char)0x09}, },
	{ { 0x1c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02de, 0x02fe, 0x1ff9, (char)0xf9, (char)0xf7}, { 0x04, false, 0x039e, 0x03be, 0x000d, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, },
	{ { 0x14, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, { 0x04, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x029f, 0x02bf, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x0c, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x005e, 0x007e, 0x1ff8, (char)0xf8, (char)0xf3}, { 0x14, false, 0x02e0, 0x0300, 0x0007, (char)0x07, (char)0x07}, },
	{ { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x01c1, 0x01e1, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x037f, 0x039f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02de, 0x02fe, 0x1ff9, (char)0xf9, (char)0xf7}, { 0x04, false, 0x039e, 0x03be, 0x000d, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0301, 0x0321, 0x17f8, (char)0x0b, (char)0xf8}, },
	{ { 0x1c, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0200, 0x0220, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, { 0x04, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x02fe, 0x001d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x005e, 0x007e, 0x1ff8, (char)0xf8, (char)0xf3}, },
	{ { 0x14, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, },
	{ { 0x14, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02de, 0x02fe, 0x1ff9, (char)0xf9, (char)0xf7}, { 0x04, false, 0x039e, 0x03be, 0x000d, (char)0xf1, (char)0x0d}, },
	{ { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, { 0x04, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, },
	{ { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, { 0x04, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x09, (char)0xf5}, { 0x1c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, },
	{ { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x000d, (char)0x0d, (char)0xf2}, },
	{ { 0x14, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x009e, 0x00be, 0x000a, (char)0x0a, (char)0xf5}, },
	{ { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x0c, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02de, 0x02fe, 0x1ff9, (char)0xf9, (char)0xf7}, },
	{ { 0x14, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x01e1, 0x0201, 0x1ff2, (char)0xf2, (char)0x0f}, },
	{ { 0x0c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e1, 0x0001, 0x1ff5, (char)0xf5, (char)0x0f}, },
	{ { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x09, (char)0xf5}, { 0x1c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x03e1, 0x0001, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02c1, 0x02e1, 0x1ff7, (char)0xf7, (char)0x0e}, },
	{ { 0x14, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x04, true , 0x00ff, 0x011e, 0x000e, (char)0x0e, (char)0xf8}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0a, (char)0xf3}, { 0x14, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, { 0x1c, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, },
	{ { 0x1c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x017f, 0x019f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x09, (char)0xf5}, { 0x1c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, },
	{ { 0x14, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x00ff, 0x011e, 0x000e, (char)0x0e, (char)0xf8}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, false, 0x031e, 0x033e, 0x0009, (char)0xf3, (char)0x09}, },
	{ { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0240, 0x0260, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x0c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0a, (char)0xf3}, { 0x14, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0e, (char)0xf5}, },
	{ { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x013f, 0x015f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x017f, 0x019f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x02a1, 0x02c1, 0x17f5, (char)0x09, (char)0xf5}, },
	{ { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x1c, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x00ff, 0x011e, 0x000e, (char)0x0e, (char)0xf8}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x14, true , 0x02bf, 0x02df, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x0c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0a, (char)0xf3}, { 0x14, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, },
	{ { 0x0c, true , 0x02a1, 0x02c1, 0x1ff3, (char)0xf3, (char)0x0d}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x14, true , 0x0261, 0x0281, 0x1ff7, (char)0xf7, (char)0x0b}, { 0x14, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x017f, 0x019f, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x04, false, 0x02e1, 0x0301, 0x17f7, (char)0x0f, (char)0xf7}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, { 0x14, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x00ff, 0x011e, 0x000e, (char)0x0e, (char)0xf8}, },
	{ { 0x1c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x021e, 0x023e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x0c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0061, 0x0081, 0x17f3, (char)0x0a, (char)0xf3}, },
	{ { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02a1, 0x02c1, 0x1ff3, (char)0xf3, (char)0x0d}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0261, 0x0281, 0x1ff7, (char)0xf7, (char)0x0b}, { 0x14, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x017f, 0x019f, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x1c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x02e1, 0x0301, 0x17f7, (char)0x0f, (char)0xf7}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0221, 0x0241, 0x1ff1, (char)0xf1, (char)0x09}, },
	{ { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0260, 0x0280, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, { 0x04, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x02a0, 0x02c0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x0c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x04, false, 0x0161, 0x0181, 0x17fa, (char)0x0e, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02a1, 0x02c1, 0x1ff3, (char)0xf3, (char)0x0d}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0261, 0x0281, 0x1ff7, (char)0xf7, (char)0x0b}, { 0x14, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x1c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x02e1, 0x0301, 0x17f7, (char)0x0f, (char)0xf7}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x000a, (char)0x0a, (char)0xf7}, },
	{ { 0x0c, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x01e0, 0x0200, 0x000f, (char)0x06, (char)0x0f}, },
	{ { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a0, 0x02c0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x02bf, 0x02df, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0161, 0x0181, 0x17fa, (char)0x0e, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x02a1, 0x02c1, 0x1ff3, (char)0xf3, (char)0x0d}, },
	{ { 0x1c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0261, 0x0281, 0x1ff7, (char)0xf7, (char)0x0b}, },
	{ { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x02e1, 0x0301, 0x17f7, (char)0x0f, (char)0xf7}, },
	{ { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a0, 0x02c0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x1c, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x1c, true , 0x00be, 0x00de, 0x000a, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0161, 0x0181, 0x17fa, (char)0x0e, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0a, (char)0xfa}, { 0x1c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x04, true , 0x01ff, 0x021e, 0x000d, (char)0x0d, (char)0xf8}, { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, },
	{ { 0x0c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a0, 0x02c0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00be, 0x00de, 0x000a, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0161, 0x0181, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x0c, false, 0x015f, 0x017e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0a, (char)0xfa}, },
	{ { 0x1c, false, 0x02be, 0x02de, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x04, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, { 0x04, true , 0x01ff, 0x021e, 0x000d, (char)0x0d, (char)0xf8}, { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, },
	{ { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00be, 0x00de, 0x000a, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, },
	{ { 0x14, true , 0x007e, 0x009e, 0x000c, (char)0x0c, (char)0xf4}, { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, },
	{ { 0x0c, false, 0x0121, 0x0140, 0x17f9, (char)0x08, (char)0xf9}, { 0x0c, false, 0x015f, 0x017e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x02be, 0x02de, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, },
	{ { 0x14, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x04, false, 0x00fe, 0x011e, 0x0008, (char)0xf4, (char)0x08}, { 0x04, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, { 0x04, true , 0x01ff, 0x021e, 0x000d, (char)0x0d, (char)0xf8}, { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, },
	{ { 0x04, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x00be, 0x00de, 0x000a, (char)0x0a, (char)0xf6}, },
	{ { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x007e, 0x009e, 0x000c, (char)0x0c, (char)0xf4}, { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x01a1, 0x01c1, 0x0006, (char)0x06, (char)0x0d}, },
	{ { 0x04, true , 0x00be, 0x00de, 0x0008, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0121, 0x0140, 0x17f9, (char)0x08, (char)0xf9}, { 0x0c, false, 0x015f, 0x017e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x035f, 0x037f, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x0c, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x02be, 0x02de, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf3, (char)0x06}, },
	{ { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x017e, 0x019e, 0x000c, (char)0xf6, (char)0x0c}, },
	{ { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x00fe, 0x011e, 0x0008, (char)0xf4, (char)0x08}, { 0x04, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, { 0x04, true , 0x01ff, 0x021e, 0x000d, (char)0x0d, (char)0xf8}, },
	{ { 0x04, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x007e, 0x009e, 0x000c, (char)0x0c, (char)0xf4}, { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, },
	{ { 0x1c, true , 0x0201, 0x0220, 0x0007, (char)0x07, (char)0x08}, { 0x04, true , 0x00be, 0x00de, 0x0008, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0121, 0x0140, 0x17f9, (char)0x08, (char)0xf9}, { 0x0c, false, 0x015f, 0x017e, 0x17fa, (char)0xf8, (char)0xfa}, },
	{ { 0x14, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf1, (char)0x06}, { 0x1c, false, 0x02be, 0x02de, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x0c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x00fe, 0x011e, 0x0008, (char)0xf4, (char)0x08}, { 0x04, true , 0x0201, 0x0220, 0x1ff5, (char)0xf5, (char)0x08}, },
	{ { 0x1c, true , 0x01df, 0x01ff, 0x0008, (char)0x08, (char)0xfa}, { 0x04, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf1, (char)0x0f}, { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x007e, 0x009e, 0x000c, (char)0x0c, (char)0xf4}, },
	{ { 0x04, true , 0x02a1, 0x02c1, 0x1ff7, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x0201, 0x0220, 0x0007, (char)0x07, (char)0x08}, { 0x04, true , 0x00be, 0x00de, 0x0008, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0121, 0x0140, 0x17f9, (char)0x08, (char)0xf9}, },
	{ { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf1, (char)0x06}, },
	{ { 0x0c, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0080, 0x00a0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, { 0x04, false, 0x00fe, 0x011e, 0x0008, (char)0xf4, (char)0x08}, },
	{ { 0x1c, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01df, 0x01ff, 0x0008, (char)0x08, (char)0xfa}, { 0x04, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x01fe, 0x021d, 0x1ff9, (char)0xf9, (char)0xf0}, },
	{ { 0x1c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf1, (char)0x0f}, { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, true , 0x0161, 0x0181, 0x1ff6, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02a1, 0x02c1, 0x1ff7, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x0201, 0x0220, 0x0007, (char)0x07, (char)0x08}, { 0x04, true , 0x00be, 0x00de, 0x0008, (char)0x08, (char)0xf6}, },
	{ { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, },
	{ { 0x1c, true , 0x02c1, 0x02e1, 0x1ff5, (char)0xf5, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, },
	{ { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02e0, 0x0000, 0x0006, (char)0x06, (char)0x07}, },
	{ { 0x0c, true , 0x0241, 0x0261, 0x1ff7, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01df, 0x01ff, 0x0008, (char)0x08, (char)0xfa}, { 0x04, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, },
	{ { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf1, (char)0x0f}, { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x1ff6, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x1c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02a1, 0x02c1, 0x1ff7, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x0201, 0x0220, 0x0007, (char)0x07, (char)0x08}, },
	{ { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x14, true , 0x021e, 0x023e, 0x000f, (char)0x0f, (char)0xf1}, },
	{ { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02c1, 0x02e1, 0x1ff5, (char)0xf5, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, { 0x0c, true , 0x005e, 0x007e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, { 0x0c, true , 0x0241, 0x0261, 0x1ff7, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01df, 0x01ff, 0x0008, (char)0x08, (char)0xfa}, },
	{ { 0x14, false, 0x025f, 0x027f, 0x17f3, (char)0xf9, (char)0xf3}, { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, false, 0x03de, 0x03fe, 0x000f, (char)0xf1, (char)0x0f}, },
	{ { 0x0c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x1ff6, (char)0xf6, (char)0x0b}, { 0x14, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, },
	{ { 0x14, false, 0x019e, 0x01be, 0x000d, (char)0xf4, (char)0x0d}, { 0x1c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, true , 0x02a1, 0x02c1, 0x1ff7, (char)0xf7, (char)0x0d}, },
	{ { 0x04, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, { 0x04, false, 0x035f, 0x037f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x02a0, 0x02c0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02c1, 0x02e1, 0x1ff5, (char)0xf5, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x000f, (char)0x0f, (char)0xf6}, },
	{ { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, { 0x0c, true , 0x0241, 0x0261, 0x1ff7, (char)0xf7, (char)0x0a}, { 0x1c, true , 0x023f, 0x025f, 0x000d, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x025f, 0x027f, 0x17f3, (char)0xf9, (char)0xf3}, { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x029e, 0x02be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0161, 0x0181, 0x1ff6, (char)0xf6, (char)0x0b}, },
	{ { 0x14, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, { 0x14, false, 0x019e, 0x01be, 0x000d, (char)0xf4, (char)0x0d}, { 0x1c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x02de, 0x02fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, false, 0x00de, 0x00fe, 0x0007, (char)0xf6, (char)0x07}, { 0x04, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x01df, 0x01ff, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02a0, 0x02c0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, { 0x1c, true , 0x02c1, 0x02e1, 0x1ff5, (char)0xf5, (char)0x0e}, },
	{ { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x1c, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, { 0x0c, true , 0x0241, 0x0261, 0x1ff7, (char)0xf7, (char)0x0a}, },
	{ { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x025f, 0x027f, 0x17f3, (char)0xf9, (char)0xf3}, { 0x14, false, 0x029f, 0x02bf, 0x17f5, (char)0xfa, (char)0xf5}, },
	{ { 0x04, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x0c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, { 0x14, false, 0x019e, 0x01be, 0x000d, (char)0xf4, (char)0x0d}, { 0x1c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, { 0x0c, false, 0x00de, 0x00fe, 0x0007, (char)0xf6, (char)0x07}, { 0x04, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, },
	{ { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02a0, 0x02c0, 0x1ff3, (char)0xf3, (char)0x06}, { 0x1c, false, 0x023e, 0x025e, 0x0006, (char)0xf5, (char)0x06}, },
	{ { 0x14, true , 0x00c0, 0x00e0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x04, true , 0x01a1, 0x01c1, 0x1ff4, (char)0xf4, (char)0x0d}, { 0x1c, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0d, (char)0xf6}, { 0x0c, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, },
	{ { 0x04, true , 0x025f, 0x027f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x14, false, 0x025f, 0x027f, 0x17f3, (char)0xf9, (char)0xf3}, },
	{ { 0x0c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x00c0, 0x00e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, { 0x14, false, 0x019e, 0x01be, 0x000d, (char)0xf4, (char)0x0d}, },
	{ { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, { 0x0c, false, 0x00de, 0x00fe, 0x0007, (char)0xf6, (char)0x07}, { 0x04, true , 0x023f, 0x025f, 0x0009, (char)0x09, (char)0xfa}, },
	{ { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x02a0, 0x02c0, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x00c0, 0x00e0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, { 0x14, false, 0x0160, 0x0180, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff4, (char)0xf4, (char)0x0d}, { 0x1c, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, { 0x04, false, 0x02c1, 0x02e1, 0x17f6, (char)0x0d, (char)0xf6}, },
	{ { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025f, 0x027f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x07, (char)0x06}, { 0x0c, true , 0x017f, 0x019f, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x0221, 0x0241, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x1c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x000b, (char)0x0b, (char)0xf3}, },
	{ { 0x14, false, 0x00df, 0x00fe, 0x17f7, (char)0xf8, (char)0xf7}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, { 0x0c, false, 0x00de, 0x00fe, 0x0007, (char)0xf6, (char)0x07}, },
	{ { 0x0c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, false, 0x01bf, 0x01df, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x00c0, 0x00e0, 0x1ff2, (char)0xf2, (char)0x06}, { 0x0c, false, 0x0381, 0x03a1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff4, (char)0xf4, (char)0x0d}, { 0x1c, true , 0x0201, 0x0220, 0x1ff3, (char)0xf3, (char)0x08}, },
	{ { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025f, 0x027f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x0220, 0x0240, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x003f, 0x005f, 0x17f2, (char)0xfa, (char)0xf2}, },
	{ { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x00df, 0x00fe, 0x17f7, (char)0xf8, (char)0xf7}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x011f, 0x013f, 0x0008, (char)0x08, (char)0xf9}, },
	{ { 0x1c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, { 0x1c, false, 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x00c0, 0x00e0, 0x1ff2, (char)0xf2, (char)0x06}, },
	{ { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, { 0x04, true , 0x01a1, 0x01c1, 0x1ff4, (char)0xf4, (char)0x0d}, },
	{ { 0x1c, true , 0x01e1, 0x0201, 0x1ff4, (char)0xf4, (char)0x0f}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025f, 0x027f, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x09, (char)0xfa}, { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x00df, 0x00fe, 0x17f7, (char)0xf8, (char)0xf7}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x04, false, 0x0341, 0x0361, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, { 0x0c, false, 0x033f, 0x035f, 0x17fa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, { 0x1c, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, { 0x14, false, 0x0101, 0x0121, 0x17f8, (char)0x0e, (char)0xf8}, },
	{ { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff4, (char)0xf4, (char)0x0f}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x09, (char)0xfa}, { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x1ffa, (char)0xfa, (char)0xf1}, },
	{ { 0x1c, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, { 0x0c, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, { 0x14, false, 0x00df, 0x00fe, 0x17f7, (char)0xf8, (char)0xf7}, },
	{ { 0x0c, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, { 0x04, false, 0x0341, 0x0361, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff0, (char)0xf0, (char)0x0e}, },
	{ { 0x14, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff1, (char)0xf1, (char)0x0d}, },
	{ { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0360, 0x0380, 0x000b, (char)0x06, (char)0x0b}, },
	{ { 0x0c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff4, (char)0xf4, (char)0x0f}, { 0x04, true , 0x02c0, 0x02e0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x07, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x09, (char)0xfa}, { 0x04, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, { 0x0c, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x027e, 0x029e, 0x000b, (char)0x0b, (char)0xf4}, },
	{ { 0x1c, true , 0x011f, 0x013f, 0x000a, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, { 0x04, false, 0x0341, 0x0361, 0x17fa, (char)0x0f, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x0006, (char)0x06, (char)0x09}, },
	{ { 0x1c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x0d, (char)0xf2}, { 0x1c, true , 0x01e1, 0x0201, 0x1ff4, (char)0xf4, (char)0x0f}, },
	{ { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x07, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03e1, 0x0001, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x0c, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, { 0x0c, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, },
	{ { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, { 0x14, false, 0x039e, 0x03be, 0x000d, (char)0xf7, (char)0x0d}, },
	{ { 0x04, true , 0x003e, 0x005e, 0x000e, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x011f, 0x013f, 0x000a, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, { 0x04, false, 0x0341, 0x0361, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, },
	{ { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0241, 0x0261, 0x17f2, (char)0x0d, (char)0xf2}, },
	{ { 0x14, true , 0x0181, 0x01a1, 0x1ff2, (char)0xf2, (char)0x0c}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x07, (char)0x06}, { 0x1c, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x04, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, { 0x0c, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, },
	{ { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, },
	{ { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x003e, 0x005e, 0x000e, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x011f, 0x013f, 0x000a, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x00de, 0x00fe, 0x0007, (char)0xf2, (char)0x07}, },
	{ { 0x14, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, },
	{ { 0x0c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x1c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, },
	{ { 0x14, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x1ff2, (char)0xf2, (char)0x0c}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xf9, (char)0xfa}, { 0x14, false, 0x02a0, 0x02c0, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, { 0x0c, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf7, (char)0x06}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x003e, 0x005e, 0x000e, (char)0x0e, (char)0xf2}, { 0x1c, true , 0x011f, 0x013f, 0x000a, (char)0x0a, (char)0xf9}, },
	{ { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, { 0x1c, true , 0x0260, 0x0280, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x00be, 0x00de, 0x1ff8, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, { 0x0c, false, 0x01be, 0x01de, 0x000e, (char)0xf4, (char)0x0e}, },
	{ { 0x14, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x1ff2, (char)0xf2, (char)0x0c}, { 0x14, false, 0x037f, 0x039f, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, { 0x0c, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, },
	{ { 0x04, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, false, 0x021e, 0x023e, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, true , 0x003e, 0x005e, 0x000e, (char)0x0e, (char)0xf2}, },
	{ { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, { 0x0c, true , 0x009e, 0x00be, 0x1ffa, (char)0xfa, (char)0xf5}, },
	{ { 0x1c, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x1ff8, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, },
	{ { 0x14, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x02c0, 0x02e0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, { 0x14, true , 0x0181, 0x01a1, 0x1ff2, (char)0xf2, (char)0x0c}, },
	{ { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, { 0x04, true , 0x0221, 0x0241, 0x1ff5, (char)0xf5, (char)0x09}, },
	{ { 0x1c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, { 0x14, true , 0x01bf, 0x01df, 0x000c, (char)0x0c, (char)0xfa}, },
	{ { 0x14, true , 0x02a1, 0x02c1, 0x1ff7, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x1ff8, (char)0xf8, (char)0xf6}, { 0x0c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, },
	{ { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, { 0x14, false, 0x0280, 0x02a0, 0x0006, (char)0x07, (char)0x06}, },
	{ { 0x1c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x00ff, 0x011f, 0x17f8, (char)0xfa, (char)0xf8}, },
	{ { 0x1c, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, { 0x0c, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, },
	{ { 0x1c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x001e, 0x003e, 0x000a, (char)0x0a, (char)0xf1}, },
	{ { 0x1c, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x0060, 0x0080, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff7, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x00be, 0x00de, 0x1ff8, (char)0xf8, (char)0xf6}, },
	{ { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, },
	{ { 0x1c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0261, 0x0281, 0x1ff1, (char)0xf1, (char)0x0b}, },
	{ { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, { 0x04, false, 0x02e0, 0x0300, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, { 0x04, true , 0x01c1, 0x01e1, 0x1ff6, (char)0xf6, (char)0x0e}, },
	{ { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, { 0x0c, false, 0x0341, 0x0361, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff7, (char)0xf7, (char)0x0d}, { 0x1c, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, { 0x14, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, },
	{ { 0x1c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x00de, 0x00fe, 0x1ffa, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, { 0x0c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, { 0x1c, true , 0x01e1, 0x0201, 0x0006, (char)0x06, (char)0x0f}, },
	{ { 0x14, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03df, 0x03ff, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, { 0x0c, true , 0x02c1, 0x02e1, 0x1ff3, (char)0xf3, (char)0x0e}, },
	{ { 0x14, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02a1, 0x02c1, 0x1ff7, (char)0xf7, (char)0x0d}, },
	{ { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, { 0x04, false, 0x0361, 0x0381, 0x17fa, (char)0x0f, (char)0xfa}, },
	{ { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02be, 0x02de, 0x1ffa, (char)0xfa, (char)0xf6}, },
	{ { 0x14, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x01a1, 0x01c1, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, { 0x0c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0341, 0x0361, 0x17fa, (char)0x0d, (char)0xfa}, },
	{ { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, { 0x1c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, { 0x1c, true , 0x0121, 0x0141, 0x1ff6, (char)0xf6, (char)0x09}, },
	{ { 0x1c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, { 0x0c, false, 0x00df, 0x00ff, 0x17f7, (char)0xfa, (char)0xf7}, },
	{ { 0x0c, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, },
	{ { 0x14, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x04, false, 0x00e1, 0x0101, 0x17f7, (char)0x0c, (char)0xf7}, { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, { 0x0c, true , 0x0241, 0x0261, 0x1ff3, (char)0xf3, (char)0x0a}, },
	{ { 0x0c, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, { 0x14, false, 0x029e, 0x02be, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, { 0x04, false, 0x0141, 0x0161, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x04, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x0121, 0x0141, 0x17f9, (char)0x0a, (char)0xf9}, },
	{ { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0240, 0x0260, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x0c, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, { 0x14, true , 0x007e, 0x009e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e1, 0x0101, 0x17f7, (char)0x0c, (char)0xf7}, { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0121, 0x0141, 0x1ff4, (char)0xf4, (char)0x09}, },
	{ { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, { 0x14, true , 0x025e, 0x027e, 0x1ff9, (char)0xf9, (char)0xf3}, },
	{ { 0x14, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, { 0x0c, false, 0x00e0, 0x0100, 0x0007, (char)0x06, (char)0x07}, },
	{ { 0x0c, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, },
	{ { 0x14, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, { 0x04, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, { 0x04, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, },
	{ { 0x0c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x0007, (char)0x07, (char)0x06}, },
	{ { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e1, 0x0101, 0x17f7, (char)0x0c, (char)0xf7}, { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, },
	{ { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, { 0x0c, false, 0x025f, 0x027f, 0x17f3, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, { 0x1c, false, 0x00c1, 0x00e1, 0x17f6, (char)0x0a, (char)0xf6}, },
	{ { 0x0c, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, },
	{ { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, { 0x04, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x01ff, 0x021e, 0x1ff9, (char)0xf9, (char)0xf8}, },
	{ { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0220, 0x0240, 0x1ff3, (char)0xf3, (char)0x06}, },
	{ { 0x1c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, { 0x14, true , 0x0060, 0x0080, 0x1ff6, (char)0xf6, (char)0x06}, },
	{ { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e1, 0x0101, 0x17f7, (char)0x0c, (char)0xf7}, },
	{ { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01bf, 0x01df, 0x1ff8, (char)0xf8, (char)0xfa}, },
	{ { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a0, 0x03c0, 0x000d, (char)0x06, (char)0x0d}, },
	{ { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, { 0x14, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, { 0x04, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025e, 0x027e, 0x000d, (char)0x0d, (char)0xf3}, },
	{ { 0x14, true , 0x027e, 0x029e, 0x1ff9, (char)0xf9, (char)0xf4}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, },
	{ { 0x0c, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x14, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, { 0x14, true , 0x029f, 0x02bf, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x04, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0261, 0x0281, 0x1ff3, (char)0xf3, (char)0x0b}, },
	{ { 0x0c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x02e0, 0x0000, 0x1ff7, (char)0xf7, (char)0x07}, },
	{ { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x01e1, 0x0201, 0x17fa, (char)0x0e, (char)0xfa}, },
	{ { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x02bf, 0x02df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x027e, 0x029e, 0x1ff9, (char)0xf9, (char)0xf4}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x0b, (char)0xfa}, },
	{ { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x07, (char)0x0a}, },
	{ { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x027e, 0x029e, 0x1ffa, (char)0xfa, (char)0xf4}, },
	{ { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, { 0x1c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0a, (char)0xf5}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, },
	{ { 0x0c, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, },
	{ { 0x14, true , 0x0260, 0x0280, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x027e, 0x029e, 0x1ff9, (char)0xf9, (char)0xf4}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x04, false, 0x00e1, 0x0101, 0x17f7, (char)0x0e, (char)0xf7}, { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, },
	{ { 0x0c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x0121, 0x0141, 0x17f9, (char)0x0e, (char)0xf9}, },
	{ { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, { 0x0c, true , 0x023e, 0x025e, 0x1ffa, (char)0xfa, (char)0xf2}, },
	{ { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x00a1, 0x00c1, 0x17f5, (char)0x0a, (char)0xf5}, },
	{ { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x0140, 0x0160, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0260, 0x0280, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x027e, 0x029e, 0x1ff9, (char)0xf9, (char)0xf4}, },
	{ { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e1, 0x0101, 0x17f7, (char)0x0e, (char)0xf7}, { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, { 0x0c, true , 0x0121, 0x0141, 0x1ff2, (char)0xf2, (char)0x09}, },
	{ { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0260, 0x0280, 0x1ff5, (char)0xf5, (char)0x06}, },
	{ { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, },
	{ { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01c1, 0x01e1, 0x1ff4, (char)0xf4, (char)0x0e}, },
	{ { 0x14, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, { 0x14, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x04, true , 0x00ff, 0x011e, 0x000e, (char)0x0e, (char)0xf8}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, { 0x0c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x0c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0260, 0x0280, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x1c, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e1, 0x0101, 0x17f7, (char)0x0e, (char)0xf7}, { 0x04, true , 0x011f, 0x013f, 0x000e, (char)0x0e, (char)0xf9}, },
	{ { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x14, false, 0x015f, 0x017e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, },
	{ { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, { 0x1c, false, 0x01c0, 0x01e0, 0x000e, (char)0x06, (char)0x0e}, },
	{ { 0x14, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, { 0x14, true , 0x027f, 0x029f, 0x1ff9, (char)0xf9, (char)0xfa}, },
	{ { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x00ff, 0x011e, 0x000e, (char)0x0e, (char)0xf8}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, { 0x0c, true , 0x0221, 0x0241, 0x1ff3, (char)0xf3, (char)0x09}, },
	{ { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, { 0x14, true , 0x0260, 0x0280, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, { 0x04, false, 0x00e1, 0x0101, 0x17f7, (char)0x0e, (char)0xf7}, },
	{ { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, { 0x0c, true , 0x01bf, 0x01df, 0x1ffa, (char)0xfa, (char)0xfa}, },
	{ { 0x0c, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x015f, 0x017e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, { 0x1c, false, 0x03a1, 0x03c1, 0x17fa, (char)0x09, (char)0xfa}, },
	{ { 0x1c, false, 0x02be, 0x02de, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, { 0x1c, false, 0x0340, 0x0360, 0x000a, (char)0x06, (char)0x0a}, },
	{ { 0x14, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, { 0x14, true , 0x0280, 0x02a0, 0x1ff7, (char)0xf7, (char)0x06}, },
	{ { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf5, (char)0x08}, { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x00ff, 0x011e, 0x000e, (char)0x0e, (char)0xf8}, { 0x04, true , 0x011f, 0x013f, 0x1ffa, (char)0xfa, (char)0xf9}, },
	{ { 0x04, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, true , 0x025e, 0x027e, 0x1ffa, (char)0xfa, (char)0xf3}, },
	{ { 0x0c, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, { 0x1c, false, 0x00e1, 0x0101, 0x17f7, (char)0x0a, (char)0xf7}, },
	{ { 0x14, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x01c1, 0x01e1, 0x0006, (char)0x06, (char)0x0e}, },
	{ { 0x0c, true , 0x00be, 0x00de, 0x0008, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (char)0xfa}, { 0x14, false, 0x015f, 0x017e, 0x17fa, (char)0xf8, (char)0xfa}, { 0x14, false, 0x039f, 0x03bf, 0x17fa, (char)0xf9, (char)0xfa}, },
	{ { 0x1c, true , 0x01a1, 0x01c1, 0x1ff0, (char)0xf0, (char)0x0d}, { 0x1c, false, 0x02be, 0x02de, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x02be, 0x02de, 0x0006, (char)0xf1, (char)0x06}, { 0x0c, false, 0x033e, 0x035e, 0x000a, (char)0xf3, (char)0x0a}, },
	{ { 0x14, true , 0x0261, 0x0281, 0x0006, (char)0x06, (char)0x0b}, { 0x14, false, 0x0180, 0x01a0, 0x000c, (char)0x06, (char)0x0c}, { 0x14, false, 0x017e, 0x019e, 0x000c, (char)0xf2, (char)0x0c}, { 0x14, false, 0x027e, 0x029e, 0x0006, (char)0xf7, (char)0x06}, },
	{ { 0x04, true , 0x02e0, 0x0000, 0x1ff3, (char)0xf3, (char)0x07}, { 0x04, false, 0x02fe, 0x031e, 0x0008, (char)0xf5, (char)0x08}, { 0x04, true , 0x0201, 0x0220, 0x0006, (char)0x06, (char)0x08}, { 0x04, true , 0x00ff, 0x011e, 0x000e, (char)0x0e, (char)0xf8}, },
	{ { 0x04, false, 0x01de, 0x01fe, 0x000f, (char)0xf6, (char)0x0f}, { 0x04, true , 0x01fe, 0x021d, 0x1ffa, (char)0xfa, (char)0xf0}, { 0x04, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, { 0x0c, false, 0x021f, 0x023f, 0x17f1, (char)0xfa, (char)0xf1}, },
	{ { 0x04, false, 0x03c1, 0x03e1, 0x17fa, (char)0x0d, (char)0xfa}, { 0x0c, true , 0x0020, 0x0040, 0x0006, (char)0x06, (char)0x06}, { 0x0c, true , 0x0040, 0x0060, 0x0006, (char)0x06, (char)0x06}, { 0x1c, true , 0x003e, 0x005e, 0x000a, (char)0x0a, (char)0xf2}, },
	{ { 0x0c, true , 0x027f, 0x029f, 0x000b, (char)0x0b, (char)0xfa}, { 0x14, false, 0x0061, 0x0081, 0x17f3, (char)0x0c, (char)0xf3}, { 0x14, true , 0x009e, 0x00be, 0x000c, (char)0x0c, (char)0xf5}, { 0x1c, true , 0x00a0, 0x00c0, 0x0006, (char)0x06, (char)0x06}, },
	{ { 0x1c, false, 0x0320, 0x0340, 0x0009, (char)0x07, (char)0x09}, { 0x0c, true , 0x00be, 0x00de, 0x0008, (char)0x08, (char)0xf6}, { 0x0c, false, 0x0161, 0x0180, 0x17fa, (char)0x08, (