
inline word MakeWord(byte high, byte low)
{
	return word(high)<<8 | word(low);
}

inline void MakeBytesFromWord(word Word, byte& High, byte& Low)
{
	High = byte(Word>>8);
	Low = byte(Word);
}

inline byte& LowByte(word& Word)
{
	return (byte&)Word;
}

inline byte& HighByte(word& Word)
{
	return *(((byte*)&Word)+1);
}

inline byte Half(byte value)
{
	if(char(value) >= 0)
		return value/2;
	else
		return char(value-1)/2;
}

inline void Clamp(byte& value, byte min, byte max)
{
	if(char(value) >= 0)
	{
		if(value > max)
			value = max;
	}
	else
	{
		if(value < min)
			value = min;
	}
}

template<typename T>
T Min(T a, T b)
{
	return a < b ? a : b;
}

template<typename T>
T Max(T a, T b)
{
	return a > b ? a : b;
}

template<typename T>
T Sq(T Value)
{
	return Value * Value;
}

inline word DecimalToBin(byte High, byte Low)
{
	return (High>>4)*1000 + (High&0x0F)*100 + (Low>>4)*10 + (Low&0x0F);
}

inline void BinToDecimal(word Bin, byte& High, byte& Low)
{
	Low = Bin%10;
	Bin /= 10;
	Low |= Bin%10 << 4;
	Bin /= 10;
	High = Bin%10;
	Bin /= 10;
	High |= Bin%10 << 4;
}

inline byte& ShiftLeft(byte& byte, bool& carry)
{
	carry = (byte>>7) != 0;
	byte <<= 1;
	return byte;
}

inline byte& RotateLeft(byte& byte, bool& carry)
{
	bool newcarry = (byte>>7) != 0;
	byte <<= 1;
	if(carry) byte |= 1;
	carry = newcarry;
	return byte;
}

inline byte& ShiftRight(byte& byte, bool& carry)
{
	carry = (byte&1) != 0;
	byte >>= 1;
	return byte;
}

inline byte& RotateRight(byte& byte, bool& carry)
{
	bool newcarry = (byte&1) != 0;
	byte >>= 1;
	if(carry) byte |= 0x80;
	carry = newcarry;
	return byte;
}

inline byte& Add(byte& a, byte b, bool& carry)
{
	int sum = a + int(b) + (carry ? 1 : 0);
	carry = (sum & 0xFF00) != 0;
	a = (byte)sum;
	return a;
}

inline byte& Subtract(byte& a, byte b, bool& carry)
{
	int c = (carry ? 1 : 0) ^ 1;
	int dif = a - int(b) - c;
	carry = (dif & 0xff00) == 0;
	a = (byte)dif;
	return a;
}