#ifdef USE_NETWORK_THREAD

//Wir implementieren einen eigenen Thread, der fr das Empfangen und Senden der Netzwerkpakete zustndig ist
//Das ist von groem Vorteil, weil so...
//Kaum Pakete verloren gehen (sehr wichtig, da unser Spiel sonst schnell asynchron wird)
//Fast immer sinnvolle Pakete gesendet werden knnen
//Unsere Pakete direkt (oder mit fester Verzgerung) nach dem Empfangen eines Pakets gesendet werden knnen

//Damit sind wir fast vllig unabhngig davon, wie schnell die KI rechnet oder ob diese Aussetzer hat und
//werden dem Titel des Wettbewerbs auch ein wenig gerecht;) Zugegebenermaen wird dieser Thread aber 99%
//der Zeit schlafen. Die KI in Threads aufzuteilen knnte einiges bringen, wr wohl aber sehr aufwendig..

//Natrlich muss unser Thread aber mit der KI kommunizieren. Das habe ich mit einem Ringpuffer realisiert.
//Der Netthread schreibt konstant seine empfangenen Pakete nacheinander in den Puffer und fngt wieder
//am Anfang an, wenn das Ende erreicht ist. Davon ausgehend, dass die KI die Daten am Anfang schon
//ausgewertet hat.
//Wenn man die Anwendung mit einem Fenster kompiliert sieht man unten einen kleinen Balken, der anzeigt,
//wie viel vom Ringpuffer belegt ist. Normalerweise sollte dieser fast ganz leer sein, verschiebt man aber
//zB das Fenster und blockiert somit die KI (weil Windows in die eigene Nachrichtenschleife blockiert),
//sieht man, dass der Balken kontinuierlich grer wird, bis das Programm schlielich aufgibt:)

#if !defined _MSC_VER || _MSC_VER < 1400
#error Wir synchronisieren hier mit volatile Variablen. Auf Multicores funktioniert das nur mit VC05 und hher. Andere Compiler untersttzen das soweit ich wei nicht..
#error Der Code wird zwar auch so kompilieren, aber eventuell wirds auf Multicores nicht funktionieren.. Siehe auch MSDN Doku zu "volatile"
#endif


struct NetBufferItem
{
	FramePacket Frame;//Wird vom Netthread gesetzt und von der KI ausgewertet
	bool FrameRecieved;//Ob der Frame angekommen ist. Wenn false, sind die VRam und Ram Member von Frame undefiniert. (die anderen Member geschtzt)
	int ExpectedFramePing;//Der Ping, den Frame enthalten sollte oder -1, falls egal. Falls die Latenz varriert, wird sich der Ping unterscheiden, sonst theoretisch nicht:) Wird von der KI zusammen mit Keys gesetzt
	byte MaxFramePing;//Der maximale (inklusive) Frameping. Frame.Ping ist entsprechend der minimale Wert. Wenn FrameRecieved == true, ist MaxFramePing == Frame.Ping. Wie blich geht der Bereich ber einen Ring.

	byte Keys;//Wird von der KI gesetzt und vom Netthread gesendet. Der Netthread prft nicht, ob der Key aktuell ist! Falls die KI nicht hinterherkommt, sendet der Netthread also die Keys vom letzten Zyklus.
	byte Ping;//Wird mit Keys gesendet und beim Senden vom Netthread fortlaufend durchnummeriert
};

#ifdef _DEBUG
const int NetBufferSize = 40*60;
#else
const int NetBufferSize = 1024;//Entspricht etwa 17 Sekunden. Eine Zweierpotenz ist von Vorteil, weil
							   //dann der Modulo beim Inkrementieren leicht in ein binres Und
							   //optimiert werden kann. Bringt nicht viel, schadet aber auch nicht:)
#endif
const int NetBufferKIFutureSteps = 3*60;//Wie weit die KI ihre Ergebnisse in die Zukunft in den Buffer schreiben soll. Sollte deutlich kleiner als NetBufferSize sein, da sonst eventuell die Keys vom letzten Zyklus berschrieben werden. Es sind keine asserts eingebaut, um das zu prfen!

NetBufferItem NetBuffer[NetBufferSize];//Unser Puffer. Diese Variable muss unbedingt global sein, da wir mit volatile Variablen synchronisieren und der Compiler nur globale Variablen entsprechend behandelt. Siehe auch MSDN Doku zu "volatile".

volatile int NetBufferPosition = 0;//Dieses Item behandelt gerade der NetThread. Diese Position wird zeitlich sehr gleichmig durchgegangen. (So, wie der Server die Pakete schickt)
volatile int KINetBufferPosition = 0;//Bis zu welcher Position+1 sich die KI durchgearbeitet hat. Diese Position nhert sich immer der oberen an, stottert aber, da die KI machnmal etwas langsam ist.
volatile int NetDelay = 0;//Zeit in Millisekunden, die nach dem Empfangen eines Pakets gewartet werden soll, bis das nchste Paket gesendet wird.
volatile bool NetworkThreadExit = false;
CriticalSection NetBufferPositionLock;

//Gibt das Paket mit dem angegebenen Ping zurck, das zuletzt abgeschickt wurde
NetBufferItem& NetItemFromPing(byte Ping, int Current, int* pLatency = 0, int* pLatencyPosition = 0)
{
	//Wir nutzen aus, dass die Pings fortlaufend nummeriert abgeschickt werden
	int Latency = byte(NetBuffer[Current].Ping - Ping);
	int LatencyPosition = (Current - Latency + NetBufferSize) % NetBufferSize;

	assert(NetBuffer[LatencyPosition].Ping == Ping || NetBuffer[LatencyPosition].Keys == 0x80);

	if(pLatency)
		*pLatency = Latency;
	if(pLatencyPosition)
		*pLatencyPosition = LatencyPosition;

	return NetBuffer[LatencyPosition];
}

void NetworkThread(void*)
{
	SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_HIGHEST);

	KeysPacket Keys;
	memcpy(Keys.Signature, "ctmame", 6);

	byte CurrentPing = 0;

	//std::ofstream log("NetThreadLog.txt");

#ifdef WRITE_FRAMES
	std::ofstream out("AsteroidsSave.dat", std::ios::binary);
#elif defined READ_FRAMES
	std::ifstream in("AsteroidsSave.dat", std::ios::binary);
#endif

	bool First = true;

	while(!NetworkThreadExit)
	{
		int NetBufferPositionCopy = NetBufferPosition;
		NetBufferItem& Item = NetBuffer[NetBufferPositionCopy];
		NetBufferItem& LastItem = NetBuffer[(NetBufferPositionCopy-1+NetBufferSize) % NetBufferSize];

#ifdef INCLUDE_WINDOW
		//Falle der Benutzer meint, er sei besser als unsere KI
		if(GetForegroundWindow() == hwnd)
		{
			if(GetAsyncKeyState('Q') < 0)
				Item.Keys |= Key_Left;
			if(GetAsyncKeyState('W') < 0)
				Item.Keys |= Key_Right;
			if(GetAsyncKeyState('I') < 0)
				Item.Keys |= Key_Thrust;
			if(GetAsyncKeyState('O') < 0)
				Item.Keys |= Key_Fire;
			if(GetAsyncKeyState(VK_SPACE) < 0)
				Item.Keys |= Key_Hyperspace;
		}
#endif

		Item.Ping = CurrentPing++;
		Keys.Keys = Item.Keys;
		Keys.Ping = Item.Ping;
	//	log<<"["<<int(NetBufferPositionCopy)<<"] Sende Keys: "<<int(Keys.Keys)<<"  Ping: "<<int(Keys.Ping)<<"    ";
		int r = sendto(ServerSocket, (char*)&Keys, sizeof(KeysPacket), 0,
					   (sockaddr*)&ServerAddress, sizeof(ServerAddress));
		if(r != sizeof(KeysPacket))
			printf("Fehler beim Senden (%i)\n", WSAGetLastError());

//		log.flush();


#ifdef INCLUDE_WINDOW
		//Belegung des Ringpuffers anzeigen
		//Das sollte man hier direkt vor recv machen, da recv eh blockiert und wir hier
		//wahrscheinlich etwas Zeit haben
		HDC hdc = GetDC(hwnd);
		RECT rc;
		SetRect(&rc,
			0,
			cyClient-10,
			(NetBufferPosition-KINetBufferPosition+NetBufferSize) % NetBufferSize * cxClient / NetBufferSize,
			cyClient);
		FillRect(hdc, &rc, (HBRUSH)GetStockObject(BLACK_BRUSH));
		ReleaseDC(hwnd, hdc);
#endif

RecievePacketAgain:
		r = recv(ServerSocket, (char*)&Item.Frame, sizeof(FramePacket), 0);
		if(r != sizeof(FramePacket))
		{
			r -= 2;
			if(r > 127)
				r = 127;
			if(r < 0)
				r = 0;
			char Buffer[128];
			memcpy(Buffer, (void*)&Item.Frame, r);
			Buffer[r] = 0;
			printf("Server: \"%s\" (Code: %i)\n", Buffer, WSAGetLastError());
			//Sleep(500);
			//continue;
			break;
		}

#ifdef WRITE_FRAMES
		out.write((char*)&Item.Frame, sizeof(Item.Frame));
		out.flush();
#elif defined READ_FRAMES
		in.read((char*)&Item.Frame, sizeof(Item.Frame));
		if(in.fail())
			return;
#endif

//		log<<"Empfange Ping: "<<int(Item.Frame.Ping)<<" No: "<<int(Item.Frame.FrameNo)<<"\n";

		if(!First && Item.Frame.FrameNo != byte(LastItem.Frame.FrameNo + 1))
		{
			char RelNo = char(byte(Item.Frame.FrameNo - byte(LastItem.Frame.FrameNo + 1)));
			//MessageBeep(0);
			if(RelNo > 0)
			{
				printf("%i Frames vom Server verloren. Eventuell stuerzt das Programm bald ab, da Informationen fehlen..\n", RelNo);
				//Versuchen wir zu retten, was zu retten ist, indem wir Fakepakete einsetzen, die wir nicht empfangen haben
				//Zugegebenermaen ist der Code hier ziemlich unbersichtlich..

				Item.FrameRecieved = false;
				Item.Frame.FrameNo = LastItem.Frame.FrameNo+1;
				Item.MaxFramePing = Item.Frame.Ping;
				int NewPosition = (NetBufferPositionCopy+RelNo) % NetBufferSize;
				while(NetBufferPositionCopy != NewPosition)
				{
					NetBufferPositionCopy = (NetBufferPositionCopy+1) % NetBufferSize;
					NetBuffer[NetBufferPositionCopy].Frame.Ping = LastItem.Frame.Ping;
					NetBuffer[NetBufferPositionCopy].MaxFramePing = Item.Frame.Ping;
#ifdef INCLUDE_EXTRA_FRAME_INFO
					NetBuffer[NetBufferPositionCopy].Frame.LastRecvKeys = LastItem.Frame.LastRecvKeys;
#endif
					NetBuffer[NetBufferPositionCopy].Frame.FrameNo = ++Item.Frame.FrameNo;
					NetBuffer[NetBufferPositionCopy].FrameRecieved = false;
					NetBuffer[NetBufferPositionCopy].Ping = CurrentPing++;
					NetBuffer[NetBufferPositionCopy].Keys = Item.Keys;//Hierauf sollte eigentlich nicht zugegriffen werden (vom anderen Thread), da der entsprechende Ping nicht gesendet wurde
				}
				NetBuffer[NetBufferPositionCopy].Frame = Item.Frame;
				Item.Frame.FrameNo = LastItem.Frame.FrameNo+1;
				Item.Frame.Ping = LastItem.Frame.Ping;
#ifdef INCLUDE_EXTRA_FRAME_INFO
				Item.Frame.LastRecvKeys = LastItem.Frame.LastRecvKeys;
#endif
			}
			else
			{
				//Das ist in meinen Tests nie passiert (zumindest hab ichs nicht bemerkt)
				//Heit also, dass hier wahrscheinlich Bugs sind:)
				int CorrectPosition = (NetBufferPositionCopy+RelNo+NetBufferSize) % NetBufferSize;
				if(NetBuffer[CorrectPosition].FrameRecieved)
					printf("Frame von vor %i Frames ist vom Server doppelt angekommen\n", -RelNo);
				else
					printf("Frame von vor %i Frames ist vom Server in falscher Reihenfolge angekommen\n", -RelNo);
				NetBuffer[CorrectPosition].Frame = (FramePacket&)Item.Frame;
				NetBuffer[CorrectPosition].FrameRecieved = true;
				NetBuffer[CorrectPosition].MaxFramePing = NetBuffer[CorrectPosition].Frame.Ping;
				goto RecievePacketAgain;
			}
		}
		NetBuffer[NetBufferPositionCopy].FrameRecieved = true;
		NetBuffer[NetBufferPositionCopy].MaxFramePing = NetBuffer[NetBufferPositionCopy].Frame.Ping;

		if(First)
		{
			char Buffer[38] = {0};
			strcpy_s(Buffer, 38, "ctnameHelmut Buhler");
			r = sendto(ServerSocket, Buffer, sizeof(Buffer), 0,
				(sockaddr*)&ServerAddress, sizeof(ServerAddress));
			if(r != sizeof(Buffer))
				printf("Fehler beim Senden des Namens (%i)\n", WSAGetLastError());
			First = false;
		}


		if((NetBufferPositionCopy+1) % NetBufferSize == KINetBufferPosition)
		{
			printf("KI rechnet zu lange: Netzwerkpuffer ist voll. Beende.\n");
			break;
		}

		if(NetDelay)
			Sleep(NetDelay);


		{
			CriticalSectionLocker l = NetBufferPositionLock;
			NetBufferPosition = (NetBufferPositionCopy+1) % NetBufferSize;
		}
	}
	NetworkThreadExit = true;
}

#endif
