//KI fr Asteroids, die bers Netzwerk mit einem Mame verbunden ist.
//Aufbauend auf dem Beispielsprogramm von Harald Bgeholz / c't, allerdings drfte davon nicht
//mehr viel brig geblieben sein:)
//Programmiert von Helmut Buhler

//Die KI hat grob die folgenden Features:
//Erkennung des internen Zustands von Asteroids
//Abschuss von Asteroiden, die zum Zeitpunkt des Schusses noch nicht existieren
//Abschuss von UFOs, wobei schon geschossen wird, wenn es noch nicht aufgetaucht ist, wenn es Sinn macht
//Nutzung von Hyperspace, um sich gezielt in eine Position zu beamen, die von Vorteil ist, oder wenn man sonst sterben wrde
//Auswahl des nchsten Asteroiden nach frhestem Kollisionszeitpunkt
//Optimierung der Asteroidenabschussreihenfolge nach der Zeit, zu dem der letzte Asteroid explodiert (leider noch deaktiviert)
//Kommt theoretisch mit Paketverlusten und groen Pingzeiten klar, verschlechtert sich aber deutlich, wenn sich die Latenz auch nur ein wenig ndert.


#include <winsock2.h>
#include <windows.h>
#include <process.h>
#include <math.h>
#include <vector>
#include <set>
#include <fstream>
#include <iomanip>
#include <stack>

#pragma comment(lib, "Ws2_32.lib")

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned int uint;
const int MaxInt = 0x7FFFFFFF;

#include "Defines.h"
#include "RandomSeeds.h"
#include "AsteroidStartPositions.h"
#include "ShipDirections.h"
#include "Math.h"

inline void assert(bool b)
{
#ifdef INCLUDE_ASSERTS
	if(b)
#endif
		return;
	printf("Assertion fehlgeschlagen!\n");
	while(true)
		;
	MessageBox(0, "Assertion fehlgeschlagen..", "Asteroids KI", 0);
}

inline void SetTrue(bool& x)//Zum Debuggen
{
	x = true;
}

#define VRamAssert(x, y) do{if(!(x)){SetTrue(y); return true;}}while(false)

template<typename T>
void assert(bool b, const T& Exc)
{
	if(!b)
		throw Exc;
}

/*
class VRamInvalidException//War beim Debuggen zu langsam
{
};
*/
class KIGameInvalidException
{
};

class RamInvalidException
{
};

#include "BitArray.h"

enum Direction
{
	Dir_Left,
	Dir_None,
	Dir_Right
};

enum
{
	Key_Hyperspace = 1,
	Key_Fire = 2,
	Key_Thrust = 4,
	Key_Right = 8,
	Key_Left = 16
};

inline byte KeyFromDirection(Direction Dir)
{
	if(Dir == Dir_Left)
		return Key_Left;
	else if(Dir == Dir_Right)
		return Key_Right;
	else
		return 0;
}

//Das Slotsystem von Asteroids:
const int cAsteroids = 27;
const int cPlayerShots = 4;
const int cSaucerShots = 2;

enum
{
	AsteroidMinIndex,
	AsteroidMaxIndex = AsteroidMinIndex+cAsteroids-1,
	PlayerIndex,
	SaucerIndex,
	SaucerShotMinIndex,
	SaucerShotMaxIndex = SaucerShotMinIndex+cSaucerShots-1,
	PlayerShotMinIndex,
	PlayerShotMaxIndex = PlayerShotMinIndex+cPlayerShots-1,
	NumObjects
};

const int ShotLifetime = 0x12 * 4;//Ein Shot kann so lange maximal berleben.
const int RotationSpeed = 3;

//Bewegt die x Komponente eines Objekts um Steps Zeiteinheiten
inline word MoveLinearX(word PositionX, char VelocityX, int Steps)
{
	assert(Steps >= 0);
	if(Steps == 0)
		return PositionX;
	else
		return (PositionX + VelocityX*Steps) & 0x1FFF;
	/*	word oldPositionX = PositionX;
	for(int i = 0; i < Steps; i++)
	{
	PositionX += char(VelocityX);
	if(PositionX >= 0x2000)//Objekt geht rechts raus
	{
	PositionX &= 0x1FFF;//links wieder rein
	}
	}
	if(PositionX != ((oldPositionX+char(VelocityX)*Steps)&0x1FFF))
	VRamAssert(0);
	return PositionX;*/
}

//Bewegt die y Komponente eines Objekts um Steps Zeiteinheiten
inline word MoveLinearY(word PositionY, char VelocityY, int Steps)
{
	assert(Steps >= 0);
	if(Steps == 0)
		return PositionY;
	//const word PositionYIn = PositionY;
	//word oldPositionY = PositionY;

	PositionY += VelocityY;
	if((PositionY & 0xFF00) == 0x1800)//Objekt geht unten raus
		PositionY = 0x0000 | (PositionY & 0x00FF);
	else if(PositionY >= 0x1800)
		PositionY = 0x1700 | (PositionY & 0x00FF);

	PositionY += VelocityY*(Steps-1);
	if(VelocityY >= 0)
	{
		while(PositionY >= 0x1800)
			PositionY -= 0x1800;
	}
	else
		while(PositionY >= 0x1800)
			PositionY += 0x1800;
	return PositionY;

/*	for(int i = 0; i < Steps; i++)
	{
		oldPositionY += VelocityY;
		if((oldPositionY & 0xFF00) == 0x1800)//Objekt geht unten raus
		{
			oldPositionY = 0x0000 | (oldPositionY&0x00FF);
		}
		else if(oldPositionY >= 0x1800)
		{
			oldPositionY = 0x1700 | (oldPositionY&0x00FF);
		}
	}
	if(PositionY != oldPositionY)
		VRamAssert(0);
	return PositionY;*/
}

//Gibt einen geplanten Schuss auf ein Objekt an
//Wird mit Gamestate::GetKeyFromShotInfo() wieder in Tastendrcke umgewandelt
class ShotInfo
{
public:
	int Time;//Zu welchem Zeitpunkt geschossen wird
	Direction Dir;//In welche Richtung muss man sich fr diesen Schuss vom letzten Schuss aus bewegen?
	byte TargetDirection;//Diese Richtung muss unser Schiff einnehmen, um zu schieen
	int CollisionTime;//Wann wird der Schuss treffen?
	int RotationWasLockedAtTime;//Wenn der Spieler bis zum Schusszeitpunkt gestorben ist der Zeitpunkt. Ansonsten -1

	//Debuggingzeugs:
	int ShotIndex;
	word PositionX, PositionY;
	int Target;
	word StartX, StartY;
	char VelocityX, VelocityY;
	word TargetPositionX, TargetPositionY;
	char TargetStatus;
	byte StartDirection;
public:
	ShotInfo()
	{
		Time = MaxInt;//Kein Schuss
	}
	int TargetXEasy() const
	{
		return int(StartX)+int(VelocityX)*(CollisionTime-Time);
	}
	int TargetYEasy() const
	{
		return int(StartY)+int(VelocityY)*(CollisionTime-Time);
	}
};

//Gibt eine Reihe von Schssen an, die wir in der Zukunft abschieen wollen
//Die Liste ist nach Abschusszeitpunkt sortiert, wird aber in Kollisionsreihenfolge
//aufgebaut. Das ist sehr wichtig, da sonst eine korrekte Berechnung der Trmmer unmglich
//wre, da sich bei jeder Kollision der Seed verndert.
//Glcklicherweise wird Rand() nicht aufgerufen, wenn geschossen wird. Sonst wr das
//alles hier frn ##..:)
class ShotInfoList
{
	int MaxCollisionTime;//Der Zeitpunkt, zu dem alle Ziele der Schsse getroffen wurden. Danach minimieren wir.
	std::vector<ShotInfo> ShotInfos;
public:
	ShotInfoList()
	{
		MaxCollisionTime = 0;

		ShotInfo Shot;
		Shot.Time = MaxInt;
		Shot.Dir = Dir_None;
		Shot.TargetDirection = 0;
		ShotInfos.push_back(Shot);
		ShotInfos.push_back(Shot);
	}

	const ShotInfo& operator [](int Index) const
	{
		return ShotInfos[Index];
	}

	bool operator <(const ShotInfoList& rhs) const
	{
/*		if(!Bad && rhs.Bad)
			return true;
		if(Bad && !rhs.Bad)
			return false;*/
		return MaxCollisionTime < rhs.MaxCollisionTime;
	}

	bool SameMovement(const ShotInfoList& rhs) const
	{
		//Gibt true zurck, wenn der Spielstatus um ShotInfos[0].Time+1 bei beiden gleich ist
		if(this == &rhs)
			return true;
		if(ShotInfos[0].Time == MaxInt && rhs.ShotInfos[0].Time == MaxInt)
			return true;
		return ShotInfos[0].Time == rhs.ShotInfos[0].Time &&
			   ShotInfos[0].TargetDirection == rhs.ShotInfos[0].TargetDirection &&
			   (ShotInfos[0].TargetDirection == ShotInfos[1].TargetDirection ? Dir_None : ShotInfos[1].Dir) == (rhs.ShotInfos[0].TargetDirection == rhs.ShotInfos[1].TargetDirection ? Dir_None : rhs.ShotInfos[1].Dir);
	}

	size_t size() const
	{
		return ShotInfos.size();
	}

	int GetMaxCollisionTime() const
	{
		return MaxCollisionTime;
	}

	void DeleteFirst()
	{
		ShotInfos.erase(ShotInfos.begin());
	}

	void AddShot(const ShotInfo& Shot, int Index, bool CrossedNextDir)
	{
		ShotInfos.insert(ShotInfos.begin()+Index, Shot);

		assert(Shot.CollisionTime >= MaxCollisionTime);
		MaxCollisionTime = Shot.CollisionTime;

		if(ShotInfos[Index+1].Time != MaxInt && CrossedNextDir)
		{
#ifdef PRINT_DEBUG_INFO
			printf("Aendere Richtung!\n");
#endif
			if(Shot.Dir == Dir_Left)
				ShotInfos[Index+1].Dir = Dir_Right;
			else
			{
				assert(Shot.Dir == Dir_Right);
				ShotInfos[Index+1].Dir = Dir_Left;
			}
		}

#ifdef PRINT_DEBUG_INFO
		printf("%sSchiesse mit Slot %i um %i auf %x! Kol: t=%i Dir: %i->%i\n",
			ShotInfos[Index+1].Time != MaxInt ? "[Sek]" : "",
			Shot.ShotIndex-PlayerShotMinIndex,
			Shot.Time,
			Shot.Target,
			Shot.CollisionTime,
			Shot.StartDirection,
			Shot.TargetDirection);
#endif
	}
};

//Wir erstellen gleichzeitig mehrere Shotlisten, von denen sich alle ein
//wenig unterscheiden. So kann es passieren, dass sich Schusslisten, die
//nach den ersten Schssen weniger gut sind, ber die Zeit doch durchsetzen,
//weil sie langfristig besser wegkommen.
std::multiset<ShotInfoList> ShotInfosVariety;

inline int NeededRotation(byte StartDir, byte GoalDir, Direction Dir)
{
	if(Dir == Dir_None)
	{
		//assert(StartDir == GoalDir);
		return 0;
	}
	int DeltaDir = 0;
	while(byte(StartDir+DeltaDir) != GoalDir)
		DeltaDir += (Dir == Dir_Left ? RotationSpeed : -RotationSpeed);
	return DeltaDir;
}

inline int NeededRotationTime(byte StartDir, byte GoalDir, Direction Dir)
{
	if(Dir == Dir_None)
	{
		assert(StartDir == GoalDir);
		return 0;
	}
	int DeltaDir = 0;
	int Time = 0;
	while(byte(StartDir+DeltaDir) != GoalDir)
	{
		DeltaDir += (Dir == Dir_Left ? RotationSpeed : -RotationSpeed);
		Time++;
	}
	return Time;
}


enum MovePositionType
{
	MPT_Start,
	MPT_Shoot,
	MPT_DoHyperSpace,
	MPT_UpdateSaucer,
	MPT_ObjectCollision,
	MPT_ResetAsteroids,
	MPT_NewGame
};

//MovePosition gibt eine Codestelle innerhalb der Gamestate::Move() Methode an.
//Wir speichern diese, wenn wir den Bereich einer unscharfen Variable eingrenzen mssen,
//um genau an der Stelle wieder weiterrechnen zu knnen.
template<typename T>
class MovePosition_
{
public:
	T Game;
	MovePositionType Type;
	bool SkipRemainingIfSuccessful;//Wenn das Spiel funktioniert hat, mit dem weiter gerechnet wurde,
								   //kann dieses Spiel nicht funktionieren. Man kann es also gleich ignorieren.

	int CollisionCauser, Target;//Wenn Type == MPT_ObjectCollision
public:
	MovePosition_(MovePositionType Type, bool SkipRemainingIfSuccessful)
	{
		this->Type = Type;
		this->SkipRemainingIfSuccessful = SkipRemainingIfSuccessful;
	}
};

//Kleiner Hack, damit wir die vielen Methoden von GameState, die diese Klasse benutzen, nicht auerhalb
//der Klasse implementieren mssen. Bitte nicht nachmachen;)
typedef MovePosition_<class GameState> MovePosition;

#include "Object.h"

//Speichert den Zustand aller Objekte fr die KI
class ObjectsState
{
public:
	int StartTime, ValidUntilTime;
	int CollisionCauser;
	int DestroyedObject;
	int CountExtraSlots;
	Object Objects[NumObjects];
};

std::vector<ObjectsState>* pObjectsStates = 0;
bool ValidateKIGame = false;
extern volatile int NetDelay;
word HyperSpaceTargetX, HyperSpaceTargetY = 0xffff;


int AverageLatency = 0;//Hat mit dem Netthread nichts zu tun. Wird nur von der KI benutzt.
void UpdateLatency(int Latency)
{
//	printf("Latenz: %i\n", Latency);
	static int LatencySum = 0;
	static int Counter = 0;
	LatencySum += Latency;
	if(++Counter == 60)
	{
		AverageLatency = LatencySum/60;
		LatencySum = 0;
		Counter = 0;
	}
}


int NetworkQuality = 0;//Wie viel Prozent der Pakete zur richtigen Zeit beim Server ankommen
void UpdateNetworkQuality(bool CorrectArrived)
{
	static int QualitySum = 0;
	static int Counter = 0;
	if(CorrectArrived)
		QualitySum++;
	if(++Counter == 100)
	{
		NetworkQuality = QualitySum;
		QualitySum = 0;
		Counter = 0;
	}
}

#include "GameState.h"

#include "KI.h"

class CriticalSection
{
	CRITICAL_SECTION cs;
	friend class CriticalSectionLocker;
public:
	CriticalSection()
	{
		InitializeCriticalSection(&cs);
	}
	~CriticalSection()
	{
		DeleteCriticalSection(&cs);
	}
private:
	CriticalSection(CriticalSection&);
	void operator=(CriticalSection& m);
};

class CriticalSectionLocker
{
	CRITICAL_SECTION* cs;
public:
	CriticalSectionLocker(CriticalSection& m)
	{
		cs = &m.cs;
		EnterCriticalSection(cs);
	}
	~CriticalSectionLocker()
	{
		LeaveCriticalSection(cs);
	}
private:
	CriticalSectionLocker(CriticalSectionLocker&);
	void operator=(CriticalSectionLocker& m);
};




#ifdef INCLUDE_WINDOW
HWND hwnd;
int cxClient, cyClient;

std::vector<GameState> GamesHistory;
int CurrentGameHistory = -1;

LRESULT CALLBACK WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);

#endif


std::vector<GameState> VRamGames;
sockaddr_in ServerAddress;
SOCKET ServerSocket;

#pragma pack(1)

//Wir senden dieses Paket zum Server
struct KeysPacket
{
	char Signature[6];
	byte Keys;
	byte Ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.
};

//Dieses Paket schickt uns der Server
struct FramePacket
{
	word VRam[512];
	byte FrameNo;  //Wird bei jedem Frame inkrementiert
	byte Ping;     //Der Server schickt das letzte empfangene ping-byte zurck
#ifdef INCLUDE_EXTRA_FRAME_INFO
	byte Ram[0x300];//Der interne Speicher von Asteroids. Das Mame im Wettbewerb sendet das natrlich nicht. Diente nur zum Debugging
	byte LastRecvKeys;
#endif
};

#pragma pack()

#include "NetworkThread.h"


void MoveVRamGames(byte* LastKeysArray, int cKeys, const word* CurrentVRam, const byte* LastRam,
				   int& LastVRamScore, int& LastVRamNumShips, GameState* pKIGame)
{
	if(VRamGames.empty())
		return;
	assert(cKeys >= 1);
	int NewVRamScore = -1, NewVRamNumShips;
	std::vector<GameState> NewVRamGames;

	for(size_t i = 0; i < VRamGames.size(); i++)
	{
		//printf("VRam Move %i\n", i);
		for(int j = 1; j < cKeys; j++)
			GameState(VRamGames[i]).VRamMove(LastKeysArray[j], CurrentVRam, LastRam, NewVRamGames, LastVRamScore, LastVRamNumShips, NewVRamScore, NewVRamNumShips, pKIGame);
		VRamGames[i].VRamMove(LastKeysArray[0], CurrentVRam, LastRam, NewVRamGames, LastVRamScore, LastVRamNumShips, NewVRamScore, NewVRamNumShips, pKIGame);
	}

	if(VRamGames[0].IsPlaying())
	{
		if(NewVRamGames.empty())
		{
			printf("Spiel ist asynchron geworden:( Wir muessen leider aufgeben.\n");
			return;
		}
		VRamGames = NewVRamGames;

		bool OredSomething = false;
		for(size_t i = 0; i < VRamGames.size(); i++)
		for(size_t j = 0; j < i; j++)
			if(VRamGames[j].CanBeOredWith(VRamGames[i]))
			{
				VRamGames[j] |= VRamGames[i];
				OredSomething = true;
				VRamGames.erase(VRamGames.begin()+i);
				i--;
				break;
			}
		if(OredSomething)
			for(size_t i = 0; i < VRamGames.size(); i++)
				VRamGames[i].RandomSeedDistribution.UpdateInternalData();
	}

	LastVRamScore = NewVRamScore;
	LastVRamNumShips = NewVRamNumShips;
}

//Kleine Hilfsfunktion
bool IsSet(byte* Array, int Size, byte SearchFor)
{
	for(int i = 0; i < Size; i++)
		if(Array[i] == SearchFor)
			return true;
	return false;
}

int main(int cArgs, char** Args)
{

#ifdef INCLUDE_WINDOW
	WNDCLASS wndclass;
	wndclass.style         = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc   = WndProc;
	wndclass.cbClsExtra    = 0;
	wndclass.cbWndExtra    = 0;
	wndclass.hInstance     = GetModuleHandle(0);
	wndclass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
	wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName  = NULL;
	wndclass.lpszClassName = "Asteroids";
	RegisterClass(&wndclass);

	HWND hwnd = CreateWindow("Asteroids", "Asteroids KI - von Helmut Buhler",
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT,
		800, 600,
		NULL, NULL, GetModuleHandle(0), NULL);

	ShowWindow(hwnd, SW_SHOW);
#endif

	WSADATA wsadata;
	if(WSAStartup(MAKEWORD(2,2), &wsadata))
	{
		printf("Fehler beim Initialisieren von Winsock.\n");
		return 1;
	}

	ServerSocket = socket(AF_INET, SOCK_DGRAM, 0);
	if(ServerSocket == INVALID_SOCKET)
	{
		printf("Fehler %d bei socket().\n", WSAGetLastError());
		return 1;
	}

	memset(&ServerAddress, 0, sizeof(ServerAddress));
	ServerAddress.sin_family = AF_INET;
	ServerAddress.sin_addr.s_addr = 0;
	ServerAddress.sin_port = 0;

	if(bind(ServerSocket, (sockaddr*)&ServerAddress, sizeof(ServerAddress)))
	{
		printf("Fehler %d bei bind().\n", WSAGetLastError());
		return 1;
	}

	ServerAddress.sin_port = htons(1979);
//	ServerAddress.sin_addr.s_addr = inet_addr("193.99.145.178");
//	ServerAddress.sin_addr.s_addr = inet_addr("192.168.178.4");
//	ServerAddress.sin_addr.s_addr = inet_addr("192.168.178.42");

#ifdef INCLUDE_WINDOW
	printf("Achtung: Diese Version zeigt zusaetzlich ein Fenster an und ist deshalb\n"
		"etwas langsamer. Bitte fuer den Wettbewerb die andere Version starten.\n"
		"Ansonsten kann man mit dem Fenster auch die Steuerung der KI ueberschreiben\n"
		"und mit der Maus eine Stelle waehlen, wo sich das Schiff hinbeamen soll.\n");
#endif

	if(cArgs >= 2)
	{
		ServerAddress.sin_addr.s_addr = inet_addr(Args[1]);
		if(ServerAddress.sin_addr.s_addr == INADDR_NONE)
		{
			printf("Loese Host \"%s\" auf...\n", Args[1]);
			HOSTENT* he = gethostbyname(Args[1]);
			if(!he)
			{//Adresse ist weder eine richtige IP, noch ein Hostname
				printf("Die Adresse \"%s\" konnte nicht aufgeloest werden.\n", Args[1]);
				return 1;
			}
			ServerAddress.sin_addr.s_addr = *((DWORD*)he->h_addr);
		}
	}
	else
	{
		printf("Geben Sie eine IP oder einen Host als Parameter an.\n");
		ServerAddress.sin_addr.s_addr = inet_addr("127.0.0.1");
	}
	printf("Verbinde mit %s...\n", inet_ntoa(ServerAddress.sin_addr));


	int t = 0;

	VRamGames.resize(1);
	VRamGames[0].StartNewGame();

	ShotInfosVariety.insert(ShotInfoList());

#ifdef USE_NETWORK_THREAD
	//std::ofstream log("KILog.txt");
	int LatencyPosition = -1;
	int Latency = 0;
#else

#ifdef WRITE_FRAMES
	std::ofstream out("AsteroidsSave.dat", std::ios::binary);
#elif defined READ_FRAMES
	std::ifstream in("AsteroidsSave.dat", std::ios::binary);
#endif

	KeysPacket Keys;
	memcpy(Keys.Signature, "ctmame", 6);
	Keys.Keys = Keys.Ping = 0;
	FramePacket LastFrame;

#endif

	int LastVRamScore = -1, LastVRamNumShips;

	GameState KIGame;
	KIGame.SetTime(0);


#ifdef USE_NETWORK_THREAD
	for(int i = 0; i < NetBufferSize; i++)
	{
		NetBuffer[i].Keys = 0x80;
		NetBuffer[i].ExpectedFramePing = -1;
	}

	_beginthread(NetworkThread, 0, 0);
#endif


	while(true)
	{
#ifdef INCLUDE_WINDOW
		MSG msg;
		while(PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
		{
			if(msg.message==WM_QUIT)
				return 0;//Eigentlich mssten wir hier den Netzwerkthread noch sauber beenden, aber ich berlass das dann doch lieber Windows:)
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}

		if(CurrentGameHistory != -1)
		{
			//Wenn wir uns einen alten Frame anschauen pausieren wir mal die KI,
			//damit das Fenster schneller reagiert
			WaitMessage();
			continue;
		}
#endif

#ifdef USE_NETWORK_THREAD
		if(NetworkThreadExit)
		{
			if(VRamGames[0].GetScore())
				printf("Erreichter Score: %i\n", VRamGames[0].GetScore());
			break;
		}
		//Hier prfen wir die VRams, die seit dem letzten Durchlauf empfangen wurden.
		const int NetBufferPositionCopy = NetBufferPosition;//Kopie von volatile Variablen, da etwas schneller und Raceconditions vermieden werden
		while(KINetBufferPosition != NetBufferPositionCopy)
		{
			const int KINetBufferPositionCopy = KINetBufferPosition;
			NetBufferItem& Current = NetBuffer[KINetBufferPositionCopy];
			if(t >= 1)
			{
				NetBufferItem& Last = NetBuffer[(KINetBufferPositionCopy-1+NetBufferSize) % NetBufferSize];

				byte Keys[32];//Die mglichen Keys, die beim aktuellen Frame wirksam waren.
				int cKeys = 0;//Wenn keine Pakete verloren gingen, wird cKeys == 1 sein.

				for(byte Ping = Last.Frame.Ping; Ping != byte(Last.MaxFramePing+1); Ping++)
				{
					byte CurrentKeys = NetItemFromPing(Ping, KINetBufferPositionCopy, &Latency, &LatencyPosition).Keys;
					if(!IsSet(Keys, cKeys, CurrentKeys))
						Keys[cKeys++] = CurrentKeys;
				}
				assert(cKeys <= 32);
				UpdateLatency(Latency-1);

				if(Last.FrameRecieved)
					assert(Last.Frame.Ping == Last.MaxFramePing && cKeys == 1);
#ifdef INCLUDE_EXTRA_FRAME_INFO
				assert(t < 10 || IsSet(Keys, cKeys, Last.Frame.LastRecvKeys));
#endif
				assert(Current.Frame.FrameNo == byte(Last.Frame.FrameNo + 1));//Das wird vom Netzwerkthread garantiert

//				if(t > 60 && Current.Frame.Ping != byte(Last.Frame.Ping + 1))
				if(Current.ExpectedFramePing != -1 &&
					Current.Frame.Ping != Current.ExpectedFramePing)
				{
					UpdateNetworkQuality(false);
					printf("Paket ist falsch angekommen. ");
					if(char(byte(Current.ExpectedFramePing - Current.Frame.Ping)) > 0)
						printf("%i zu spaet. ", byte(Current.ExpectedFramePing - Current.Frame.Ping));
					else
						printf("%i zu frueh. ", byte(Current.Frame.Ping - Current.ExpectedFramePing));
					byte ArrivedKeys = NetItemFromPing(Current.Frame.Ping, KINetBufferPositionCopy).Keys;
					byte ExpectedKeys = NetItemFromPing(Current.ExpectedFramePing, KINetBufferPositionCopy).Keys;
					if(ArrivedKeys == ExpectedKeys)
						printf("Gleicher Key!\n");
					else
					{
						printf("Key: %i != %i !\n", ArrivedKeys, ExpectedKeys);
						//MessageBeep(0);
					}
				}
				else
					UpdateNetworkQuality(true);

				//printf("Eigener Frame: Hash: %x\n", Game.GetHash());
				//printf("Move Key: %i\n", LastKeys);
				MoveVRamGames(Keys, cKeys,
					Current.FrameRecieved ? (const word*)Current.Frame.VRam : 0,
#ifdef INCLUDE_EXTRA_FRAME_INFO
					Last.FrameRecieved ? (const byte*)Last.Frame.Ram : 0,
#else
					0,
#endif
					LastVRamScore, LastVRamNumShips, &KIGame);///////////////////cast

				//GamesHistory.push_back(Game);
			}
			KINetBufferPosition = (KINetBufferPositionCopy+1) % NetBufferSize;
			t++;
		}



		if(LatencyPosition != -1 && t >= 3 && KIGame.GetTime() != 0)
		{
			GameState KIGame(KIGame);
			//Latency = current_ping - frame.ping + 2;
			//printf("Latenz: %i\n", Latency);
			int CurrentPosition = LatencyPosition;
			const int BeginPosition = (NetBufferPosition-1+NetBufferSize) % NetBufferSize;
			while(CurrentPosition != (BeginPosition+20) % NetBufferSize)
			{
				KIGame.Move(NetBuffer[CurrentPosition].Keys);
				CurrentPosition = (CurrentPosition+1) % NetBufferSize;
			}
			//printf("Berechne neuen Schuss ab %i\n", KIGame.CurrentTime);

			ShotInfoList OldShotInfos = *ShotInfosVariety.begin();
			while(OldShotInfos[0].Time < KIGame.GetTime())
			{
				//printf("Loesche Schuss um %i\n", OldShotInfos[0].Time);
				OldShotInfos.DeleteFirst();
			}
			assert(!ValidateKIGame);
			ValidateKIGame = true;
TryAgain:
			ShotInfosVariety.clear();
			try
			{
				KIGame.CalculateNextShot(OldShotInfos, 0, ShotInfosVariety);
			}
			catch(KIGameInvalidException)
			{
				//MessageBeep(0);
				//assert(OldShotInfos[0].Time != MaxInt);
				assert(ValidateKIGame);
				OldShotInfos = ShotInfoList();
				ValidateKIGame = false;
				//printf("Loesche Schuesse wegen Fehler\n", OldShotInfos[0].Time);
				goto TryAgain;
				throw;///////////////////
			}
			ValidateKIGame = false;

			ShotInfoList& NewShotInfos = *ShotInfosVariety.begin();
			int CurrentShotInfo = 0;

			{
			CriticalSectionLocker l = NetBufferPositionLock;

			//Das Ergebnis der KI in den Puffer schreiben. Falls der NetThread uns schon voraus ist, schauen
			//wir, ob er zufllig genau das gesendet hat, was wir wollten. Falls nicht, lschen wir alles
			//und versuchen's das nchste mal.
//			log<<"Neuer Schuss\n";
			//AverageLatency = 0;
			//CurrentPosition = (CurrentPosition-AverageLatency+NetBufferSize) % NetBufferSize;
			for(int i = 0; i < NetBufferKIFutureSteps; i++)
			{
				byte Keys = KIGame.GetKeyFromShotInfo(NewShotInfos[CurrentShotInfo], NewShotInfos[CurrentShotInfo+1]);
				if((CurrentPosition-BeginPosition+NetBufferSize) % NetBufferSize <= (NetBufferPosition-BeginPosition+NetBufferSize) % NetBufferSize)
				//if(CurrentPosition <= NetBufferPosition)//das selbe wie oben, funktioniert nur nicht im Ring
				{
					if(NetBuffer[CurrentPosition].Keys == Keys)
					{
						printf("Schuss zu spaet, aber zum Glueck gleich.\n");
//						log<<"["<<CurrentPosition<<"] Ist schon: Key: "<<int(NetBuffer[CurrentPosition].Keys)<<"  Zeit: "<<KIGame.CurrentTime<<"\n";
					}
					else
					{
						printf("Schuss zu spaet und falsch!!\n");
						ShotInfosVariety.clear();
						ShotInfosVariety.insert(OldShotInfos);
						break;
					}
				}
				else
				{
					NetBuffer[CurrentPosition].Keys = Keys;
					NetBuffer[(CurrentPosition+Latency-1) % NetBufferSize].ExpectedFramePing = byte(NetBuffer[BeginPosition].Ping + (CurrentPosition-BeginPosition));
			//		log<<"["<<CurrentPosition<<"] Key: "<<int(NetBuffer[CurrentPosition].Keys)<<"  Zeit: "<<KIGame.CurrentTime<<"\n";
				}
				KIGame.Move(Keys);
				if(NewShotInfos[CurrentShotInfo].Time == KIGame.GetTime()-1)
					CurrentShotInfo++;
				if(NewShotInfos[CurrentShotInfo].Time == MaxInt)
					break;
				CurrentPosition = (CurrentPosition+1) % NetBufferSize;
				assert(CurrentPosition != BeginPosition);
			}
			}
			//log.flush();
		}
#ifdef INCLUDE_WINDOW
		InvalidateRect(hwnd, 0, false);
#endif

#else


		//Paket senden
		int r = sendto(ServerSocket, (char*)&Keys, sizeof(KeysPacket), 0,
					   (sockaddr*)&ServerAddress, sizeof(ServerAddress));
		if(r != sizeof(KeysPacket))
			printf("Fehler beim Senden (%i)\n", WSAGetLastError());
	
/*		//Auf neues Paket warten
		fd_set readfds, exceptfds;
		FD_ZERO(&readfds);
		FD_ZERO(&exceptfds);
		FD_SET(ServerSocket, &readfds);
		FD_SET(ServerSocket, &exceptfds);
		select(0, &readfds, 0, &exceptfds, 0);*/

		FramePacket Frame;

#ifndef READ_FRAMES
		r = recv(ServerSocket, (char*)&Frame, sizeof(FramePacket), 0);
		if(r != sizeof(FramePacket))
		{
			r -= 2;
			if(r > 127)
				r = 127;
			if(r < 0)
				r = 0;
			char Buffer[128];
			memcpy(Buffer, (void*)&Frame, r);
			Buffer[r] = 0;
			printf("Server: \"%s\" (Code: %i)\n", Buffer, WSAGetLastError());
			return;
		}
#endif

#ifdef WRITE_FRAMES
		out.write((char*)&Frame, sizeof(Frame));
		out.flush();
#elif defined READ_FRAMES
		in.read((char*)&Frame, sizeof(Frame));
		if(in.fail())
			return;
#endif


		const int MaxSameShotInfos = 10;
/*		if(ShotInfosVariety.empty())
		{
			ShotInfosVariety.insert(ShotInfoList());
#ifndef USER_CONTROL
			for(int i = 0; i <= FutureShots; i++)
			{
				std::multiset<ShotInfoList> NewShotInfosVariety;
				int Index = 0;
				for(std::multiset<ShotInfoList>::iterator j = ShotInfosVariety.begin();
					j != ShotInfosVariety.end();
					j++)
				{
					if(++Index == MaxSameShotInfos)
						break;
					gameram.CalculateNextShot(*j, 0, NewShotInfosVariety);
				}
				assert(!NewShotInfosVariety.empty());
				ShotInfosVariety = NewShotInfosVariety;
			}
#endif
		}*/

		/*while(ShotInfos.size() < 4)
		{
			if(ShotInfos.size() == 3 && ShotInfos[0].CollisionTime == MaxCollisionTime)
			{
				int ShootTime = ShotInfos[0].Time;
				gameram.CalculateNextShot(ShotInfos, MaxCollisionTime, 0);
				int MinMaxCollisionTime = MaxCollisionTime;
				int BestDelay;

				//printf("Test\n");
				for(int i = 1; i <= 2 ; i++)
				{
					std::vector<ShotInfo> ShotInfos2 = EmptyShotInfos;
					int MaxCollisionTime2 = 0;
					gameram.CalculateNextShot(ShotInfos2, MaxCollisionTime2, ShootTime+i);
					if(MaxCollisionTime2 >= MinMaxCollisionTime)
						break;
					gameram.CalculateNextShot(ShotInfos2, MaxCollisionTime2, 0);
					if(MaxCollisionTime2 < MinMaxCollisionTime)
					{
						ShotInfos = ShotInfos2;
						MinMaxCollisionTime = MaxCollisionTime2;
						BestDelay = i;
					}
				}
				//printf("TestEnde\n");
#ifdef PRINT_DEBUG_INFO
				if(MinMaxCollisionTime < MaxCollisionTime)
					printf("Juhuu. Spare %i mit der Verzoegerung %i\n", MaxCollisionTime - MinMaxCollisionTime, BestDelay);
#endif
				MaxCollisionTime = MinMaxCollisionTime;
			}
			else
				gameram.CalculateNextShot(ShotInfos, MaxCollisionTime, 0);
		}*/

		if(t && Frame.FrameNo != byte(LastFrame.FrameNo+1))
			printf("%i Frames verloren.\n", byte(Frame.FrameNo - byte(LastFrame.FrameNo+1)));

#ifdef INCLUDE_EXTRA_FRAME_INFO
		//Frame.Ping = Frame.LastRecvKeys;/////////////////////////
		assert(Frame.LastRecvKeys == Frame.Ping);
#endif

		//printf("Move Key: %x Ping: %x\n", keys_packets[i].keys & 0x1f, keys_packets[i].ping);
		//printf("Frame Hash: %x\n", gameram.Hash());


		if(t > 1)
		{
			MoveVRamGames(LastFrame.Ping, Frame.VRam,
#ifdef INCLUDE_EXTRA_FRAME_INFO
				LastFrame.Ram,
#else
				0,
#endif
				LastVRamScore, LastVRamNumShips, &KIGame);
		}


/*		int TargetTime = gameram.CurrentTime+1;
		while(gameram.CurrentTime != TargetTime)
		{
			try
			{
				assert(CurrentVRamTime - gameram.CurrentTime < DecisionTime);
				word* VRam = VRams[(CurrentVRam - (CurrentVRamTime - gameram.CurrentTime) + DecisionTime) % DecisionTime];
				DecisionAdded = false;
				gameram.Move_(KeysPacket(), ShotInfo(), frame.ram, VRam, Decisions);
			}
			catch(VRamInvalidException)
			{
				if(DecisionAdded)
				{
					printf("Entscheidung um %i\n", GameRam::last_ram.CurrentTime);
					DecisionGameRams[GameRam::last_ram.CurrentTime] = GameRam::last_ram;
				}
				printf("Aendere Entscheidung\n");
				assert(!Decisions.empty());
				while(Decisions.begin()->second.NextDecision())
				{
					Decisions.erase(Decisions.begin());
					assert(!Decisions.empty());
					printf("Springe zu Zeitpunkt %i zurueck\n", Decisions.begin()->first.GetTime());
				}
				assert(DecisionGameRams.find(Decisions.begin()->first.GetTime()) != DecisionGameRams.end());
				assert(CurrentVRamTime - Decisions.begin()->first.GetTime() < DecisionTime);
				gameram = DecisionGameRams[Decisions.begin()->first.GetTime()];
				if(Decisions.find(DecisionKey::RandomSeed(gameram.CurrentTime)) != Decisions.end() &&
					Decisions[DecisionKey::RandomSeed(gameram.CurrentTime)].GetTriesLeft() != gameram.RandomSeedTriesLeft)
				{
					assert(gameram.RandomSeedTriesLeft > 0);
					gameram.RandomSeedTriesLeft--;
					assert(Decisions[DecisionKey::RandomSeed(gameram.CurrentTime)].GetTriesLeft() == gameram.RandomSeedTriesLeft);
					gameram.Rand();
					DecisionGameRams[Decisions.begin()->first.GetTime()] = gameram;
					printf("Naechster Seed. Noch %i\n", gameram.RandomSeedTriesLeft);
				}
				continue;
				throw;//////////////////////
			}
			if(DecisionAdded)
			{
				printf("Entscheidung um %i\n", GameRam::last_ram.CurrentTime);
				DecisionGameRams[GameRam::last_ram.CurrentTime] = GameRam::last_ram;
			}
		}
		gameram.Check(frame.ram, keys_packets[i], ShotInfo(), false, server_ip, sd, Decisions);				*/
/*				}
			}
			else if(t != 1)
				printf("%i Paket(e) verloren\n", int(frame.frameno - prevframe+char(1)));
			if(prevframe-frame.frameno >= 0 && prevframe-frame.frameno < 10)
			{
				printf("Paket ignoriert\n");
				continue;
			}
			//gameram.Check(frame.ram, keys_packets[0], ShotInfo(), true, 0, 0);
			last_ping = frame.ping;
			//if(frame.frameno != prevframe+1)
			//	printf("Frame Hash: %x\n", gameram.Hash());
		}
		else*/
/*		{
		}*/



		/*BitBlt(hdcMem, 0, yFont*2, xChars*xFont, (yChars-2)*yFont, hdcMem, 0, yFont, SRCCOPY);
		for(int i=0; i<0x100; i++)
		{
			const int Start = 0x200;
			if(t > 20 && frame.ram.GetRawRam()[i+Start] != last_frame.ram.GetRawRam()[i+Start])
				changed[i] = 255;
			SetTextColor(hdcMem, RGB(changed[i],0,0));
			if(changed[i]) changed[i]--;
			char Buffer[3];
			sprintf_s(Buffer, 3, "%2.2x", frame.ram.GetRawRam()[i+Start]);
			TextOut(hdcMem, i*xFont*2, yFont, Buffer, 2);
		}*/
		InvalidateRect(hwnd, 0, false);

//		last_frame = frame;


		//if(updating) InterpretScreen(frame, game);

#if 1
		if(KIGame.CurrentTime)
		{
/*			Latency = current_ping - frame.ping + 2;
			//printf("Latenz: %i\n", Latency);
			for(int i = 0; i < Latency; i++)
				KIGame.Move(keys_packets[(t+i-Latency)%10]);*/
			ShotInfoList ShotInfos;

#ifndef READ_FRAMES
			KIGame.Move(LastFrame.Ping);
			KIGame.Move(Frame.Ping);

			ShotInfosVariety.clear();
			KIGame.CalculateNextShot(ShotInfos, 0, ShotInfosVariety);
			ShotInfos = *ShotInfosVariety.begin();
#endif
			/*ShotInfosVariety.clear();
			KIGame.CalculateNextShot(ShotInfos, 0, ShotInfosVariety);
			ShotInfos = *ShotInfosVariety.begin();*/

			Keys.Keys = KIGame.GetKeyFromShotInfo(ShotInfos[0], ShotInfos[1]);

			Keys.Ping = Keys.Keys;

			/*const ShotInfoList ShotInfos = *ShotInfosVariety.begin();//Darf keine Referenz sein, da wir unten die Daten brauchen, whrend wir das multiset ndern.

			//printf("Eigener Frame: Hash: %x\n", KIRam.GetHash());
			//printf("Move Key: %x\n", keys_packets[t%10].keys & 0x1f);
			bool DeleteFirst = ShotInfos[0].Time <= KIGame.CurrentTime;
			if(DeleteFirst || (int)ShotInfos.size() < (Game.RandomSeedDistribution.GetNumSetBits() == 1 ? FutureShots : 3))
			{
				KIGame.Move(keys_packets[t%10]);
				std::multiset<ShotInfoList> NewShotInfosVariety;
				int Index = 0;
				for(std::multiset<ShotInfoList>::iterator i = ShotInfosVariety.begin();
					i != ShotInfosVariety.end();
					i++)
				{
					if(DeleteFirst && !(*i).SameMovement(ShotInfos))
						continue;
					if(!DeleteFirst && (*i)[0].Time <= KIGame.CurrentTime-1)//Fr diesen Schuss ist es bereits zu spt
						continue;
					if(++Index == MaxSameShotInfos)
						break;
					ShotInfoList OldList = *i;/////////////////
					if(DeleteFirst)
						i->DeleteFirst();
					KIGame.CalculateNextShot(*i, 0, NewShotInfosVariety);
				}
				assert(!NewShotInfosVariety.empty());
				ShotInfosVariety = NewShotInfosVariety;
			}*/
		}
/*
		const ShotInfoList ShotInfos = *ShotInfosVariety.begin();//Darf keine Referenz sein, da wir unten die Daten brauchen, whrend wir das multiset ndern.
		//int Needed = abs(NeededRotation(ShotInfos[0].TargetDirection, ShotInfos[1].TargetDirection, ShotInfos[1].Dir));
		//if(Needed > MaxNeeded)
		//	printf("Neues Max bei %i um %i\n", MaxNeeded = Needed, ShotInfos[1].Time);
		pScore = &Score;
		gameram.Move(ShotInfos[0], ShotInfos[1]);
		pScore = 0;
		if(ShotInfos[0].Time == gameram.CurrentTime-1)
		{
			std::multiset<ShotInfoList> NewShotInfosVariety;
			int Index = 0;
			for(std::multiset<ShotInfoList>::iterator i = ShotInfosVariety.begin();
				i != ShotInfosVariety.end();
				i++)
			{
				if(!(*i).SameMovement(ShotInfos))
					continue;
				if(++Index == MaxSameShotInfos)
					break;
				//ShotInfoList OldList = *i;
				i->DeleteFirst();
				gameram.CalculateNextShot(*i, 0, NewShotInfosVariety);
			}
			assert(!NewShotInfosVariety.empty());
			ShotInfosVariety = NewShotInfosVariety;
		}
		RunningTime++;
		char Buffer[128];
		sprintf_s(Buffer, 128, "Sco: %i0 %i%%  Zeit: %i",
			int(Score), RunningTime*100/(60*60*5), RunningTime/60);
		SetWindowText(hwnd, Buffer);
		if(60*60*5 == RunningTime)
		{
			printf("Score nach 5 Minuten ohne Saucer mit Seed %02x: %i0\n", StartSeed, Score);
			//exit(0);
			gameram.StartNewGame();
			if(++StartSeed == 11)
			{
				StartSeed = 0;
				if(++FutureShots == -1)
					exit(0);
				printf("FutureShots: %i\n", FutureShots);
			}
			gameram.RandomSeed1 = StartSeed;
			RunningTime = 0;
			Score = 0;
			t = 0;
			ShotInfosVariety.clear();
			GameRamsHistory.clear();
		}



		keys_packets[t%10] = gameram.CalcDirInfos(&ShotInfos[t%10], 0, true, -1, 0, KeysPacket());
		if(Latency)
			gameram = OriginalRam;*/

		//keys_packets[t%10].fire(t%2 == 0);


#else
		keys_packets[t%10].clear();
		if(GetForegroundWindow() == hwnd)
		{
			if(GetAsyncKeyState('Q') < 0)
				keys_packets[t%10].left(true);
			if(GetAsyncKeyState('W') < 0)
				keys_packets[t%10].right(true);
			if(GetAsyncKeyState('I') < 0)
				keys_packets[t%10].thrust(true);
			if(GetAsyncKeyState('O') < 0)
				keys_packets[t%10].fire(true);
			if(GetAsyncKeyState(VK_SPACE) < 0)
				keys_packets[t%10].hyperspace(true);
		}
#endif

		LastFrame = Frame;

		/*int min_dist = 0x7fffffff;
		int min_dx = 0;
		int min_dy = 0;
		if (game.ship_present)
		{
			for (int i=0; i<game.nasteroids; ++i)
			{   // nchstgelegenen Asteroiden suchen
				int dx = game.asteroids[i].x - game.ship_x;
				while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
				while (dx > 511) dx -= 1024;
				int dy = game.asteroids[i].y - game.ship_y;
				while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
				while (dy > 383) dy -= 768;
				int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
				switch (game.asteroids[i].sf)
				{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
					case 0:  // groer Asteroid
						dist -= 40*40;
						break;
					case 15: // mittlerer Asteroid
						dist -= 20*20;
						break;
					case 14: // kleiner Asteroid
						dist -= 8*8;
						break;
				}
				if (dist < min_dist)
				{
					min_dist = dist;
					min_dx = dx;
					min_dy = dy;
				}
			}
			if (game.saucer_present)
			{
				int dx = game.saucer_x - game.ship_x;
				while (dx < -512) dx += 1024;
				while (dx > 511) dx -= 1024;
				int dy = game.saucer_y - game.ship_y;
				while (dy < -384) dy += 768;
				while (dy > 383) dy -= 768;
				int dist = dx*dx+dy*dy;
				switch (game.saucer_size)
				{	// Abstand um den ungefhren Radius des UFOs korrigieren
				case 15: // groes UFO
					dist -= 20*12;
					break;
				case 14: // kleines UFO
					dist -= 10*6;
					break;
				}
				if (dist < min_dist)
				{
					min_dist = dist;
					min_dx = dx;
					min_dy = dy;
				}
			}

			// Schiff in Richtung auf das nchstgelegene Objekt drehen
			// mathematisch wird hier das Kreuzprodukt aus den Vektoren 
			// ship_dx/y/0 und min_dx/y/0 berechnet
			if (game.ship_dx * min_dy - game.ship_dy * min_dx > 0)
				keys_packets[t%10].left(true);
			else
				keys_packets[t%10].right(true);

			if (min_dist < 30*30)  // Flucht, wenn Kollision unausweichlich
				keys_packets[t%10].hyperspace(true);

			if (min_dist > 300*300/100) // beschleunigen, wenn nichts in der Nhe
				keys_packets[t%10].thrust(true);

			if (t % 2 == 0)  // Feuerknopf drcken, so schnell es geht
				keys_packets[t%10].fire(true);
		}*/
		t++;
#endif
	}
	return 0;
}


#ifdef INCLUDE_WINDOW
LRESULT CALLBACK WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
	switch(Message)
	{
	case WM_CREATE:
		::hwnd = hwnd;
		return 0;

	case WM_SIZE:
		cxClient = LOWORD(lParam);
		cyClient = HIWORD(lParam);
		return 0 ;

	case WM_KEYDOWN:
#ifdef USE_NETWORK_THREAD
		if(wParam == 'Y')
			NetDelay++;
		else if(wParam == 'X')
			NetDelay = Max(NetDelay-1, 0);
#endif
		if(wParam==VK_LEFT)
		{
			CurrentGameHistory--;
			if(CurrentGameHistory < 0)
				CurrentGameHistory = (int)GamesHistory.size()-1;
		}
		else if(wParam==VK_RIGHT)
		{
			CurrentGameHistory++;
			if(CurrentGameHistory >= (int)GamesHistory.size())
				CurrentGameHistory = (int)GamesHistory.size()-1;
		}
		else if(wParam==VK_UP)
		{
			CurrentGameHistory = -1;
		}
		else if(wParam==VK_DOWN)
		{
//			ShotInfo S;
//			while(CurrentGameRam != -1)
//				GameRamsHistory[CurrentGameRam].CalcDirInfos(&S, 0, true, -1, 0, KeysPacket());
		}
		else
			return 0;
		InvalidateRect(hwnd, 0, false);
		return 0;

	case WM_PAINT:
	{
		PAINTSTRUCT	ps;
		HDC hdcScreen = BeginPaint(hwnd, &ps);

		HBITMAP hBitmap = CreateCompatibleBitmap(hdcScreen, cxClient, cyClient);
		HDC hdc = CreateCompatibleDC(hdcScreen);
		SelectObject(hdc, hBitmap);

		RECT rc;
		SetRect(&rc, 0, 0, cxClient, cyClient);
		FillRect(hdc, &rc, (HBRUSH)GetStockObject(WHITE_BRUSH));

		//BitBlt(hdc, 0, 0, cxClient, cyClient,
		//       hdcMem, xView*xFont, yView*yFont, SRCCOPY);
		if(CurrentGameHistory == -1)
		{
			VRamGames[0].Render(hdc, cxClient, cyClient);
		}
		else
		{
			GamesHistory[CurrentGameHistory].Render(hdc, cxClient, cyClient);
		}

		BitBlt(hdcScreen, 0, 0, cxClient, cyClient, hdc, 0, 0, SRCCOPY);
		DeleteDC(hdc);
		DeleteObject(hBitmap);
		EndPaint(hwnd, &ps);
		return 0;
	}

	case WM_LBUTTONDOWN:
		HyperSpaceTargetX = LOWORD(lParam) * 0x2000 / cxClient;
		HyperSpaceTargetY = (cyClient-HIWORD(lParam)) * 0x1800 / cyClient;
		return 0;


	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
	}
	return DefWindowProc(hwnd, Message, wParam, lParam);
}

#endif
