// Ship.cpp: Implementierung der Klasse Ship.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "stdafx.h"
#include "Ship.h"
#include "global.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

Winkelentry winkeltab[256] = {
{1536,0,63,0},
{1536,0,63,1},
{1536,0,63,3},
{1536,0,63,4},
{1528,152,63,6},
{1528,152,63,8},
{1528,152,63,9},
{1528,152,62,11},
{1504,296,62,12},
{1504,296,62,14},
{1504,296,61,15},
{1504,296,61,17},
{1472,440,61,18},
{1472,440,60,20},
{1472,440,60,21},
{1472,440,59,23},
{1416,584,58,24},
{1416,584,58,25},
{1416,584,57,27},
{1416,584,56,28},
{1360,720,56,30},  // 20
{1360,720,55,31}, 
{1360,720,54,32},
{1360,720,53,34},
{1280,856,53,35},  // 24   1 x L
{1280,856,52,36},  //      2 x L
{1280,856,51,38},  //      4 x L
{1280,856,50,39},  // 27   4 x L
{1192,976,49,40},
{1192,976,48,41},
{1192,976,47,42},  // 30
{1192,976,46,44},
{1088,1088,45,45},
{1088,1088,44,46}, // 33
{1088,1088,42,47},
{1088,1088,41,48},
{976,1192,40,49},
{976,1192,39,50},
{976,1192,38,51},
{976,1192,36,52},
{856,1280,35,53},
{856,1280,34,53},
{856,1280,32,54},
{856,1280,31,55},
{720,1360,30,56},
{720,1360,28,56},
{720,1360,27,57},
{720,1360,25,58},
{584,1416,24,58},
{584,1416,23,59},
{584,1416,21,60},
{584,1416,20,60},
{440,1472,18,61},
{440,1472,17,61},
{440,1472,15,61},
{440,1472,14,62},
{296,1504,12,62},
{296,1504,11,62},
{296,1504,9,63},
{296,1504,8,63},
{152,1528,6,63},
{152,1528,4,63},
{152,1528,3,63},
{152,1528,1,63},
{0,1536,0,63},     // 64
{-152,1528,-2,63},
{-152,1528,-3,63},
{-152,1528,-5,63},
{-152,1528,-6,63},
{-296,1504,-8,63},
{-296,1504,-10,63},
{-296,1504,-11,62},
{-296,1504,-13,62},
{-440,1472,-14,62},
{-440,1472,-16,61},
{-440,1472,-17,61},
{-440,1472,-19,61},
{-584,1416,-20,60},
{-584,1416,-22,60},
{-584,1416,-23,59},
{-584,1416,-25,58},
{-720,1360,-26,58},
{-720,1360,-27,57},
{-720,1360,-29,56},
{-720,1360,-30,56},
{-856,1280,-32,55},
{-856,1280,-33,54},
{-856,1280,-34,53},
{-856,1280,-36,53},
{-976,1192,-37,52},
{-976,1192,-38,51},
{-976,1192,-39,50},
{-976,1192,-41,49},
{-1088,1088,-42,48},
{-1088,1088,-43,47},
{-1088,1088,-44,46},
{-1088,1088,-45,45},
{-1192,976,-46,44},
{-1192,976,-47,42},
{-1192,976,-48,41},
{-1192,976,-49,40},
{-1280,856,-50,39},
{-1280,856,-51,38},
{-1280,856,-52,36},
{-1280,856,-53,35},
{-1360,720,-54,34},
{-1360,720,-55,32},
{-1360,720,-56,30},
{-1360,720,-56,30},
{-1416,584,-57,28},
{-1416,584,-58,27},
{-1416,584,-58,25},
{-1416,584,-59,24},
{-1472,440,-59,23},
{-1472,440,-60,21},
{-1472,440,-61,20},
{-1472,440,-61,18},
{-1504,296,-61,17},
{-1504,296,-62,15},
{-1504,296,-62,14},
{-1504,296,-63,12},
{-1528,152,-63,11},
{-1528,152,-63,9},
{-1528,152,-63,8},
{-1528,152,-63,6},
{-1536,0,-64,4},
{-1536,0,-64,3},
{-1536,0,-64,1},
{-1536,0,-64,0},
{-1536,0,-64,-2},
{-1536,0,-64,-3},
{-1536,0,-64,-5},
{-1528,-152,-63,-6},
{-1528,-152,-63,-8},
{-1528,-152,-63,-10},
{-1528,-152,-63,-11},
{-1504,-296,-63,-13},
{-1504,-296,-62,-14},
{-1504,-296,-62,-16},
{-1504,-296,-61,-17},
{-1472,-440,-61,-19},
{-1472,-440,-61,-20},
{-1472,-440,-60,-22},
{-1472,-440,-59,-23},
{-1416,-584,-59,-25},
{-1416,-584,-58,-26},
{-1416,-584,-58,-27},
{-1416,-584,-57,-29},
{-1360,-720,-56,-30},
{-1360,-720,-56,-32},
{-1360,-720,-55,-33},
{-1360,-720,-54,-34},
{-1280,-856,-53,-36},
{-1280,-856,-52,-37},
{-1280,-856,-51,-38},
{-1280,-856,-50,-39},
{-1192,-976,-49,-41},
{-1192,-976,-48,-42},
{-1192,-976,-47,-43},
{-1192,-976,-46,-44},
{-1088,-1088,-45,-45},
{-1088,-1088,-44,-46},
{-1088,-1088,-43,-47},
{-1088,-1088,-42,-48},
{-976,-1192,-41,-49},
{-976,-1192,-39,-50},
{-976,-1192,-38,-51},
{-976,-1192,-37,-52},
{-856,-1280,-36,-53},
{-856,-1280,-34,-54},
{-856,-1280,-33,-55},
{-856,-1280,-32,-56},
{-720,-1360,-30,-56},
{-720,-1360,-29,-57},
{-720,-1360,-27,-58},
{-720,-1360,-26,-58},
{-584,-1416,-25,-59},
{-584,-1416,-23,-59},
{-584,-1416,-22,-60},
{-584,-1416,-20,-61},
{-440,-1472,-19,-61},
{-440,-1472,-17,-61},
{-440,-1472,-16,-62},
{-440,-1472,-14,-62},
{-296,-1504,-13,-63},
{-296,-1504,-11,-63},
{-296,-1504,-10,-63},
{-296,-1504,-8,-63},
{-152,-1528,-6,-63},
{-152,-1528,-5,-64},
{-152,-1528,-3,-64},
{-152,-1528,-2,-64},
{0,-1536,0,-64},
{152,-1528,1,-64},
{152,-1528,3,-64},
{152,-1528,4,-64},
{152,-1528,6,-63},
{296,-1504,8,-63},
{296,-1504,9,-63},
{296,-1504,11,-63},
{296,-1504,12,-63},
{440,-1472,14,-62},
{440,-1472,15,-62},
{440,-1472,17,-61},
{440,-1472,18,-61},
{584,-1416,20,-61},
{584,-1416,21,-60},
{584,-1416,23,-59},
{584,-1416,24,-59},
{720,-1360,25,-58},
{720,-1360,27,-58},
{720,-1360,28,-57},
{720,-1360,30,-56},
{856,-1280,31,-56},
{856,-1280,32,-55},
{856,-1280,34,-54},
{856,-1280,35,-53},
{976,-1192,36,-52},
{976,-1192,38,-51},
{976,-1192,39,-50},
{976,-1192,40,-49},
{1088,-1088,41,-48},
{1088,-1088,42,-47},
{1088,-1088,44,-46},
{1088,-1088,45,-45},
{1192,-976,46,-44},
{1192,-976,47,-43},
{1192,-976,48,-42},
{1192,-976,49,-41},
{1280,-856,50,-39},
{1280,-856,51,-38},
{1280,-856,52,-37},
{1280,-856,53,-36},
{1360,-720,53,-34},
{1360,-720,54,-33},
{1360,-720,55,-32},
{1360,-720,56,-30},
{1416,-584,56,-29},
{1416,-584,57,-27},
{1416,-584,58,-26},
{1416,-584,58,-25},
{1472,-440,59,-23},
{1472,-440,60,-22},
{1472,-440,60,20},
{1472,-440,61,-19},
{1504,-296,61,-17},
{1504,-296,61,-16},
{1504,-296,62,-14},
{1504,-296,62,-13},
{1528,-152,62,-11},
{1528,-152,63,-10},
{1528,-152,63,-8},
{1528,-152,63,-6},
{1536,0,63,-5},
{1536,0,63,-3},
{1536,0,63,-2}
};


Ship::Ship()
{
  thisWinkelbyte = 0;
  nextWinkelbyte = 0;
  bx = 0;
  by = 0;
}

Ship::~Ship()
{

}


// ndert die interne Ausrichtung des Raumschiffs
// Drehung links  +1
// Drehung rechts -1
// Achtung hier ist wahrscheinlich fter zu korrigieren,
// wenn man vorher nicht wei, in welcher Umdrehung (1,2,3) man ist.
void Ship::adjustWinkelbyte(int change,int lastChange, int lostFrames)
{  
  // nur wenn etwas ber das Raumschiff bekannt ist, korrigieren
  if (bx != 0 || by != 0) {
    int jump = 1;
    int mult = 1;
    if (lostFrames > 0) {
      fprintf(fo,"lostFrame: WB %3d %5d %5d\n",thisWinkelbyte,
        lastChange, lostFrames );
    }
    thisWinkelbyte = thisWinkelbyte + lastChange * 3 * (lostFrames+1);
    while ((winkeltab[thisWinkelbyte].ship_bx != bx)
        || (winkeltab[thisWinkelbyte].ship_by != by)) {
      thisWinkelbyte += jump*mult;  // suchen in +1,-2,+3,-4,+5,...
      jump++;
      mult = -mult;
      fprintf(fo,"adjust WB: %3d %5d %5d  %3d %3d\n",thisWinkelbyte,
        winkeltab[thisWinkelbyte].ship_bx, winkeltab[thisWinkelbyte].ship_by,
        winkeltab[thisWinkelbyte].shot_dx8, winkeltab[thisWinkelbyte].shot_dy8);
    }
  }
  if (change != 0) {
    nextWinkelbyte = thisWinkelbyte + change*3;
    fprintf(fo,"this WB: %3d next WB: %3d %5d %5d  %3d %3d\n",thisWinkelbyte, nextWinkelbyte,
        winkeltab[nextWinkelbyte].ship_bx, winkeltab[nextWinkelbyte].ship_by,
        winkeltab[nextWinkelbyte].shot_dx8, winkeltab[nextWinkelbyte].shot_dy8);
  }
  
}


Winkelentry* Ship::getWinkeltab()
{
  return winkeltab;
}


int Ship::getNextWinkelbyteDx8(int offset)
{
  return winkeltab[(nextWinkelbyte+offset*3) & 0xFF].shot_dx8;
}


int Ship::getNextWinkelbyteDy8(int offset)
{
  return winkeltab[(nextWinkelbyte+offset*3) & 0xFF].shot_dy8;
}
