// c't Programmierwettbewerb Asteroids Juni 2008
// Maurer Christoph	christoph_m@gmx.net

// Grafische Anzeige zur Fehlersuche

#define USE_CONSOLE
#pragma warning(disable:4312) // diverse allegro warnings
#pragma warning(disable:4996) // sscanf veraltet

#pragma comment(lib,"alleg.lib")

#include <allegro.h>
#include <stdio.h>
#include <stdlib.h>
#define _USE_MATH_DEFINES
#include <math.h>

#define conv_y(y)HEIGHT-y+125

#define WIDTH 1024
#define HEIGHT 768
#define MAX_LINE 300

BITMAP *doubleBuffer = NULL;

void welcome(void);
void init(void);
void clean_up(void);
void draw_asteroid(BITMAP *dest,int type,int sf,int x,int y);
void draw_arrow(BITMAP *dest,int x,int y,int x2,int y2,int color);
void draw_ufo(BITMAP *dest,int size,int x,int y);

int main(int argc,char **argv)
{
	char inp[MAX_LINE+1];
	FILE *fp = stdin;
	int rest_time=0;
	if(argc>1)
	{
		fp = fopen(argv[1],"r");
		fp = (fp!=NULL)?fp:stdin;
	}
	if(argc>2)
		rest_time = atoi(argv[3]);
	

	welcome();
	init();
	

	while(fgets(inp,MAX_LINE-1,fp) && !key[KEY_ESC])
	{	
		if(!strncmp(inp,">ast ",5))
		{
			int i,x,y,type,sf;
			float vx,vy;
			sscanf(inp,">ast %d %d %d %d %d %f %f\n",&i,&x,&y,&type,&sf,&vx,&vy);
			printf("parse %s i=%d x=%d y=%d type=%d sf=%d vx=%f vy=%f\n",inp,i,x,y,type,sf,vx,vy);
			draw_asteroid(doubleBuffer,type,sf,x,conv_y(y));
			
			if(vx<500 && vx>-500 && vy<500 && vy>-500)
				draw_arrow(doubleBuffer,x,conv_y(y),x+vx*25,conv_y(y)-vy*25,makecol(255,0,255));

		}
		else if(!strncmp(inp,">ufo ",5))
		{
			int x,y,size;
			float vx,vy;
			sscanf(inp,">ufo %d %d %d %f %f\n",&x,&y,&size,&vx,&vy);
			draw_ufo(doubleBuffer,size,x,conv_y(y));
			if(vx<500 && vx>-500 && vy<500 && vy>-500)
				draw_arrow(doubleBuffer,x,conv_y(y),x+vx*25,conv_y(y)-vy*25,makecol(255,0,255));
		}
		else if(!strncmp(inp,">shot ",6))
		{
			int i,x,y;
			int radius = 1;
			sscanf(inp,">shot %d %d %d\n",&i,&x,&y);
			circlefill(doubleBuffer,x,conv_y(y),radius,makecol(255,0,0));
		}
		else if(!strncmp(inp,">ship ",6))
		{
			int x,y,dx,dy;
			float vx,vy,ship_angle;
			sscanf(inp,">ship %d %d %d %d %f %f %f\n",&x,&y,&dx,&dy,&vx,&vy,&ship_angle);
			line(doubleBuffer,x,conv_y(y),x+dx,conv_y(y)-dy,makecol(0,0,255));
			//line(doubleBuffer,x,conv_y(y),x+cos(ship_angle)*300.0,conv_y(y)-sin(ship_angle)*300.0,makecol(255,0,0));
			circle(doubleBuffer,x,conv_y(y),10,makecol(0,255,255));
			textprintf(doubleBuffer,font,10,10,makecol(0,200,200),"ship_angle=%f|%f",ship_angle,(double)atan2((double)dy,(double)dx)*180/M_PI);
		}
		else if(!strncmp(inp,">dctx",5))
		{
			int x,y,ship_x,ship_y;
			float a=0,b=0,t=0,angle=0;
			sscanf(inp,">dctx %d %d %f %f %f %f %d %d\n",&x,&y,&a,&b,&t,&angle,&ship_x,&ship_y);
			rect(doubleBuffer,x-20,conv_y(y)-20,x+20,conv_y(y)+20,makecol(255,0,0));
			line(doubleBuffer,ship_x,conv_y(ship_y),ship_x+a*100,conv_y(ship_y)-b*100,makecol(0,255,0));
			textprintf(doubleBuffer,font,10,25,makecol(0,200,200),"a=%5.2f b=%5.2f t=%5.2f angle=%5.2f ship_x=%d ship_y=%d",a,b,t,angle,ship_x,ship_y);
			//textprintf(doubleBuffer,font,10,40,makecol(0,200,200),"X+vx*t=t*a",a,b,t,angle,ship_x,ship_y);
		}
		else if(!strncmp(inp,">eof",4))
		{
				blit(doubleBuffer, screen, 0, 0, 0, 0, doubleBuffer->w, doubleBuffer->h);
				clear(doubleBuffer);
				rest(rest_time);	
		}
		else
		{
			printf("%s",inp);	
		}
	}

	clean_up();
	
	if(fp!=stdin)
		fclose(fp);
	
	return 0;
}
END_OF_MAIN()


void welcome(void)
{
	puts("Programmierwettbewerb zum 25. c't-Geburtstag");
	printf("Asteroids Displayprogramm von Maurer Christoph christoph_m@gmx.net %s/%s\n\n",__DATE__,__TIME__);
}
void init(void)
{
	allegro_init();
	install_keyboard();
	set_gfx_mode(GFX_AUTODETECT_WINDOWED,WIDTH,HEIGHT,0,0);
	doubleBuffer = create_bitmap(WIDTH,HEIGHT);
}

void clean_up(void)
{
	if(doubleBuffer != NULL)
		destroy_bitmap(doubleBuffer);
}

void draw_arrow(BITMAP *dest,int x,int y,int x2,int y2,int color)
{
	line(dest,x,y,x2,y2,color);
}

void draw_asteroid(BITMAP *dest,int type,int sf,int x,int y)
{
	int color;
	switch(sf)
	{	
		case 0:  // groer Asteroid
			color = makecol(200,200,200);
			rect(dest,x-40,y-40,x+40,y+40,color);
			break;
		case 15: // mittlerer Asteroid
			color = makecol(0,100,200);
			rect(dest,x-20,y-20,x+20,y+20,color);
			break;
		case 14: // kleiner Asteroid
			color = makecol(0,255,100);
			rect(dest,x-8,y-8,x+8,y+8,color);
			break;
	}
}

void draw_ufo(BITMAP *dest,int size,int x,int y)
{
	int color = makecol(0,200,200);
	switch(size)
	{	
		case 15: 
			rect(dest,x-20,y-12,x+20,y+20,color);
			break;
		case 14: 
			rect(dest,x-10,y-6,x+10,y+6,color);
			break;
	}
}