/*
 * Decompiled with CFR 0.152.
 */
package de.oflebbe.asteroids;

import de.oflebbe.asteroids.DatagramSocketCommunicator;
import de.oflebbe.asteroids.Keys;
import de.oflebbe.asteroids.Screen;
import de.oflebbe.asteroids.ScreenAnalyser;
import de.oflebbe.asteroids.Tactic;
import de.oflebbe.monitor.DisplayFrame;
import java.io.IOException;
import java.net.SocketTimeoutException;

public class Main {
    public static void main(String[] args) {
        DisplayFrame dis = new DisplayFrame();
        dis.setVisible(true);
        try {
            DatagramSocketCommunicator c = args.length == 1 ? new DatagramSocketCommunicator(args[0]) : new DatagramSocketCommunicator("127.0.0.1");
            Keys k = new Keys();
            ScreenAnalyser analyser = new ScreenAnalyser();
            Tactic tactic = new Tactic();
            dis.setTacticVisualiser(tactic);
            while (true) {
                c.send(k.code());
                byte[] recBuffer = new byte[1026];
                try {
                    c.receive(recBuffer);
                    Screen screen = new Screen(recBuffer);
                    dis.updateScreen(screen);
                    analyser.nextFrame(screen);
                    k = tactic.nextFrame(screen);
                }
                catch (SocketTimeoutException ex) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }
}

