/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package de.oflebbe.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;

/**
 *
 * @author olaf
 */
public class Tactic implements Tacticvisualiser{

    public Tactic() {
        this.fired = false;
        thruster = 0;
    }
    private int minDist;
    boolean fired;
    int thruster;
    // Find nearest Asteroid
    
    // 8 Pixel / Frame shooting velocity
    static final double vshot = 8;  
    
    private MovingObject target;
    private Vecd2D direct;
  
    private Ship ship = null;
    public Keys nextFrame( Screen current) {
        Keys keys = new Keys();
        target = null;
        ship = current.getShip();
        if (ship == null)
            return keys;
        
        minDist= 1024*1024;
        for (Asteroid ast : current.getAsteroids()) {
            int dist2 = ast.len2(ship);
            if (dist2 < minDist) {
                minDist = dist2;
                target = ast; 
            }
        }
        if (target != null) {
            int size = ((Asteroid) target).getSize()+10;
            if (minDist < (size*size)) {
                // Flucht, wenn Kollision unausweichlich
                keys.setHyperspace( true);
            }    
        }
        
        MovingObject saucer = current.getSaucer();
        if (saucer != null && saucer.len2(ship) < minDist)
            target= saucer;
        
        for (Shot s : current.getShots()) {
            //if (!s.isUfoShot())
            //    continue;
            if (keys.isHyperspace())
                break;
          
            if (closestDistance2( ship,s,2) < 20*20) {
                // friendly fire?
                int rx = s.getX() - ship.getX();
                int ry = s.getY() - ship.getY();
                double dvx = s.getVx(); //- ship.getVx();
                double dvy = s.getVy(); //- ship.getVy();
                if (rx* dvx + ry *dvy<0) {
                    // red alert!!!
                    keys.setHyperspace( true);
                }
                    
            }
            
        }
        if (target == null)
            return keys;
        
        
        // reset shot
        if (fired) {
            fired = ! fired;
        } else {
            // is there anything to shoot at?
            Shot testShot = new Shot( ship);
            // 8 is speed of shots
            testShot.setVx( ship.getVx() + 8*ship.getDx());
            testShot.setVy( ship.getVy() + 8*ship.getDy());
            
            for (Asteroid ast : current.getAsteroids()) {
                double dist = ast.getSize() +10;
                
                if (closestDistance2(testShot, ast, 40) < dist* dist) {
                    // yeah!
                    fired = true;
                    break;
                }
            }
            
            // A saucer? shoot it!
            if (saucer!= null && closestDistance2(testShot,saucer,40) < 50*50) {
                fired = true;
            }
        }
                
        // press / release fire button
        keys.setFire(fired);
        
        direct = new Vecd2D();
        // Ship advanced one timeframe
        Ship nextShip = new Ship( ship);
        nextShip.setV( ship.getV());
        nextShip.add( ship.getV().d2i());
        
        // Target advanced one timeframe
        MovingObject nextTarget = new MovingObject( target);
        nextTarget.setV(target.getV());
        nextTarget.add( target.getV().d2i()); 
        
        if (!shotDirection(nextShip, nextTarget, direct)) {
            return keys;
        }
        
         // determing left/right
        if (direct.getX()*ship.getDy() - direct.getY()*ship.getDx() > 0) {
            keys.setRight(true);
        } else {
            keys.setLeft(true);
        }
        
        // follow targets
        if ( target.getVx()*ship.getVx() + target.getVy() * ship.getVy() >= 0) {
            thruster++;
            keys.setThrust(thruster %3 == 0);
        }
        
        return keys;
    }
    
    private double closestTime(MovingObject source, MovingObject target) {
        int dry = target.getY()-source.getY();
        int drx = target.getX()-source.getX();
        double dvx = source.getVx()-target.getVx();
        double dvy = source.getVy()-target.getVy();
        
        return (drx*dvx + dry*dvy)/(dvx*dvx+dvy*dvy); 
    }
    
    private double closestDistance2(MovingObject source, MovingObject target, double cutoff) { // , Integer when) {
        double time = closestTime(source, target);
        
        // do not use solutions in the past 
        if (time < 0) 
            time = 0;
        // do not use far away future solutions 
        if (time > cutoff) 
            time = cutoff;
       
        double rtx = source.getX() + time * source.getVx() -
                     target.getX() - time * target.getVx();
        double rty = source.getY() + time * source.getVy() -
                     target.getY() - time * target.getVy();
        return (rtx*rtx+rty*rty);
    }
    
    private static boolean shotDirection( Ship ship, MovingObject target, 
            Vecd2D direct) {
        double cosa, sina;
        /* determine best attack direction */
        int dry = target.getY()-ship.getY();
        int drx = target.getX()-ship.getX();
        double dvx = ship.getVx()-target.getVx();
        double dvy = ship.getVy()-target.getVy();
        double termA =  (drx*dvy -dry*dvx)/vshot;
        
        double term2 = drx*Math.sqrt( drx*drx+dry*dry-termA*termA);
        
        double cosa1 = (dry*termA + term2)/(dry*dry+drx*drx);
        double cosa2 = (dry*termA - term2)/(dry*dry+drx*drx);
        // testing for a  correct solution
        double dt1 = drx/(dvx+vshot*cosa1);
        double dt2 = drx/(dvx+vshot*cosa2);
        if (dt1 < 0 && dt2 < 0) {
            // discard solutions in the past
            return false;
        }
        // choose the solution next in time
        else if (dt1 > 0 && dt2 < 0)
           cosa = cosa1;
        else if (dt1 < 0 && dt2 > 0)
           cosa = cosa2;
        else if (dt1 < dt2)
            cosa = cosa1;
        else
            cosa = cosa2;
        
        double sina1 = Math.sqrt(1 - cosa*cosa);
        double dt3 = dry/(dvy+vshot*sina1);
        double dt4 = dry/(dvy-vshot*sina1);
       
         // dito
        if (dt3 < 0 && dt4 < 0) {
            return false;
        } else if ( dt3 > 0 && dt4 < 0) {
            sina = sina1;
        } else if (dt3 < 0 && dt4 > 0) {
            sina = -sina1;
        } else if (dt3 < dt4) {
            sina = sina1;
        } else
            sina = -sina1;
        direct.setX(cosa);
        direct.setY(sina);
        return true;
    } 
    
    public void visualiseTactic(Graphics2D g2) {
        if (target != null) {
            g2.setPaint( new Color(1.f,0.f,0.f));
            g2.drawOval( target.getX()-25, target.getY()-25, 50, 50);
        }
        if (ship != null) {
          g2.drawLine( ship.getX(), ship.getY(), ship.getX() +(int) (100*direct.getX()), ship.getY() + (int) (100*direct.getY()));
        }
    }
}
