/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package de.oflebbe.monitor;

import de.oflebbe.asteroids.Asteroid;
import de.oflebbe.asteroids.MovingObject;
import de.oflebbe.asteroids.Saucer;
import de.oflebbe.asteroids.Screen;
import de.oflebbe.asteroids.Ship;
import de.oflebbe.asteroids.Shot;
import de.oflebbe.asteroids.Tacticvisualiser;
                  
import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import javax.swing.JComponent;

/**
 *
 * @author olaf
 */
public class MonitorComponent extends JComponent {
    
    @Override
    protected void paintComponent(Graphics g) {
        java.awt.Graphics2D g2  = (java.awt.Graphics2D) g;
        
        g2.clearRect(0, 0, getWidth(),getHeight());
        
        g2.translate(0, getHeight());
        g2.scale(getWidth()/1024., -getHeight()/1024.);
        Screen current = currentScreen;
        if (current == null)
            return;
        for (Asteroid ast : current.getAsteroids()) {
     
            drawMovable(g2, ast);
        }
        
        drawMovable(g2, current.getSaucer());
        drawMovable(g2, current.getShip());
        
        g2.setPaint(new Color(1.f,0.f,1.f));
        for (Shot sh : current.getShots()) {
            drawMovable(g2, sh);
        }
        
        if (visualise != null) {
            visualise.visualiseTactic(g2);
        }
    }
    
    private Screen currentScreen = null;

    public void setCurrentScreen(Screen currentScreen) {
        this.currentScreen = currentScreen;
    }

    private void drawMovable(java.awt.Graphics2D g2, MovingObject m) {
        if ( m == null)
            return;
        if (m instanceof Asteroid) {
            Asteroid ast = (Asteroid) m;
            int size = (ast.getSize());
            g2.drawOval(ast.getX()-size/2, ast.getY()-size/2, size, size);
            g2.drawString( Integer.toString(ast.getSize()), ast.getX(), ast.getY());
        } else if (m instanceof Saucer) {
            Saucer sau = (Saucer) m;
            g2.drawRect(sau.getX()-10, sau.getY()-10, 
                    20, 20);
        } else if (m instanceof Ship) {
            Ship shi = (Ship) m;
            g2.drawLine(shi.getX(), shi.getY(), shi.getDx()*10, shi.getDy()*10);
        }
        
        
        g2.drawLine( m.getX(), m.getY(), (int) (m.getX()+m.getVx()*10), (int) (m.getY()+m.getVy()*10));
    }

    private Tacticvisualiser visualise;

    public void setVisualise(Tacticvisualiser tictac) {
        this.visualise = tictac;
    }
}
