/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid;

import de.heise.asteroid.comm.Communicator;
import de.heise.asteroid.comm.FramePacket;
import de.heise.asteroid.comm.KeyPacket;
import de.heise.asteroid.comm.ServerConnection;
import de.heise.asteroid.engine.Engine;
import de.heise.asteroid.engine.GameStatus;
import de.heise.asteroid.player.ModifiedSamplePlayer;
import de.heise.asteroid.util.Worker;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;

public class Main {
    private static final boolean syncComm = true;
    private static final int timeout = 0;
    private static final int gamesToPlay = 1;
    private static String serverName;
    private static List<FramePacket> fpQueue;
    private static List<KeyPacket> kpQueue;

    private static void runPlayer() throws Exception {
        GameStatus gameStatus = new GameStatus();
        ServerConnection serverConnection = new ServerConnection();
        try {
            try {
                serverConnection.connect(serverName);
                Communicator communicator = new Communicator(serverConnection);
                communicator.setQueues(fpQueue, kpQueue);
                Engine engine = new Engine(communicator, gameStatus, 1);
                engine.setQueues(fpQueue, kpQueue);
                ModifiedSamplePlayer player = new ModifiedSamplePlayer(engine);
                engine.registerPlayer(player);
                Worker engineWorker = new Worker("Engine", engine);
                engineWorker.start();
                Thread commWorker = null;
                if (commWorker != null) {
                    commWorker.start();
                }
                try {
                    while (engine.getGamesCompleted() < 1) {
                        Thread.sleep(3000L);
                    }
                }
                catch (InterruptedException e) {
                    System.out.println("InterruptedException: " + e.getMessage());
                }
            }
            catch (Exception e) {
                System.err.println("Uncaught exception: " + e.getMessage());
                throw e;
            }
        }
        finally {
            serverConnection.disconnect();
        }
    }

    public static void main(String[] args) throws Exception, UnknownHostException {
        if (args.length > 1) {
            System.out.println("usage: " + Main.class.getCanonicalName() + " <server>");
            return;
        }
        serverName = args.length == 1 ? args[0] : "127.0.0.1";
        fpQueue = null;
        kpQueue = new LinkedList<KeyPacket>();
        Main.runPlayer();
    }
}

