/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.engine;

import de.heise.asteroid.engine.Engine;
import de.heise.asteroid.engine.FrameProcessor;

public abstract class AbstractProcessor
implements FrameProcessor {
    private Engine engine;
    private byte keys;

    public AbstractProcessor(Engine e) {
        this.engine = e;
    }

    protected Engine getEngine() {
        return this.engine;
    }

    protected void pressKey(byte key) {
        this.keys = (byte)(this.keys | key & 0x3F);
    }

    protected void releaseKey(byte key) {
        this.keys = (byte)(this.keys & ~(key & 0x3F));
    }

    protected void releaseKeys() {
        this.keys = (byte)64;
    }

    protected void sendKeys(int frameNo) {
        this.engine.sendKeys(this.keys, frameNo);
    }
}

