/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.engine;

import de.heise.asteroid.engine.AsteroidTracker;
import de.heise.asteroid.engine.GameStatus;
import de.heise.asteroid.model.Asteroid;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsteroidSequenceTracker {
    public static final int MAX_ASTEROIDS = 27;
    private AsteroidTracker[] trackers = new AsteroidTracker[27];
    private int curSlot;
    private int maxSlot;
    private boolean inSync;
    private int curFrame;
    private int numObjects;

    public AsteroidSequenceTracker() {
        this.reset();
    }

    public void reset() {
        this.maxSlot = 0;
        this.start(0);
    }

    public void start(int frameNo) {
        this.numObjects = 0;
        this.curSlot = 0;
        this.inSync = true;
        this.curFrame = frameNo;
        int s = 0;
        while (s < this.maxSlot) {
            AsteroidTracker t = this.trackers[s];
            if (t != null && t.isExploding() && t.getFramesRemaining(this.curFrame) <= 0) {
                t.dispose();
                this.trackers[s] = null;
            }
            ++s;
        }
    }

    public void trackTarget(int sx, int sy, int type, int size) {
        AsteroidTracker t;
        ++this.numObjects;
        if (this.curSlot >= this.maxSlot) {
            if (this.maxSlot < 27) {
                this.trackers[this.maxSlot++] = null;
            } else {
                this.inSync = false;
                System.out.println("Asteroid table overflow");
                System.out.println(this.dump());
                return;
            }
        }
        if ((t = this.trackers[this.curSlot]) != null) {
            if (t.match(this.curFrame, sx, sy, type, size)) {
                t.update(sx, sy, type, size);
            } else {
                this.inSync = false;
                System.out.println("AsteroidSequenceTracker out of sync");
                System.out.println(this.dump());
            }
        } else {
            int nextSlot = this.getNextSlot(this.curSlot);
            t = this.trackers[nextSlot];
            if (t != null) {
                if (t.match(this.curFrame, sx, sy, type, size)) {
                    t.update(sx, sy, type, size);
                    this.curSlot = nextSlot;
                } else {
                    t = null;
                }
            }
            if (t == null) {
                if (GameStatus.isExplosionType(type)) {
                    System.out.printf("[%d] Spurious explosion detected\n", this.curSlot);
                }
                this.trackers[this.curSlot] = new AsteroidTracker(this.curFrame, sx, sy, type, size, this.curSlot);
            }
        }
        ++this.curSlot;
    }

    private int getNextSlot(int slot) {
        int s = slot;
        while (s < this.maxSlot) {
            if (this.trackers[s] != null) {
                return s;
            }
            ++s;
        }
        return slot;
    }

    public boolean isInSync() {
        return this.inSync;
    }

    public List<Asteroid> getAsteroids(List<Asteroid> list, boolean inclExpl) {
        if (list == null) {
            list = new LinkedList<Asteroid>();
        } else {
            list.clear();
        }
        int i = 0;
        while (i < this.maxSlot) {
            if (this.trackers[i] != null && (inclExpl || !this.trackers[i].isExploding())) {
                list.add(this.trackers[i].getAsteroid());
            }
            ++i;
        }
        return list;
    }

    public String dump() {
        StringBuilder strb = new StringBuilder("|");
        int s = 0;
        while (s < this.maxSlot) {
            if (this.trackers[s] == null) {
                strb.append(" - |");
            } else if (this.trackers[s].isExploding()) {
                strb.append(" # |");
            } else {
                switch (this.trackers[s].getAsteroid().getType()) {
                    case 0: {
                        strb.append(" 0 |");
                        break;
                    }
                    case 1: {
                        strb.append(" 1 |");
                        break;
                    }
                    case 2: {
                        strb.append(" 2 |");
                        break;
                    }
                    case 3: {
                        strb.append(" 3 |");
                    }
                }
            }
            ++s;
        }
        return strb.toString();
    }

    public void cleanup() {
        this.maxSlot = this.curSlot;
        if (this.numObjects == 0) {
            this.cleanTable();
        }
    }

    private void cleanTable() {
        int s = 0;
        while (s < this.maxSlot) {
            AsteroidTracker t = this.trackers[s];
            if (t != null) {
                t.dispose();
                this.trackers[s] = null;
            }
            ++s;
        }
        this.maxSlot = 0;
    }
}

