/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.engine;

import de.heise.asteroid.Position;
import de.heise.asteroid.ScreenVector;
import de.heise.asteroid.engine.Explosion;
import de.heise.asteroid.engine.GameStatus;
import de.heise.asteroid.model.Asteroid;
import de.heise.asteroid.util.SimpleMath;

public class AsteroidTracker {
    private int[] xBuf = new int[9];
    private int[] yBuf = new int[9];
    private int bufPos;
    private int baseFrame;
    private int curFrame;
    private int px;
    private int py;
    private int vx;
    private int vy;
    private int sqTol;
    private Position pos;
    private ScreenVector speed;
    private int type;
    private int size;
    private int slot;
    private Asteroid asteroid;
    private Explosion explosion;

    public AsteroidTracker(int frameNo, int sx, int sy, int t, int s, int sl) {
        this.baseFrame = frameNo;
        this.curFrame = frameNo;
        this.xBuf[0] = sx;
        this.yBuf[0] = sy;
        this.bufPos = 1;
        this.px = sx * 8;
        this.py = sy * 8;
        this.vx = 0;
        this.vy = 0;
        this.sqTol = 128;
        this.pos = null;
        this.speed = ScreenVector.NULL_VECTOR;
        this.type = t;
        this.size = s;
        this.slot = sl;
        this.explosion = null;
        this.asteroid = new Asteroid(this.getPos(), this.speed, t, s);
        if (GameStatus.isExplosionType(t)) {
            this.startExplosion(sx, sy, t, s);
        }
    }

    public void dispose() {
        this.asteroid = null;
    }

    public ScreenVector getSpeed() {
        return this.speed;
    }

    public Position getPos() {
        if (this.pos == null) {
            this.pos = new Position(this.px, this.py);
        }
        return this.pos;
    }

    public Asteroid getAsteroid() {
        return this.asteroid;
    }

    public boolean match(int frameNo, int sx, int sy, int t, int s) {
        this.curFrame = frameNo;
        if (GameStatus.isExplosionType(t)) {
            if (this.explosion != null) {
                return this.explosion.match(this.curFrame, sx, sy, t, s);
            }
            int x = this.px >> 3;
            int y = this.py >> 3;
            if (sx != x || sy != y) {
                System.out.printf("[%d] Explosion seen at (%d,%d) but Asteroid expected at (%d,%d)\n", this.slot, sx, sy, x, y);
                return false;
            }
        } else {
            int dy;
            if (t != this.type) {
                return false;
            }
            if (s != this.size) {
                return false;
            }
            int x = SimpleMath.normalize(this.px + this.vx * (this.curFrame - this.baseFrame) >> 3, 0, 1024);
            int y = SimpleMath.normalize(this.py + this.vy * (this.curFrame - this.baseFrame) >> 3, 128, 896);
            int dx = SimpleMath.normalize(sx - x, -512, 512);
            if (dx * dx + (dy = SimpleMath.normalize(sy - y, -384, 384)) * dy > this.sqTol) {
                return false;
            }
        }
        return true;
    }

    public void update(int sx, int sy, int t, int s) {
        if (GameStatus.isExplosionType(t)) {
            if (this.explosion == null) {
                this.startExplosion(sx, sy, t, s);
            }
        } else if (this.explosion == null) {
            this.updatePosition(sx, sy);
        } else {
            System.out.printf("[%d] Asteroid was already exploding, but is not now\n", this.slot);
        }
        this.asteroid.update(this.getPos(), this.speed);
    }

    public int getFramesRemaining(int frameNo) {
        return this.explosion != null ? this.explosion.getFramesRemaining(frameNo) : Integer.MAX_VALUE;
    }

    public boolean isExploding() {
        return this.explosion != null;
    }

    private void updatePosition(int sx, int sy) {
        if (this.bufPos < 9) {
            if (this.curFrame != this.baseFrame + this.bufPos) {
                this.bufPos = 0;
                this.baseFrame = this.curFrame;
            }
            this.xBuf[this.bufPos] = sx;
            this.yBuf[this.bufPos] = sy;
            this.px = sx << 3;
            this.py = sy << 3;
            if (++this.bufPos >= 9) {
                this.vx = SimpleMath.normalize(this.xBuf[8] - this.xBuf[0], -512, 512);
                this.vy = SimpleMath.normalize(this.yBuf[8] - this.yBuf[0], -384, 384);
                this.adjustPosition();
                this.baseFrame = this.curFrame;
                this.speed = new ScreenVector(this.vx, this.vy);
                this.sqTol = 2;
            }
        } else {
            this.px = SimpleMath.normalize(this.px + this.vx * (this.curFrame - this.baseFrame), 0, 8192);
            this.py = SimpleMath.normalize(this.py + this.vy * (this.curFrame - this.baseFrame), 1024, 7168);
            this.baseFrame = this.curFrame;
        }
        this.pos = null;
    }

    private void adjustPosition() {
        boolean foundX = false;
        boolean foundY = false;
        int offs = 0;
        while (offs < 8) {
            if (!foundX && this.backtrack(this.vx, offs, this.xBuf, 0, 8192)) {
                this.px += offs;
                foundX = true;
            }
            if (!foundY && this.backtrack(this.vy, offs, this.yBuf, 1024, 7168)) {
                this.py += offs;
                foundY = true;
            }
            if (foundX && foundY) {
                return;
            }
            ++offs;
        }
        System.out.printf("[%d] Co-ordinate backtracking failed\n", this.slot);
    }

    private boolean backtrack(int v, int offs, int[] buf, int min, int max) {
        int p = (buf[8] << 3) + offs;
        int i = 7;
        while (i >= 0) {
            if ((p -= v) < min) {
                p += max - min;
            } else if (p >= max) {
                p -= max - min;
            }
            if (p >> 3 != buf[i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    private void startExplosion(int sx, int sy, int t, int s) {
        this.vx = 0;
        this.vy = 0;
        this.speed = ScreenVector.NULL_VECTOR;
        this.explosion = new Explosion(this.curFrame, sx, sy, t, s);
        this.asteroid.setExploding(true);
        int index = this.explosion.getIndex();
        if (index < 0) {
            System.out.printf("[%d] Unable to synchronize explosion sequence\n", this.slot);
            this.explosion = null;
        }
    }
}

