/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.engine;

import de.heise.asteroid.model.Asteroid;
import de.heise.asteroid.model.Saucer;
import de.heise.asteroid.model.Ship;
import de.heise.asteroid.model.Shot;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameStatus {
    public static final int TYPE_1 = 0;
    public static final int TYPE_2 = 1;
    public static final int TYPE_3 = 2;
    public static final int TYPE_4 = 3;
    public static final int EXPL_0 = 4;
    public static final int EXPL_1 = 5;
    public static final int EXPL_2 = 6;
    public static final int EXPL_3 = 7;
    public static final int SAUCER = 8;
    public static final int MAX_ASTEROIDS = 30;
    public static final int MAX_SHOTS = 20;
    public static final int MAX_STRINGS = 10;
    private List<Asteroid> asteroids = new LinkedList<Asteroid>();
    private List<Shot> shots = new LinkedList<Shot>();
    private Saucer saucer = null;
    private Ship ship = null;
    private int lifeCount = 0;
    int playerNo = 0;
    int[] score = new int[3];
    private String initials = null;

    public void clear() {
        this.asteroids.clear();
        this.shots.clear();
        this.saucer = null;
        this.ship = null;
        this.lifeCount = 0;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.ship != null) {
            str.append(this.ship.toString()).append('\n');
        }
        if (this.saucer != null) {
            str.append(this.saucer.toString()).append('\n');
        }
        for (Asteroid a : this.asteroids) {
            str.append(a.toString()).append('\n');
        }
        for (Shot s : this.shots) {
            str.append(s.toString()).append('\n');
        }
        return str.toString();
    }

    public Ship getShip() {
        return this.ship;
    }

    public Saucer getSaucer() {
        return this.saucer;
    }

    public List<Asteroid> getAsteroids() {
        return this.asteroids;
    }

    public int getNumAsteroids() {
        return this.asteroids.size();
    }

    public List<Shot> getShots() {
        return this.shots;
    }

    public void setLifeCount(int lc) {
        this.lifeCount = lc;
    }

    public int getLifeCount() {
        return this.lifeCount;
    }

    public String getInitials() {
        return this.initials;
    }

    public void setInitials(String initials) {
        this.initials = initials;
    }

    public void setPlayerNo(int p) {
        this.playerNo = p;
    }

    public void setScore(int player, int s) {
        if (player >= 0 && player <= 2) {
            this.score[player] = s;
        } else {
            System.out.println("Cannot set score - invalid player number");
        }
    }

    public void addAsteroids(List<Asteroid> astList) {
        this.asteroids.addAll(astList);
    }

    public void addShots(List<Shot> shotList) {
        this.shots.addAll(shotList);
    }

    public void setSaucer(Saucer s) {
        this.saucer = s;
    }

    public void setShip(Ship s) {
        this.ship = s;
    }

    public static boolean isExplosionType(int t) {
        return t >= 4 && t <= 7;
    }
}

