/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.engine;

import de.heise.asteroid.engine.AbstractProcessor;
import de.heise.asteroid.engine.Engine;
import de.heise.asteroid.engine.GameStatus;

public class HallOfFameEditor
extends AbstractProcessor {
    private static final String alphabet = " ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final int SEARCHING = 0;
    private static final int FOUND = 1;
    private String playerInitials;
    private StringBuilder curInitials;
    private int editState;
    private int cursor;
    private int curFrameNo;
    private boolean waiting;
    private int frameToWait;
    private byte lastKey;

    public HallOfFameEditor(Engine e, String initials) {
        super(e);
        this.playerInitials = initials;
        this.curInitials = new StringBuilder();
        this.initialize();
    }

    public void initialize() {
        this.cursor = -1;
        this.waiting = false;
        this.editState = 0;
        this.curFrameNo = 0;
        this.frameToWait = 0;
        this.curInitials.setLength(0);
        this.curInitials.append("   ");
        this.lastKey = 0;
    }

    public void process(GameStatus status, int frameNo) {
        String frameIni;
        this.curFrameNo = frameNo;
        if (this.waiting) {
            if (frameNo < this.frameToWait) {
                return;
            }
            this.waiting = false;
        }
        if ((frameIni = status.getInitials()) == null) {
            System.out.println("No initials found in frame");
            return;
        }
        this.curInitials.replace(0, frameIni.length(), frameIni);
        if (frameIni.length() - 1 > this.cursor) {
            this.cursor = frameIni.length() - 1;
            if (this.cursor < 3) {
                this.editState = 0;
                this.scheduleKey((byte)0);
            } else {
                this.scheduleKey((byte)1);
                System.out.println("Cursor advanced too far");
            }
            return;
        }
        int dir = this.getLetterDirection(this.playerInitials.charAt(this.cursor), this.curInitials.charAt(this.cursor));
        if (this.editState == 0) {
            switch (dir) {
                case -1: {
                    this.scheduleKey((byte)16);
                    break;
                }
                case 0: {
                    this.scheduleKey((byte)0);
                    this.editState = 1;
                    this.scheduleWaitFor(15);
                    break;
                }
                case 1: {
                    this.scheduleKey((byte)8);
                }
            }
        } else if (this.editState == 1) {
            if (dir != 0) {
                this.editState = 0;
            } else {
                this.scheduleKey((byte)1);
                this.scheduleWaitFor(5);
            }
        }
    }

    private void scheduleKey(byte key) {
        if (key != this.lastKey) {
            if (key == 0) {
                this.releaseKeys();
            } else {
                this.pressKey(key);
            }
            this.sendKeys(this.curFrameNo);
            this.lastKey = key;
        }
    }

    private void scheduleWaitFor(int frames) {
        this.waiting = true;
        this.frameToWait = this.curFrameNo + frames;
    }

    private int getLetterDirection(char a, char b) {
        int dist = alphabet.indexOf(b) - alphabet.indexOf(a);
        if (dist == 0) {
            return 0;
        }
        if (dist > 0) {
            return dist > 13 ? -1 : 1;
        }
        return dist < -13 ? 1 : -1;
    }
}

