/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.player;

import de.heise.asteroid.ScreenVector;
import de.heise.asteroid.engine.Engine;
import de.heise.asteroid.model.Asteroid;
import de.heise.asteroid.model.Saucer;
import de.heise.asteroid.model.Ship;
import de.heise.asteroid.player.AbstractPlayer;
import java.util.List;

public class SamplePlayer
extends AbstractPlayer {
    public SamplePlayer(Engine e) {
        super(e);
    }

    public void play() {
        if (this.status != null) {
            Ship ship = this.status.getShip();
            Saucer saucer = this.status.getSaucer();
            this.releaseKeys();
            int minDistance = Integer.MAX_VALUE;
            ScreenVector minDifference = null;
            if (ship != null) {
                List<Asteroid> asteroids = this.status.getAsteroids();
                for (Asteroid ast : asteroids) {
                    if (ast.isExploding()) continue;
                    ScreenVector distVector = ship.getDistanceTo(ast);
                    distVector.normalize();
                    int sqDist = distVector.scalarProduct(distVector);
                    if ((sqDist -= ast.getRadius() * ast.getRadius()) >= minDistance) continue;
                    minDistance = sqDist;
                    minDifference = distVector;
                }
                if (saucer != null) {
                    ScreenVector distVector = ship.getDistanceTo(saucer);
                    distVector.normalize();
                    int sqDist = distVector.scalarProduct(distVector);
                    if ((sqDist -= saucer.getSize().getDistanceCorrection()) < minDistance) {
                        minDistance = sqDist;
                        minDifference = distVector;
                    }
                }
                if (minDifference != null) {
                    if (ship.getOrientation().crossProduct2D(minDifference) > 0) {
                        this.pressKey((byte)16);
                    } else {
                        this.pressKey((byte)8);
                    }
                }
                if (minDistance < 46656) {
                    this.pressKey((byte)1);
                }
                if (minDistance > 10240000) {
                    this.pressKey((byte)4);
                }
                if (this.curFrame % 2 == 0) {
                    this.pressKey((byte)2);
                }
            }
            this.sendKeys(0);
        }
    }

    public String getInitials() {
        return "HBO";
    }
}

