/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.util;

public class SimpleMath {
    public static final double PI2 = Math.PI * 2;
    public static final double PI_2 = 1.5707963267948966;
    public static final double PI_180 = Math.PI / 180;
    public static final int[] astCos = new int[256];
    public static final int[] astSin = new int[256];
    public static final double[] astAlpha = new double[256];

    static {
        System.out.print("Building trigonometric tables... ");
        SimpleMath.astCos[0] = 127;
        SimpleMath.astSin[64] = 127;
        SimpleMath.astCos[128] = -127;
        SimpleMath.astSin[192] = -127;
        SimpleMath.astCos[192] = 0;
        SimpleMath.astCos[64] = 0;
        SimpleMath.astSin[128] = 0;
        SimpleMath.astSin[0] = 0;
        int a = 1;
        while (a < 64) {
            SimpleMath.astCos[256 - a] = SimpleMath.astCos[a] = (int)Math.round(127.0 * Math.cos((double)a / 128.0 * Math.PI));
            int n = -astCos[a];
            SimpleMath.astCos[128 + a] = n;
            SimpleMath.astCos[128 - a] = n;
            SimpleMath.astSin[128 - a] = SimpleMath.astSin[a] = (int)Math.round(127.0 * Math.sin((double)a / 128.0 * Math.PI));
            int n2 = -astSin[a];
            SimpleMath.astSin[256 - a] = n2;
            SimpleMath.astSin[128 + a] = n2;
            ++a;
        }
        a = 0;
        while (a < 256) {
            SimpleMath.astAlpha[a] = Math.atan2(astSin[a], astCos[a]);
            if (astAlpha[a] < 0.0) {
                int n = a;
                astAlpha[n] = astAlpha[n] + Math.PI * 2;
            }
            ++a;
        }
        System.out.println("done.");
    }

    private static void plausiCheck() {
        double epsilon = 0.04;
        int a = 1;
        while (a < 128) {
            if (astCos[a] != astCos[256 - a]) {
                System.out.printf("astCos is asymmetric a=+/-%d\n", a);
            }
            if (astSin[64 + a] != astSin[64 - a & 0xFF]) {
                System.out.printf("astSin is asymmetric a=64+/-%d\n", a);
            }
            ++a;
        }
        double maxDeltaSin = 0.0;
        double maxDeltaCos = 0.0;
        double maxDeltaAlpha = 0.0;
        double alpha = 0.0;
        int a2 = 1;
        while (a2 < 256) {
            double deltaCos;
            double realAlpha;
            double deltaAlpha;
            if (astAlpha[a2] <= alpha) {
                System.out.printf("astAlpha is not monotonous: alpha[%d]=%f, alpha[%d]=%f\n", a2, astAlpha[a2], a2 - 1, alpha);
            }
            if ((deltaAlpha = (realAlpha = (double)a2 / 128.0 * Math.PI) - (alpha = astAlpha[a2])) * deltaAlpha > maxDeltaAlpha * maxDeltaAlpha) {
                maxDeltaAlpha = deltaAlpha;
            }
            double deltaSin = astSin[a2] == 0 ? 0.0 : 1.0 - 127.0 * Math.sin(realAlpha) / (double)astSin[a2];
            double d = deltaCos = astCos[a2] == 0 ? 0.0 : 1.0 - 127.0 * Math.cos(realAlpha) / (double)astCos[a2];
            if (deltaSin * deltaSin > maxDeltaSin * maxDeltaSin) {
                maxDeltaSin = deltaSin;
            }
            if (deltaCos * deltaCos > maxDeltaCos * maxDeltaCos) {
                maxDeltaCos = deltaCos;
            }
            if (deltaSin * deltaSin > epsilon * epsilon) {
                System.out.printf("astSin exceeds allowed error at a=%d, delta=%f\n", a2, deltaSin);
            }
            if (deltaSin * deltaSin > epsilon * epsilon) {
                System.out.printf("astCos exceeds allowed error at a=%d, delta=%f\n", a2, deltaSin);
            }
            ++a2;
        }
        System.out.printf("Max. alpha deviation is %f deg\n", maxDeltaAlpha / (Math.PI / 180));
        System.out.printf("Max. sin() deviation is %.2f %%\n", maxDeltaSin * 100.0);
        System.out.printf("Max. cos() deviation is %.2f %%\n", maxDeltaCos * 100.0);
    }

    private static void dumpTables() {
        System.out.println("Angle astSin astCos astAlpha realAlpha");
        int a = 0;
        while (a < 256) {
            System.out.printf("%3d:   %4d   %4d   %6.2f    %6.2f\n", a, astSin[a], astCos[a], astAlpha[a] / (Math.PI / 180), (double)a / 32.0 * 45.0);
            ++a;
        }
    }

    public static int normalize(int p, int min, int max) {
        while (p < min) {
            p += max - min;
        }
        while (p >= max) {
            p -= max - min;
        }
        return p;
    }
}

