/**
 * File:    FrameProcessor.java
 * Package: de.heise.asteroid
 * Created: 24.05.2008 10:47:23
 * Author:  Chr. Moellenberg
 *
 * Copyright (c) 2008 by Chr. Moellenberg
 */

package de.heise.asteroid.engine;


/**
 * A <code>FrameProcessor</code> is something that can react on a 
 * <code>GameStatus</code>, typically by issueing keypress events. 
 * 
 * @author Chr. Moellenberg
 */
public interface FrameProcessor {
   public static final byte KEY_NONE = 0x00;
   public static final byte KEY_HYPERSPACE = 0x01;
   public static final byte KEY_FIRE = 0x02;
   public static final byte KEY_THRUST = 0x04;
   public static final byte KEY_RIGHT = 0x08;
   public static final byte KEY_LEFT = 0x10;
   public static final byte KEY_START = 0x20;
   public static final byte KEY_MASK = 0x3f;

   /**
    * The actual processing routine. Frame processors should be aware 
    * that <code>status</code> may be <code>null</code>, or the frame 
    * number may be negative, respectively.
    * 
    * @param status the <code>GameStatus<code> to react on.
    * @param frameNo the frame number for which the status is valid.
    */
   public void process(GameStatus status, int frameNo);
   
   /**
    * This method is called by the player <code>Engine</code> when a new
    * state is entered, i.e. immediately before <code>process()</code> is 
    * called for the first time.
    */
   public void initialize();
}
