package de.heise.asteroid.model;

import de.heise.asteroid.Position;
import de.heise.asteroid.ScreenVector;


/**
 * The <code>MovingObject</code> class represents a moving object on the screen.
 * It is a <code>ScreenObject</code> that also has a speed.
 * 
 * @author Chr. Moellenberg
 */
public abstract class MovingObject extends ScreenObject {
   private static int nextTargetID = 0;

   protected int targetID;
   protected ScreenVector speed;

	/**
	 * Initializes position to p and the speed to (0, 0).
	 * 
	 * @param p the <code>Position</code> where this object was detected
	 */
	public MovingObject(Position p) {
	   super(p);
	   targetID = nextTargetID++;
	   speed = null;
	}

	public int getTargetID() {
	   return targetID;
	}

	/**
	 * Makes an update of position and speed with this object.
	 *  
	 * @param p the new position
	 * @param s the new speed vector
	 */
	public void update(Position p, ScreenVector s) {
	   pos = p;
	   speed = s;
	}
	
	/**
	 * Returns the speed of this <code>MovingObject</code>.
	 * 
	 * @return the speed.
	 */
	public final ScreenVector getSpeed() {
	   return speed;
	}

	/* (non-Javadoc)
    * @see de.heise.asteroid.model.ScreenObject#toString()
    */
   @Override
   public String toString() {
      StringBuilder str = new StringBuilder();
      str.append(pos).append(';').append(speed);
      return str.toString();
   }
}
