package de.heise.asteroid.model;

import de.heise.asteroid.Position;
import de.heise.asteroid.engine.GameStatus;

/**
 * The <code>Shot</code> class represents a shot fired either from the 
 * players ship or from a flying saucer. It is a <code>MovingObject</code>
 * 
 * @author Chr. Moellenberg
 * @see GameStatus
 */
public class Shot extends MovingObject {
	/**
	 * Initializes a new shot.
	 */
	public Shot(Position p) {
		super(p);
	}

   /* (non-Javadoc)
    * @see de.heise.asteroid.model.MovingObject#toString()
    */
   @Override
   public String toString() {
      StringBuilder str = new StringBuilder();
      str.append("shot:").append(super.toString());
      return str.toString();
   }
}
