/**
 * File:    Target.java
 * Package: de.heise.asteroid.model
 * Created: 23.06.2008 00:22:27
 * Author:  Chr. Moellenberg
 *
 * Copyright (c) 2008 by Chr. Moellenberg
 */

package de.heise.asteroid.model;

import de.heise.asteroid.Position;
import de.heise.asteroid.ScreenVector;

/**
 * The <code>Target</code> class represents a moving target on the screen.
 * It is a <code>MovingObject</code> that also has a radius and can explode. 
 * The radius is used for collision detection.
 * 
 * @author Chr. Moellenberg
 *
 */
public abstract class Target extends MovingObject {
   boolean exploding;

   /**
    * Initializes position to p and speed to sp.
    * 
    * @param p the <code>Position</code> where this <code>Target</code> was detected
    * @param sp the initial speed of this <code>Target</code>
    */
   public Target(Position p, ScreenVector sp) {
      super(p);
      speed = sp;
      exploding = false;
   }

   /**
    * Returns whether this <code>Asteroid</code> is exploding.
    * 
    * @return <code>true</code> if exploding, otherwise <code>false</code>
    */
   public boolean isExploding() {
      return exploding; 
   }

   /**
    * Sets a flag indicating if this <code>Asteroid</code> is exploding.
    * 
    * @param exploding the exploding to set
    */
   public void setExploding(boolean expl) {
      exploding = expl;
   }

   /**
    * Returns the approximate size of this <code>MovingObject</code>.
    * It is used for collision detection.
    * 
    * @return the approximate size
    */
   public abstract int getRadius();
}
