/*
 * Decompiled with CFR 0.152.
 */
package se.jupp.asteroids;

import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.jupp.asteroids.Asteroid;
import se.jupp.asteroids.Bullet;
import se.jupp.asteroids.Communication;
import se.jupp.asteroids.Frame;
import se.jupp.asteroids.FrameListener;
import se.jupp.asteroids.GameObject;
import se.jupp.asteroids.Position;
import se.jupp.asteroids.Ship;
import se.jupp.asteroids.Ufo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Game
implements FrameListener {
    private Ufo ufo;
    private List<Asteroid> asteroids = new LinkedList<Asteroid>();
    private List<Asteroid> virtual = new LinkedList<Asteroid>();
    private Ship ship;
    private List<Bullet> bullets = new LinkedList<Bullet>();
    private Communication com;
    int fired = 0;
    boolean goingLeft;
    int time = 0;
    int score = 0;
    int minuteStartScore = 0;
    int minuteStartTime = 0;
    int lastFrameScore = 0;
    int levelStartTime = 0;
    int levelEndTime = 0;
    List<GameObject> important = Collections.emptyList();

    public Game(Communication com) {
        this.com = com;
    }

    List<Move> moves(Ship shipclone, int start, List<? extends GameObject> enemies, List<Move> done, List<GameObject> important) {
        int earliestShotTime;
        ArrayList<Move> result = new ArrayList<Move>();
        ArrayList<Move> underway = new ArrayList<Move>(4);
        int time = 0;
        for (Move m : done) {
            time += m.wait;
            time += m.turns;
            Iterator i = underway.iterator();
            while (i.hasNext()) {
                Move u = (Move)i.next();
                if (u.start + u.time >= time) continue;
                i.remove();
            }
            underway.add(m);
        }
        if (underway.size() < 4) {
            earliestShotTime = 0;
        } else {
            earliestShotTime = Integer.MAX_VALUE;
            for (Move m : underway) {
                if (m.hitTime >= earliestShotTime) continue;
                earliestShotTime = m.hitTime;
            }
        }
        boolean d = important.size() > 0;
        int wait = 0;
        while (wait < 10) {
            int i = 0;
            while (i < 60) {
                if (i + wait >= earliestShotTime) {
                    Bullet b = shipclone.predictedBullet(shipclone.turns + i);
                    Hit x = this.willHitFirst(enemies, b, i + wait);
                    if (x != null && (!d || important.contains(x.enemy))) {
                        result.add(new Move(start, wait, true, i, x.time, x.enemy));
                    }
                    if ((x = this.willHitFirst(enemies, b = shipclone.predictedBullet(shipclone.turns - i), i)) != null && (!d || important.contains(x.enemy))) {
                        result.add(new Move(start, wait, false, i, x.time, x.enemy));
                    }
                }
                ++i;
            }
            ++wait;
        }
        Collections.sort(result);
        int i = 0;
        while (i < result.size()) {
            GameObject enemy = ((Move)result.get((int)i)).enemy;
            int j = result.size() - 1;
            while (j > i) {
                if (((Move)result.get((int)j)).enemy == enemy) {
                    result.remove(j);
                }
                --j;
            }
            ++i;
        }
        return result;
    }

    int eval(List<Move> moves) {
        int time = 0;
        ArrayList<Move> underway = new ArrayList<Move>(4);
        for (Move m : moves) {
            time += m.wait;
            time += m.turns;
            Iterator i = underway.iterator();
            while (i.hasNext()) {
                Move u = (Move)i.next();
                if (u.start + u.time >= time) continue;
                i.remove();
            }
            underway.add(m);
        }
        for (Move m : underway) {
            time += m.hitTime / 4;
        }
        return time;
    }

    boolean findMove(List<GameObject> important) {
        Move best = null;
        boolean d = important.size() > 0;
        int wait = 0;
        int i = 0;
        while (i < 60) {
            Bullet b = this.ship.predictedBullet(this.ship.turns + i);
            Hit x = this.willHitFirst(b, i + wait);
            if (!(x == null || best != null && x.time + i + wait >= best.time || d && !important.contains(x.enemy))) {
                best = new Move(this.time, wait, true, i, x.time, x.enemy);
            }
            if (!((x = this.willHitFirst(b = this.ship.predictedBullet(this.ship.turns - i), i)) == null || best != null && x.time + i + wait >= best.time || d && !important.contains(x.enemy))) {
                best = new Move(this.time, wait, false, i, x.time, x.enemy);
            }
            ++i;
        }
        return best != null ? best.left : true;
    }

    boolean bulletUnderway(GameObject e) {
        if (e == null) {
            return false;
        }
        for (Bullet bullet : this.bullets) {
            if (!bullet.target(e) || !bullet.willHit) continue;
            return true;
        }
        return false;
    }

    int evaluateEnemy(GameObject b, GameObject e, int future) {
        if (e == null) {
            return -1;
        }
        if (this.bulletUnderway(e)) {
            return -1;
        }
        int t = b.timeToCollision(e, future);
        if (t >= 0 && t < 70) {
            return t;
        }
        return -1;
    }

    List<Hit> collisions() {
        int d;
        LinkedList<Hit> result = new LinkedList<Hit>();
        for (Asteroid a : this.asteroids) {
            int d2 = this.ship.timeToCollision(a, 0);
            if (d2 < 0 || this.bulletUnderway(a)) continue;
            result.add(new Hit(d2, a, this.ship));
        }
        if (this.ufo != null && (d = this.ship.timeToCollision(this.ufo, 0)) >= 0 && !this.bulletUnderway(this.ufo)) {
            result.add(new Hit(d, this.ufo, this.ship));
        }
        Collections.sort(result);
        return result;
    }

    List<GameObject> importantEnemies() {
        LinkedList<GameObject> result = new LinkedList<GameObject>();
        for (Hit h : this.collisions()) {
            result.add(h.enemy);
        }
        if (this.ufo != null && !this.bulletUnderway(this.ufo)) {
            result.add(this.ufo);
        }
        return result;
    }

    Position diffOfClosestEnemy() {
        Position difference;
        int d;
        Position minDifference = new Position();
        int dist2 = Integer.MAX_VALUE;
        for (Asteroid a : this.asteroids) {
            Position difference2 = a.pos.subtract(this.ship.pos).normalize();
            int d2 = difference2.square();
            if (d2 >= dist2 || this.bulletUnderway(a)) continue;
            dist2 = d2;
            minDifference = difference2;
        }
        if (this.ufo != null && (d = (difference = this.ufo.pos.subtract(this.ship.pos).normalize()).square()) < dist2) {
            dist2 = d;
            minDifference = difference;
        }
        return minDifference;
    }

    Hit willHitFirst(List<? extends GameObject> enemies, GameObject friend, int future) {
        GameObject target = null;
        int time = Integer.MAX_VALUE;
        for (GameObject gameObject : enemies) {
            int t = this.evaluateEnemy(friend, gameObject, future);
            if (t < 0 || t >= time) continue;
            target = gameObject;
            time = t;
        }
        if (target != null) {
            return new Hit(time, target, friend);
        }
        return null;
    }

    Hit willHitFirst(GameObject friend, int future) {
        int t;
        GameObject target = null;
        int time = Integer.MAX_VALUE;
        for (Asteroid asteroid : this.asteroids) {
            t = this.evaluateEnemy(friend, asteroid, future);
            if (t < 0 || t >= time) continue;
            target = asteroid;
            time = t;
        }
        for (Asteroid asteroid : this.virtual) {
            t = this.evaluateEnemy(friend, asteroid, future);
            if (t < 0 || t >= time) continue;
            target = asteroid;
            time = t;
        }
        for (Bullet bullet : this.bullets) {
            if (bullet.ship != null || (t = this.evaluateEnemy(friend, bullet, future)) < 0 || t >= time) continue;
            target = bullet;
            time = t;
        }
        int n = this.evaluateEnemy(friend, this.ufo, future);
        if (n >= 0 && n < time) {
            target = this.ufo;
            time = n;
        }
        if (target != null) {
            return new Hit(time, target, friend);
        }
        return null;
    }

    boolean fireIfEnemyInSight(List<GameObject> important) {
        Bullet b = this.ship.predictedBullet();
        Hit hit = this.willHitFirst(b, 0);
        int importantToShoot = 0;
        for (GameObject imp : important) {
            if (this.bulletUnderway(imp)) continue;
            ++importantToShoot;
        }
        int n = 4 - this.ship.bulletsUnderway() - importantToShoot;
        if (hit != null && (n > 0 || important.contains(hit.enemy))) {
            this.ship.fire(hit);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void frameReceived(Frame frame) {
        if (frame == null) {
            System.out.println("Game over after " + this.time + " frames. Total score " + this.score);
            return;
        }
        int step = (frame.getId() & 0xFF) - (this.time & 0xFF) & 0xFF;
        this.time += step;
        boolean oldHasEnemies = this.asteroids.size() > 0 || this.ufo != null;
        this.updateObjects(frame);
        if (this.lastFrameScore > 98000 && frame.score < 2000) {
            this.score += 100000;
        }
        this.score = this.score / 100000 * 100000 + frame.score;
        if (this.time - this.minuteStartTime >= 3600) {
            System.out.println("Minute score = " + (this.score - this.minuteStartScore));
            this.minuteStartTime = this.time;
            this.minuteStartScore = this.score;
        }
        this.lastFrameScore = frame.score;
        if (this.asteroids.size() == 0 && this.ufo == null && oldHasEnemies) {
            this.levelEndTime = this.time;
        } else if (!(this.asteroids.size() <= 0 && this.ufo == null || oldHasEnemies)) {
            this.levelStartTime = this.time;
        }
        if (this.ship != null) {
            Hit hit;
            this.important = this.importantEnemies();
            for (GameObject gameObject : this.asteroids) {
                gameObject.dangerous = false;
            }
            if (this.ufo != null) {
                this.ufo.dangerous = false;
            }
            for (GameObject gameObject : this.important) {
                gameObject.dangerous = true;
            }
            if (this.asteroids.size() > 0 || this.ufo != null) {
                if (this.ship.canFire() && this.fireIfEnemyInSight(this.important)) {
                    ++this.fired;
                }
                if (this.findMove(this.important)) {
                    this.ship.goLeft();
                } else {
                    this.ship.goRight();
                }
            }
            if ((hit = this.willHitFirst(this.ship, 0)) != null && hit.time <= 3) {
                this.ship.goHyper();
            }
        }
        try {
            this.com.sendKeys(this.ship != null ? this.ship.getKeys() : 0, this.time);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateObjects(Frame frame) {
        if (frame.spaceShip != null && this.ship == null) {
            this.ship = new Ship(frame.spaceShip, this.time);
        } else if (this.ship != null) {
            this.ship.update(frame.spaceShip);
            if (frame.spaceShip == null) {
                this.ship = null;
            }
        }
        if (frame.ufo != null && this.ufo == null) {
            this.ufo = new Ufo(frame.ufo, this.time);
        } else if (this.ufo != null) {
            this.ufo.update(frame.ufo);
            if (frame.ufo == null) {
                this.ufo = null;
            }
        }
        ai = 0;
        pi = 0;
        block0: while (true) {
            a = this.asteroidAt(ai);
            ap = frame.asteroidAt(pi);
            if (a == null && ap == null) break;
            if (ap == null) {
                a.update(null);
                this.asteroids.remove(ai);
                continue;
            }
            if (a == null) {
                this.asteroids.add(new Asteroid(ap, this.time));
                ++pi;
                ++ai;
                continue;
            }
            if (a.match(ap)) {
                a.update(ap);
                ++pi;
                ++ai;
                continue;
            }
            a.update(null);
            this.asteroids.remove(ai);
            n = this.asteroidAt(ai);
            while (true) {
                if (n != null && ap != null && !n.match(ap)) ** break;
                continue block0;
                this.asteroids.add(ai++, new Asteroid(ap, this.time));
                n = this.asteroidAt(ai);
                ap = frame.asteroidAt(++pi);
            }
            break;
        }
        i = this.virtual.iterator();
        while (i.hasNext()) {
            a = i.next();
            if (this.time - a.timeBorn <= 10) continue;
            i.remove();
        }
        this.updateBullets(frame);
    }

    Bullet closestBullet(Position p) {
        int mindist = Integer.MAX_VALUE;
        Bullet closest = null;
        for (Bullet b : this.bullets) {
            int d = b.pos.add(b.velocity).distanceSquared(p);
            if (d >= mindist) continue;
            mindist = d;
            closest = b;
        }
        return closest;
    }

    private void updateBullets(Frame f) {
        LinkedList<Bullet> done = new LinkedList<Bullet>();
        for (Position position : f.bullets) {
            Bullet closest = this.closestBullet(position);
            if (closest != null && closest.match(position)) {
                closest.update(position);
                done.add(closest);
                this.bullets.remove(closest);
                continue;
            }
            Bullet x = new Bullet(position, this.ship, this.time);
            done.add(x);
        }
        for (Bullet bullet : this.bullets) {
            this.virtual.removeAll(bullet.virtual);
            bullet.update(null);
        }
        this.bullets = done;
    }

    private Asteroid asteroidAt(int i) {
        return i < this.asteroids.size() ? this.asteroids.get(i) : null;
    }

    public synchronized void draw(Graphics2D g) {
        for (Asteroid asteroid : this.asteroids) {
            asteroid.draw(g);
        }
        if (this.ufo != null) {
            this.ufo.draw(g);
        }
        if (this.ship != null) {
            this.ship.draw(g);
        }
        for (Bullet bullet : this.bullets) {
            bullet.draw(g);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Hit
    implements Comparable<Hit> {
        GameObject friend;
        int time;
        GameObject enemy;

        Hit(int time, GameObject target, GameObject friend) {
            this.time = time;
            this.enemy = target;
            this.friend = friend;
        }

        @Override
        public int compareTo(Hit o) {
            if (this.time < o.time) {
                return -1;
            }
            if (o.time < this.time) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Move
    implements Comparable<Move> {
        int start;
        int wait;
        int turns;
        int hitTime;
        int time;
        boolean left;
        GameObject enemy;

        public Move(int start, int wait, boolean left, int turns, int hitTime, GameObject enemy) {
            this.start = start;
            this.wait = wait;
            this.left = left;
            this.turns = turns;
            this.hitTime = hitTime;
            this.enemy = enemy;
            this.time = wait + turns + hitTime;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.hitTime;
            result = 31 * result + (this.left ? 1231 : 1237);
            result = 31 * result + this.start;
            result = 31 * result + this.time;
            result = 31 * result + this.turns;
            result = 31 * result + this.wait;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Move other = (Move)obj;
            if (this.hitTime != other.hitTime) {
                return false;
            }
            if (this.left != other.left) {
                return false;
            }
            if (this.start != other.start) {
                return false;
            }
            if (this.time != other.time) {
                return false;
            }
            if (this.turns != other.turns) {
                return false;
            }
            return this.wait == other.wait;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.wait > 0) {
                buf.append(this.wait).append("w");
            }
            buf.append(this.turns);
            buf.append(this.left ? (char)'L' : 'R');
            buf.append(this.hitTime).append("h");
            buf.append('/').append(this.enemy.id);
            return buf.toString();
        }

        @Override
        public int compareTo(Move o) {
            if (this.time < o.time) {
                return -1;
            }
            if (o.time < this.time) {
                return 1;
            }
            return 0;
        }
    }
}

