/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.GameData;
import de.caff.asteroid.Text;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;

public class FrameDisplay
extends JComponent
implements FrameListener,
GameData {
    private FrameInfo frameInfo;
    private AffineTransform trafo;

    public FrameDisplay(int width) {
        Dimension size = new Dimension(width, 3 * width / 4);
        this.setMaximumSize(size);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        double scaling = (double)width / 1024.0;
        this.trafo = AffineTransform.getTranslateInstance(0.0, -896.0);
        this.trafo.preConcatenate(AffineTransform.getScaleInstance(scaling, -scaling));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        FrameInfo info;
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        FrameDisplay frameDisplay = this;
        synchronized (frameDisplay) {
            info = this.frameInfo;
        }
        if (info != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.transform(this.trafo);
            info.draw(g2);
            Point pos = new Point();
            if (!info.isGameRunning()) {
                g.setColor(new Color(255, 255, 0, 128));
                for (Text txt : info.getTexts()) {
                    this.trafo.transform(txt.getLocation(), pos);
                    g.drawString(txt.getText(), pos.x, pos.y);
                }
            }
            g.setColor(new Color(255, 255, 255, 128));
            this.trafo.transform(FrameInfo.SCORE_LOCATION_GAME, pos);
            g.drawString(String.format("%7d", info.getScore()), pos.x, pos.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void frameReceived(FrameInfo frame) {
        FrameDisplay frameDisplay = this;
        synchronized (frameDisplay) {
            this.frameInfo = frame;
        }
        this.repaint();
    }
}

