
package de.caff.asteroid;

import java.awt.*;

/**
 * Bullet object in automated player of Asteroids game.
 *
 * Bullets are either shot by the player's ship or by an ufo.
 */
public class Bullet
        extends SizedGameObject
{
  /** Calculate maximum lifetime? */
  private static final boolean CALC_LIFTIME = true;
  /** Calculated maximum lifetime. */
  private static int MAX_LIFETIME = 0;
  private int lifetime;

  /**
   *  Constructor.
   *  @param x  x coordinate
   *  @param y  y coordinate
   */
  public Bullet(int x, int y)
  {
    super(x, y);
  }

  /**
   *  Get the size of the object.
   *
   *  The size returned by this method is half the length of a square which contains the object,
   *  so the object's bounding box is between (x - size, y - size) and (x + size, y + size).
   *  @return object size
   */
  public int getSize()
  {
    return 0;
  }

  /**
   *  Draw the object.
   *  @param g graphics context
   */
  public void draw(Graphics2D g)
  {
    drawVelocityVector(g, Color.blue);

    g.setColor(Color.white);
    g.fillOval(x-1, y-1, 3, 3);
  }

  private static int minVX = 0;
  private static int maxVX = 0;
  private static int minVY = 0;
  private static int maxVY = 0;
  private static int maxVSquared   = 0;

  /**
   * Set the velocity.
   * <p/>
   * The velocity is the step between frames.
   *
   * @param x x coordinate of velocity
   * @param y y coordinate of velocity
   */
  @Override
  public void setVelocity(int x, int y)
  {
    super.setVelocity(x, y);
    if (WATCH_VELOCITIES) {
      boolean print = false;
      if (x < minVX) {
        minVX = x;
        print = true;
      }
      else if (x > maxVX) {
        maxVX = x;
        print = true;
      }
      if (y < minVY) {
        minVY = y;
        print = true;
      }
      else if (y > maxVY) {
        maxVY = y;
        print = true;
      }
      int len2 = x*x + y*y;
      if (len2 > maxVSquared) {
        maxVSquared = len2;
        print = true;
      }
      if (print) {
        System.out.println(String.format("BLL: minV=(%d,%d), maxV=(%d,%d), maxV^2=%d",
                                         minVX, minVY, maxVX, maxVY, maxVSquared));
      }
    }
  }

  /**
   *  Get the lifetime of this buller.
   *
   *  Because it is not always easy to connect two bullets between frames the
   *  returned lifetime is not 100% correct. Also it is not calculated
   *  internally but has to be set from outside. For an example see
   *  {@link de.caff.asteroid.SimpleVelocityPreparer#prepareFrames(java.util.LinkedList)}.
   *  @return lifetime (number of frames this bullet was displayed)
   */
  public int getLifetime()
  {
    return lifetime;
  }

  /**
   *  Set the lifetime.
   *  @param lifetime life time (number of frames 'this' bullet exists)
   */
  public void setLifetime(int lifetime)
  {
    this.lifetime = lifetime;
    if (CALC_LIFTIME) {
      if (lifetime > MAX_LIFETIME) {
        MAX_LIFETIME = lifetime;
        System.out.println("BULLET: lifetime="+lifetime);
      }
    }
  }
}
