// Georgs erster Asteroid Client Versuch
package de.caff.asteroid;

import java.awt.Point;
import java.util.Collection;

public class GeorgsFirstAsteroidPlayer implements FrameListener, GameData {
	private static final String Bullet = null;
	/** Switch between shooting and not shooting. */
	private boolean shot;
	/** The communication object. */
	private Communication com;

	/**
	 * Constructor.
	 * 
	 * @param com
	 *            communications object for key sending
	 */
	public GeorgsFirstAsteroidPlayer(Communication com) {
		this.com = com;
		com.setFramePreparer(new FramePreparerSequence(
				new SimpleVelocityPreparer(), new ScoreFixer()));
		com.addFrameListener(new HallOfFameFiller(com, "bo"));
	}

	void start(SpaceShip ship, Communication com) {// ??????????????????????????????????
		com.pushButton(BUTTON_START);
	}

	/**
	 * Called each time a frame is received.
	 * 
	 * <b>ATTENTION:</b> this is called from the communication thread!
	 * Implementing classes must be aware of this and take care by
	 * synchronization or similar!
	 * 
	 * @param frame
	 *            the received frame
	 */
	public void frameReceived(FrameInfo frame) {

		if (frame == null) {
			return;
		}

		SpaceShip ship = frame.getSpaceShip();

		if (ship == null) {
			return;
		}

		// Kollision erkennen
		if (avoidCollision(ship, frame)) {
			return;
		}
//		System.out.println("no collision");

		SizedGameObject target = findNearestTarget(ship, frame);
		if (target == null) {
			if (frame.getTargetCount() > 0) {
				com.pushButton(BUTTON_THRUST);
			}
		} else {
			Point delta = ship.getDelta(target);
			int dist2 = delta.x * delta.x + delta.y * delta.y;
			if (dist2 < 31 * 31) {
				com.pushButton(BUTTON_HYPERSPACE);
			} else {
				if (ship.getDirX() * delta.y - ship.getDirY() * delta.x > 0) {
					com.pushButton(BUTTON_LEFT);
				} else {
					com.pushButton(BUTTON_RIGHT);
				}
			}
		}

		com.setButton(BUTTON_FIRE, shot);
		shot = !shot;
	}

	private boolean avoidCollision(SpaceShip ship, FrameInfo frame) {
		/*
		 * Anzahl von Frames, bis zur Kollision, ab der reagiert werden muss.
		 * Wird also eine Kollision in escapeFrames oder weniger Frames erkannt,
		 * so muss aktiv etwas dagegen unternommen werden
		 */
		final int escapeFrames = 50;

		int timeToCollision = 0;
		for (Bullet bullet : frame.getBullets()) {
			timeToCollision = objectsCollidingInFrames(ship, bullet);
			if (timeToCollision > 0 && timeToCollision <= escapeFrames
					&& bullet.getLifetime() >= timeToCollision) {
				System.out.println("bullet");
				com.pushButton(GameData.BUTTON_LEFT);
				com.pushButton(GameData.BUTTON_THRUST);
				return true;
			}
		}
		
		SizedGameObject target = findNearestCollidingTarget(ship, frame.getAsteroids(), escapeFrames);
		if (target != null) {
//			System.out.println(target);
			Point delta = ship.getDelta(target);
			if (ship.getDirX() * delta.y - ship.getDirY() * delta.x > 0) {
				com.pushButton(BUTTON_LEFT);
			} else {
				com.pushButton(BUTTON_RIGHT);
			}

			com.setButton(BUTTON_FIRE, shot);
			shot = !shot;
			return true;
		}

		if (frame.getUfo() != null) {
			timeToCollision = objectsCollidingInFrames(ship, frame.getUfo());
			if (timeToCollision > 0 && timeToCollision <= escapeFrames) {
				System.out.println("ufo " + timeToCollision);
				com.pushButton(GameData.BUTTON_LEFT);
				com.pushButton(GameData.BUTTON_THRUST);
				return true;
			}
		}
		return false;
	}

	private SizedGameObject findNearestCollidingTarget(SpaceShip ship,
			Collection<Asteroid> asteroids, int escapeFrames) {
		SizedGameObject nearest = null;
		int minDist2 = 400 * 400;
		for (Asteroid ast : asteroids) {
			int collidingInFrames = objectsCollidingInFrames(ship, ast);
			if (collidingInFrames > 0 && collidingInFrames < escapeFrames) {
				int dist2 = ship.getSquaredDistance(ast) - ast.getSquaredSize();
				if (dist2 < minDist2) {
					minDist2 = dist2;
					nearest = ast;
				}
			}
		}
		return nearest;
	}

	/**
	 * Prpft, ob eine Kollsision zwischen dem Schiff und dem anderen Objekt
	 * auftritt. Ist dies nicht der Fall, so liefert die Methode -1. Bei einer
	 * Kollision liefert die Methode die Anzahl der Frames bis zu Kollision.
	 * 
	 * Eigentlich private, protected fr Testflle.
	 * 
	 * @param ship
	 *            Das Shiff, auf welches sich die Kollisionsprfung beziehen
	 *            soll.
	 * @param object
	 *            Das andere Objekt, welches zur Kollisionsprfung herangezogen
	 *            wird.
	 * @return -1, falls keine Kollision auftritt, ansonsten die Anzahl der
	 *         Frames bis zu Kollision. Aufgrund von Rundungsfehlern kann die
	 *         Kollision einen Frame frher gemeldet werden als sie tatschlich
	 *         erfolgen wrde
	 */
	protected int objectsCollidingInFrames(SpaceShip ship,
			SizedGameObject object) {

		if (object.getVelocityX() == ship.getVelocityX()
				&& object.getVelocityY() == ship.getVelocityY()) {
			return -1;
		}

		boolean velocityYsame = object.getVelocityY() == ship.getVelocityY();
		boolean velocityXsame = object.getVelocityX() == ship.getVelocityX();

		/*
		 * Berechnung als int, da das Ergebnis die Anzahl der Frames bis zur
		 * Kollision wiedergibt. Lieber ein Frame zu wenig (Berechnung schneidet
		 * immer ab, 7,9999 wird 7), dann sind wir im Zweifelsfall ein Frame zu
		 * frh dran.
		 */
		int timeX = 0;

		if (!velocityXsame) {
			timeX = (ship.x - object.x)
					/ (object.getVelocityX() - ship.getVelocityX());
		}

		int timeY = 0;

		if (!velocityYsame) {
			timeY = (ship.y - object.y)
					/ (object.getVelocityY() - ship.getVelocityY());
		}

		if (timeX < 0 || timeY < 0) {
			return -1;
		}

		/* Gre der Objekte bercksichtigen */
		int deltaXShip = 0;
		int deltaXObject = 0;
		int deltaYShip = 0;
		int deltaYObject = 0;

		if (ship.getVelocityX() != 0) {
			deltaXShip = ship.getSize() / ship.getVelocityX();
			deltaXShip = Math.abs(deltaXShip);
		}

		if (object.getVelocityX() != 0) {
			deltaXObject = object.getSize() / object.getVelocityX();
			deltaXObject = Math.abs(deltaXObject);
		}

		if (ship.getVelocityY() != 0) {
			deltaYShip = ship.getSize() / ship.getVelocityY();
			deltaYShip = Math.abs(deltaYShip);
		}

		if (object.getVelocityY() != 0) {
			deltaYObject = object.getSize() / object.getVelocityY();
			deltaYObject = Math.abs(deltaYObject);
		}

		int faktor = 1;
		if (!((ship.getVelocityX() > 0 && object.getVelocityX() > 0) || (ship
				.getVelocityX() < 0 && object.getVelocityX() < 0))) {
			faktor = -1;
		}
		int timeX2 = timeX + faktor * Math.min(deltaXShip, deltaXObject);

		if (((ship.getVelocityY() > 0 && object.getVelocityY() > 0) || (ship
				.getVelocityY() < 0 && object.getVelocityY() < 0))) {
			faktor = 1;
		} else {
			faktor = -1;
		}
		int timeY2 = timeY + faktor * Math.min(deltaYShip, deltaYObject);

		if (velocityXsame) {
			return timeY2;
		}
		if (velocityYsame) {
			return timeX2;
		}

		if ((timeX2 >= timeY2 && timeX2 <= timeY2 && timeX >= timeY)
				|| (timeX2 <= timeY2 && timeX >= timeY2 && timeX <= timeY)) {
			return Math.min(timeX2, timeY2);
		} else {
			return -1;
		}
	}

	/**
	 * Find the nearest target. Everything farer away than 400 pixel is
	 * considered to be in infinity.
	 * 
	 * @param ship
	 *            ship info
	 * @param info
	 *            frame info
	 * @return nearest target or <code>null</code> if there is no target near
	 *         enough
	 */
	private static SizedGameObject findNearestTarget(SpaceShip ship,
			FrameInfo info) {
		SizedGameObject nearest = null;
		int minDist2 = 400 * 400;
		for (Asteroid ast : info.getAsteroids()) {
			int dist2 = ship.getSquaredDistance(ast) - ast.getSquaredSize();
			if (dist2 < minDist2) {
				minDist2 = dist2;
				nearest = ast;
			}
		}
		Ufo ufo = info.getUfo();
		if (ufo != null) {
			int dist2 = ship.getSquaredDistance(ufo) - ufo.getSquaredSize();
			if (dist2 < minDist2) {
				nearest = ufo;
			}
		}
		// System.out.println("Nearest: "+nearest);
		return nearest;
	}
}
