
#include "StdAfx.h"
#include "GameEngine.h"
#include "Calculator.h"
#include "GlobalSettings.h"

#include "Shot.h"


Shot::Shot(void)
: mSender(Shot::Saucer), mTargetId(0)
{
	mLifeTime = static_cast<int>(GlobalSettings::Instance()->shotLifeTime);
}

Shot::~Shot(void)
{
}

Shot& Shot::operator=(const Shot& rhs)
{
    if (&rhs == this) { return *this; }
	
	*(dynamic_cast<MovingEntity*>(this)) = *(dynamic_cast<MovingEntity*>(const_cast<Shot*>(&rhs)));

	mSender = rhs.mSender;
	mTargetId = rhs.mTargetId;
	mLifeTime = rhs.mLifeTime;

    return *this; 
}

void Shot::set(double x, double y)
{
	setPosition(Vector2D(x, y));
}

int Shot::getLifeTime(void) const
{
	return mLifeTime;
}

Shot::ShotSender Shot::getSender(void) const
{
	return mSender;
}

void Shot::setSender(const ShotSender& sender)
{
	mSender = sender;
}

int Shot::getTargetId(void) const
{
	return mTargetId;
}

void Shot::setTargetId(const int& targetId)
{
	mTargetId = targetId;
}

void Shot::calculateVelocityFromPrevPosition(const Vector2D& prevPosition, int frameCount)
{
	MovingEntity::calculateVelocityFromPrevPosition(prevPosition, frameCount);
	mLifeTime -= frameCount;
}

void Shot::writeStatusToLog() const
{
	char buffer[255] = { 0 };
	
	char sender[15] = { 0 };
	if (mSender == Saucer)
	{
		sprintf_s(sender, 15, "Saucer");
	}
	else
	{
		sprintf_s(sender, 15, "Spaceship");
	}

	sprintf_s(buffer, 255, 
		"Shot(%d): TargetId=%d, Position=[%4.2f, %4.2f], Velocity=[%4.4f, %4.4f], Speed=%4.4f, Creation=%d, Sender=%s, Rotation=%4.4f, LifeTime: %d\n", 
			  getId(),
			  mTargetId,
			  getPosition().getX(), 
			  getPosition().getY(), 
			  getVelocity().getX(),
			  getVelocity().getY(),
			  getSpeed(),
			  getCreationState(),
			  sender,
			  Calculator::calculateRotationInDeg(getVelocity()),
			  mLifeTime
			  );

	GameEngine::log(buffer);
}
